import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ContainerRegistryConfig extends cdktf.TerraformMetaArguments {
    /**
     * The location of the registry.
     *
     * One of ASIA, EU, US or not specified. See the official documentation for more information on registry locations.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_registry.html#location ContainerRegistry#location}
     */
    readonly location?: string;
    /**
     * The ID of the project in which the resource belongs.
     *
     * If it is not provided, the provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_registry.html#project ContainerRegistry#project}
     */
    readonly project?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/container_registry.html google_container_registry}.
 */
export declare class ContainerRegistry extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/container_registry.html google_container_registry} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config?: ContainerRegistryConfig);
    get bucketSelfLink(): string;
    get id(): string;
    private _location?;
    get location(): string | undefined;
    set location(value: string | undefined);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
