import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ContainerNodePoolConfig extends cdktf.TerraformMetaArguments {
    /**
     * The cluster to create the node pool for. Cluster must be present in location provided for zonal clusters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#cluster ContainerNodePool#cluster}
     */
    readonly cluster: string;
    /**
     * The initial number of nodes for the pool.
     *
     * In regional or multi-zonal clusters, this is the number of nodes per zone. Changing this will force recreation of the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#initial_node_count ContainerNodePool#initial_node_count}
     */
    readonly initialNodeCount?: number;
    /**
     * The location (region or zone) of the cluster.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#location ContainerNodePool#location}
     */
    readonly location?: string;
    /**
     * The maximum number of pods per node in this node pool.
     *
     * Note that this does not work on node pools which are "route-based" - that is, node pools belonging to clusters that do not have IP Aliasing enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#max_pods_per_node ContainerNodePool#max_pods_per_node}
     */
    readonly maxPodsPerNode?: number;
    /**
     * The name of the node pool. If left blank, Terraform will auto-generate a unique name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#name ContainerNodePool#name}
     */
    readonly name?: string;
    /**
     * Creates a unique name for the node pool beginning with the specified prefix. Conflicts with name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#name_prefix ContainerNodePool#name_prefix}
     */
    readonly namePrefix?: string;
    /**
     * The number of nodes per instance group.
     *
     * This field can be used to update the number of nodes per instance group but should not be used alongside autoscaling.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#node_count ContainerNodePool#node_count}
     */
    readonly nodeCount?: number;
    /**
     * The list of zones in which the node pool's nodes should be located.
     *
     * Nodes must be in the region of their regional cluster or in the same region as their cluster's zone for zonal clusters. If unspecified, the cluster-level node_locations will be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#node_locations ContainerNodePool#node_locations}
     */
    readonly nodeLocations?: string[];
    /**
     * The ID of the project in which to create the node pool.
     *
     * If blank, the provider-configured project will be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#project ContainerNodePool#project}
     */
    readonly project?: string;
    /**
     * The Kubernetes version for the nodes in this pool.
     *
     * Note that if this field and auto_upgrade are both specified, they will fight each other for what the node version should be, so setting both is highly discouraged. While a fuzzy version can be specified, it's recommended that you specify explicit versions as Terraform will see spurious diffs when fuzzy versions are used. See the google_container_engine_versions data source's version_prefix field to approximate fuzzy versions in a Terraform-compatible way.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#version ContainerNodePool#version}
     */
    readonly version?: string;
    /**
     * autoscaling block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#autoscaling ContainerNodePool#autoscaling}
     */
    readonly autoscaling?: ContainerNodePoolAutoscaling;
    /**
     * management block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#management ContainerNodePool#management}
     */
    readonly management?: ContainerNodePoolManagement;
    /**
     * node_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#node_config ContainerNodePool#node_config}
     */
    readonly nodeConfig?: ContainerNodePoolNodeConfig;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#timeouts ContainerNodePool#timeouts}
     */
    readonly timeouts?: ContainerNodePoolTimeouts;
    /**
     * upgrade_settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#upgrade_settings ContainerNodePool#upgrade_settings}
     */
    readonly upgradeSettings?: ContainerNodePoolUpgradeSettings;
}
export interface ContainerNodePoolAutoscaling {
    /**
     * Maximum number of nodes in the NodePool. Must be >= min_node_count.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#max_node_count ContainerNodePool#max_node_count}
     */
    readonly maxNodeCount: number;
    /**
     * Minimum number of nodes in the NodePool. Must be >=0 and <= max_node_count.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#min_node_count ContainerNodePool#min_node_count}
     */
    readonly minNodeCount: number;
}
export declare class ContainerNodePoolAutoscalingOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _maxNodeCount?;
    get maxNodeCount(): number;
    set maxNodeCount(value: number);
    get maxNodeCountInput(): number | undefined;
    private _minNodeCount?;
    get minNodeCount(): number;
    set minNodeCount(value: number);
    get minNodeCountInput(): number | undefined;
}
export interface ContainerNodePoolManagement {
    /**
     * Whether the nodes will be automatically repaired.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#auto_repair ContainerNodePool#auto_repair}
     */
    readonly autoRepair?: boolean | cdktf.IResolvable;
    /**
     * Whether the nodes will be automatically upgraded.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#auto_upgrade ContainerNodePool#auto_upgrade}
     */
    readonly autoUpgrade?: boolean | cdktf.IResolvable;
}
export declare class ContainerNodePoolManagementOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _autoRepair?;
    get autoRepair(): boolean | cdktf.IResolvable | undefined;
    set autoRepair(value: boolean | cdktf.IResolvable | undefined);
    resetAutoRepair(): void;
    get autoRepairInput(): boolean | cdktf.IResolvable | undefined;
    private _autoUpgrade?;
    get autoUpgrade(): boolean | cdktf.IResolvable | undefined;
    set autoUpgrade(value: boolean | cdktf.IResolvable | undefined);
    resetAutoUpgrade(): void;
    get autoUpgradeInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ContainerNodePoolNodeConfigGuestAccelerator {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#count ContainerNodePool#count}.
     */
    readonly count?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#gpu_partition_size ContainerNodePool#gpu_partition_size}.
     */
    readonly gpuPartitionSize?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#type ContainerNodePool#type}.
     */
    readonly type?: string;
}
export interface ContainerNodePoolNodeConfigTaint {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#effect ContainerNodePool#effect}.
     */
    readonly effect?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#key ContainerNodePool#key}.
     */
    readonly key?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#value ContainerNodePool#value}.
     */
    readonly value?: string;
}
export interface ContainerNodePoolNodeConfigShieldedInstanceConfig {
    /**
     * Defines whether the instance has integrity monitoring enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#enable_integrity_monitoring ContainerNodePool#enable_integrity_monitoring}
     */
    readonly enableIntegrityMonitoring?: boolean | cdktf.IResolvable;
    /**
     * Defines whether the instance has Secure Boot enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#enable_secure_boot ContainerNodePool#enable_secure_boot}
     */
    readonly enableSecureBoot?: boolean | cdktf.IResolvable;
}
export declare class ContainerNodePoolNodeConfigShieldedInstanceConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _enableIntegrityMonitoring?;
    get enableIntegrityMonitoring(): boolean | cdktf.IResolvable | undefined;
    set enableIntegrityMonitoring(value: boolean | cdktf.IResolvable | undefined);
    resetEnableIntegrityMonitoring(): void;
    get enableIntegrityMonitoringInput(): boolean | cdktf.IResolvable | undefined;
    private _enableSecureBoot?;
    get enableSecureBoot(): boolean | cdktf.IResolvable | undefined;
    set enableSecureBoot(value: boolean | cdktf.IResolvable | undefined);
    resetEnableSecureBoot(): void;
    get enableSecureBootInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ContainerNodePoolNodeConfigWorkloadMetadataConfig {
    /**
     * Mode is the configuration for how to expose metadata to workloads running on the node.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#mode ContainerNodePool#mode}
     */
    readonly mode?: string;
    /**
     * NodeMetadata is the configuration for how to expose metadata to the workloads running on the node.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#node_metadata ContainerNodePool#node_metadata}
     */
    readonly nodeMetadata?: string;
}
export declare class ContainerNodePoolNodeConfigWorkloadMetadataConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _mode?;
    get mode(): string | undefined;
    set mode(value: string | undefined);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _nodeMetadata?;
    get nodeMetadata(): string | undefined;
    set nodeMetadata(value: string | undefined);
    resetNodeMetadata(): void;
    get nodeMetadataInput(): string | undefined;
}
export interface ContainerNodePoolNodeConfig {
    /**
     * Size of the disk attached to each node, specified in GB. The smallest allowed disk size is 10GB.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#disk_size_gb ContainerNodePool#disk_size_gb}
     */
    readonly diskSizeGb?: number;
    /**
     * Type of the disk attached to each node.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#disk_type ContainerNodePool#disk_type}
     */
    readonly diskType?: string;
    /**
     * List of the type and count of accelerator cards attached to the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#guest_accelerator ContainerNodePool#guest_accelerator}
     */
    readonly guestAccelerator?: ContainerNodePoolNodeConfigGuestAccelerator[];
    /**
     * The image type to use for this node.
     *
     * Note that for a given image type, the latest version of it will be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#image_type ContainerNodePool#image_type}
     */
    readonly imageType?: string;
    /**
     * The map of Kubernetes labels (key/value pairs) to be applied to each node.
     *
     * These will added in addition to any default label(s) that Kubernetes may apply to the node.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#labels ContainerNodePool#labels}
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The number of local SSD disks to be attached to the node.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#local_ssd_count ContainerNodePool#local_ssd_count}
     */
    readonly localSsdCount?: number;
    /**
     * The name of a Google Compute Engine machine type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#machine_type ContainerNodePool#machine_type}
     */
    readonly machineType?: string;
    /**
     * The metadata key/value pairs assigned to instances in the cluster.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#metadata ContainerNodePool#metadata}
     */
    readonly metadata?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Minimum CPU platform to be used by this instance.
     *
     * The instance may be scheduled on the specified or newer CPU platform.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#min_cpu_platform ContainerNodePool#min_cpu_platform}
     */
    readonly minCpuPlatform?: string;
    /**
     * The set of Google API scopes to be made available on all of the node VMs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#oauth_scopes ContainerNodePool#oauth_scopes}
     */
    readonly oauthScopes?: string[];
    /**
     * Whether the nodes are created as preemptible VM instances.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#preemptible ContainerNodePool#preemptible}
     */
    readonly preemptible?: boolean | cdktf.IResolvable;
    /**
     * The Google Cloud Platform Service Account to be used by the node VMs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#service_account ContainerNodePool#service_account}
     */
    readonly serviceAccount?: string;
    /**
     * The list of instance tags applied to all nodes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#tags ContainerNodePool#tags}
     */
    readonly tags?: string[];
    /**
     * List of Kubernetes taints to be applied to each node.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#taint ContainerNodePool#taint}
     */
    readonly taint?: ContainerNodePoolNodeConfigTaint[];
    /**
     * shielded_instance_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#shielded_instance_config ContainerNodePool#shielded_instance_config}
     */
    readonly shieldedInstanceConfig?: ContainerNodePoolNodeConfigShieldedInstanceConfig;
    /**
     * workload_metadata_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#workload_metadata_config ContainerNodePool#workload_metadata_config}
     */
    readonly workloadMetadataConfig?: ContainerNodePoolNodeConfigWorkloadMetadataConfig;
}
export declare class ContainerNodePoolNodeConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _diskSizeGb?;
    get diskSizeGb(): number | undefined;
    set diskSizeGb(value: number | undefined);
    resetDiskSizeGb(): void;
    get diskSizeGbInput(): number | undefined;
    private _diskType?;
    get diskType(): string | undefined;
    set diskType(value: string | undefined);
    resetDiskType(): void;
    get diskTypeInput(): string | undefined;
    private _guestAccelerator?;
    get guestAccelerator(): ContainerNodePoolNodeConfigGuestAccelerator[] | undefined;
    set guestAccelerator(value: ContainerNodePoolNodeConfigGuestAccelerator[] | undefined);
    resetGuestAccelerator(): void;
    get guestAcceleratorInput(): ContainerNodePoolNodeConfigGuestAccelerator[] | undefined;
    private _imageType?;
    get imageType(): string | undefined;
    set imageType(value: string | undefined);
    resetImageType(): void;
    get imageTypeInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _localSsdCount?;
    get localSsdCount(): number | undefined;
    set localSsdCount(value: number | undefined);
    resetLocalSsdCount(): void;
    get localSsdCountInput(): number | undefined;
    private _machineType?;
    get machineType(): string | undefined;
    set machineType(value: string | undefined);
    resetMachineType(): void;
    get machineTypeInput(): string | undefined;
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set metadata(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetMetadata(): void;
    get metadataInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _minCpuPlatform?;
    get minCpuPlatform(): string | undefined;
    set minCpuPlatform(value: string | undefined);
    resetMinCpuPlatform(): void;
    get minCpuPlatformInput(): string | undefined;
    private _oauthScopes?;
    get oauthScopes(): string[] | undefined;
    set oauthScopes(value: string[] | undefined);
    resetOauthScopes(): void;
    get oauthScopesInput(): string[] | undefined;
    private _preemptible?;
    get preemptible(): boolean | cdktf.IResolvable | undefined;
    set preemptible(value: boolean | cdktf.IResolvable | undefined);
    resetPreemptible(): void;
    get preemptibleInput(): boolean | cdktf.IResolvable | undefined;
    private _serviceAccount?;
    get serviceAccount(): string | undefined;
    set serviceAccount(value: string | undefined);
    resetServiceAccount(): void;
    get serviceAccountInput(): string | undefined;
    private _tags?;
    get tags(): string[] | undefined;
    set tags(value: string[] | undefined);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _taint?;
    get taint(): ContainerNodePoolNodeConfigTaint[] | undefined;
    set taint(value: ContainerNodePoolNodeConfigTaint[] | undefined);
    resetTaint(): void;
    get taintInput(): ContainerNodePoolNodeConfigTaint[] | undefined;
    private _shieldedInstanceConfig?;
    private __shieldedInstanceConfigOutput;
    get shieldedInstanceConfig(): ContainerNodePoolNodeConfigShieldedInstanceConfigOutputReference;
    putShieldedInstanceConfig(value: ContainerNodePoolNodeConfigShieldedInstanceConfig | undefined): void;
    resetShieldedInstanceConfig(): void;
    get shieldedInstanceConfigInput(): ContainerNodePoolNodeConfigShieldedInstanceConfig | undefined;
    private _workloadMetadataConfig?;
    private __workloadMetadataConfigOutput;
    get workloadMetadataConfig(): ContainerNodePoolNodeConfigWorkloadMetadataConfigOutputReference;
    putWorkloadMetadataConfig(value: ContainerNodePoolNodeConfigWorkloadMetadataConfig | undefined): void;
    resetWorkloadMetadataConfig(): void;
    get workloadMetadataConfigInput(): ContainerNodePoolNodeConfigWorkloadMetadataConfig | undefined;
}
export interface ContainerNodePoolTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#create ContainerNodePool#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#delete ContainerNodePool#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#update ContainerNodePool#update}.
     */
    readonly update?: string;
}
export declare class ContainerNodePoolTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface ContainerNodePoolUpgradeSettings {
    /**
     * The number of additional nodes that can be added to the node pool during an upgrade.
     *
     * Increasing max_surge raises the number of nodes that can be upgraded simultaneously. Can be set to 0 or greater.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#max_surge ContainerNodePool#max_surge}
     */
    readonly maxSurge: number;
    /**
     * The number of nodes that can be simultaneously unavailable during an upgrade.
     *
     * Increasing max_unavailable raises the number of nodes that can be upgraded in parallel. Can be set to 0 or greater.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html#max_unavailable ContainerNodePool#max_unavailable}
     */
    readonly maxUnavailable: number;
}
export declare class ContainerNodePoolUpgradeSettingsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _maxSurge?;
    get maxSurge(): number;
    set maxSurge(value: number);
    get maxSurgeInput(): number | undefined;
    private _maxUnavailable?;
    get maxUnavailable(): number;
    set maxUnavailable(value: number);
    get maxUnavailableInput(): number | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html google_container_node_pool}.
 */
export declare class ContainerNodePool extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/container_node_pool.html google_container_node_pool} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: ContainerNodePoolConfig);
    private _cluster?;
    get cluster(): string;
    set cluster(value: string);
    get clusterInput(): string | undefined;
    get id(): string;
    private _initialNodeCount?;
    get initialNodeCount(): number | undefined;
    set initialNodeCount(value: number | undefined);
    resetInitialNodeCount(): void;
    get initialNodeCountInput(): number | undefined;
    get instanceGroupUrls(): string[];
    private _location?;
    get location(): string | undefined;
    set location(value: string | undefined);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _maxPodsPerNode?;
    get maxPodsPerNode(): number | undefined;
    set maxPodsPerNode(value: number | undefined);
    resetMaxPodsPerNode(): void;
    get maxPodsPerNodeInput(): number | undefined;
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    resetName(): void;
    get nameInput(): string | undefined;
    private _namePrefix?;
    get namePrefix(): string | undefined;
    set namePrefix(value: string | undefined);
    resetNamePrefix(): void;
    get namePrefixInput(): string | undefined;
    private _nodeCount?;
    get nodeCount(): number | undefined;
    set nodeCount(value: number | undefined);
    resetNodeCount(): void;
    get nodeCountInput(): number | undefined;
    private _nodeLocations?;
    get nodeLocations(): string[] | undefined;
    set nodeLocations(value: string[] | undefined);
    resetNodeLocations(): void;
    get nodeLocationsInput(): string[] | undefined;
    get operation(): string;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _version?;
    get version(): string | undefined;
    set version(value: string | undefined);
    resetVersion(): void;
    get versionInput(): string | undefined;
    private _autoscaling?;
    private __autoscalingOutput;
    get autoscaling(): ContainerNodePoolAutoscalingOutputReference;
    putAutoscaling(value: ContainerNodePoolAutoscaling | undefined): void;
    resetAutoscaling(): void;
    get autoscalingInput(): ContainerNodePoolAutoscaling | undefined;
    private _management?;
    private __managementOutput;
    get management(): ContainerNodePoolManagementOutputReference;
    putManagement(value: ContainerNodePoolManagement | undefined): void;
    resetManagement(): void;
    get managementInput(): ContainerNodePoolManagement | undefined;
    private _nodeConfig?;
    private __nodeConfigOutput;
    get nodeConfig(): ContainerNodePoolNodeConfigOutputReference;
    putNodeConfig(value: ContainerNodePoolNodeConfig | undefined): void;
    resetNodeConfig(): void;
    get nodeConfigInput(): ContainerNodePoolNodeConfig | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): ContainerNodePoolTimeoutsOutputReference;
    putTimeouts(value: ContainerNodePoolTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): ContainerNodePoolTimeouts | undefined;
    private _upgradeSettings?;
    private __upgradeSettingsOutput;
    get upgradeSettings(): ContainerNodePoolUpgradeSettingsOutputReference;
    putUpgradeSettings(value: ContainerNodePoolUpgradeSettings | undefined): void;
    resetUpgradeSettings(): void;
    get upgradeSettingsInput(): ContainerNodePoolUpgradeSettings | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
