import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ContainerClusterConfig extends cdktf.TerraformMetaArguments {
    /**
     * The IP address range of the Kubernetes pods in this cluster in CIDR notation (e.g. 10.96.0.0/14). Leave blank to have one automatically chosen or specify a /14 block in 10.0.0.0/8. This field will only work for routes-based clusters, where ip_allocation_policy is not defined.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#cluster_ipv4_cidr ContainerCluster#cluster_ipv4_cidr}
     */
    readonly clusterIpv4Cidr?: string;
    /**
     * The desired datapath provider for this cluster. By default, uses the IPTables-based kube-proxy implementation.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#datapath_provider ContainerCluster#datapath_provider}
     */
    readonly datapathProvider?: string;
    /**
     * The default maximum number of pods per node in this cluster.
     *
     * This doesn't work on "routes-based" clusters, clusters that don't have IP Aliasing enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#default_max_pods_per_node ContainerCluster#default_max_pods_per_node}
     */
    readonly defaultMaxPodsPerNode?: number;
    /**
     * Description of the cluster.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#description ContainerCluster#description}
     */
    readonly description?: string;
    /**
     * Enable Autopilot for this cluster.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#enable_autopilot ContainerCluster#enable_autopilot}
     */
    readonly enableAutopilot?: boolean | cdktf.IResolvable;
    /**
     * Enable Binary Authorization for this cluster. If enabled, all container images will be validated by Google Binary Authorization.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#enable_binary_authorization ContainerCluster#enable_binary_authorization}
     */
    readonly enableBinaryAuthorization?: boolean | cdktf.IResolvable;
    /**
     * Whether Intra-node visibility is enabled for this cluster.
     *
     * This makes same node pod to pod traffic visible for VPC network.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#enable_intranode_visibility ContainerCluster#enable_intranode_visibility}
     */
    readonly enableIntranodeVisibility?: boolean | cdktf.IResolvable;
    /**
     * Whether to enable Kubernetes Alpha features for this cluster.
     *
     * Note that when this option is enabled, the cluster cannot be upgraded and will be automatically deleted after 30 days.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#enable_kubernetes_alpha ContainerCluster#enable_kubernetes_alpha}
     */
    readonly enableKubernetesAlpha?: boolean | cdktf.IResolvable;
    /**
     * Whether the ABAC authorizer is enabled for this cluster.
     *
     * When enabled, identities in the system, including service accounts, nodes, and controllers, will have statically granted permissions beyond those provided by the RBAC configuration or IAM. Defaults to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#enable_legacy_abac ContainerCluster#enable_legacy_abac}
     */
    readonly enableLegacyAbac?: boolean | cdktf.IResolvable;
    /**
     * Enable Shielded Nodes features on all nodes in this cluster.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#enable_shielded_nodes ContainerCluster#enable_shielded_nodes}
     */
    readonly enableShieldedNodes?: boolean | cdktf.IResolvable;
    /**
     * Whether to enable Cloud TPU resources in this cluster.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#enable_tpu ContainerCluster#enable_tpu}
     */
    readonly enableTpu?: boolean | cdktf.IResolvable;
    /**
     * The number of nodes to create in this cluster's default node pool.
     *
     * In regional or multi-zonal clusters, this is the number of nodes per zone. Must be set if node_pool is not set. If you're using google_container_node_pool objects with no default node pool, you'll need to set this to a value of at least 1, alongside setting remove_default_node_pool to true.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#initial_node_count ContainerCluster#initial_node_count}
     */
    readonly initialNodeCount?: number;
    /**
     * The location (region or zone) in which the cluster master will be created, as well as the default node location.
     *
     * If you specify a zone (such as us-central1-a), the cluster will be a zonal cluster with a single cluster master. If you specify a region (such as us-west1), the cluster will be a regional cluster with multiple masters spread across zones in the region, and with default node locations in those zones as well.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#location ContainerCluster#location}
     */
    readonly location?: string;
    /**
     * The logging service that the cluster should write logs to.
     *
     * Available options include logging.googleapis.com(Legacy Stackdriver), logging.googleapis.com/kubernetes(Stackdriver Kubernetes Engine Logging), and none. Defaults to logging.googleapis.com/kubernetes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#logging_service ContainerCluster#logging_service}
     */
    readonly loggingService?: string;
    /**
     * The minimum version of the master.
     *
     * GKE will auto-update the master to new versions, so this does not guarantee the current master version--use the read-only master_version field to obtain that. If unset, the cluster's version will be set by GKE to the version of the most recent official release (which is not necessarily the latest version).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#min_master_version ContainerCluster#min_master_version}
     */
    readonly minMasterVersion?: string;
    /**
     * The monitoring service that the cluster should write metrics to.
     *
     * Automatically send metrics from pods in the cluster to the Google Cloud Monitoring API. VM metrics will be collected by Google Compute Engine regardless of this setting Available options include monitoring.googleapis.com(Legacy Stackdriver), monitoring.googleapis.com/kubernetes(Stackdriver Kubernetes Engine Monitoring), and none. Defaults to monitoring.googleapis.com/kubernetes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#monitoring_service ContainerCluster#monitoring_service}
     */
    readonly monitoringService?: string;
    /**
     * The name of the cluster, unique within the project and location.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#name ContainerCluster#name}
     */
    readonly name: string;
    /**
     * The name or self_link of the Google Compute Engine network to which the cluster is connected.
     *
     * For Shared VPC, set this to the self link of the shared network.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#network ContainerCluster#network}
     */
    readonly network?: string;
    /**
     * Determines whether alias IPs or routes will be used for pod IPs in the cluster.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#networking_mode ContainerCluster#networking_mode}
     */
    readonly networkingMode?: string;
    /**
     * The list of zones in which the cluster's nodes are located.
     *
     * Nodes must be in the region of their regional cluster or in the same region as their cluster's zone for zonal clusters. If this is specified for a zonal cluster, omit the cluster's zone.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#node_locations ContainerCluster#node_locations}
     */
    readonly nodeLocations?: string[];
    /**
     * The Kubernetes version on the nodes.
     *
     * Must either be unset or set to the same value as min_master_version on create. Defaults to the default version set by GKE which is not necessarily the latest version. This only affects nodes in the default node pool. While a fuzzy version can be specified, it's recommended that you specify explicit versions as Terraform will see spurious diffs when fuzzy versions are used. See the google_container_engine_versions data source's version_prefix field to approximate fuzzy versions in a Terraform-compatible way. To update nodes in other node pools, use the version attribute on the node pool.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#node_version ContainerCluster#node_version}
     */
    readonly nodeVersion?: string;
    /**
     * The desired state of IPv6 connectivity to Google Services.
     *
     * By default, no private IPv6 access to or from Google Services (all access will be via IPv4).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#private_ipv6_google_access ContainerCluster#private_ipv6_google_access}
     */
    readonly privateIpv6GoogleAccess?: string;
    /**
     * The ID of the project in which the resource belongs.
     *
     * If it is not provided, the provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#project ContainerCluster#project}
     */
    readonly project?: string;
    /**
     * If true, deletes the default node pool upon cluster creation.
     *
     * If you're using google_container_node_pool resources with no default node pool, this should be set to true, alongside setting initial_node_count to at least 1.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#remove_default_node_pool ContainerCluster#remove_default_node_pool}
     */
    readonly removeDefaultNodePool?: boolean | cdktf.IResolvable;
    /**
     * The GCE resource labels (a map of key/value pairs) to be applied to the cluster.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#resource_labels ContainerCluster#resource_labels}
     */
    readonly resourceLabels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The name or self_link of the Google Compute Engine subnetwork in which the cluster's instances are launched.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#subnetwork ContainerCluster#subnetwork}
     */
    readonly subnetwork?: string;
    /**
     * addons_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#addons_config ContainerCluster#addons_config}
     */
    readonly addonsConfig?: ContainerClusterAddonsConfig;
    /**
     * authenticator_groups_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#authenticator_groups_config ContainerCluster#authenticator_groups_config}
     */
    readonly authenticatorGroupsConfig?: ContainerClusterAuthenticatorGroupsConfig;
    /**
     * cluster_autoscaling block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#cluster_autoscaling ContainerCluster#cluster_autoscaling}
     */
    readonly clusterAutoscaling?: ContainerClusterClusterAutoscaling;
    /**
     * database_encryption block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#database_encryption ContainerCluster#database_encryption}
     */
    readonly databaseEncryption?: ContainerClusterDatabaseEncryption;
    /**
     * default_snat_status block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#default_snat_status ContainerCluster#default_snat_status}
     */
    readonly defaultSnatStatus?: ContainerClusterDefaultSnatStatus;
    /**
     * ip_allocation_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#ip_allocation_policy ContainerCluster#ip_allocation_policy}
     */
    readonly ipAllocationPolicy?: ContainerClusterIpAllocationPolicy;
    /**
     * logging_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#logging_config ContainerCluster#logging_config}
     */
    readonly loggingConfig?: ContainerClusterLoggingConfig;
    /**
     * maintenance_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#maintenance_policy ContainerCluster#maintenance_policy}
     */
    readonly maintenancePolicy?: ContainerClusterMaintenancePolicy;
    /**
     * master_auth block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#master_auth ContainerCluster#master_auth}
     */
    readonly masterAuth?: ContainerClusterMasterAuth;
    /**
     * master_authorized_networks_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#master_authorized_networks_config ContainerCluster#master_authorized_networks_config}
     */
    readonly masterAuthorizedNetworksConfig?: ContainerClusterMasterAuthorizedNetworksConfig;
    /**
     * monitoring_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#monitoring_config ContainerCluster#monitoring_config}
     */
    readonly monitoringConfig?: ContainerClusterMonitoringConfig;
    /**
     * network_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#network_policy ContainerCluster#network_policy}
     */
    readonly networkPolicy?: ContainerClusterNetworkPolicy;
    /**
     * node_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#node_config ContainerCluster#node_config}
     */
    readonly nodeConfig?: ContainerClusterNodeConfig;
    /**
     * node_pool block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#node_pool ContainerCluster#node_pool}
     */
    readonly nodePool?: ContainerClusterNodePool[];
    /**
     * pod_security_policy_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#pod_security_policy_config ContainerCluster#pod_security_policy_config}
     */
    readonly podSecurityPolicyConfig?: ContainerClusterPodSecurityPolicyConfig;
    /**
     * private_cluster_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#private_cluster_config ContainerCluster#private_cluster_config}
     */
    readonly privateClusterConfig?: ContainerClusterPrivateClusterConfig;
    /**
     * release_channel block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#release_channel ContainerCluster#release_channel}
     */
    readonly releaseChannel?: ContainerClusterReleaseChannel;
    /**
     * resource_usage_export_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#resource_usage_export_config ContainerCluster#resource_usage_export_config}
     */
    readonly resourceUsageExportConfig?: ContainerClusterResourceUsageExportConfig;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#timeouts ContainerCluster#timeouts}
     */
    readonly timeouts?: ContainerClusterTimeouts;
    /**
     * vertical_pod_autoscaling block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#vertical_pod_autoscaling ContainerCluster#vertical_pod_autoscaling}
     */
    readonly verticalPodAutoscaling?: ContainerClusterVerticalPodAutoscaling;
    /**
     * workload_identity_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#workload_identity_config ContainerCluster#workload_identity_config}
     */
    readonly workloadIdentityConfig?: ContainerClusterWorkloadIdentityConfig;
}
export interface ContainerClusterAddonsConfigCloudrunConfig {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#disabled ContainerCluster#disabled}.
     */
    readonly disabled: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#load_balancer_type ContainerCluster#load_balancer_type}.
     */
    readonly loadBalancerType?: string;
}
export declare class ContainerClusterAddonsConfigCloudrunConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _loadBalancerType?;
    get loadBalancerType(): string | undefined;
    set loadBalancerType(value: string | undefined);
    resetLoadBalancerType(): void;
    get loadBalancerTypeInput(): string | undefined;
}
export interface ContainerClusterAddonsConfigHorizontalPodAutoscaling {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#disabled ContainerCluster#disabled}.
     */
    readonly disabled: boolean | cdktf.IResolvable;
}
export declare class ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ContainerClusterAddonsConfigHttpLoadBalancing {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#disabled ContainerCluster#disabled}.
     */
    readonly disabled: boolean | cdktf.IResolvable;
}
export declare class ContainerClusterAddonsConfigHttpLoadBalancingOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ContainerClusterAddonsConfigNetworkPolicyConfig {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#disabled ContainerCluster#disabled}.
     */
    readonly disabled: boolean | cdktf.IResolvable;
}
export declare class ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ContainerClusterAddonsConfig {
    /**
     * cloudrun_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#cloudrun_config ContainerCluster#cloudrun_config}
     */
    readonly cloudrunConfig?: ContainerClusterAddonsConfigCloudrunConfig;
    /**
     * horizontal_pod_autoscaling block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#horizontal_pod_autoscaling ContainerCluster#horizontal_pod_autoscaling}
     */
    readonly horizontalPodAutoscaling?: ContainerClusterAddonsConfigHorizontalPodAutoscaling;
    /**
     * http_load_balancing block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#http_load_balancing ContainerCluster#http_load_balancing}
     */
    readonly httpLoadBalancing?: ContainerClusterAddonsConfigHttpLoadBalancing;
    /**
     * network_policy_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#network_policy_config ContainerCluster#network_policy_config}
     */
    readonly networkPolicyConfig?: ContainerClusterAddonsConfigNetworkPolicyConfig;
}
export declare class ContainerClusterAddonsConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _cloudrunConfig?;
    private __cloudrunConfigOutput;
    get cloudrunConfig(): ContainerClusterAddonsConfigCloudrunConfigOutputReference;
    putCloudrunConfig(value: ContainerClusterAddonsConfigCloudrunConfig | undefined): void;
    resetCloudrunConfig(): void;
    get cloudrunConfigInput(): ContainerClusterAddonsConfigCloudrunConfig | undefined;
    private _horizontalPodAutoscaling?;
    private __horizontalPodAutoscalingOutput;
    get horizontalPodAutoscaling(): ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference;
    putHorizontalPodAutoscaling(value: ContainerClusterAddonsConfigHorizontalPodAutoscaling | undefined): void;
    resetHorizontalPodAutoscaling(): void;
    get horizontalPodAutoscalingInput(): ContainerClusterAddonsConfigHorizontalPodAutoscaling | undefined;
    private _httpLoadBalancing?;
    private __httpLoadBalancingOutput;
    get httpLoadBalancing(): ContainerClusterAddonsConfigHttpLoadBalancingOutputReference;
    putHttpLoadBalancing(value: ContainerClusterAddonsConfigHttpLoadBalancing | undefined): void;
    resetHttpLoadBalancing(): void;
    get httpLoadBalancingInput(): ContainerClusterAddonsConfigHttpLoadBalancing | undefined;
    private _networkPolicyConfig?;
    private __networkPolicyConfigOutput;
    get networkPolicyConfig(): ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference;
    putNetworkPolicyConfig(value: ContainerClusterAddonsConfigNetworkPolicyConfig | undefined): void;
    resetNetworkPolicyConfig(): void;
    get networkPolicyConfigInput(): ContainerClusterAddonsConfigNetworkPolicyConfig | undefined;
}
export interface ContainerClusterAuthenticatorGroupsConfig {
    /**
     * The name of the RBAC security group for use with Google security groups in Kubernetes RBAC.
     *
     * Group name must be in format gke-security-groups@yourdomain.com.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#security_group ContainerCluster#security_group}
     */
    readonly securityGroup: string;
}
export declare class ContainerClusterAuthenticatorGroupsConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _securityGroup?;
    get securityGroup(): string;
    set securityGroup(value: string);
    get securityGroupInput(): string | undefined;
}
export interface ContainerClusterClusterAutoscalingAutoProvisioningDefaults {
    /**
     * Scopes that are used by NAP when creating node pools.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#oauth_scopes ContainerCluster#oauth_scopes}
     */
    readonly oauthScopes?: string[];
    /**
     * The Google Cloud Platform Service Account to be used by the node VMs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#service_account ContainerCluster#service_account}
     */
    readonly serviceAccount?: string;
}
export declare class ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _oauthScopes?;
    get oauthScopes(): string[] | undefined;
    set oauthScopes(value: string[] | undefined);
    resetOauthScopes(): void;
    get oauthScopesInput(): string[] | undefined;
    private _serviceAccount?;
    get serviceAccount(): string | undefined;
    set serviceAccount(value: string | undefined);
    resetServiceAccount(): void;
    get serviceAccountInput(): string | undefined;
}
export interface ContainerClusterClusterAutoscalingResourceLimits {
    /**
     * Maximum amount of the resource in the cluster.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#maximum ContainerCluster#maximum}
     */
    readonly maximum?: number;
    /**
     * Minimum amount of the resource in the cluster.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#minimum ContainerCluster#minimum}
     */
    readonly minimum?: number;
    /**
     * The type of the resource.
     *
     * For example, cpu and memory. See the guide to using Node Auto-Provisioning for a list of types.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#resource_type ContainerCluster#resource_type}
     */
    readonly resourceType: string;
}
export interface ContainerClusterClusterAutoscaling {
    /**
     * Whether node auto-provisioning is enabled. Resource limits for cpu and memory must be defined to enable node auto-provisioning.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#enabled ContainerCluster#enabled}
     */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
     * auto_provisioning_defaults block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#auto_provisioning_defaults ContainerCluster#auto_provisioning_defaults}
     */
    readonly autoProvisioningDefaults?: ContainerClusterClusterAutoscalingAutoProvisioningDefaults;
    /**
     * resource_limits block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#resource_limits ContainerCluster#resource_limits}
     */
    readonly resourceLimits?: ContainerClusterClusterAutoscalingResourceLimits[];
}
export declare class ContainerClusterClusterAutoscalingOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _autoProvisioningDefaults?;
    private __autoProvisioningDefaultsOutput;
    get autoProvisioningDefaults(): ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference;
    putAutoProvisioningDefaults(value: ContainerClusterClusterAutoscalingAutoProvisioningDefaults | undefined): void;
    resetAutoProvisioningDefaults(): void;
    get autoProvisioningDefaultsInput(): ContainerClusterClusterAutoscalingAutoProvisioningDefaults | undefined;
    private _resourceLimits?;
    get resourceLimits(): ContainerClusterClusterAutoscalingResourceLimits[] | undefined;
    set resourceLimits(value: ContainerClusterClusterAutoscalingResourceLimits[] | undefined);
    resetResourceLimits(): void;
    get resourceLimitsInput(): ContainerClusterClusterAutoscalingResourceLimits[] | undefined;
}
export interface ContainerClusterDatabaseEncryption {
    /**
     * The key to use to encrypt/decrypt secrets.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#key_name ContainerCluster#key_name}
     */
    readonly keyName?: string;
    /**
     * ENCRYPTED or DECRYPTED.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#state ContainerCluster#state}
     */
    readonly state: string;
}
export declare class ContainerClusterDatabaseEncryptionOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _keyName?;
    get keyName(): string | undefined;
    set keyName(value: string | undefined);
    resetKeyName(): void;
    get keyNameInput(): string | undefined;
    private _state?;
    get state(): string;
    set state(value: string);
    get stateInput(): string | undefined;
}
export interface ContainerClusterDefaultSnatStatus {
    /**
     * When disabled is set to false, default IP masquerade rules will be applied to the nodes to prevent sNAT on cluster internal traffic.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#disabled ContainerCluster#disabled}
     */
    readonly disabled: boolean | cdktf.IResolvable;
}
export declare class ContainerClusterDefaultSnatStatusOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ContainerClusterIpAllocationPolicy {
    /**
     * The IP address range for the cluster pod IPs.
     *
     * Set to blank to have a range chosen with the default size. Set to /netmask (e.g. /14) to have a range chosen with a specific netmask. Set to a CIDR notation (e.g. 10.96.0.0/14) from the RFC-1918 private networks (e.g. 10.0.0.0/8, 172.16.0.0/12, 192.168.0.0/16) to pick a specific range to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#cluster_ipv4_cidr_block ContainerCluster#cluster_ipv4_cidr_block}
     */
    readonly clusterIpv4CidrBlock?: string;
    /**
     * The name of the existing secondary range in the cluster's subnetwork to use for pod IP addresses.
     *
     * Alternatively, cluster_ipv4_cidr_block can be used to automatically create a GKE-managed one.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#cluster_secondary_range_name ContainerCluster#cluster_secondary_range_name}
     */
    readonly clusterSecondaryRangeName?: string;
    /**
     * The IP address range of the services IPs in this cluster.
     *
     * Set to blank to have a range chosen with the default size. Set to /netmask (e.g. /14) to have a range chosen with a specific netmask. Set to a CIDR notation (e.g. 10.96.0.0/14) from the RFC-1918 private networks (e.g. 10.0.0.0/8, 172.16.0.0/12, 192.168.0.0/16) to pick a specific range to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#services_ipv4_cidr_block ContainerCluster#services_ipv4_cidr_block}
     */
    readonly servicesIpv4CidrBlock?: string;
    /**
     * The name of the existing secondary range in the cluster's subnetwork to use for service ClusterIPs.
     *
     * Alternatively, services_ipv4_cidr_block can be used to automatically create a GKE-managed one.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#services_secondary_range_name ContainerCluster#services_secondary_range_name}
     */
    readonly servicesSecondaryRangeName?: string;
}
export declare class ContainerClusterIpAllocationPolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _clusterIpv4CidrBlock?;
    get clusterIpv4CidrBlock(): string | undefined;
    set clusterIpv4CidrBlock(value: string | undefined);
    resetClusterIpv4CidrBlock(): void;
    get clusterIpv4CidrBlockInput(): string | undefined;
    private _clusterSecondaryRangeName?;
    get clusterSecondaryRangeName(): string | undefined;
    set clusterSecondaryRangeName(value: string | undefined);
    resetClusterSecondaryRangeName(): void;
    get clusterSecondaryRangeNameInput(): string | undefined;
    private _servicesIpv4CidrBlock?;
    get servicesIpv4CidrBlock(): string | undefined;
    set servicesIpv4CidrBlock(value: string | undefined);
    resetServicesIpv4CidrBlock(): void;
    get servicesIpv4CidrBlockInput(): string | undefined;
    private _servicesSecondaryRangeName?;
    get servicesSecondaryRangeName(): string | undefined;
    set servicesSecondaryRangeName(value: string | undefined);
    resetServicesSecondaryRangeName(): void;
    get servicesSecondaryRangeNameInput(): string | undefined;
}
export interface ContainerClusterLoggingConfig {
    /**
     * GKE components exposing logs. Valid values include SYSTEM_COMPONENTS and WORKLOADS.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#enable_components ContainerCluster#enable_components}
     */
    readonly enableComponents: string[];
}
export declare class ContainerClusterLoggingConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _enableComponents?;
    get enableComponents(): string[];
    set enableComponents(value: string[]);
    get enableComponentsInput(): string[] | undefined;
}
export interface ContainerClusterMaintenancePolicyDailyMaintenanceWindow {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#start_time ContainerCluster#start_time}.
     */
    readonly startTime: string;
}
export declare class ContainerClusterMaintenancePolicyDailyMaintenanceWindowOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _startTime?;
    get startTime(): string;
    set startTime(value: string);
    get startTimeInput(): string | undefined;
}
export interface ContainerClusterMaintenancePolicyMaintenanceExclusion {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#end_time ContainerCluster#end_time}.
     */
    readonly endTime: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#exclusion_name ContainerCluster#exclusion_name}.
     */
    readonly exclusionName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#start_time ContainerCluster#start_time}.
     */
    readonly startTime: string;
}
export interface ContainerClusterMaintenancePolicyRecurringWindow {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#end_time ContainerCluster#end_time}.
     */
    readonly endTime: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#recurrence ContainerCluster#recurrence}.
     */
    readonly recurrence: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#start_time ContainerCluster#start_time}.
     */
    readonly startTime: string;
}
export declare class ContainerClusterMaintenancePolicyRecurringWindowOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _endTime?;
    get endTime(): string;
    set endTime(value: string);
    get endTimeInput(): string | undefined;
    private _recurrence?;
    get recurrence(): string;
    set recurrence(value: string);
    get recurrenceInput(): string | undefined;
    private _startTime?;
    get startTime(): string;
    set startTime(value: string);
    get startTimeInput(): string | undefined;
}
export interface ContainerClusterMaintenancePolicy {
    /**
     * daily_maintenance_window block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#daily_maintenance_window ContainerCluster#daily_maintenance_window}
     */
    readonly dailyMaintenanceWindow?: ContainerClusterMaintenancePolicyDailyMaintenanceWindow;
    /**
     * maintenance_exclusion block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#maintenance_exclusion ContainerCluster#maintenance_exclusion}
     */
    readonly maintenanceExclusion?: ContainerClusterMaintenancePolicyMaintenanceExclusion[];
    /**
     * recurring_window block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#recurring_window ContainerCluster#recurring_window}
     */
    readonly recurringWindow?: ContainerClusterMaintenancePolicyRecurringWindow;
}
export declare class ContainerClusterMaintenancePolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _dailyMaintenanceWindow?;
    private __dailyMaintenanceWindowOutput;
    get dailyMaintenanceWindow(): ContainerClusterMaintenancePolicyDailyMaintenanceWindowOutputReference;
    putDailyMaintenanceWindow(value: ContainerClusterMaintenancePolicyDailyMaintenanceWindow | undefined): void;
    resetDailyMaintenanceWindow(): void;
    get dailyMaintenanceWindowInput(): ContainerClusterMaintenancePolicyDailyMaintenanceWindow | undefined;
    private _maintenanceExclusion?;
    get maintenanceExclusion(): ContainerClusterMaintenancePolicyMaintenanceExclusion[] | undefined;
    set maintenanceExclusion(value: ContainerClusterMaintenancePolicyMaintenanceExclusion[] | undefined);
    resetMaintenanceExclusion(): void;
    get maintenanceExclusionInput(): ContainerClusterMaintenancePolicyMaintenanceExclusion[] | undefined;
    private _recurringWindow?;
    private __recurringWindowOutput;
    get recurringWindow(): ContainerClusterMaintenancePolicyRecurringWindowOutputReference;
    putRecurringWindow(value: ContainerClusterMaintenancePolicyRecurringWindow | undefined): void;
    resetRecurringWindow(): void;
    get recurringWindowInput(): ContainerClusterMaintenancePolicyRecurringWindow | undefined;
}
export interface ContainerClusterMasterAuthClientCertificateConfig {
    /**
     * Whether client certificate authorization is enabled for this cluster.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#issue_client_certificate ContainerCluster#issue_client_certificate}
     */
    readonly issueClientCertificate: boolean | cdktf.IResolvable;
}
export declare class ContainerClusterMasterAuthClientCertificateConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _issueClientCertificate?;
    get issueClientCertificate(): boolean | cdktf.IResolvable;
    set issueClientCertificate(value: boolean | cdktf.IResolvable);
    get issueClientCertificateInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ContainerClusterMasterAuth {
    /**
     * The password to use for HTTP basic authentication when accessing the Kubernetes master endpoint.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#password ContainerCluster#password}
     */
    readonly password?: string;
    /**
     * The username to use for HTTP basic authentication when accessing the Kubernetes master endpoint.
     *
     * If not present basic auth will be disabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#username ContainerCluster#username}
     */
    readonly username?: string;
    /**
     * client_certificate_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#client_certificate_config ContainerCluster#client_certificate_config}
     */
    readonly clientCertificateConfig?: ContainerClusterMasterAuthClientCertificateConfig;
}
export declare class ContainerClusterMasterAuthOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _password?;
    get password(): string | undefined;
    set password(value: string | undefined);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _username?;
    get username(): string | undefined;
    set username(value: string | undefined);
    resetUsername(): void;
    get usernameInput(): string | undefined;
    private _clientCertificateConfig?;
    private __clientCertificateConfigOutput;
    get clientCertificateConfig(): ContainerClusterMasterAuthClientCertificateConfigOutputReference;
    putClientCertificateConfig(value: ContainerClusterMasterAuthClientCertificateConfig | undefined): void;
    resetClientCertificateConfig(): void;
    get clientCertificateConfigInput(): ContainerClusterMasterAuthClientCertificateConfig | undefined;
}
export interface ContainerClusterMasterAuthorizedNetworksConfigCidrBlocks {
    /**
     * External network that can access Kubernetes master through HTTPS. Must be specified in CIDR notation.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#cidr_block ContainerCluster#cidr_block}
     */
    readonly cidrBlock: string;
    /**
     * Field for users to identify CIDR blocks.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#display_name ContainerCluster#display_name}
     */
    readonly displayName?: string;
}
export interface ContainerClusterMasterAuthorizedNetworksConfig {
    /**
     * cidr_blocks block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#cidr_blocks ContainerCluster#cidr_blocks}
     */
    readonly cidrBlocks?: ContainerClusterMasterAuthorizedNetworksConfigCidrBlocks[];
}
export declare class ContainerClusterMasterAuthorizedNetworksConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _cidrBlocks?;
    get cidrBlocks(): ContainerClusterMasterAuthorizedNetworksConfigCidrBlocks[] | undefined;
    set cidrBlocks(value: ContainerClusterMasterAuthorizedNetworksConfigCidrBlocks[] | undefined);
    resetCidrBlocks(): void;
    get cidrBlocksInput(): ContainerClusterMasterAuthorizedNetworksConfigCidrBlocks[] | undefined;
}
export interface ContainerClusterMonitoringConfig {
    /**
     * GKE components exposing metrics. Valid values include SYSTEM_COMPONENTS.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#enable_components ContainerCluster#enable_components}
     */
    readonly enableComponents: string[];
}
export declare class ContainerClusterMonitoringConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _enableComponents?;
    get enableComponents(): string[];
    set enableComponents(value: string[]);
    get enableComponentsInput(): string[] | undefined;
}
export interface ContainerClusterNetworkPolicy {
    /**
     * Whether network policy is enabled on the cluster.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#enabled ContainerCluster#enabled}
     */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
     * The selected network policy provider. Defaults to PROVIDER_UNSPECIFIED.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#provider ContainerCluster#provider}
     */
    readonly provider?: string;
}
export declare class ContainerClusterNetworkPolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _provider?;
    get provider(): string | undefined;
    set provider(value: string | undefined);
    resetProvider(): void;
    get providerInput(): string | undefined;
}
export interface ContainerClusterNodeConfigGuestAccelerator {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#count ContainerCluster#count}.
     */
    readonly count?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#gpu_partition_size ContainerCluster#gpu_partition_size}.
     */
    readonly gpuPartitionSize?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#type ContainerCluster#type}.
     */
    readonly type?: string;
}
export interface ContainerClusterNodeConfigTaint {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#effect ContainerCluster#effect}.
     */
    readonly effect?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#key ContainerCluster#key}.
     */
    readonly key?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#value ContainerCluster#value}.
     */
    readonly value?: string;
}
export interface ContainerClusterNodeConfigShieldedInstanceConfig {
    /**
     * Defines whether the instance has integrity monitoring enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#enable_integrity_monitoring ContainerCluster#enable_integrity_monitoring}
     */
    readonly enableIntegrityMonitoring?: boolean | cdktf.IResolvable;
    /**
     * Defines whether the instance has Secure Boot enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#enable_secure_boot ContainerCluster#enable_secure_boot}
     */
    readonly enableSecureBoot?: boolean | cdktf.IResolvable;
}
export declare class ContainerClusterNodeConfigShieldedInstanceConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _enableIntegrityMonitoring?;
    get enableIntegrityMonitoring(): boolean | cdktf.IResolvable | undefined;
    set enableIntegrityMonitoring(value: boolean | cdktf.IResolvable | undefined);
    resetEnableIntegrityMonitoring(): void;
    get enableIntegrityMonitoringInput(): boolean | cdktf.IResolvable | undefined;
    private _enableSecureBoot?;
    get enableSecureBoot(): boolean | cdktf.IResolvable | undefined;
    set enableSecureBoot(value: boolean | cdktf.IResolvable | undefined);
    resetEnableSecureBoot(): void;
    get enableSecureBootInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ContainerClusterNodeConfigWorkloadMetadataConfig {
    /**
     * Mode is the configuration for how to expose metadata to workloads running on the node.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#mode ContainerCluster#mode}
     */
    readonly mode?: string;
    /**
     * NodeMetadata is the configuration for how to expose metadata to the workloads running on the node.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#node_metadata ContainerCluster#node_metadata}
     */
    readonly nodeMetadata?: string;
}
export declare class ContainerClusterNodeConfigWorkloadMetadataConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _mode?;
    get mode(): string | undefined;
    set mode(value: string | undefined);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _nodeMetadata?;
    get nodeMetadata(): string | undefined;
    set nodeMetadata(value: string | undefined);
    resetNodeMetadata(): void;
    get nodeMetadataInput(): string | undefined;
}
export interface ContainerClusterNodeConfig {
    /**
     * Size of the disk attached to each node, specified in GB. The smallest allowed disk size is 10GB.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#disk_size_gb ContainerCluster#disk_size_gb}
     */
    readonly diskSizeGb?: number;
    /**
     * Type of the disk attached to each node.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#disk_type ContainerCluster#disk_type}
     */
    readonly diskType?: string;
    /**
     * List of the type and count of accelerator cards attached to the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#guest_accelerator ContainerCluster#guest_accelerator}
     */
    readonly guestAccelerator?: ContainerClusterNodeConfigGuestAccelerator[];
    /**
     * The image type to use for this node.
     *
     * Note that for a given image type, the latest version of it will be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#image_type ContainerCluster#image_type}
     */
    readonly imageType?: string;
    /**
     * The map of Kubernetes labels (key/value pairs) to be applied to each node.
     *
     * These will added in addition to any default label(s) that Kubernetes may apply to the node.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#labels ContainerCluster#labels}
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The number of local SSD disks to be attached to the node.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#local_ssd_count ContainerCluster#local_ssd_count}
     */
    readonly localSsdCount?: number;
    /**
     * The name of a Google Compute Engine machine type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#machine_type ContainerCluster#machine_type}
     */
    readonly machineType?: string;
    /**
     * The metadata key/value pairs assigned to instances in the cluster.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#metadata ContainerCluster#metadata}
     */
    readonly metadata?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Minimum CPU platform to be used by this instance.
     *
     * The instance may be scheduled on the specified or newer CPU platform.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#min_cpu_platform ContainerCluster#min_cpu_platform}
     */
    readonly minCpuPlatform?: string;
    /**
     * The set of Google API scopes to be made available on all of the node VMs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#oauth_scopes ContainerCluster#oauth_scopes}
     */
    readonly oauthScopes?: string[];
    /**
     * Whether the nodes are created as preemptible VM instances.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#preemptible ContainerCluster#preemptible}
     */
    readonly preemptible?: boolean | cdktf.IResolvable;
    /**
     * The Google Cloud Platform Service Account to be used by the node VMs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#service_account ContainerCluster#service_account}
     */
    readonly serviceAccount?: string;
    /**
     * The list of instance tags applied to all nodes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#tags ContainerCluster#tags}
     */
    readonly tags?: string[];
    /**
     * List of Kubernetes taints to be applied to each node.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#taint ContainerCluster#taint}
     */
    readonly taint?: ContainerClusterNodeConfigTaint[];
    /**
     * shielded_instance_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#shielded_instance_config ContainerCluster#shielded_instance_config}
     */
    readonly shieldedInstanceConfig?: ContainerClusterNodeConfigShieldedInstanceConfig;
    /**
     * workload_metadata_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#workload_metadata_config ContainerCluster#workload_metadata_config}
     */
    readonly workloadMetadataConfig?: ContainerClusterNodeConfigWorkloadMetadataConfig;
}
export declare class ContainerClusterNodeConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _diskSizeGb?;
    get diskSizeGb(): number | undefined;
    set diskSizeGb(value: number | undefined);
    resetDiskSizeGb(): void;
    get diskSizeGbInput(): number | undefined;
    private _diskType?;
    get diskType(): string | undefined;
    set diskType(value: string | undefined);
    resetDiskType(): void;
    get diskTypeInput(): string | undefined;
    private _guestAccelerator?;
    get guestAccelerator(): ContainerClusterNodeConfigGuestAccelerator[] | undefined;
    set guestAccelerator(value: ContainerClusterNodeConfigGuestAccelerator[] | undefined);
    resetGuestAccelerator(): void;
    get guestAcceleratorInput(): ContainerClusterNodeConfigGuestAccelerator[] | undefined;
    private _imageType?;
    get imageType(): string | undefined;
    set imageType(value: string | undefined);
    resetImageType(): void;
    get imageTypeInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _localSsdCount?;
    get localSsdCount(): number | undefined;
    set localSsdCount(value: number | undefined);
    resetLocalSsdCount(): void;
    get localSsdCountInput(): number | undefined;
    private _machineType?;
    get machineType(): string | undefined;
    set machineType(value: string | undefined);
    resetMachineType(): void;
    get machineTypeInput(): string | undefined;
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set metadata(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetMetadata(): void;
    get metadataInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _minCpuPlatform?;
    get minCpuPlatform(): string | undefined;
    set minCpuPlatform(value: string | undefined);
    resetMinCpuPlatform(): void;
    get minCpuPlatformInput(): string | undefined;
    private _oauthScopes?;
    get oauthScopes(): string[] | undefined;
    set oauthScopes(value: string[] | undefined);
    resetOauthScopes(): void;
    get oauthScopesInput(): string[] | undefined;
    private _preemptible?;
    get preemptible(): boolean | cdktf.IResolvable | undefined;
    set preemptible(value: boolean | cdktf.IResolvable | undefined);
    resetPreemptible(): void;
    get preemptibleInput(): boolean | cdktf.IResolvable | undefined;
    private _serviceAccount?;
    get serviceAccount(): string | undefined;
    set serviceAccount(value: string | undefined);
    resetServiceAccount(): void;
    get serviceAccountInput(): string | undefined;
    private _tags?;
    get tags(): string[] | undefined;
    set tags(value: string[] | undefined);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _taint?;
    get taint(): ContainerClusterNodeConfigTaint[] | undefined;
    set taint(value: ContainerClusterNodeConfigTaint[] | undefined);
    resetTaint(): void;
    get taintInput(): ContainerClusterNodeConfigTaint[] | undefined;
    private _shieldedInstanceConfig?;
    private __shieldedInstanceConfigOutput;
    get shieldedInstanceConfig(): ContainerClusterNodeConfigShieldedInstanceConfigOutputReference;
    putShieldedInstanceConfig(value: ContainerClusterNodeConfigShieldedInstanceConfig | undefined): void;
    resetShieldedInstanceConfig(): void;
    get shieldedInstanceConfigInput(): ContainerClusterNodeConfigShieldedInstanceConfig | undefined;
    private _workloadMetadataConfig?;
    private __workloadMetadataConfigOutput;
    get workloadMetadataConfig(): ContainerClusterNodeConfigWorkloadMetadataConfigOutputReference;
    putWorkloadMetadataConfig(value: ContainerClusterNodeConfigWorkloadMetadataConfig | undefined): void;
    resetWorkloadMetadataConfig(): void;
    get workloadMetadataConfigInput(): ContainerClusterNodeConfigWorkloadMetadataConfig | undefined;
}
export interface ContainerClusterNodePoolAutoscaling {
    /**
     * Maximum number of nodes in the NodePool. Must be >= min_node_count.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#max_node_count ContainerCluster#max_node_count}
     */
    readonly maxNodeCount: number;
    /**
     * Minimum number of nodes in the NodePool. Must be >=0 and <= max_node_count.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#min_node_count ContainerCluster#min_node_count}
     */
    readonly minNodeCount: number;
}
export declare class ContainerClusterNodePoolAutoscalingOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _maxNodeCount?;
    get maxNodeCount(): number;
    set maxNodeCount(value: number);
    get maxNodeCountInput(): number | undefined;
    private _minNodeCount?;
    get minNodeCount(): number;
    set minNodeCount(value: number);
    get minNodeCountInput(): number | undefined;
}
export interface ContainerClusterNodePoolManagement {
    /**
     * Whether the nodes will be automatically repaired.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#auto_repair ContainerCluster#auto_repair}
     */
    readonly autoRepair?: boolean | cdktf.IResolvable;
    /**
     * Whether the nodes will be automatically upgraded.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#auto_upgrade ContainerCluster#auto_upgrade}
     */
    readonly autoUpgrade?: boolean | cdktf.IResolvable;
}
export declare class ContainerClusterNodePoolManagementOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _autoRepair?;
    get autoRepair(): boolean | cdktf.IResolvable | undefined;
    set autoRepair(value: boolean | cdktf.IResolvable | undefined);
    resetAutoRepair(): void;
    get autoRepairInput(): boolean | cdktf.IResolvable | undefined;
    private _autoUpgrade?;
    get autoUpgrade(): boolean | cdktf.IResolvable | undefined;
    set autoUpgrade(value: boolean | cdktf.IResolvable | undefined);
    resetAutoUpgrade(): void;
    get autoUpgradeInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ContainerClusterNodePoolNodeConfigGuestAccelerator {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#count ContainerCluster#count}.
     */
    readonly count?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#gpu_partition_size ContainerCluster#gpu_partition_size}.
     */
    readonly gpuPartitionSize?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#type ContainerCluster#type}.
     */
    readonly type?: string;
}
export interface ContainerClusterNodePoolNodeConfigTaint {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#effect ContainerCluster#effect}.
     */
    readonly effect?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#key ContainerCluster#key}.
     */
    readonly key?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#value ContainerCluster#value}.
     */
    readonly value?: string;
}
export interface ContainerClusterNodePoolNodeConfigShieldedInstanceConfig {
    /**
     * Defines whether the instance has integrity monitoring enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#enable_integrity_monitoring ContainerCluster#enable_integrity_monitoring}
     */
    readonly enableIntegrityMonitoring?: boolean | cdktf.IResolvable;
    /**
     * Defines whether the instance has Secure Boot enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#enable_secure_boot ContainerCluster#enable_secure_boot}
     */
    readonly enableSecureBoot?: boolean | cdktf.IResolvable;
}
export declare class ContainerClusterNodePoolNodeConfigShieldedInstanceConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _enableIntegrityMonitoring?;
    get enableIntegrityMonitoring(): boolean | cdktf.IResolvable | undefined;
    set enableIntegrityMonitoring(value: boolean | cdktf.IResolvable | undefined);
    resetEnableIntegrityMonitoring(): void;
    get enableIntegrityMonitoringInput(): boolean | cdktf.IResolvable | undefined;
    private _enableSecureBoot?;
    get enableSecureBoot(): boolean | cdktf.IResolvable | undefined;
    set enableSecureBoot(value: boolean | cdktf.IResolvable | undefined);
    resetEnableSecureBoot(): void;
    get enableSecureBootInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ContainerClusterNodePoolNodeConfigWorkloadMetadataConfig {
    /**
     * Mode is the configuration for how to expose metadata to workloads running on the node.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#mode ContainerCluster#mode}
     */
    readonly mode?: string;
    /**
     * NodeMetadata is the configuration for how to expose metadata to the workloads running on the node.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#node_metadata ContainerCluster#node_metadata}
     */
    readonly nodeMetadata?: string;
}
export declare class ContainerClusterNodePoolNodeConfigWorkloadMetadataConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _mode?;
    get mode(): string | undefined;
    set mode(value: string | undefined);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _nodeMetadata?;
    get nodeMetadata(): string | undefined;
    set nodeMetadata(value: string | undefined);
    resetNodeMetadata(): void;
    get nodeMetadataInput(): string | undefined;
}
export interface ContainerClusterNodePoolNodeConfig {
    /**
     * Size of the disk attached to each node, specified in GB. The smallest allowed disk size is 10GB.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#disk_size_gb ContainerCluster#disk_size_gb}
     */
    readonly diskSizeGb?: number;
    /**
     * Type of the disk attached to each node.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#disk_type ContainerCluster#disk_type}
     */
    readonly diskType?: string;
    /**
     * List of the type and count of accelerator cards attached to the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#guest_accelerator ContainerCluster#guest_accelerator}
     */
    readonly guestAccelerator?: ContainerClusterNodePoolNodeConfigGuestAccelerator[];
    /**
     * The image type to use for this node.
     *
     * Note that for a given image type, the latest version of it will be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#image_type ContainerCluster#image_type}
     */
    readonly imageType?: string;
    /**
     * The map of Kubernetes labels (key/value pairs) to be applied to each node.
     *
     * These will added in addition to any default label(s) that Kubernetes may apply to the node.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#labels ContainerCluster#labels}
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The number of local SSD disks to be attached to the node.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#local_ssd_count ContainerCluster#local_ssd_count}
     */
    readonly localSsdCount?: number;
    /**
     * The name of a Google Compute Engine machine type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#machine_type ContainerCluster#machine_type}
     */
    readonly machineType?: string;
    /**
     * The metadata key/value pairs assigned to instances in the cluster.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#metadata ContainerCluster#metadata}
     */
    readonly metadata?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Minimum CPU platform to be used by this instance.
     *
     * The instance may be scheduled on the specified or newer CPU platform.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#min_cpu_platform ContainerCluster#min_cpu_platform}
     */
    readonly minCpuPlatform?: string;
    /**
     * The set of Google API scopes to be made available on all of the node VMs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#oauth_scopes ContainerCluster#oauth_scopes}
     */
    readonly oauthScopes?: string[];
    /**
     * Whether the nodes are created as preemptible VM instances.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#preemptible ContainerCluster#preemptible}
     */
    readonly preemptible?: boolean | cdktf.IResolvable;
    /**
     * The Google Cloud Platform Service Account to be used by the node VMs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#service_account ContainerCluster#service_account}
     */
    readonly serviceAccount?: string;
    /**
     * The list of instance tags applied to all nodes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#tags ContainerCluster#tags}
     */
    readonly tags?: string[];
    /**
     * List of Kubernetes taints to be applied to each node.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#taint ContainerCluster#taint}
     */
    readonly taint?: ContainerClusterNodePoolNodeConfigTaint[];
    /**
     * shielded_instance_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#shielded_instance_config ContainerCluster#shielded_instance_config}
     */
    readonly shieldedInstanceConfig?: ContainerClusterNodePoolNodeConfigShieldedInstanceConfig;
    /**
     * workload_metadata_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#workload_metadata_config ContainerCluster#workload_metadata_config}
     */
    readonly workloadMetadataConfig?: ContainerClusterNodePoolNodeConfigWorkloadMetadataConfig;
}
export declare class ContainerClusterNodePoolNodeConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _diskSizeGb?;
    get diskSizeGb(): number | undefined;
    set diskSizeGb(value: number | undefined);
    resetDiskSizeGb(): void;
    get diskSizeGbInput(): number | undefined;
    private _diskType?;
    get diskType(): string | undefined;
    set diskType(value: string | undefined);
    resetDiskType(): void;
    get diskTypeInput(): string | undefined;
    private _guestAccelerator?;
    get guestAccelerator(): ContainerClusterNodePoolNodeConfigGuestAccelerator[] | undefined;
    set guestAccelerator(value: ContainerClusterNodePoolNodeConfigGuestAccelerator[] | undefined);
    resetGuestAccelerator(): void;
    get guestAcceleratorInput(): ContainerClusterNodePoolNodeConfigGuestAccelerator[] | undefined;
    private _imageType?;
    get imageType(): string | undefined;
    set imageType(value: string | undefined);
    resetImageType(): void;
    get imageTypeInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _localSsdCount?;
    get localSsdCount(): number | undefined;
    set localSsdCount(value: number | undefined);
    resetLocalSsdCount(): void;
    get localSsdCountInput(): number | undefined;
    private _machineType?;
    get machineType(): string | undefined;
    set machineType(value: string | undefined);
    resetMachineType(): void;
    get machineTypeInput(): string | undefined;
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set metadata(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetMetadata(): void;
    get metadataInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _minCpuPlatform?;
    get minCpuPlatform(): string | undefined;
    set minCpuPlatform(value: string | undefined);
    resetMinCpuPlatform(): void;
    get minCpuPlatformInput(): string | undefined;
    private _oauthScopes?;
    get oauthScopes(): string[] | undefined;
    set oauthScopes(value: string[] | undefined);
    resetOauthScopes(): void;
    get oauthScopesInput(): string[] | undefined;
    private _preemptible?;
    get preemptible(): boolean | cdktf.IResolvable | undefined;
    set preemptible(value: boolean | cdktf.IResolvable | undefined);
    resetPreemptible(): void;
    get preemptibleInput(): boolean | cdktf.IResolvable | undefined;
    private _serviceAccount?;
    get serviceAccount(): string | undefined;
    set serviceAccount(value: string | undefined);
    resetServiceAccount(): void;
    get serviceAccountInput(): string | undefined;
    private _tags?;
    get tags(): string[] | undefined;
    set tags(value: string[] | undefined);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _taint?;
    get taint(): ContainerClusterNodePoolNodeConfigTaint[] | undefined;
    set taint(value: ContainerClusterNodePoolNodeConfigTaint[] | undefined);
    resetTaint(): void;
    get taintInput(): ContainerClusterNodePoolNodeConfigTaint[] | undefined;
    private _shieldedInstanceConfig?;
    private __shieldedInstanceConfigOutput;
    get shieldedInstanceConfig(): ContainerClusterNodePoolNodeConfigShieldedInstanceConfigOutputReference;
    putShieldedInstanceConfig(value: ContainerClusterNodePoolNodeConfigShieldedInstanceConfig | undefined): void;
    resetShieldedInstanceConfig(): void;
    get shieldedInstanceConfigInput(): ContainerClusterNodePoolNodeConfigShieldedInstanceConfig | undefined;
    private _workloadMetadataConfig?;
    private __workloadMetadataConfigOutput;
    get workloadMetadataConfig(): ContainerClusterNodePoolNodeConfigWorkloadMetadataConfigOutputReference;
    putWorkloadMetadataConfig(value: ContainerClusterNodePoolNodeConfigWorkloadMetadataConfig | undefined): void;
    resetWorkloadMetadataConfig(): void;
    get workloadMetadataConfigInput(): ContainerClusterNodePoolNodeConfigWorkloadMetadataConfig | undefined;
}
export interface ContainerClusterNodePoolUpgradeSettings {
    /**
     * The number of additional nodes that can be added to the node pool during an upgrade.
     *
     * Increasing max_surge raises the number of nodes that can be upgraded simultaneously. Can be set to 0 or greater.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#max_surge ContainerCluster#max_surge}
     */
    readonly maxSurge: number;
    /**
     * The number of nodes that can be simultaneously unavailable during an upgrade.
     *
     * Increasing max_unavailable raises the number of nodes that can be upgraded in parallel. Can be set to 0 or greater.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#max_unavailable ContainerCluster#max_unavailable}
     */
    readonly maxUnavailable: number;
}
export declare class ContainerClusterNodePoolUpgradeSettingsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _maxSurge?;
    get maxSurge(): number;
    set maxSurge(value: number);
    get maxSurgeInput(): number | undefined;
    private _maxUnavailable?;
    get maxUnavailable(): number;
    set maxUnavailable(value: number);
    get maxUnavailableInput(): number | undefined;
}
export interface ContainerClusterNodePool {
    /**
     * The initial number of nodes for the pool.
     *
     * In regional or multi-zonal clusters, this is the number of nodes per zone. Changing this will force recreation of the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#initial_node_count ContainerCluster#initial_node_count}
     */
    readonly initialNodeCount?: number;
    /**
     * The maximum number of pods per node in this node pool.
     *
     * Note that this does not work on node pools which are "route-based" - that is, node pools belonging to clusters that do not have IP Aliasing enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#max_pods_per_node ContainerCluster#max_pods_per_node}
     */
    readonly maxPodsPerNode?: number;
    /**
     * The name of the node pool. If left blank, Terraform will auto-generate a unique name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#name ContainerCluster#name}
     */
    readonly name?: string;
    /**
     * Creates a unique name for the node pool beginning with the specified prefix. Conflicts with name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#name_prefix ContainerCluster#name_prefix}
     */
    readonly namePrefix?: string;
    /**
     * The number of nodes per instance group.
     *
     * This field can be used to update the number of nodes per instance group but should not be used alongside autoscaling.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#node_count ContainerCluster#node_count}
     */
    readonly nodeCount?: number;
    /**
     * The list of zones in which the node pool's nodes should be located.
     *
     * Nodes must be in the region of their regional cluster or in the same region as their cluster's zone for zonal clusters. If unspecified, the cluster-level node_locations will be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#node_locations ContainerCluster#node_locations}
     */
    readonly nodeLocations?: string[];
    /**
     * The Kubernetes version for the nodes in this pool.
     *
     * Note that if this field and auto_upgrade are both specified, they will fight each other for what the node version should be, so setting both is highly discouraged. While a fuzzy version can be specified, it's recommended that you specify explicit versions as Terraform will see spurious diffs when fuzzy versions are used. See the google_container_engine_versions data source's version_prefix field to approximate fuzzy versions in a Terraform-compatible way.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#version ContainerCluster#version}
     */
    readonly version?: string;
    /**
     * autoscaling block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#autoscaling ContainerCluster#autoscaling}
     */
    readonly autoscaling?: ContainerClusterNodePoolAutoscaling;
    /**
     * management block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#management ContainerCluster#management}
     */
    readonly management?: ContainerClusterNodePoolManagement;
    /**
     * node_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#node_config ContainerCluster#node_config}
     */
    readonly nodeConfig?: ContainerClusterNodePoolNodeConfig;
    /**
     * upgrade_settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#upgrade_settings ContainerCluster#upgrade_settings}
     */
    readonly upgradeSettings?: ContainerClusterNodePoolUpgradeSettings;
}
export interface ContainerClusterPodSecurityPolicyConfig {
    /**
     * Enable the PodSecurityPolicy controller for this cluster. If enabled, pods must be valid under a PodSecurityPolicy to be created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#enabled ContainerCluster#enabled}
     */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare class ContainerClusterPodSecurityPolicyConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ContainerClusterPrivateClusterConfigMasterGlobalAccessConfig {
    /**
     * Whether the cluster master is accessible globally or not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#enabled ContainerCluster#enabled}
     */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare class ContainerClusterPrivateClusterConfigMasterGlobalAccessConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ContainerClusterPrivateClusterConfig {
    /**
     * Enables the private cluster feature, creating a private endpoint on the cluster.
     *
     * In a private cluster, nodes only have RFC 1918 private addresses and communicate with the master's private endpoint via private networking.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#enable_private_endpoint ContainerCluster#enable_private_endpoint}
     */
    readonly enablePrivateEndpoint: boolean | cdktf.IResolvable;
    /**
     * When true, the cluster's private endpoint is used as the cluster endpoint and access through the public endpoint is disabled.
     *
     * When false, either endpoint can be used. This field only applies to private clusters, when enable_private_nodes is true.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#enable_private_nodes ContainerCluster#enable_private_nodes}
     */
    readonly enablePrivateNodes?: boolean | cdktf.IResolvable;
    /**
     * The IP range in CIDR notation to use for the hosted master network.
     *
     * This range will be used for assigning private IP addresses to the cluster master(s) and the ILB VIP. This range must not overlap with any other ranges in use within the cluster's network, and it must be a /28 subnet. See Private Cluster Limitations for more details. This field only applies to private clusters, when enable_private_nodes is true.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#master_ipv4_cidr_block ContainerCluster#master_ipv4_cidr_block}
     */
    readonly masterIpv4CidrBlock?: string;
    /**
     * master_global_access_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#master_global_access_config ContainerCluster#master_global_access_config}
     */
    readonly masterGlobalAccessConfig?: ContainerClusterPrivateClusterConfigMasterGlobalAccessConfig;
}
export declare class ContainerClusterPrivateClusterConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _enablePrivateEndpoint?;
    get enablePrivateEndpoint(): boolean | cdktf.IResolvable;
    set enablePrivateEndpoint(value: boolean | cdktf.IResolvable);
    get enablePrivateEndpointInput(): boolean | cdktf.IResolvable | undefined;
    private _enablePrivateNodes?;
    get enablePrivateNodes(): boolean | cdktf.IResolvable | undefined;
    set enablePrivateNodes(value: boolean | cdktf.IResolvable | undefined);
    resetEnablePrivateNodes(): void;
    get enablePrivateNodesInput(): boolean | cdktf.IResolvable | undefined;
    private _masterIpv4CidrBlock?;
    get masterIpv4CidrBlock(): string | undefined;
    set masterIpv4CidrBlock(value: string | undefined);
    resetMasterIpv4CidrBlock(): void;
    get masterIpv4CidrBlockInput(): string | undefined;
    private _masterGlobalAccessConfig?;
    private __masterGlobalAccessConfigOutput;
    get masterGlobalAccessConfig(): ContainerClusterPrivateClusterConfigMasterGlobalAccessConfigOutputReference;
    putMasterGlobalAccessConfig(value: ContainerClusterPrivateClusterConfigMasterGlobalAccessConfig | undefined): void;
    resetMasterGlobalAccessConfig(): void;
    get masterGlobalAccessConfigInput(): ContainerClusterPrivateClusterConfigMasterGlobalAccessConfig | undefined;
}
export interface ContainerClusterReleaseChannel {
    /**
     * The selected release channel.
     *
     * Accepted values are:
     * UNSPECIFIED: Not set.
     * RAPID: Weekly upgrade cadence; Early testers and developers who requires new features.
     * REGULAR: Multiple per month upgrade cadence; Production users who need features not yet offered in the Stable channel.
     * STABLE: Every few months upgrade cadence; Production users who need stability above all else, and for whom frequent upgrades are too risky.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#channel ContainerCluster#channel}
     */
    readonly channel: string;
}
export declare class ContainerClusterReleaseChannelOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _channel?;
    get channel(): string;
    set channel(value: string);
    get channelInput(): string | undefined;
}
export interface ContainerClusterResourceUsageExportConfigBigqueryDestination {
    /**
     * The ID of a BigQuery Dataset.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#dataset_id ContainerCluster#dataset_id}
     */
    readonly datasetId: string;
}
export declare class ContainerClusterResourceUsageExportConfigBigqueryDestinationOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _datasetId?;
    get datasetId(): string;
    set datasetId(value: string);
    get datasetIdInput(): string | undefined;
}
export interface ContainerClusterResourceUsageExportConfig {
    /**
     * Whether to enable network egress metering for this cluster.
     *
     * If enabled, a daemonset will be created in the cluster to meter network egress traffic.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#enable_network_egress_metering ContainerCluster#enable_network_egress_metering}
     */
    readonly enableNetworkEgressMetering?: boolean | cdktf.IResolvable;
    /**
     * Whether to enable resource consumption metering on this cluster.
     *
     * When enabled, a table will be created in the resource export BigQuery dataset to store resource consumption data. The resulting table can be joined with the resource usage table or with BigQuery billing export. Defaults to true.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#enable_resource_consumption_metering ContainerCluster#enable_resource_consumption_metering}
     */
    readonly enableResourceConsumptionMetering?: boolean | cdktf.IResolvable;
    /**
     * bigquery_destination block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#bigquery_destination ContainerCluster#bigquery_destination}
     */
    readonly bigqueryDestination: ContainerClusterResourceUsageExportConfigBigqueryDestination;
}
export declare class ContainerClusterResourceUsageExportConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _enableNetworkEgressMetering?;
    get enableNetworkEgressMetering(): boolean | cdktf.IResolvable | undefined;
    set enableNetworkEgressMetering(value: boolean | cdktf.IResolvable | undefined);
    resetEnableNetworkEgressMetering(): void;
    get enableNetworkEgressMeteringInput(): boolean | cdktf.IResolvable | undefined;
    private _enableResourceConsumptionMetering?;
    get enableResourceConsumptionMetering(): boolean | cdktf.IResolvable | undefined;
    set enableResourceConsumptionMetering(value: boolean | cdktf.IResolvable | undefined);
    resetEnableResourceConsumptionMetering(): void;
    get enableResourceConsumptionMeteringInput(): boolean | cdktf.IResolvable | undefined;
    private _bigqueryDestination?;
    private __bigqueryDestinationOutput;
    get bigqueryDestination(): ContainerClusterResourceUsageExportConfigBigqueryDestinationOutputReference;
    putBigqueryDestination(value: ContainerClusterResourceUsageExportConfigBigqueryDestination): void;
    get bigqueryDestinationInput(): ContainerClusterResourceUsageExportConfigBigqueryDestination | undefined;
}
export interface ContainerClusterTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#create ContainerCluster#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#delete ContainerCluster#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#read ContainerCluster#read}.
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#update ContainerCluster#update}.
     */
    readonly update?: string;
}
export declare class ContainerClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string | undefined;
    set read(value: string | undefined);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface ContainerClusterVerticalPodAutoscaling {
    /**
     * Enables vertical pod autoscaling.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#enabled ContainerCluster#enabled}
     */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare class ContainerClusterVerticalPodAutoscalingOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ContainerClusterWorkloadIdentityConfig {
    /**
     * Enables workload identity.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#identity_namespace ContainerCluster#identity_namespace}
     */
    readonly identityNamespace?: string;
    /**
     * The workload pool to attach all Kubernetes service accounts to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html#workload_pool ContainerCluster#workload_pool}
     */
    readonly workloadPool?: string;
}
export declare class ContainerClusterWorkloadIdentityConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _identityNamespace?;
    get identityNamespace(): string | undefined;
    set identityNamespace(value: string | undefined);
    resetIdentityNamespace(): void;
    get identityNamespaceInput(): string | undefined;
    private _workloadPool?;
    get workloadPool(): string | undefined;
    set workloadPool(value: string | undefined);
    resetWorkloadPool(): void;
    get workloadPoolInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html google_container_cluster}.
 */
export declare class ContainerCluster extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/container_cluster.html google_container_cluster} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: ContainerClusterConfig);
    private _clusterIpv4Cidr?;
    get clusterIpv4Cidr(): string | undefined;
    set clusterIpv4Cidr(value: string | undefined);
    resetClusterIpv4Cidr(): void;
    get clusterIpv4CidrInput(): string | undefined;
    private _datapathProvider?;
    get datapathProvider(): string | undefined;
    set datapathProvider(value: string | undefined);
    resetDatapathProvider(): void;
    get datapathProviderInput(): string | undefined;
    private _defaultMaxPodsPerNode?;
    get defaultMaxPodsPerNode(): number | undefined;
    set defaultMaxPodsPerNode(value: number | undefined);
    resetDefaultMaxPodsPerNode(): void;
    get defaultMaxPodsPerNodeInput(): number | undefined;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _enableAutopilot?;
    get enableAutopilot(): boolean | cdktf.IResolvable | undefined;
    set enableAutopilot(value: boolean | cdktf.IResolvable | undefined);
    resetEnableAutopilot(): void;
    get enableAutopilotInput(): boolean | cdktf.IResolvable | undefined;
    private _enableBinaryAuthorization?;
    get enableBinaryAuthorization(): boolean | cdktf.IResolvable | undefined;
    set enableBinaryAuthorization(value: boolean | cdktf.IResolvable | undefined);
    resetEnableBinaryAuthorization(): void;
    get enableBinaryAuthorizationInput(): boolean | cdktf.IResolvable | undefined;
    private _enableIntranodeVisibility?;
    get enableIntranodeVisibility(): boolean | cdktf.IResolvable | undefined;
    set enableIntranodeVisibility(value: boolean | cdktf.IResolvable | undefined);
    resetEnableIntranodeVisibility(): void;
    get enableIntranodeVisibilityInput(): boolean | cdktf.IResolvable | undefined;
    private _enableKubernetesAlpha?;
    get enableKubernetesAlpha(): boolean | cdktf.IResolvable | undefined;
    set enableKubernetesAlpha(value: boolean | cdktf.IResolvable | undefined);
    resetEnableKubernetesAlpha(): void;
    get enableKubernetesAlphaInput(): boolean | cdktf.IResolvable | undefined;
    private _enableLegacyAbac?;
    get enableLegacyAbac(): boolean | cdktf.IResolvable | undefined;
    set enableLegacyAbac(value: boolean | cdktf.IResolvable | undefined);
    resetEnableLegacyAbac(): void;
    get enableLegacyAbacInput(): boolean | cdktf.IResolvable | undefined;
    private _enableShieldedNodes?;
    get enableShieldedNodes(): boolean | cdktf.IResolvable | undefined;
    set enableShieldedNodes(value: boolean | cdktf.IResolvable | undefined);
    resetEnableShieldedNodes(): void;
    get enableShieldedNodesInput(): boolean | cdktf.IResolvable | undefined;
    private _enableTpu?;
    get enableTpu(): boolean | cdktf.IResolvable | undefined;
    set enableTpu(value: boolean | cdktf.IResolvable | undefined);
    resetEnableTpu(): void;
    get enableTpuInput(): boolean | cdktf.IResolvable | undefined;
    get endpoint(): string;
    get id(): string;
    private _initialNodeCount?;
    get initialNodeCount(): number | undefined;
    set initialNodeCount(value: number | undefined);
    resetInitialNodeCount(): void;
    get initialNodeCountInput(): number | undefined;
    get instanceGroupUrls(): string[];
    get labelFingerprint(): string;
    private _location?;
    get location(): string | undefined;
    set location(value: string | undefined);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _loggingService?;
    get loggingService(): string | undefined;
    set loggingService(value: string | undefined);
    resetLoggingService(): void;
    get loggingServiceInput(): string | undefined;
    get masterVersion(): string;
    private _minMasterVersion?;
    get minMasterVersion(): string | undefined;
    set minMasterVersion(value: string | undefined);
    resetMinMasterVersion(): void;
    get minMasterVersionInput(): string | undefined;
    private _monitoringService?;
    get monitoringService(): string | undefined;
    set monitoringService(value: string | undefined);
    resetMonitoringService(): void;
    get monitoringServiceInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _network?;
    get network(): string | undefined;
    set network(value: string | undefined);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _networkingMode?;
    get networkingMode(): string | undefined;
    set networkingMode(value: string | undefined);
    resetNetworkingMode(): void;
    get networkingModeInput(): string | undefined;
    private _nodeLocations?;
    get nodeLocations(): string[] | undefined;
    set nodeLocations(value: string[] | undefined);
    resetNodeLocations(): void;
    get nodeLocationsInput(): string[] | undefined;
    private _nodeVersion?;
    get nodeVersion(): string | undefined;
    set nodeVersion(value: string | undefined);
    resetNodeVersion(): void;
    get nodeVersionInput(): string | undefined;
    get operation(): string;
    private _privateIpv6GoogleAccess?;
    get privateIpv6GoogleAccess(): string | undefined;
    set privateIpv6GoogleAccess(value: string | undefined);
    resetPrivateIpv6GoogleAccess(): void;
    get privateIpv6GoogleAccessInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _removeDefaultNodePool?;
    get removeDefaultNodePool(): boolean | cdktf.IResolvable | undefined;
    set removeDefaultNodePool(value: boolean | cdktf.IResolvable | undefined);
    resetRemoveDefaultNodePool(): void;
    get removeDefaultNodePoolInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceLabels?;
    get resourceLabels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set resourceLabels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetResourceLabels(): void;
    get resourceLabelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    get selfLink(): string;
    get servicesIpv4Cidr(): string;
    private _subnetwork?;
    get subnetwork(): string | undefined;
    set subnetwork(value: string | undefined);
    resetSubnetwork(): void;
    get subnetworkInput(): string | undefined;
    get tpuIpv4CidrBlock(): string;
    private _addonsConfig?;
    private __addonsConfigOutput;
    get addonsConfig(): ContainerClusterAddonsConfigOutputReference;
    putAddonsConfig(value: ContainerClusterAddonsConfig | undefined): void;
    resetAddonsConfig(): void;
    get addonsConfigInput(): ContainerClusterAddonsConfig | undefined;
    private _authenticatorGroupsConfig?;
    private __authenticatorGroupsConfigOutput;
    get authenticatorGroupsConfig(): ContainerClusterAuthenticatorGroupsConfigOutputReference;
    putAuthenticatorGroupsConfig(value: ContainerClusterAuthenticatorGroupsConfig | undefined): void;
    resetAuthenticatorGroupsConfig(): void;
    get authenticatorGroupsConfigInput(): ContainerClusterAuthenticatorGroupsConfig | undefined;
    private _clusterAutoscaling?;
    private __clusterAutoscalingOutput;
    get clusterAutoscaling(): ContainerClusterClusterAutoscalingOutputReference;
    putClusterAutoscaling(value: ContainerClusterClusterAutoscaling | undefined): void;
    resetClusterAutoscaling(): void;
    get clusterAutoscalingInput(): ContainerClusterClusterAutoscaling | undefined;
    private _databaseEncryption?;
    private __databaseEncryptionOutput;
    get databaseEncryption(): ContainerClusterDatabaseEncryptionOutputReference;
    putDatabaseEncryption(value: ContainerClusterDatabaseEncryption | undefined): void;
    resetDatabaseEncryption(): void;
    get databaseEncryptionInput(): ContainerClusterDatabaseEncryption | undefined;
    private _defaultSnatStatus?;
    private __defaultSnatStatusOutput;
    get defaultSnatStatus(): ContainerClusterDefaultSnatStatusOutputReference;
    putDefaultSnatStatus(value: ContainerClusterDefaultSnatStatus | undefined): void;
    resetDefaultSnatStatus(): void;
    get defaultSnatStatusInput(): ContainerClusterDefaultSnatStatus | undefined;
    private _ipAllocationPolicy?;
    private __ipAllocationPolicyOutput;
    get ipAllocationPolicy(): ContainerClusterIpAllocationPolicyOutputReference;
    putIpAllocationPolicy(value: ContainerClusterIpAllocationPolicy | undefined): void;
    resetIpAllocationPolicy(): void;
    get ipAllocationPolicyInput(): ContainerClusterIpAllocationPolicy | undefined;
    private _loggingConfig?;
    private __loggingConfigOutput;
    get loggingConfig(): ContainerClusterLoggingConfigOutputReference;
    putLoggingConfig(value: ContainerClusterLoggingConfig | undefined): void;
    resetLoggingConfig(): void;
    get loggingConfigInput(): ContainerClusterLoggingConfig | undefined;
    private _maintenancePolicy?;
    private __maintenancePolicyOutput;
    get maintenancePolicy(): ContainerClusterMaintenancePolicyOutputReference;
    putMaintenancePolicy(value: ContainerClusterMaintenancePolicy | undefined): void;
    resetMaintenancePolicy(): void;
    get maintenancePolicyInput(): ContainerClusterMaintenancePolicy | undefined;
    private _masterAuth?;
    private __masterAuthOutput;
    get masterAuth(): ContainerClusterMasterAuthOutputReference;
    putMasterAuth(value: ContainerClusterMasterAuth | undefined): void;
    resetMasterAuth(): void;
    get masterAuthInput(): ContainerClusterMasterAuth | undefined;
    private _masterAuthorizedNetworksConfig?;
    private __masterAuthorizedNetworksConfigOutput;
    get masterAuthorizedNetworksConfig(): ContainerClusterMasterAuthorizedNetworksConfigOutputReference;
    putMasterAuthorizedNetworksConfig(value: ContainerClusterMasterAuthorizedNetworksConfig | undefined): void;
    resetMasterAuthorizedNetworksConfig(): void;
    get masterAuthorizedNetworksConfigInput(): ContainerClusterMasterAuthorizedNetworksConfig | undefined;
    private _monitoringConfig?;
    private __monitoringConfigOutput;
    get monitoringConfig(): ContainerClusterMonitoringConfigOutputReference;
    putMonitoringConfig(value: ContainerClusterMonitoringConfig | undefined): void;
    resetMonitoringConfig(): void;
    get monitoringConfigInput(): ContainerClusterMonitoringConfig | undefined;
    private _networkPolicy?;
    private __networkPolicyOutput;
    get networkPolicy(): ContainerClusterNetworkPolicyOutputReference;
    putNetworkPolicy(value: ContainerClusterNetworkPolicy | undefined): void;
    resetNetworkPolicy(): void;
    get networkPolicyInput(): ContainerClusterNetworkPolicy | undefined;
    private _nodeConfig?;
    private __nodeConfigOutput;
    get nodeConfig(): ContainerClusterNodeConfigOutputReference;
    putNodeConfig(value: ContainerClusterNodeConfig | undefined): void;
    resetNodeConfig(): void;
    get nodeConfigInput(): ContainerClusterNodeConfig | undefined;
    private _nodePool?;
    get nodePool(): ContainerClusterNodePool[] | undefined;
    set nodePool(value: ContainerClusterNodePool[] | undefined);
    resetNodePool(): void;
    get nodePoolInput(): ContainerClusterNodePool[] | undefined;
    private _podSecurityPolicyConfig?;
    private __podSecurityPolicyConfigOutput;
    get podSecurityPolicyConfig(): ContainerClusterPodSecurityPolicyConfigOutputReference;
    putPodSecurityPolicyConfig(value: ContainerClusterPodSecurityPolicyConfig | undefined): void;
    resetPodSecurityPolicyConfig(): void;
    get podSecurityPolicyConfigInput(): ContainerClusterPodSecurityPolicyConfig | undefined;
    private _privateClusterConfig?;
    private __privateClusterConfigOutput;
    get privateClusterConfig(): ContainerClusterPrivateClusterConfigOutputReference;
    putPrivateClusterConfig(value: ContainerClusterPrivateClusterConfig | undefined): void;
    resetPrivateClusterConfig(): void;
    get privateClusterConfigInput(): ContainerClusterPrivateClusterConfig | undefined;
    private _releaseChannel?;
    private __releaseChannelOutput;
    get releaseChannel(): ContainerClusterReleaseChannelOutputReference;
    putReleaseChannel(value: ContainerClusterReleaseChannel | undefined): void;
    resetReleaseChannel(): void;
    get releaseChannelInput(): ContainerClusterReleaseChannel | undefined;
    private _resourceUsageExportConfig?;
    private __resourceUsageExportConfigOutput;
    get resourceUsageExportConfig(): ContainerClusterResourceUsageExportConfigOutputReference;
    putResourceUsageExportConfig(value: ContainerClusterResourceUsageExportConfig | undefined): void;
    resetResourceUsageExportConfig(): void;
    get resourceUsageExportConfigInput(): ContainerClusterResourceUsageExportConfig | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): ContainerClusterTimeoutsOutputReference;
    putTimeouts(value: ContainerClusterTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): ContainerClusterTimeouts | undefined;
    private _verticalPodAutoscaling?;
    private __verticalPodAutoscalingOutput;
    get verticalPodAutoscaling(): ContainerClusterVerticalPodAutoscalingOutputReference;
    putVerticalPodAutoscaling(value: ContainerClusterVerticalPodAutoscaling | undefined): void;
    resetVerticalPodAutoscaling(): void;
    get verticalPodAutoscalingInput(): ContainerClusterVerticalPodAutoscaling | undefined;
    private _workloadIdentityConfig?;
    private __workloadIdentityConfigOutput;
    get workloadIdentityConfig(): ContainerClusterWorkloadIdentityConfigOutputReference;
    putWorkloadIdentityConfig(value: ContainerClusterWorkloadIdentityConfig | undefined): void;
    resetWorkloadIdentityConfig(): void;
    get workloadIdentityConfigInput(): ContainerClusterWorkloadIdentityConfig | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
