import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ContainerAnalysisNoteConfig extends cdktf.TerraformMetaArguments {
    /**
     * Time of expiration for this note. Leave empty if note does not expire.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_note.html#expiration_time ContainerAnalysisNote#expiration_time}
     */
    readonly expirationTime?: string;
    /**
     * A detailed description of the note.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_note.html#long_description ContainerAnalysisNote#long_description}
     */
    readonly longDescription?: string;
    /**
     * The name of the note.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_note.html#name ContainerAnalysisNote#name}
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_note.html#project ContainerAnalysisNote#project}.
     */
    readonly project?: string;
    /**
     * Names of other notes related to this note.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_note.html#related_note_names ContainerAnalysisNote#related_note_names}
     */
    readonly relatedNoteNames?: string[];
    /**
     * A one sentence description of the note.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_note.html#short_description ContainerAnalysisNote#short_description}
     */
    readonly shortDescription?: string;
    /**
     * attestation_authority block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_note.html#attestation_authority ContainerAnalysisNote#attestation_authority}
     */
    readonly attestationAuthority: ContainerAnalysisNoteAttestationAuthority;
    /**
     * related_url block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_note.html#related_url ContainerAnalysisNote#related_url}
     */
    readonly relatedUrl?: ContainerAnalysisNoteRelatedUrl[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_note.html#timeouts ContainerAnalysisNote#timeouts}
     */
    readonly timeouts?: ContainerAnalysisNoteTimeouts;
}
export interface ContainerAnalysisNoteAttestationAuthorityHint {
    /**
     * The human readable name of this Attestation Authority, for example "qa".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_note.html#human_readable_name ContainerAnalysisNote#human_readable_name}
     */
    readonly humanReadableName: string;
}
export declare class ContainerAnalysisNoteAttestationAuthorityHintOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _humanReadableName?;
    get humanReadableName(): string;
    set humanReadableName(value: string);
    get humanReadableNameInput(): string | undefined;
}
export interface ContainerAnalysisNoteAttestationAuthority {
    /**
     * hint block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_note.html#hint ContainerAnalysisNote#hint}
     */
    readonly hint: ContainerAnalysisNoteAttestationAuthorityHint;
}
export declare class ContainerAnalysisNoteAttestationAuthorityOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _hint?;
    private __hintOutput;
    get hint(): ContainerAnalysisNoteAttestationAuthorityHintOutputReference;
    putHint(value: ContainerAnalysisNoteAttestationAuthorityHint): void;
    get hintInput(): ContainerAnalysisNoteAttestationAuthorityHint | undefined;
}
export interface ContainerAnalysisNoteRelatedUrl {
    /**
     * Label to describe usage of the URL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_note.html#label ContainerAnalysisNote#label}
     */
    readonly label?: string;
    /**
     * Specific URL associated with the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_note.html#url ContainerAnalysisNote#url}
     */
    readonly url: string;
}
export interface ContainerAnalysisNoteTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_note.html#create ContainerAnalysisNote#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_note.html#delete ContainerAnalysisNote#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_analysis_note.html#update ContainerAnalysisNote#update}.
     */
    readonly update?: string;
}
export declare class ContainerAnalysisNoteTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/container_analysis_note.html google_container_analysis_note}.
 */
export declare class ContainerAnalysisNote extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/container_analysis_note.html google_container_analysis_note} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: ContainerAnalysisNoteConfig);
    get createTime(): string;
    private _expirationTime?;
    get expirationTime(): string | undefined;
    set expirationTime(value: string | undefined);
    resetExpirationTime(): void;
    get expirationTimeInput(): string | undefined;
    get id(): string;
    get kind(): string;
    private _longDescription?;
    get longDescription(): string | undefined;
    set longDescription(value: string | undefined);
    resetLongDescription(): void;
    get longDescriptionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _relatedNoteNames?;
    get relatedNoteNames(): string[] | undefined;
    set relatedNoteNames(value: string[] | undefined);
    resetRelatedNoteNames(): void;
    get relatedNoteNamesInput(): string[] | undefined;
    private _shortDescription?;
    get shortDescription(): string | undefined;
    set shortDescription(value: string | undefined);
    resetShortDescription(): void;
    get shortDescriptionInput(): string | undefined;
    get updateTime(): string;
    private _attestationAuthority?;
    private __attestationAuthorityOutput;
    get attestationAuthority(): ContainerAnalysisNoteAttestationAuthorityOutputReference;
    putAttestationAuthority(value: ContainerAnalysisNoteAttestationAuthority): void;
    get attestationAuthorityInput(): ContainerAnalysisNoteAttestationAuthority | undefined;
    private _relatedUrl?;
    get relatedUrl(): ContainerAnalysisNoteRelatedUrl[] | undefined;
    set relatedUrl(value: ContainerAnalysisNoteRelatedUrl[] | undefined);
    resetRelatedUrl(): void;
    get relatedUrlInput(): ContainerAnalysisNoteRelatedUrl[] | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): ContainerAnalysisNoteTimeoutsOutputReference;
    putTimeouts(value: ContainerAnalysisNoteTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): ContainerAnalysisNoteTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
