import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeVpnTunnelConfig extends cdktf.TerraformMetaArguments {
    /**
     * An optional description of this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_vpn_tunnel.html#description ComputeVpnTunnel#description}
     */
    readonly description?: string;
    /**
     * IKE protocol version to use when establishing the VPN tunnel with peer VPN gateway.
     *
     * Acceptable IKE versions are 1 or 2. Default version is 2.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_vpn_tunnel.html#ike_version ComputeVpnTunnel#ike_version}
     */
    readonly ikeVersion?: number;
    /**
     * Local traffic selector to use when establishing the VPN tunnel with peer VPN gateway.
     *
     * The value should be a CIDR formatted string,
     * for example '192.168.0.0/16'. The ranges should be disjoint.
     * Only IPv4 is supported.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_vpn_tunnel.html#local_traffic_selector ComputeVpnTunnel#local_traffic_selector}
     */
    readonly localTrafficSelector?: string[];
    /**
     * Name of the resource.
     *
     * The name must be 1-63 characters long, and
     * comply with RFC1035. Specifically, the name must be 1-63
     * characters long and match the regular expression
     * '[a-z]([-a-z0-9]*[a-z0-9])?' which means the first character
     * must be a lowercase letter, and all following characters must
     * be a dash, lowercase letter, or digit,
     * except the last character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_vpn_tunnel.html#name ComputeVpnTunnel#name}
     */
    readonly name: string;
    /**
     * URL of the peer side external VPN gateway to which this VPN tunnel is connected.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_vpn_tunnel.html#peer_external_gateway ComputeVpnTunnel#peer_external_gateway}
     */
    readonly peerExternalGateway?: string;
    /**
     * The interface ID of the external VPN gateway to which this VPN tunnel is connected.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_vpn_tunnel.html#peer_external_gateway_interface ComputeVpnTunnel#peer_external_gateway_interface}
     */
    readonly peerExternalGatewayInterface?: number;
    /**
     * URL of the peer side HA GCP VPN gateway to which this VPN tunnel is connected.
     *
     * If provided, the VPN tunnel will automatically use the same vpn_gateway_interface
     * ID in the peer GCP VPN gateway.
     * This field must reference a 'google_compute_ha_vpn_gateway' resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_vpn_tunnel.html#peer_gcp_gateway ComputeVpnTunnel#peer_gcp_gateway}
     */
    readonly peerGcpGateway?: string;
    /**
     * IP address of the peer VPN gateway. Only IPv4 is supported.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_vpn_tunnel.html#peer_ip ComputeVpnTunnel#peer_ip}
     */
    readonly peerIp?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_vpn_tunnel.html#project ComputeVpnTunnel#project}.
     */
    readonly project?: string;
    /**
     * The region where the tunnel is located. If unset, is set to the region of 'target_vpn_gateway'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_vpn_tunnel.html#region ComputeVpnTunnel#region}
     */
    readonly region?: string;
    /**
     * Remote traffic selector to use when establishing the VPN tunnel with peer VPN gateway.
     *
     * The value should be a CIDR formatted string,
     * for example '192.168.0.0/16'. The ranges should be disjoint.
     * Only IPv4 is supported.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_vpn_tunnel.html#remote_traffic_selector ComputeVpnTunnel#remote_traffic_selector}
     */
    readonly remoteTrafficSelector?: string[];
    /**
     * URL of router resource to be used for dynamic routing.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_vpn_tunnel.html#router ComputeVpnTunnel#router}
     */
    readonly router?: string;
    /**
     * Shared secret used to set the secure session between the Cloud VPN gateway and the peer VPN gateway.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_vpn_tunnel.html#shared_secret ComputeVpnTunnel#shared_secret}
     */
    readonly sharedSecret: string;
    /**
     * URL of the Target VPN gateway with which this VPN tunnel is associated.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_vpn_tunnel.html#target_vpn_gateway ComputeVpnTunnel#target_vpn_gateway}
     */
    readonly targetVpnGateway?: string;
    /**
     * URL of the VPN gateway with which this VPN tunnel is associated.
     *
     * This must be used if a High Availability VPN gateway resource is created.
     * This field must reference a 'google_compute_ha_vpn_gateway' resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_vpn_tunnel.html#vpn_gateway ComputeVpnTunnel#vpn_gateway}
     */
    readonly vpnGateway?: string;
    /**
     * The interface ID of the VPN gateway with which this VPN tunnel is associated.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_vpn_tunnel.html#vpn_gateway_interface ComputeVpnTunnel#vpn_gateway_interface}
     */
    readonly vpnGatewayInterface?: number;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_vpn_tunnel.html#timeouts ComputeVpnTunnel#timeouts}
     */
    readonly timeouts?: ComputeVpnTunnelTimeouts;
}
export interface ComputeVpnTunnelTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_vpn_tunnel.html#create ComputeVpnTunnel#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_vpn_tunnel.html#delete ComputeVpnTunnel#delete}.
     */
    readonly delete?: string;
}
export declare class ComputeVpnTunnelTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_vpn_tunnel.html google_compute_vpn_tunnel}.
 */
export declare class ComputeVpnTunnel extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_vpn_tunnel.html google_compute_vpn_tunnel} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: ComputeVpnTunnelConfig);
    get creationTimestamp(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get detailedStatus(): string;
    get id(): string;
    private _ikeVersion?;
    get ikeVersion(): number | undefined;
    set ikeVersion(value: number | undefined);
    resetIkeVersion(): void;
    get ikeVersionInput(): number | undefined;
    private _localTrafficSelector?;
    get localTrafficSelector(): string[] | undefined;
    set localTrafficSelector(value: string[] | undefined);
    resetLocalTrafficSelector(): void;
    get localTrafficSelectorInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _peerExternalGateway?;
    get peerExternalGateway(): string | undefined;
    set peerExternalGateway(value: string | undefined);
    resetPeerExternalGateway(): void;
    get peerExternalGatewayInput(): string | undefined;
    private _peerExternalGatewayInterface?;
    get peerExternalGatewayInterface(): number | undefined;
    set peerExternalGatewayInterface(value: number | undefined);
    resetPeerExternalGatewayInterface(): void;
    get peerExternalGatewayInterfaceInput(): number | undefined;
    private _peerGcpGateway?;
    get peerGcpGateway(): string | undefined;
    set peerGcpGateway(value: string | undefined);
    resetPeerGcpGateway(): void;
    get peerGcpGatewayInput(): string | undefined;
    private _peerIp?;
    get peerIp(): string | undefined;
    set peerIp(value: string | undefined);
    resetPeerIp(): void;
    get peerIpInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string | undefined;
    set region(value: string | undefined);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _remoteTrafficSelector?;
    get remoteTrafficSelector(): string[] | undefined;
    set remoteTrafficSelector(value: string[] | undefined);
    resetRemoteTrafficSelector(): void;
    get remoteTrafficSelectorInput(): string[] | undefined;
    private _router?;
    get router(): string | undefined;
    set router(value: string | undefined);
    resetRouter(): void;
    get routerInput(): string | undefined;
    get selfLink(): string;
    private _sharedSecret?;
    get sharedSecret(): string;
    set sharedSecret(value: string);
    get sharedSecretInput(): string | undefined;
    get sharedSecretHash(): string;
    private _targetVpnGateway?;
    get targetVpnGateway(): string | undefined;
    set targetVpnGateway(value: string | undefined);
    resetTargetVpnGateway(): void;
    get targetVpnGatewayInput(): string | undefined;
    get tunnelId(): string;
    private _vpnGateway?;
    get vpnGateway(): string | undefined;
    set vpnGateway(value: string | undefined);
    resetVpnGateway(): void;
    get vpnGatewayInput(): string | undefined;
    private _vpnGatewayInterface?;
    get vpnGatewayInterface(): number | undefined;
    set vpnGatewayInterface(value: number | undefined);
    resetVpnGatewayInterface(): void;
    get vpnGatewayInterfaceInput(): number | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): ComputeVpnTunnelTimeoutsOutputReference;
    putTimeouts(value: ComputeVpnTunnelTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeVpnTunnelTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
