import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeUrlMapConfig extends cdktf.TerraformMetaArguments {
    /**
     * The backend service or backend bucket to use when none of the given rules match.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#default_service ComputeUrlMap#default_service}
     */
    readonly defaultService?: string;
    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#description ComputeUrlMap#description}
     */
    readonly description?: string;
    /**
     * Name of the resource.
     *
     * Provided by the client when the resource is created. The
     * name must be 1-63 characters long, and comply with RFC1035. Specifically, the
     * name must be 1-63 characters long and match the regular expression
     * '[a-z]([-a-z0-9]*[a-z0-9])?' which means the first character must be a lowercase
     * letter, and all following characters must be a dash, lowercase letter, or digit,
     * except the last character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#name ComputeUrlMap#name}
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#project ComputeUrlMap#project}.
     */
    readonly project?: string;
    /**
     * default_route_action block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#default_route_action ComputeUrlMap#default_route_action}
     */
    readonly defaultRouteAction?: ComputeUrlMapDefaultRouteAction;
    /**
     * default_url_redirect block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#default_url_redirect ComputeUrlMap#default_url_redirect}
     */
    readonly defaultUrlRedirect?: ComputeUrlMapDefaultUrlRedirect;
    /**
     * header_action block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_action ComputeUrlMap#header_action}
     */
    readonly headerAction?: ComputeUrlMapHeaderAction;
    /**
     * host_rule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#host_rule ComputeUrlMap#host_rule}
     */
    readonly hostRule?: ComputeUrlMapHostRule[];
    /**
     * path_matcher block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#path_matcher ComputeUrlMap#path_matcher}
     */
    readonly pathMatcher?: ComputeUrlMapPathMatcher[];
    /**
     * test block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#test ComputeUrlMap#test}
     */
    readonly test?: ComputeUrlMapTest[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#timeouts ComputeUrlMap#timeouts}
     */
    readonly timeouts?: ComputeUrlMapTimeouts;
}
export interface ComputeUrlMapDefaultRouteActionCorsPolicy {
    /**
     * In response to a preflight request, setting this to true indicates that the actual request can include user credentials.
     *
     * This translates to the Access-Control-Allow-Credentials header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#allow_credentials ComputeUrlMap#allow_credentials}
     */
    readonly allowCredentials?: boolean | cdktf.IResolvable;
    /**
     * Specifies the content for the Access-Control-Allow-Headers header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#allow_headers ComputeUrlMap#allow_headers}
     */
    readonly allowHeaders?: string[];
    /**
     * Specifies the content for the Access-Control-Allow-Methods header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#allow_methods ComputeUrlMap#allow_methods}
     */
    readonly allowMethods?: string[];
    /**
     * Specifies the regular expression patterns that match allowed origins.
     *
     * For regular expression grammar
     * please see en.cppreference.com/w/cpp/regex/ecmascript
     * An origin is allowed if it matches either an item in allowOrigins or an item in allowOriginRegexes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#allow_origin_regexes ComputeUrlMap#allow_origin_regexes}
     */
    readonly allowOriginRegexes?: string[];
    /**
     * Specifies the list of origins that will be allowed to do CORS requests.
     *
     * An origin is allowed if it matches either an item in allowOrigins or an item in allowOriginRegexes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#allow_origins ComputeUrlMap#allow_origins}
     */
    readonly allowOrigins?: string[];
    /**
     * If true, specifies the CORS policy is disabled.
     *
     * The default value is false, which indicates that the CORS policy is in effect.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#disabled ComputeUrlMap#disabled}
     */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
     * Specifies the content for the Access-Control-Expose-Headers header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#expose_headers ComputeUrlMap#expose_headers}
     */
    readonly exposeHeaders?: string[];
    /**
     * Specifies how long results of a preflight request can be cached in seconds. This translates to the Access-Control-Max-Age header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#max_age ComputeUrlMap#max_age}
     */
    readonly maxAge?: number;
}
export declare class ComputeUrlMapDefaultRouteActionCorsPolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _allowCredentials?;
    get allowCredentials(): boolean | cdktf.IResolvable | undefined;
    set allowCredentials(value: boolean | cdktf.IResolvable | undefined);
    resetAllowCredentials(): void;
    get allowCredentialsInput(): boolean | cdktf.IResolvable | undefined;
    private _allowHeaders?;
    get allowHeaders(): string[] | undefined;
    set allowHeaders(value: string[] | undefined);
    resetAllowHeaders(): void;
    get allowHeadersInput(): string[] | undefined;
    private _allowMethods?;
    get allowMethods(): string[] | undefined;
    set allowMethods(value: string[] | undefined);
    resetAllowMethods(): void;
    get allowMethodsInput(): string[] | undefined;
    private _allowOriginRegexes?;
    get allowOriginRegexes(): string[] | undefined;
    set allowOriginRegexes(value: string[] | undefined);
    resetAllowOriginRegexes(): void;
    get allowOriginRegexesInput(): string[] | undefined;
    private _allowOrigins?;
    get allowOrigins(): string[] | undefined;
    set allowOrigins(value: string[] | undefined);
    resetAllowOrigins(): void;
    get allowOriginsInput(): string[] | undefined;
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable | undefined;
    set disabled(value: boolean | cdktf.IResolvable | undefined);
    resetDisabled(): void;
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _exposeHeaders?;
    get exposeHeaders(): string[] | undefined;
    set exposeHeaders(value: string[] | undefined);
    resetExposeHeaders(): void;
    get exposeHeadersInput(): string[] | undefined;
    private _maxAge?;
    get maxAge(): number | undefined;
    set maxAge(value: number | undefined);
    resetMaxAge(): void;
    get maxAgeInput(): number | undefined;
}
export interface ComputeUrlMapDefaultRouteActionFaultInjectionPolicyAbort {
    /**
     * The HTTP status code used to abort the request. The value must be between 200 and 599 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#http_status ComputeUrlMap#http_status}
     */
    readonly httpStatus?: number;
    /**
     * The percentage of traffic (connections/operations/requests) which will be aborted as part of fault injection.
     *
     * The value must be between 0.0 and 100.0 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#percentage ComputeUrlMap#percentage}
     */
    readonly percentage?: number;
}
export declare class ComputeUrlMapDefaultRouteActionFaultInjectionPolicyAbortOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _httpStatus?;
    get httpStatus(): number | undefined;
    set httpStatus(value: number | undefined);
    resetHttpStatus(): void;
    get httpStatusInput(): number | undefined;
    private _percentage?;
    get percentage(): number | undefined;
    set percentage(value: number | undefined);
    resetPercentage(): void;
    get percentageInput(): number | undefined;
}
export interface ComputeUrlMapDefaultRouteActionFaultInjectionPolicyDelayFixedDelay {
    /**
     * Span of time that's a fraction of a second at nanosecond resolution.
     *
     * Durations less than one second are
     * represented with a 0 seconds field and a positive nanos field. Must be from 0 to 999,999,999 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#nanos ComputeUrlMap#nanos}
     */
    readonly nanos?: number;
    /**
     * Span of time at a resolution of a second.
     *
     * Must be from 0 to 315,576,000,000 inclusive.
     * Note: these bounds are computed from: 60 sec/min * 60 min/hr * 24 hr/day * 365.25 days/year * 10000 years
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#seconds ComputeUrlMap#seconds}
     */
    readonly seconds?: string;
}
export declare class ComputeUrlMapDefaultRouteActionFaultInjectionPolicyDelayFixedDelayOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _nanos?;
    get nanos(): number | undefined;
    set nanos(value: number | undefined);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): string | undefined;
    set seconds(value: string | undefined);
    resetSeconds(): void;
    get secondsInput(): string | undefined;
}
export interface ComputeUrlMapDefaultRouteActionFaultInjectionPolicyDelay {
    /**
     * The percentage of traffic (connections/operations/requests) on which delay will be introduced as part of fault injection.
     *
     * The value must be between 0.0 and 100.0 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#percentage ComputeUrlMap#percentage}
     */
    readonly percentage?: number;
    /**
     * fixed_delay block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#fixed_delay ComputeUrlMap#fixed_delay}
     */
    readonly fixedDelay?: ComputeUrlMapDefaultRouteActionFaultInjectionPolicyDelayFixedDelay;
}
export declare class ComputeUrlMapDefaultRouteActionFaultInjectionPolicyDelayOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _percentage?;
    get percentage(): number | undefined;
    set percentage(value: number | undefined);
    resetPercentage(): void;
    get percentageInput(): number | undefined;
    private _fixedDelay?;
    private __fixedDelayOutput;
    get fixedDelay(): ComputeUrlMapDefaultRouteActionFaultInjectionPolicyDelayFixedDelayOutputReference;
    putFixedDelay(value: ComputeUrlMapDefaultRouteActionFaultInjectionPolicyDelayFixedDelay | undefined): void;
    resetFixedDelay(): void;
    get fixedDelayInput(): ComputeUrlMapDefaultRouteActionFaultInjectionPolicyDelayFixedDelay | undefined;
}
export interface ComputeUrlMapDefaultRouteActionFaultInjectionPolicy {
    /**
     * abort block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#abort ComputeUrlMap#abort}
     */
    readonly abort?: ComputeUrlMapDefaultRouteActionFaultInjectionPolicyAbort;
    /**
     * delay block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#delay ComputeUrlMap#delay}
     */
    readonly delay?: ComputeUrlMapDefaultRouteActionFaultInjectionPolicyDelay;
}
export declare class ComputeUrlMapDefaultRouteActionFaultInjectionPolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _abort?;
    private __abortOutput;
    get abort(): ComputeUrlMapDefaultRouteActionFaultInjectionPolicyAbortOutputReference;
    putAbort(value: ComputeUrlMapDefaultRouteActionFaultInjectionPolicyAbort | undefined): void;
    resetAbort(): void;
    get abortInput(): ComputeUrlMapDefaultRouteActionFaultInjectionPolicyAbort | undefined;
    private _delay?;
    private __delayOutput;
    get delay(): ComputeUrlMapDefaultRouteActionFaultInjectionPolicyDelayOutputReference;
    putDelay(value: ComputeUrlMapDefaultRouteActionFaultInjectionPolicyDelay | undefined): void;
    resetDelay(): void;
    get delayInput(): ComputeUrlMapDefaultRouteActionFaultInjectionPolicyDelay | undefined;
}
export interface ComputeUrlMapDefaultRouteActionRequestMirrorPolicy {
    /**
     * The full or partial URL to the BackendService resource being mirrored to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#backend_service ComputeUrlMap#backend_service}
     */
    readonly backendService: string;
}
export declare class ComputeUrlMapDefaultRouteActionRequestMirrorPolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _backendService?;
    get backendService(): string;
    set backendService(value: string);
    get backendServiceInput(): string | undefined;
}
export interface ComputeUrlMapDefaultRouteActionRetryPolicyPerTryTimeout {
    /**
     * Span of time that's a fraction of a second at nanosecond resolution.
     *
     * Durations less than one second are
     * represented with a 0 seconds field and a positive nanos field. Must be from 0 to 999,999,999 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#nanos ComputeUrlMap#nanos}
     */
    readonly nanos?: number;
    /**
     * Span of time at a resolution of a second.
     *
     * Must be from 0 to 315,576,000,000 inclusive.
     * Note: these bounds are computed from: 60 sec/min * 60 min/hr * 24 hr/day * 365.25 days/year * 10000 years
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#seconds ComputeUrlMap#seconds}
     */
    readonly seconds?: string;
}
export declare class ComputeUrlMapDefaultRouteActionRetryPolicyPerTryTimeoutOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _nanos?;
    get nanos(): number | undefined;
    set nanos(value: number | undefined);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): string | undefined;
    set seconds(value: string | undefined);
    resetSeconds(): void;
    get secondsInput(): string | undefined;
}
export interface ComputeUrlMapDefaultRouteActionRetryPolicy {
    /**
     * Specifies the allowed number retries. This number must be > 0. If not specified, defaults to 1.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#num_retries ComputeUrlMap#num_retries}
     */
    readonly numRetries?: number;
    /**
     * Specfies one or more conditions when this retry rule applies. Valid values are:.
     *
     * 5xx: Loadbalancer will attempt a retry if the backend service responds with any 5xx response code,
     * or if the backend service does not respond at all, example: disconnects, reset, read timeout,
     * connection failure, and refused streams.
     * gateway-error: Similar to 5xx, but only applies to response codes 502, 503 or 504.
     * connect-failure: Loadbalancer will retry on failures connecting to backend services,
     * for example due to connection timeouts.
     * retriable-4xx: Loadbalancer will retry for retriable 4xx response codes.
     * Currently the only retriable error supported is 409.
     * refused-stream:Loadbalancer will retry if the backend service resets the stream with a REFUSED_STREAM error code.
     * This reset type indicates that it is safe to retry.
     * cancelled: Loadbalancer will retry if the gRPC status code in the response header is set to cancelled
     * deadline-exceeded: Loadbalancer will retry if the gRPC status code in the response header is set to deadline-exceeded
     * resource-exhausted: Loadbalancer will retry if the gRPC status code in the response header is set to resource-exhausted
     * unavailable: Loadbalancer will retry if the gRPC status code in the response header is set to unavailable
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#retry_conditions ComputeUrlMap#retry_conditions}
     */
    readonly retryConditions?: string[];
    /**
     * per_try_timeout block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#per_try_timeout ComputeUrlMap#per_try_timeout}
     */
    readonly perTryTimeout?: ComputeUrlMapDefaultRouteActionRetryPolicyPerTryTimeout;
}
export declare class ComputeUrlMapDefaultRouteActionRetryPolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _numRetries?;
    get numRetries(): number | undefined;
    set numRetries(value: number | undefined);
    resetNumRetries(): void;
    get numRetriesInput(): number | undefined;
    private _retryConditions?;
    get retryConditions(): string[] | undefined;
    set retryConditions(value: string[] | undefined);
    resetRetryConditions(): void;
    get retryConditionsInput(): string[] | undefined;
    private _perTryTimeout?;
    private __perTryTimeoutOutput;
    get perTryTimeout(): ComputeUrlMapDefaultRouteActionRetryPolicyPerTryTimeoutOutputReference;
    putPerTryTimeout(value: ComputeUrlMapDefaultRouteActionRetryPolicyPerTryTimeout | undefined): void;
    resetPerTryTimeout(): void;
    get perTryTimeoutInput(): ComputeUrlMapDefaultRouteActionRetryPolicyPerTryTimeout | undefined;
}
export interface ComputeUrlMapDefaultRouteActionTimeout {
    /**
     * Span of time that's a fraction of a second at nanosecond resolution.
     *
     * Durations less than one second are represented
     * with a 0 seconds field and a positive nanos field. Must be from 0 to 999,999,999 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#nanos ComputeUrlMap#nanos}
     */
    readonly nanos?: number;
    /**
     * Span of time at a resolution of a second.
     *
     * Must be from 0 to 315,576,000,000 inclusive.
     * Note: these bounds are computed from: 60 sec/min * 60 min/hr * 24 hr/day * 365.25 days/year * 10000 years
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#seconds ComputeUrlMap#seconds}
     */
    readonly seconds?: string;
}
export declare class ComputeUrlMapDefaultRouteActionTimeoutOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _nanos?;
    get nanos(): number | undefined;
    set nanos(value: number | undefined);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): string | undefined;
    set seconds(value: string | undefined);
    resetSeconds(): void;
    get secondsInput(): string | undefined;
}
export interface ComputeUrlMapDefaultRouteActionUrlRewrite {
    /**
     * Prior to forwarding the request to the selected service, the request's host header is replaced with contents of hostRewrite.
     *
     * The value must be between 1 and 255 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#host_rewrite ComputeUrlMap#host_rewrite}
     */
    readonly hostRewrite?: string;
    /**
     * Prior to forwarding the request to the selected backend service, the matching portion of the request's path is replaced by pathPrefixRewrite.
     *
     * The value must be between 1 and 1024 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#path_prefix_rewrite ComputeUrlMap#path_prefix_rewrite}
     */
    readonly pathPrefixRewrite?: string;
}
export declare class ComputeUrlMapDefaultRouteActionUrlRewriteOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _hostRewrite?;
    get hostRewrite(): string | undefined;
    set hostRewrite(value: string | undefined);
    resetHostRewrite(): void;
    get hostRewriteInput(): string | undefined;
    private _pathPrefixRewrite?;
    get pathPrefixRewrite(): string | undefined;
    set pathPrefixRewrite(value: string | undefined);
    resetPathPrefixRewrite(): void;
    get pathPrefixRewriteInput(): string | undefined;
}
export interface ComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd {
    /**
     * The name of the header to add.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_name ComputeUrlMap#header_name}
     */
    readonly headerName?: string;
    /**
     * The value of the header to add.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_value ComputeUrlMap#header_value}
     */
    readonly headerValue?: string;
    /**
     * If false, headerValue is appended to any values that already exist for the header.
     *
     * If true, headerValue is set for the header, discarding any values that were set for that header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#replace ComputeUrlMap#replace}
     */
    readonly replace?: boolean | cdktf.IResolvable;
}
export interface ComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd {
    /**
     * The name of the header to add.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_name ComputeUrlMap#header_name}
     */
    readonly headerName?: string;
    /**
     * The value of the header to add.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_value ComputeUrlMap#header_value}
     */
    readonly headerValue?: string;
    /**
     * If false, headerValue is appended to any values that already exist for the header.
     *
     * If true, headerValue is set for the header, discarding any values that were set for that header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#replace ComputeUrlMap#replace}
     */
    readonly replace?: boolean | cdktf.IResolvable;
}
export interface ComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderAction {
    /**
     * A list of header names for headers that need to be removed from the request prior to forwarding the request to the backendService.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#request_headers_to_remove ComputeUrlMap#request_headers_to_remove}
     */
    readonly requestHeadersToRemove?: string[];
    /**
     * A list of header names for headers that need to be removed from the response prior to sending the response back to the client.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#response_headers_to_remove ComputeUrlMap#response_headers_to_remove}
     */
    readonly responseHeadersToRemove?: string[];
    /**
     * request_headers_to_add block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#request_headers_to_add ComputeUrlMap#request_headers_to_add}
     */
    readonly requestHeadersToAdd?: ComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[];
    /**
     * response_headers_to_add block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#response_headers_to_add ComputeUrlMap#response_headers_to_add}
     */
    readonly responseHeadersToAdd?: ComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[];
}
export declare class ComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _requestHeadersToRemove?;
    get requestHeadersToRemove(): string[] | undefined;
    set requestHeadersToRemove(value: string[] | undefined);
    resetRequestHeadersToRemove(): void;
    get requestHeadersToRemoveInput(): string[] | undefined;
    private _responseHeadersToRemove?;
    get responseHeadersToRemove(): string[] | undefined;
    set responseHeadersToRemove(value: string[] | undefined);
    resetResponseHeadersToRemove(): void;
    get responseHeadersToRemoveInput(): string[] | undefined;
    private _requestHeadersToAdd?;
    get requestHeadersToAdd(): ComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[] | undefined;
    set requestHeadersToAdd(value: ComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[] | undefined);
    resetRequestHeadersToAdd(): void;
    get requestHeadersToAddInput(): ComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[] | undefined;
    private _responseHeadersToAdd?;
    get responseHeadersToAdd(): ComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[] | undefined;
    set responseHeadersToAdd(value: ComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[] | undefined);
    resetResponseHeadersToAdd(): void;
    get responseHeadersToAddInput(): ComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[] | undefined;
}
export interface ComputeUrlMapDefaultRouteActionWeightedBackendServices {
    /**
     * The full or partial URL to the default BackendService resource.
     *
     * Before forwarding the
     * request to backendService, the loadbalancer applies any relevant headerActions
     * specified as part of this backendServiceWeight.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#backend_service ComputeUrlMap#backend_service}
     */
    readonly backendService?: string;
    /**
     * Specifies the fraction of traffic sent to backendService, computed as weight / (sum of all weightedBackendService weights in routeAction) .
     *
     * The selection of a backend service is determined only for new traffic. Once a user's request
     * has been directed to a backendService, subsequent requests will be sent to the same backendService
     * as determined by the BackendService's session affinity policy.
     *
     * The value must be between 0 and 1000
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#weight ComputeUrlMap#weight}
     */
    readonly weight?: number;
    /**
     * header_action block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_action ComputeUrlMap#header_action}
     */
    readonly headerAction?: ComputeUrlMapDefaultRouteActionWeightedBackendServicesHeaderAction;
}
export interface ComputeUrlMapDefaultRouteAction {
    /**
     * cors_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#cors_policy ComputeUrlMap#cors_policy}
     */
    readonly corsPolicy?: ComputeUrlMapDefaultRouteActionCorsPolicy;
    /**
     * fault_injection_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#fault_injection_policy ComputeUrlMap#fault_injection_policy}
     */
    readonly faultInjectionPolicy?: ComputeUrlMapDefaultRouteActionFaultInjectionPolicy;
    /**
     * request_mirror_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#request_mirror_policy ComputeUrlMap#request_mirror_policy}
     */
    readonly requestMirrorPolicy?: ComputeUrlMapDefaultRouteActionRequestMirrorPolicy;
    /**
     * retry_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#retry_policy ComputeUrlMap#retry_policy}
     */
    readonly retryPolicy?: ComputeUrlMapDefaultRouteActionRetryPolicy;
    /**
     * timeout block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#timeout ComputeUrlMap#timeout}
     */
    readonly timeout?: ComputeUrlMapDefaultRouteActionTimeout;
    /**
     * url_rewrite block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#url_rewrite ComputeUrlMap#url_rewrite}
     */
    readonly urlRewrite?: ComputeUrlMapDefaultRouteActionUrlRewrite;
    /**
     * weighted_backend_services block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#weighted_backend_services ComputeUrlMap#weighted_backend_services}
     */
    readonly weightedBackendServices?: ComputeUrlMapDefaultRouteActionWeightedBackendServices[];
}
export declare class ComputeUrlMapDefaultRouteActionOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _corsPolicy?;
    private __corsPolicyOutput;
    get corsPolicy(): ComputeUrlMapDefaultRouteActionCorsPolicyOutputReference;
    putCorsPolicy(value: ComputeUrlMapDefaultRouteActionCorsPolicy | undefined): void;
    resetCorsPolicy(): void;
    get corsPolicyInput(): ComputeUrlMapDefaultRouteActionCorsPolicy | undefined;
    private _faultInjectionPolicy?;
    private __faultInjectionPolicyOutput;
    get faultInjectionPolicy(): ComputeUrlMapDefaultRouteActionFaultInjectionPolicyOutputReference;
    putFaultInjectionPolicy(value: ComputeUrlMapDefaultRouteActionFaultInjectionPolicy | undefined): void;
    resetFaultInjectionPolicy(): void;
    get faultInjectionPolicyInput(): ComputeUrlMapDefaultRouteActionFaultInjectionPolicy | undefined;
    private _requestMirrorPolicy?;
    private __requestMirrorPolicyOutput;
    get requestMirrorPolicy(): ComputeUrlMapDefaultRouteActionRequestMirrorPolicyOutputReference;
    putRequestMirrorPolicy(value: ComputeUrlMapDefaultRouteActionRequestMirrorPolicy | undefined): void;
    resetRequestMirrorPolicy(): void;
    get requestMirrorPolicyInput(): ComputeUrlMapDefaultRouteActionRequestMirrorPolicy | undefined;
    private _retryPolicy?;
    private __retryPolicyOutput;
    get retryPolicy(): ComputeUrlMapDefaultRouteActionRetryPolicyOutputReference;
    putRetryPolicy(value: ComputeUrlMapDefaultRouteActionRetryPolicy | undefined): void;
    resetRetryPolicy(): void;
    get retryPolicyInput(): ComputeUrlMapDefaultRouteActionRetryPolicy | undefined;
    private _timeout?;
    private __timeoutOutput;
    get timeout(): ComputeUrlMapDefaultRouteActionTimeoutOutputReference;
    putTimeout(value: ComputeUrlMapDefaultRouteActionTimeout | undefined): void;
    resetTimeout(): void;
    get timeoutInput(): ComputeUrlMapDefaultRouteActionTimeout | undefined;
    private _urlRewrite?;
    private __urlRewriteOutput;
    get urlRewrite(): ComputeUrlMapDefaultRouteActionUrlRewriteOutputReference;
    putUrlRewrite(value: ComputeUrlMapDefaultRouteActionUrlRewrite | undefined): void;
    resetUrlRewrite(): void;
    get urlRewriteInput(): ComputeUrlMapDefaultRouteActionUrlRewrite | undefined;
    private _weightedBackendServices?;
    get weightedBackendServices(): ComputeUrlMapDefaultRouteActionWeightedBackendServices[] | undefined;
    set weightedBackendServices(value: ComputeUrlMapDefaultRouteActionWeightedBackendServices[] | undefined);
    resetWeightedBackendServices(): void;
    get weightedBackendServicesInput(): ComputeUrlMapDefaultRouteActionWeightedBackendServices[] | undefined;
}
export interface ComputeUrlMapDefaultUrlRedirect {
    /**
     * The host that will be used in the redirect response instead of the one that was supplied in the request.
     *
     * The value must be between 1 and 255 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#host_redirect ComputeUrlMap#host_redirect}
     */
    readonly hostRedirect?: string;
    /**
     * If set to true, the URL scheme in the redirected request is set to https.
     *
     * If set to
     * false, the URL scheme of the redirected request will remain the same as that of the
     * request. This must only be set for UrlMaps used in TargetHttpProxys. Setting this
     * true for TargetHttpsProxy is not permitted. The default is set to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#https_redirect ComputeUrlMap#https_redirect}
     */
    readonly httpsRedirect?: boolean | cdktf.IResolvable;
    /**
     * The path that will be used in the redirect response instead of the one that was supplied in the request.
     *
     * pathRedirect cannot be supplied together with
     * prefixRedirect. Supply one alone or neither. If neither is supplied, the path of the
     * original request will be used for the redirect. The value must be between 1 and 1024
     * characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#path_redirect ComputeUrlMap#path_redirect}
     */
    readonly pathRedirect?: string;
    /**
     * The prefix that replaces the prefixMatch specified in the HttpRouteRuleMatch, retaining the remaining portion of the URL before redirecting the request.
     *
     * prefixRedirect cannot be supplied together with pathRedirect. Supply one alone or
     * neither. If neither is supplied, the path of the original request will be used for
     * the redirect. The value must be between 1 and 1024 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#prefix_redirect ComputeUrlMap#prefix_redirect}
     */
    readonly prefixRedirect?: string;
    /**
     * The HTTP Status code to use for this RedirectAction. Supported values are:.
     *
     * MOVED_PERMANENTLY_DEFAULT, which is the default value and corresponds to 301.
     *
     * FOUND, which corresponds to 302.
     *
     * SEE_OTHER which corresponds to 303.
     *
     * TEMPORARY_REDIRECT, which corresponds to 307. In this case, the request method
     * will be retained.
     *
     * PERMANENT_REDIRECT, which corresponds to 308. In this case,
     * the request method will be retained. Possible values: ["FOUND", "MOVED_PERMANENTLY_DEFAULT", "PERMANENT_REDIRECT", "SEE_OTHER", "TEMPORARY_REDIRECT"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#redirect_response_code ComputeUrlMap#redirect_response_code}
     */
    readonly redirectResponseCode?: string;
    /**
     * If set to true, any accompanying query portion of the original URL is removed prior to redirecting the request.
     *
     * If set to false, the query portion of the original URL is
     * retained. The default is set to false.
     * This field is required to ensure an empty block is not set. The normal default value is false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#strip_query ComputeUrlMap#strip_query}
     */
    readonly stripQuery: boolean | cdktf.IResolvable;
}
export declare class ComputeUrlMapDefaultUrlRedirectOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _hostRedirect?;
    get hostRedirect(): string | undefined;
    set hostRedirect(value: string | undefined);
    resetHostRedirect(): void;
    get hostRedirectInput(): string | undefined;
    private _httpsRedirect?;
    get httpsRedirect(): boolean | cdktf.IResolvable | undefined;
    set httpsRedirect(value: boolean | cdktf.IResolvable | undefined);
    resetHttpsRedirect(): void;
    get httpsRedirectInput(): boolean | cdktf.IResolvable | undefined;
    private _pathRedirect?;
    get pathRedirect(): string | undefined;
    set pathRedirect(value: string | undefined);
    resetPathRedirect(): void;
    get pathRedirectInput(): string | undefined;
    private _prefixRedirect?;
    get prefixRedirect(): string | undefined;
    set prefixRedirect(value: string | undefined);
    resetPrefixRedirect(): void;
    get prefixRedirectInput(): string | undefined;
    private _redirectResponseCode?;
    get redirectResponseCode(): string | undefined;
    set redirectResponseCode(value: string | undefined);
    resetRedirectResponseCode(): void;
    get redirectResponseCodeInput(): string | undefined;
    private _stripQuery?;
    get stripQuery(): boolean | cdktf.IResolvable;
    set stripQuery(value: boolean | cdktf.IResolvable);
    get stripQueryInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ComputeUrlMapHeaderActionRequestHeadersToAdd {
    /**
     * The name of the header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_name ComputeUrlMap#header_name}
     */
    readonly headerName: string;
    /**
     * The value of the header to add.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_value ComputeUrlMap#header_value}
     */
    readonly headerValue: string;
    /**
     * If false, headerValue is appended to any values that already exist for the header.
     *
     * If true, headerValue is set for the header, discarding any values that
     * were set for that header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#replace ComputeUrlMap#replace}
     */
    readonly replace: boolean | cdktf.IResolvable;
}
export interface ComputeUrlMapHeaderActionResponseHeadersToAdd {
    /**
     * The name of the header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_name ComputeUrlMap#header_name}
     */
    readonly headerName: string;
    /**
     * The value of the header to add.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_value ComputeUrlMap#header_value}
     */
    readonly headerValue: string;
    /**
     * If false, headerValue is appended to any values that already exist for the header.
     *
     * If true, headerValue is set for the header, discarding any values that
     * were set for that header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#replace ComputeUrlMap#replace}
     */
    readonly replace: boolean | cdktf.IResolvable;
}
export interface ComputeUrlMapHeaderAction {
    /**
     * A list of header names for headers that need to be removed from the request prior to forwarding the request to the backendService.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#request_headers_to_remove ComputeUrlMap#request_headers_to_remove}
     */
    readonly requestHeadersToRemove?: string[];
    /**
     * A list of header names for headers that need to be removed from the response prior to sending the response back to the client.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#response_headers_to_remove ComputeUrlMap#response_headers_to_remove}
     */
    readonly responseHeadersToRemove?: string[];
    /**
     * request_headers_to_add block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#request_headers_to_add ComputeUrlMap#request_headers_to_add}
     */
    readonly requestHeadersToAdd?: ComputeUrlMapHeaderActionRequestHeadersToAdd[];
    /**
     * response_headers_to_add block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#response_headers_to_add ComputeUrlMap#response_headers_to_add}
     */
    readonly responseHeadersToAdd?: ComputeUrlMapHeaderActionResponseHeadersToAdd[];
}
export declare class ComputeUrlMapHeaderActionOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _requestHeadersToRemove?;
    get requestHeadersToRemove(): string[] | undefined;
    set requestHeadersToRemove(value: string[] | undefined);
    resetRequestHeadersToRemove(): void;
    get requestHeadersToRemoveInput(): string[] | undefined;
    private _responseHeadersToRemove?;
    get responseHeadersToRemove(): string[] | undefined;
    set responseHeadersToRemove(value: string[] | undefined);
    resetResponseHeadersToRemove(): void;
    get responseHeadersToRemoveInput(): string[] | undefined;
    private _requestHeadersToAdd?;
    get requestHeadersToAdd(): ComputeUrlMapHeaderActionRequestHeadersToAdd[] | undefined;
    set requestHeadersToAdd(value: ComputeUrlMapHeaderActionRequestHeadersToAdd[] | undefined);
    resetRequestHeadersToAdd(): void;
    get requestHeadersToAddInput(): ComputeUrlMapHeaderActionRequestHeadersToAdd[] | undefined;
    private _responseHeadersToAdd?;
    get responseHeadersToAdd(): ComputeUrlMapHeaderActionResponseHeadersToAdd[] | undefined;
    set responseHeadersToAdd(value: ComputeUrlMapHeaderActionResponseHeadersToAdd[] | undefined);
    resetResponseHeadersToAdd(): void;
    get responseHeadersToAddInput(): ComputeUrlMapHeaderActionResponseHeadersToAdd[] | undefined;
}
export interface ComputeUrlMapHostRule {
    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#description ComputeUrlMap#description}
     */
    readonly description?: string;
    /**
     * The list of host patterns to match.
     *
     * They must be valid hostnames, except * will
     * match any string of ([a-z0-9-.]*). In that case, * must be the first character
     * and must be followed in the pattern by either - or ..
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#hosts ComputeUrlMap#hosts}
     */
    readonly hosts: string[];
    /**
     * The name of the PathMatcher to use to match the path portion of the URL if the hostRule matches the URL's host portion.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#path_matcher ComputeUrlMap#path_matcher}
     */
    readonly pathMatcher: string;
}
export interface ComputeUrlMapPathMatcherDefaultRouteActionCorsPolicy {
    /**
     * In response to a preflight request, setting this to true indicates that the actual request can include user credentials.
     *
     * This translates to the Access-Control-Allow-Credentials header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#allow_credentials ComputeUrlMap#allow_credentials}
     */
    readonly allowCredentials?: boolean | cdktf.IResolvable;
    /**
     * Specifies the content for the Access-Control-Allow-Headers header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#allow_headers ComputeUrlMap#allow_headers}
     */
    readonly allowHeaders?: string[];
    /**
     * Specifies the content for the Access-Control-Allow-Methods header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#allow_methods ComputeUrlMap#allow_methods}
     */
    readonly allowMethods?: string[];
    /**
     * Specifies the regular expression patterns that match allowed origins.
     *
     * For regular expression grammar
     * please see en.cppreference.com/w/cpp/regex/ecmascript
     * An origin is allowed if it matches either an item in allowOrigins or an item in allowOriginRegexes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#allow_origin_regexes ComputeUrlMap#allow_origin_regexes}
     */
    readonly allowOriginRegexes?: string[];
    /**
     * Specifies the list of origins that will be allowed to do CORS requests.
     *
     * An origin is allowed if it matches either an item in allowOrigins or an item in allowOriginRegexes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#allow_origins ComputeUrlMap#allow_origins}
     */
    readonly allowOrigins?: string[];
    /**
     * If true, specifies the CORS policy is disabled.
     *
     * The default value is false, which indicates that the CORS policy is in effect.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#disabled ComputeUrlMap#disabled}
     */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
     * Specifies the content for the Access-Control-Expose-Headers header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#expose_headers ComputeUrlMap#expose_headers}
     */
    readonly exposeHeaders?: string[];
    /**
     * Specifies how long results of a preflight request can be cached in seconds. This translates to the Access-Control-Max-Age header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#max_age ComputeUrlMap#max_age}
     */
    readonly maxAge?: number;
}
export declare class ComputeUrlMapPathMatcherDefaultRouteActionCorsPolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _allowCredentials?;
    get allowCredentials(): boolean | cdktf.IResolvable | undefined;
    set allowCredentials(value: boolean | cdktf.IResolvable | undefined);
    resetAllowCredentials(): void;
    get allowCredentialsInput(): boolean | cdktf.IResolvable | undefined;
    private _allowHeaders?;
    get allowHeaders(): string[] | undefined;
    set allowHeaders(value: string[] | undefined);
    resetAllowHeaders(): void;
    get allowHeadersInput(): string[] | undefined;
    private _allowMethods?;
    get allowMethods(): string[] | undefined;
    set allowMethods(value: string[] | undefined);
    resetAllowMethods(): void;
    get allowMethodsInput(): string[] | undefined;
    private _allowOriginRegexes?;
    get allowOriginRegexes(): string[] | undefined;
    set allowOriginRegexes(value: string[] | undefined);
    resetAllowOriginRegexes(): void;
    get allowOriginRegexesInput(): string[] | undefined;
    private _allowOrigins?;
    get allowOrigins(): string[] | undefined;
    set allowOrigins(value: string[] | undefined);
    resetAllowOrigins(): void;
    get allowOriginsInput(): string[] | undefined;
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable | undefined;
    set disabled(value: boolean | cdktf.IResolvable | undefined);
    resetDisabled(): void;
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _exposeHeaders?;
    get exposeHeaders(): string[] | undefined;
    set exposeHeaders(value: string[] | undefined);
    resetExposeHeaders(): void;
    get exposeHeadersInput(): string[] | undefined;
    private _maxAge?;
    get maxAge(): number | undefined;
    set maxAge(value: number | undefined);
    resetMaxAge(): void;
    get maxAgeInput(): number | undefined;
}
export interface ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyAbort {
    /**
     * The HTTP status code used to abort the request. The value must be between 200 and 599 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#http_status ComputeUrlMap#http_status}
     */
    readonly httpStatus?: number;
    /**
     * The percentage of traffic (connections/operations/requests) which will be aborted as part of fault injection.
     *
     * The value must be between 0.0 and 100.0 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#percentage ComputeUrlMap#percentage}
     */
    readonly percentage?: number;
}
export declare class ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyAbortOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _httpStatus?;
    get httpStatus(): number | undefined;
    set httpStatus(value: number | undefined);
    resetHttpStatus(): void;
    get httpStatusInput(): number | undefined;
    private _percentage?;
    get percentage(): number | undefined;
    set percentage(value: number | undefined);
    resetPercentage(): void;
    get percentageInput(): number | undefined;
}
export interface ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyDelayFixedDelay {
    /**
     * Span of time that's a fraction of a second at nanosecond resolution.
     *
     * Durations less than one second are
     * represented with a 0 seconds field and a positive nanos field. Must be from 0 to 999,999,999 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#nanos ComputeUrlMap#nanos}
     */
    readonly nanos?: number;
    /**
     * Span of time at a resolution of a second.
     *
     * Must be from 0 to 315,576,000,000 inclusive.
     * Note: these bounds are computed from: 60 sec/min * 60 min/hr * 24 hr/day * 365.25 days/year * 10000 years
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#seconds ComputeUrlMap#seconds}
     */
    readonly seconds?: string;
}
export declare class ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyDelayFixedDelayOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _nanos?;
    get nanos(): number | undefined;
    set nanos(value: number | undefined);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): string | undefined;
    set seconds(value: string | undefined);
    resetSeconds(): void;
    get secondsInput(): string | undefined;
}
export interface ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyDelay {
    /**
     * The percentage of traffic (connections/operations/requests) on which delay will be introduced as part of fault injection.
     *
     * The value must be between 0.0 and 100.0 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#percentage ComputeUrlMap#percentage}
     */
    readonly percentage?: number;
    /**
     * fixed_delay block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#fixed_delay ComputeUrlMap#fixed_delay}
     */
    readonly fixedDelay?: ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyDelayFixedDelay;
}
export declare class ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyDelayOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _percentage?;
    get percentage(): number | undefined;
    set percentage(value: number | undefined);
    resetPercentage(): void;
    get percentageInput(): number | undefined;
    private _fixedDelay?;
    private __fixedDelayOutput;
    get fixedDelay(): ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyDelayFixedDelayOutputReference;
    putFixedDelay(value: ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyDelayFixedDelay | undefined): void;
    resetFixedDelay(): void;
    get fixedDelayInput(): ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyDelayFixedDelay | undefined;
}
export interface ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicy {
    /**
     * abort block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#abort ComputeUrlMap#abort}
     */
    readonly abort?: ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyAbort;
    /**
     * delay block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#delay ComputeUrlMap#delay}
     */
    readonly delay?: ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyDelay;
}
export declare class ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _abort?;
    private __abortOutput;
    get abort(): ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyAbortOutputReference;
    putAbort(value: ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyAbort | undefined): void;
    resetAbort(): void;
    get abortInput(): ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyAbort | undefined;
    private _delay?;
    private __delayOutput;
    get delay(): ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyDelayOutputReference;
    putDelay(value: ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyDelay | undefined): void;
    resetDelay(): void;
    get delayInput(): ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyDelay | undefined;
}
export interface ComputeUrlMapPathMatcherDefaultRouteActionRequestMirrorPolicy {
    /**
     * The full or partial URL to the BackendService resource being mirrored to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#backend_service ComputeUrlMap#backend_service}
     */
    readonly backendService: string;
}
export declare class ComputeUrlMapPathMatcherDefaultRouteActionRequestMirrorPolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _backendService?;
    get backendService(): string;
    set backendService(value: string);
    get backendServiceInput(): string | undefined;
}
export interface ComputeUrlMapPathMatcherDefaultRouteActionRetryPolicyPerTryTimeout {
    /**
     * Span of time that's a fraction of a second at nanosecond resolution.
     *
     * Durations less than one second are
     * represented with a 0 seconds field and a positive nanos field. Must be from 0 to 999,999,999 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#nanos ComputeUrlMap#nanos}
     */
    readonly nanos?: number;
    /**
     * Span of time at a resolution of a second.
     *
     * Must be from 0 to 315,576,000,000 inclusive.
     * Note: these bounds are computed from: 60 sec/min * 60 min/hr * 24 hr/day * 365.25 days/year * 10000 years
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#seconds ComputeUrlMap#seconds}
     */
    readonly seconds?: string;
}
export declare class ComputeUrlMapPathMatcherDefaultRouteActionRetryPolicyPerTryTimeoutOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _nanos?;
    get nanos(): number | undefined;
    set nanos(value: number | undefined);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): string | undefined;
    set seconds(value: string | undefined);
    resetSeconds(): void;
    get secondsInput(): string | undefined;
}
export interface ComputeUrlMapPathMatcherDefaultRouteActionRetryPolicy {
    /**
     * Specifies the allowed number retries. This number must be > 0. If not specified, defaults to 1.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#num_retries ComputeUrlMap#num_retries}
     */
    readonly numRetries?: number;
    /**
     * Specfies one or more conditions when this retry rule applies. Valid values are:.
     *
     * 5xx: Loadbalancer will attempt a retry if the backend service responds with any 5xx response code,
     * or if the backend service does not respond at all, example: disconnects, reset, read timeout,
     * connection failure, and refused streams.
     * gateway-error: Similar to 5xx, but only applies to response codes 502, 503 or 504.
     * connect-failure: Loadbalancer will retry on failures connecting to backend services,
     * for example due to connection timeouts.
     * retriable-4xx: Loadbalancer will retry for retriable 4xx response codes.
     * Currently the only retriable error supported is 409.
     * refused-stream:Loadbalancer will retry if the backend service resets the stream with a REFUSED_STREAM error code.
     * This reset type indicates that it is safe to retry.
     * cancelled: Loadbalancer will retry if the gRPC status code in the response header is set to cancelled
     * deadline-exceeded: Loadbalancer will retry if the gRPC status code in the response header is set to deadline-exceeded
     * resource-exhausted: Loadbalancer will retry if the gRPC status code in the response header is set to resource-exhausted
     * unavailable: Loadbalancer will retry if the gRPC status code in the response header is set to unavailable
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#retry_conditions ComputeUrlMap#retry_conditions}
     */
    readonly retryConditions?: string[];
    /**
     * per_try_timeout block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#per_try_timeout ComputeUrlMap#per_try_timeout}
     */
    readonly perTryTimeout?: ComputeUrlMapPathMatcherDefaultRouteActionRetryPolicyPerTryTimeout;
}
export declare class ComputeUrlMapPathMatcherDefaultRouteActionRetryPolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _numRetries?;
    get numRetries(): number | undefined;
    set numRetries(value: number | undefined);
    resetNumRetries(): void;
    get numRetriesInput(): number | undefined;
    private _retryConditions?;
    get retryConditions(): string[] | undefined;
    set retryConditions(value: string[] | undefined);
    resetRetryConditions(): void;
    get retryConditionsInput(): string[] | undefined;
    private _perTryTimeout?;
    private __perTryTimeoutOutput;
    get perTryTimeout(): ComputeUrlMapPathMatcherDefaultRouteActionRetryPolicyPerTryTimeoutOutputReference;
    putPerTryTimeout(value: ComputeUrlMapPathMatcherDefaultRouteActionRetryPolicyPerTryTimeout | undefined): void;
    resetPerTryTimeout(): void;
    get perTryTimeoutInput(): ComputeUrlMapPathMatcherDefaultRouteActionRetryPolicyPerTryTimeout | undefined;
}
export interface ComputeUrlMapPathMatcherDefaultRouteActionTimeout {
    /**
     * Span of time that's a fraction of a second at nanosecond resolution.
     *
     * Durations less than one second are represented
     * with a 0 seconds field and a positive nanos field. Must be from 0 to 999,999,999 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#nanos ComputeUrlMap#nanos}
     */
    readonly nanos?: number;
    /**
     * Span of time at a resolution of a second.
     *
     * Must be from 0 to 315,576,000,000 inclusive.
     * Note: these bounds are computed from: 60 sec/min * 60 min/hr * 24 hr/day * 365.25 days/year * 10000 years
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#seconds ComputeUrlMap#seconds}
     */
    readonly seconds?: string;
}
export declare class ComputeUrlMapPathMatcherDefaultRouteActionTimeoutOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _nanos?;
    get nanos(): number | undefined;
    set nanos(value: number | undefined);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): string | undefined;
    set seconds(value: string | undefined);
    resetSeconds(): void;
    get secondsInput(): string | undefined;
}
export interface ComputeUrlMapPathMatcherDefaultRouteActionUrlRewrite {
    /**
     * Prior to forwarding the request to the selected service, the request's host header is replaced with contents of hostRewrite.
     *
     * The value must be between 1 and 255 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#host_rewrite ComputeUrlMap#host_rewrite}
     */
    readonly hostRewrite?: string;
    /**
     * Prior to forwarding the request to the selected backend service, the matching portion of the request's path is replaced by pathPrefixRewrite.
     *
     * The value must be between 1 and 1024 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#path_prefix_rewrite ComputeUrlMap#path_prefix_rewrite}
     */
    readonly pathPrefixRewrite?: string;
}
export declare class ComputeUrlMapPathMatcherDefaultRouteActionUrlRewriteOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _hostRewrite?;
    get hostRewrite(): string | undefined;
    set hostRewrite(value: string | undefined);
    resetHostRewrite(): void;
    get hostRewriteInput(): string | undefined;
    private _pathPrefixRewrite?;
    get pathPrefixRewrite(): string | undefined;
    set pathPrefixRewrite(value: string | undefined);
    resetPathPrefixRewrite(): void;
    get pathPrefixRewriteInput(): string | undefined;
}
export interface ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd {
    /**
     * The name of the header to add.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_name ComputeUrlMap#header_name}
     */
    readonly headerName?: string;
    /**
     * The value of the header to add.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_value ComputeUrlMap#header_value}
     */
    readonly headerValue?: string;
    /**
     * If false, headerValue is appended to any values that already exist for the header.
     *
     * If true, headerValue is set for the header, discarding any values that were set for that header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#replace ComputeUrlMap#replace}
     */
    readonly replace?: boolean | cdktf.IResolvable;
}
export interface ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd {
    /**
     * The name of the header to add.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_name ComputeUrlMap#header_name}
     */
    readonly headerName?: string;
    /**
     * The value of the header to add.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_value ComputeUrlMap#header_value}
     */
    readonly headerValue?: string;
    /**
     * If false, headerValue is appended to any values that already exist for the header.
     *
     * If true, headerValue is set for the header, discarding any values that were set for that header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#replace ComputeUrlMap#replace}
     */
    readonly replace?: boolean | cdktf.IResolvable;
}
export interface ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderAction {
    /**
     * A list of header names for headers that need to be removed from the request prior to forwarding the request to the backendService.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#request_headers_to_remove ComputeUrlMap#request_headers_to_remove}
     */
    readonly requestHeadersToRemove?: string[];
    /**
     * A list of header names for headers that need to be removed from the response prior to sending the response back to the client.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#response_headers_to_remove ComputeUrlMap#response_headers_to_remove}
     */
    readonly responseHeadersToRemove?: string[];
    /**
     * request_headers_to_add block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#request_headers_to_add ComputeUrlMap#request_headers_to_add}
     */
    readonly requestHeadersToAdd?: ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[];
    /**
     * response_headers_to_add block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#response_headers_to_add ComputeUrlMap#response_headers_to_add}
     */
    readonly responseHeadersToAdd?: ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[];
}
export declare class ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _requestHeadersToRemove?;
    get requestHeadersToRemove(): string[] | undefined;
    set requestHeadersToRemove(value: string[] | undefined);
    resetRequestHeadersToRemove(): void;
    get requestHeadersToRemoveInput(): string[] | undefined;
    private _responseHeadersToRemove?;
    get responseHeadersToRemove(): string[] | undefined;
    set responseHeadersToRemove(value: string[] | undefined);
    resetResponseHeadersToRemove(): void;
    get responseHeadersToRemoveInput(): string[] | undefined;
    private _requestHeadersToAdd?;
    get requestHeadersToAdd(): ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[] | undefined;
    set requestHeadersToAdd(value: ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[] | undefined);
    resetRequestHeadersToAdd(): void;
    get requestHeadersToAddInput(): ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[] | undefined;
    private _responseHeadersToAdd?;
    get responseHeadersToAdd(): ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[] | undefined;
    set responseHeadersToAdd(value: ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[] | undefined);
    resetResponseHeadersToAdd(): void;
    get responseHeadersToAddInput(): ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[] | undefined;
}
export interface ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServices {
    /**
     * The full or partial URL to the default BackendService resource.
     *
     * Before forwarding the
     * request to backendService, the loadbalancer applies any relevant headerActions
     * specified as part of this backendServiceWeight.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#backend_service ComputeUrlMap#backend_service}
     */
    readonly backendService?: string;
    /**
     * Specifies the fraction of traffic sent to backendService, computed as weight / (sum of all weightedBackendService weights in routeAction) .
     *
     * The selection of a backend service is determined only for new traffic. Once a user's request
     * has been directed to a backendService, subsequent requests will be sent to the same backendService
     * as determined by the BackendService's session affinity policy.
     *
     * The value must be between 0 and 1000
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#weight ComputeUrlMap#weight}
     */
    readonly weight?: number;
    /**
     * header_action block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_action ComputeUrlMap#header_action}
     */
    readonly headerAction?: ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServicesHeaderAction;
}
export interface ComputeUrlMapPathMatcherDefaultRouteAction {
    /**
     * cors_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#cors_policy ComputeUrlMap#cors_policy}
     */
    readonly corsPolicy?: ComputeUrlMapPathMatcherDefaultRouteActionCorsPolicy;
    /**
     * fault_injection_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#fault_injection_policy ComputeUrlMap#fault_injection_policy}
     */
    readonly faultInjectionPolicy?: ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicy;
    /**
     * request_mirror_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#request_mirror_policy ComputeUrlMap#request_mirror_policy}
     */
    readonly requestMirrorPolicy?: ComputeUrlMapPathMatcherDefaultRouteActionRequestMirrorPolicy;
    /**
     * retry_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#retry_policy ComputeUrlMap#retry_policy}
     */
    readonly retryPolicy?: ComputeUrlMapPathMatcherDefaultRouteActionRetryPolicy;
    /**
     * timeout block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#timeout ComputeUrlMap#timeout}
     */
    readonly timeout?: ComputeUrlMapPathMatcherDefaultRouteActionTimeout;
    /**
     * url_rewrite block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#url_rewrite ComputeUrlMap#url_rewrite}
     */
    readonly urlRewrite?: ComputeUrlMapPathMatcherDefaultRouteActionUrlRewrite;
    /**
     * weighted_backend_services block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#weighted_backend_services ComputeUrlMap#weighted_backend_services}
     */
    readonly weightedBackendServices?: ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServices[];
}
export declare class ComputeUrlMapPathMatcherDefaultRouteActionOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _corsPolicy?;
    private __corsPolicyOutput;
    get corsPolicy(): ComputeUrlMapPathMatcherDefaultRouteActionCorsPolicyOutputReference;
    putCorsPolicy(value: ComputeUrlMapPathMatcherDefaultRouteActionCorsPolicy | undefined): void;
    resetCorsPolicy(): void;
    get corsPolicyInput(): ComputeUrlMapPathMatcherDefaultRouteActionCorsPolicy | undefined;
    private _faultInjectionPolicy?;
    private __faultInjectionPolicyOutput;
    get faultInjectionPolicy(): ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicyOutputReference;
    putFaultInjectionPolicy(value: ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicy | undefined): void;
    resetFaultInjectionPolicy(): void;
    get faultInjectionPolicyInput(): ComputeUrlMapPathMatcherDefaultRouteActionFaultInjectionPolicy | undefined;
    private _requestMirrorPolicy?;
    private __requestMirrorPolicyOutput;
    get requestMirrorPolicy(): ComputeUrlMapPathMatcherDefaultRouteActionRequestMirrorPolicyOutputReference;
    putRequestMirrorPolicy(value: ComputeUrlMapPathMatcherDefaultRouteActionRequestMirrorPolicy | undefined): void;
    resetRequestMirrorPolicy(): void;
    get requestMirrorPolicyInput(): ComputeUrlMapPathMatcherDefaultRouteActionRequestMirrorPolicy | undefined;
    private _retryPolicy?;
    private __retryPolicyOutput;
    get retryPolicy(): ComputeUrlMapPathMatcherDefaultRouteActionRetryPolicyOutputReference;
    putRetryPolicy(value: ComputeUrlMapPathMatcherDefaultRouteActionRetryPolicy | undefined): void;
    resetRetryPolicy(): void;
    get retryPolicyInput(): ComputeUrlMapPathMatcherDefaultRouteActionRetryPolicy | undefined;
    private _timeout?;
    private __timeoutOutput;
    get timeout(): ComputeUrlMapPathMatcherDefaultRouteActionTimeoutOutputReference;
    putTimeout(value: ComputeUrlMapPathMatcherDefaultRouteActionTimeout | undefined): void;
    resetTimeout(): void;
    get timeoutInput(): ComputeUrlMapPathMatcherDefaultRouteActionTimeout | undefined;
    private _urlRewrite?;
    private __urlRewriteOutput;
    get urlRewrite(): ComputeUrlMapPathMatcherDefaultRouteActionUrlRewriteOutputReference;
    putUrlRewrite(value: ComputeUrlMapPathMatcherDefaultRouteActionUrlRewrite | undefined): void;
    resetUrlRewrite(): void;
    get urlRewriteInput(): ComputeUrlMapPathMatcherDefaultRouteActionUrlRewrite | undefined;
    private _weightedBackendServices?;
    get weightedBackendServices(): ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServices[] | undefined;
    set weightedBackendServices(value: ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServices[] | undefined);
    resetWeightedBackendServices(): void;
    get weightedBackendServicesInput(): ComputeUrlMapPathMatcherDefaultRouteActionWeightedBackendServices[] | undefined;
}
export interface ComputeUrlMapPathMatcherDefaultUrlRedirect {
    /**
     * The host that will be used in the redirect response instead of the one that was supplied in the request.
     *
     * The value must be between 1 and 255 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#host_redirect ComputeUrlMap#host_redirect}
     */
    readonly hostRedirect?: string;
    /**
     * If set to true, the URL scheme in the redirected request is set to https.
     *
     * If set to
     * false, the URL scheme of the redirected request will remain the same as that of the
     * request. This must only be set for UrlMaps used in TargetHttpProxys. Setting this
     * true for TargetHttpsProxy is not permitted. The default is set to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#https_redirect ComputeUrlMap#https_redirect}
     */
    readonly httpsRedirect?: boolean | cdktf.IResolvable;
    /**
     * The path that will be used in the redirect response instead of the one that was supplied in the request.
     *
     * pathRedirect cannot be supplied together with
     * prefixRedirect. Supply one alone or neither. If neither is supplied, the path of the
     * original request will be used for the redirect. The value must be between 1 and 1024
     * characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#path_redirect ComputeUrlMap#path_redirect}
     */
    readonly pathRedirect?: string;
    /**
     * The prefix that replaces the prefixMatch specified in the HttpRouteRuleMatch, retaining the remaining portion of the URL before redirecting the request.
     *
     * prefixRedirect cannot be supplied together with pathRedirect. Supply one alone or
     * neither. If neither is supplied, the path of the original request will be used for
     * the redirect. The value must be between 1 and 1024 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#prefix_redirect ComputeUrlMap#prefix_redirect}
     */
    readonly prefixRedirect?: string;
    /**
     * The HTTP Status code to use for this RedirectAction. Supported values are:.
     *
     * MOVED_PERMANENTLY_DEFAULT, which is the default value and corresponds to 301.
     *
     * FOUND, which corresponds to 302.
     *
     * SEE_OTHER which corresponds to 303.
     *
     * TEMPORARY_REDIRECT, which corresponds to 307. In this case, the request method
     * will be retained.
     *
     * PERMANENT_REDIRECT, which corresponds to 308. In this case,
     * the request method will be retained. Possible values: ["FOUND", "MOVED_PERMANENTLY_DEFAULT", "PERMANENT_REDIRECT", "SEE_OTHER", "TEMPORARY_REDIRECT"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#redirect_response_code ComputeUrlMap#redirect_response_code}
     */
    readonly redirectResponseCode?: string;
    /**
     * If set to true, any accompanying query portion of the original URL is removed prior to redirecting the request.
     *
     * If set to false, the query portion of the original URL is
     * retained.
     * This field is required to ensure an empty block is not set. The normal default value is false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#strip_query ComputeUrlMap#strip_query}
     */
    readonly stripQuery: boolean | cdktf.IResolvable;
}
export declare class ComputeUrlMapPathMatcherDefaultUrlRedirectOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _hostRedirect?;
    get hostRedirect(): string | undefined;
    set hostRedirect(value: string | undefined);
    resetHostRedirect(): void;
    get hostRedirectInput(): string | undefined;
    private _httpsRedirect?;
    get httpsRedirect(): boolean | cdktf.IResolvable | undefined;
    set httpsRedirect(value: boolean | cdktf.IResolvable | undefined);
    resetHttpsRedirect(): void;
    get httpsRedirectInput(): boolean | cdktf.IResolvable | undefined;
    private _pathRedirect?;
    get pathRedirect(): string | undefined;
    set pathRedirect(value: string | undefined);
    resetPathRedirect(): void;
    get pathRedirectInput(): string | undefined;
    private _prefixRedirect?;
    get prefixRedirect(): string | undefined;
    set prefixRedirect(value: string | undefined);
    resetPrefixRedirect(): void;
    get prefixRedirectInput(): string | undefined;
    private _redirectResponseCode?;
    get redirectResponseCode(): string | undefined;
    set redirectResponseCode(value: string | undefined);
    resetRedirectResponseCode(): void;
    get redirectResponseCodeInput(): string | undefined;
    private _stripQuery?;
    get stripQuery(): boolean | cdktf.IResolvable;
    set stripQuery(value: boolean | cdktf.IResolvable);
    get stripQueryInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ComputeUrlMapPathMatcherHeaderActionRequestHeadersToAdd {
    /**
     * The name of the header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_name ComputeUrlMap#header_name}
     */
    readonly headerName: string;
    /**
     * The value of the header to add.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_value ComputeUrlMap#header_value}
     */
    readonly headerValue: string;
    /**
     * If false, headerValue is appended to any values that already exist for the header.
     *
     * If true, headerValue is set for the header, discarding any values that
     * were set for that header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#replace ComputeUrlMap#replace}
     */
    readonly replace: boolean | cdktf.IResolvable;
}
export interface ComputeUrlMapPathMatcherHeaderActionResponseHeadersToAdd {
    /**
     * The name of the header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_name ComputeUrlMap#header_name}
     */
    readonly headerName: string;
    /**
     * The value of the header to add.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_value ComputeUrlMap#header_value}
     */
    readonly headerValue: string;
    /**
     * If false, headerValue is appended to any values that already exist for the header.
     *
     * If true, headerValue is set for the header, discarding any values that
     * were set for that header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#replace ComputeUrlMap#replace}
     */
    readonly replace: boolean | cdktf.IResolvable;
}
export interface ComputeUrlMapPathMatcherHeaderAction {
    /**
     * A list of header names for headers that need to be removed from the request prior to forwarding the request to the backendService.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#request_headers_to_remove ComputeUrlMap#request_headers_to_remove}
     */
    readonly requestHeadersToRemove?: string[];
    /**
     * A list of header names for headers that need to be removed from the response prior to sending the response back to the client.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#response_headers_to_remove ComputeUrlMap#response_headers_to_remove}
     */
    readonly responseHeadersToRemove?: string[];
    /**
     * request_headers_to_add block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#request_headers_to_add ComputeUrlMap#request_headers_to_add}
     */
    readonly requestHeadersToAdd?: ComputeUrlMapPathMatcherHeaderActionRequestHeadersToAdd[];
    /**
     * response_headers_to_add block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#response_headers_to_add ComputeUrlMap#response_headers_to_add}
     */
    readonly responseHeadersToAdd?: ComputeUrlMapPathMatcherHeaderActionResponseHeadersToAdd[];
}
export declare class ComputeUrlMapPathMatcherHeaderActionOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _requestHeadersToRemove?;
    get requestHeadersToRemove(): string[] | undefined;
    set requestHeadersToRemove(value: string[] | undefined);
    resetRequestHeadersToRemove(): void;
    get requestHeadersToRemoveInput(): string[] | undefined;
    private _responseHeadersToRemove?;
    get responseHeadersToRemove(): string[] | undefined;
    set responseHeadersToRemove(value: string[] | undefined);
    resetResponseHeadersToRemove(): void;
    get responseHeadersToRemoveInput(): string[] | undefined;
    private _requestHeadersToAdd?;
    get requestHeadersToAdd(): ComputeUrlMapPathMatcherHeaderActionRequestHeadersToAdd[] | undefined;
    set requestHeadersToAdd(value: ComputeUrlMapPathMatcherHeaderActionRequestHeadersToAdd[] | undefined);
    resetRequestHeadersToAdd(): void;
    get requestHeadersToAddInput(): ComputeUrlMapPathMatcherHeaderActionRequestHeadersToAdd[] | undefined;
    private _responseHeadersToAdd?;
    get responseHeadersToAdd(): ComputeUrlMapPathMatcherHeaderActionResponseHeadersToAdd[] | undefined;
    set responseHeadersToAdd(value: ComputeUrlMapPathMatcherHeaderActionResponseHeadersToAdd[] | undefined);
    resetResponseHeadersToAdd(): void;
    get responseHeadersToAddInput(): ComputeUrlMapPathMatcherHeaderActionResponseHeadersToAdd[] | undefined;
}
export interface ComputeUrlMapPathMatcherPathRuleRouteActionCorsPolicy {
    /**
     * In response to a preflight request, setting this to true indicates that the actual request can include user credentials.
     *
     * This translates to the Access-
     * Control-Allow-Credentials header. Defaults to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#allow_credentials ComputeUrlMap#allow_credentials}
     */
    readonly allowCredentials?: boolean | cdktf.IResolvable;
    /**
     * Specifies the content for the Access-Control-Allow-Headers header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#allow_headers ComputeUrlMap#allow_headers}
     */
    readonly allowHeaders?: string[];
    /**
     * Specifies the content for the Access-Control-Allow-Methods header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#allow_methods ComputeUrlMap#allow_methods}
     */
    readonly allowMethods?: string[];
    /**
     * Specifies the regular expression patterns that match allowed origins.
     *
     * For
     * regular expression grammar please see en.cppreference.com/w/cpp/regex/ecmascript
     * An origin is allowed if it matches either allow_origins or allow_origin_regex.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#allow_origin_regexes ComputeUrlMap#allow_origin_regexes}
     */
    readonly allowOriginRegexes?: string[];
    /**
     * Specifies the list of origins that will be allowed to do CORS requests.
     *
     * An
     * origin is allowed if it matches either allow_origins or allow_origin_regex.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#allow_origins ComputeUrlMap#allow_origins}
     */
    readonly allowOrigins?: string[];
    /**
     * If true, specifies the CORS policy is disabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#disabled ComputeUrlMap#disabled}
     */
    readonly disabled: boolean | cdktf.IResolvable;
    /**
     * Specifies the content for the Access-Control-Expose-Headers header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#expose_headers ComputeUrlMap#expose_headers}
     */
    readonly exposeHeaders?: string[];
    /**
     * Specifies how long the results of a preflight request can be cached.
     *
     * This
     * translates to the content for the Access-Control-Max-Age header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#max_age ComputeUrlMap#max_age}
     */
    readonly maxAge?: number;
}
export declare class ComputeUrlMapPathMatcherPathRuleRouteActionCorsPolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _allowCredentials?;
    get allowCredentials(): boolean | cdktf.IResolvable | undefined;
    set allowCredentials(value: boolean | cdktf.IResolvable | undefined);
    resetAllowCredentials(): void;
    get allowCredentialsInput(): boolean | cdktf.IResolvable | undefined;
    private _allowHeaders?;
    get allowHeaders(): string[] | undefined;
    set allowHeaders(value: string[] | undefined);
    resetAllowHeaders(): void;
    get allowHeadersInput(): string[] | undefined;
    private _allowMethods?;
    get allowMethods(): string[] | undefined;
    set allowMethods(value: string[] | undefined);
    resetAllowMethods(): void;
    get allowMethodsInput(): string[] | undefined;
    private _allowOriginRegexes?;
    get allowOriginRegexes(): string[] | undefined;
    set allowOriginRegexes(value: string[] | undefined);
    resetAllowOriginRegexes(): void;
    get allowOriginRegexesInput(): string[] | undefined;
    private _allowOrigins?;
    get allowOrigins(): string[] | undefined;
    set allowOrigins(value: string[] | undefined);
    resetAllowOrigins(): void;
    get allowOriginsInput(): string[] | undefined;
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _exposeHeaders?;
    get exposeHeaders(): string[] | undefined;
    set exposeHeaders(value: string[] | undefined);
    resetExposeHeaders(): void;
    get exposeHeadersInput(): string[] | undefined;
    private _maxAge?;
    get maxAge(): number | undefined;
    set maxAge(value: number | undefined);
    resetMaxAge(): void;
    get maxAgeInput(): number | undefined;
}
export interface ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyAbort {
    /**
     * The HTTP status code used to abort the request. The value must be between 200 and 599 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#http_status ComputeUrlMap#http_status}
     */
    readonly httpStatus: number;
    /**
     * The percentage of traffic (connections/operations/requests) which will be aborted as part of fault injection.
     *
     * The value must be between 0.0 and 100.0
     * inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#percentage ComputeUrlMap#percentage}
     */
    readonly percentage: number;
}
export declare class ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyAbortOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _httpStatus?;
    get httpStatus(): number;
    set httpStatus(value: number);
    get httpStatusInput(): number | undefined;
    private _percentage?;
    get percentage(): number;
    set percentage(value: number);
    get percentageInput(): number | undefined;
}
export interface ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayFixedDelay {
    /**
     * Span of time that's a fraction of a second at nanosecond resolution.
     *
     * Durations
     * less than one second are represented with a 0 'seconds' field and a positive
     * 'nanos' field. Must be from 0 to 999,999,999 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#nanos ComputeUrlMap#nanos}
     */
    readonly nanos?: number;
    /**
     * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#seconds ComputeUrlMap#seconds}
     */
    readonly seconds: string;
}
export declare class ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayFixedDelayOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _nanos?;
    get nanos(): number | undefined;
    set nanos(value: number | undefined);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): string;
    set seconds(value: string);
    get secondsInput(): string | undefined;
}
export interface ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelay {
    /**
     * The percentage of traffic (connections/operations/requests) on which delay will be introduced as part of fault injection.
     *
     * The value must be between 0.0 and
     * 100.0 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#percentage ComputeUrlMap#percentage}
     */
    readonly percentage: number;
    /**
     * fixed_delay block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#fixed_delay ComputeUrlMap#fixed_delay}
     */
    readonly fixedDelay: ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayFixedDelay;
}
export declare class ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _percentage?;
    get percentage(): number;
    set percentage(value: number);
    get percentageInput(): number | undefined;
    private _fixedDelay?;
    private __fixedDelayOutput;
    get fixedDelay(): ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayFixedDelayOutputReference;
    putFixedDelay(value: ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayFixedDelay): void;
    get fixedDelayInput(): ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayFixedDelay | undefined;
}
export interface ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicy {
    /**
     * abort block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#abort ComputeUrlMap#abort}
     */
    readonly abort?: ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyAbort;
    /**
     * delay block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#delay ComputeUrlMap#delay}
     */
    readonly delay?: ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelay;
}
export declare class ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _abort?;
    private __abortOutput;
    get abort(): ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyAbortOutputReference;
    putAbort(value: ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyAbort | undefined): void;
    resetAbort(): void;
    get abortInput(): ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyAbort | undefined;
    private _delay?;
    private __delayOutput;
    get delay(): ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelayOutputReference;
    putDelay(value: ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelay | undefined): void;
    resetDelay(): void;
    get delayInput(): ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyDelay | undefined;
}
export interface ComputeUrlMapPathMatcherPathRuleRouteActionRequestMirrorPolicy {
    /**
     * The BackendService resource being mirrored to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#backend_service ComputeUrlMap#backend_service}
     */
    readonly backendService: string;
}
export declare class ComputeUrlMapPathMatcherPathRuleRouteActionRequestMirrorPolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _backendService?;
    get backendService(): string;
    set backendService(value: string);
    get backendServiceInput(): string | undefined;
}
export interface ComputeUrlMapPathMatcherPathRuleRouteActionRetryPolicyPerTryTimeout {
    /**
     * Span of time that's a fraction of a second at nanosecond resolution.
     *
     * Durations
     * less than one second are represented with a 0 'seconds' field and a positive
     * 'nanos' field. Must be from 0 to 999,999,999 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#nanos ComputeUrlMap#nanos}
     */
    readonly nanos?: number;
    /**
     * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#seconds ComputeUrlMap#seconds}
     */
    readonly seconds: string;
}
export declare class ComputeUrlMapPathMatcherPathRuleRouteActionRetryPolicyPerTryTimeoutOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _nanos?;
    get nanos(): number | undefined;
    set nanos(value: number | undefined);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): string;
    set seconds(value: string);
    get secondsInput(): string | undefined;
}
export interface ComputeUrlMapPathMatcherPathRuleRouteActionRetryPolicy {
    /**
     * Specifies the allowed number retries. This number must be > 0.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#num_retries ComputeUrlMap#num_retries}
     */
    readonly numRetries?: number;
    /**
     * Specifies one or more conditions when this retry rule applies. Valid values are:.
     *
     * 5xx: Loadbalancer will attempt a retry if the backend service responds with
     * any 5xx response code, or if the backend service does not respond at all,
     * example: disconnects, reset, read timeout, connection failure, and refused
     * streams.
     * gateway-error: Similar to 5xx, but only applies to response codes
     * 502, 503 or 504.
     * connect-failure: Loadbalancer will retry on failures
     * connecting to backend services, for example due to connection timeouts.
     * retriable-4xx: Loadbalancer will retry for retriable 4xx response codes.
     * Currently the only retriable error supported is 409.
     * refused-stream: Loadbalancer will retry if the backend service resets the stream with a
     * REFUSED_STREAM error code. This reset type indicates that it is safe to retry.
     * cancelled: Loadbalancer will retry if the gRPC status code in the response
     * header is set to cancelled
     * deadline-exceeded: Loadbalancer will retry if the
     * gRPC status code in the response header is set to deadline-exceeded
     * resource-exhausted: Loadbalancer will retry if the gRPC status code in the response
     * header is set to resource-exhausted
     * unavailable: Loadbalancer will retry if
     * the gRPC status code in the response header is set to unavailable
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#retry_conditions ComputeUrlMap#retry_conditions}
     */
    readonly retryConditions?: string[];
    /**
     * per_try_timeout block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#per_try_timeout ComputeUrlMap#per_try_timeout}
     */
    readonly perTryTimeout?: ComputeUrlMapPathMatcherPathRuleRouteActionRetryPolicyPerTryTimeout;
}
export declare class ComputeUrlMapPathMatcherPathRuleRouteActionRetryPolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _numRetries?;
    get numRetries(): number | undefined;
    set numRetries(value: number | undefined);
    resetNumRetries(): void;
    get numRetriesInput(): number | undefined;
    private _retryConditions?;
    get retryConditions(): string[] | undefined;
    set retryConditions(value: string[] | undefined);
    resetRetryConditions(): void;
    get retryConditionsInput(): string[] | undefined;
    private _perTryTimeout?;
    private __perTryTimeoutOutput;
    get perTryTimeout(): ComputeUrlMapPathMatcherPathRuleRouteActionRetryPolicyPerTryTimeoutOutputReference;
    putPerTryTimeout(value: ComputeUrlMapPathMatcherPathRuleRouteActionRetryPolicyPerTryTimeout | undefined): void;
    resetPerTryTimeout(): void;
    get perTryTimeoutInput(): ComputeUrlMapPathMatcherPathRuleRouteActionRetryPolicyPerTryTimeout | undefined;
}
export interface ComputeUrlMapPathMatcherPathRuleRouteActionTimeout {
    /**
     * Span of time that's a fraction of a second at nanosecond resolution.
     *
     * Durations
     * less than one second are represented with a 0 'seconds' field and a positive
     * 'nanos' field. Must be from 0 to 999,999,999 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#nanos ComputeUrlMap#nanos}
     */
    readonly nanos?: number;
    /**
     * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#seconds ComputeUrlMap#seconds}
     */
    readonly seconds: string;
}
export declare class ComputeUrlMapPathMatcherPathRuleRouteActionTimeoutOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _nanos?;
    get nanos(): number | undefined;
    set nanos(value: number | undefined);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): string;
    set seconds(value: string);
    get secondsInput(): string | undefined;
}
export interface ComputeUrlMapPathMatcherPathRuleRouteActionUrlRewrite {
    /**
     * Prior to forwarding the request to the selected service, the request's host header is replaced with contents of hostRewrite.
     *
     * The value must be between 1 and
     * 255 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#host_rewrite ComputeUrlMap#host_rewrite}
     */
    readonly hostRewrite?: string;
    /**
     * Prior to forwarding the request to the selected backend service, the matching portion of the request's path is replaced by pathPrefixRewrite.
     *
     * The value must
     * be between 1 and 1024 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#path_prefix_rewrite ComputeUrlMap#path_prefix_rewrite}
     */
    readonly pathPrefixRewrite?: string;
}
export declare class ComputeUrlMapPathMatcherPathRuleRouteActionUrlRewriteOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _hostRewrite?;
    get hostRewrite(): string | undefined;
    set hostRewrite(value: string | undefined);
    resetHostRewrite(): void;
    get hostRewriteInput(): string | undefined;
    private _pathPrefixRewrite?;
    get pathPrefixRewrite(): string | undefined;
    set pathPrefixRewrite(value: string | undefined);
    resetPathPrefixRewrite(): void;
    get pathPrefixRewriteInput(): string | undefined;
}
export interface ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd {
    /**
     * The name of the header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_name ComputeUrlMap#header_name}
     */
    readonly headerName: string;
    /**
     * The value of the header to add.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_value ComputeUrlMap#header_value}
     */
    readonly headerValue: string;
    /**
     * If false, headerValue is appended to any values that already exist for the header.
     *
     * If true, headerValue is set for the header, discarding any values that
     * were set for that header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#replace ComputeUrlMap#replace}
     */
    readonly replace: boolean | cdktf.IResolvable;
}
export interface ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd {
    /**
     * The name of the header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_name ComputeUrlMap#header_name}
     */
    readonly headerName: string;
    /**
     * The value of the header to add.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_value ComputeUrlMap#header_value}
     */
    readonly headerValue: string;
    /**
     * If false, headerValue is appended to any values that already exist for the header.
     *
     * If true, headerValue is set for the header, discarding any values that
     * were set for that header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#replace ComputeUrlMap#replace}
     */
    readonly replace: boolean | cdktf.IResolvable;
}
export interface ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderAction {
    /**
     * A list of header names for headers that need to be removed from the request prior to forwarding the request to the backendService.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#request_headers_to_remove ComputeUrlMap#request_headers_to_remove}
     */
    readonly requestHeadersToRemove?: string[];
    /**
     * A list of header names for headers that need to be removed from the response prior to sending the response back to the client.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#response_headers_to_remove ComputeUrlMap#response_headers_to_remove}
     */
    readonly responseHeadersToRemove?: string[];
    /**
     * request_headers_to_add block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#request_headers_to_add ComputeUrlMap#request_headers_to_add}
     */
    readonly requestHeadersToAdd?: ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[];
    /**
     * response_headers_to_add block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#response_headers_to_add ComputeUrlMap#response_headers_to_add}
     */
    readonly responseHeadersToAdd?: ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[];
}
export declare class ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _requestHeadersToRemove?;
    get requestHeadersToRemove(): string[] | undefined;
    set requestHeadersToRemove(value: string[] | undefined);
    resetRequestHeadersToRemove(): void;
    get requestHeadersToRemoveInput(): string[] | undefined;
    private _responseHeadersToRemove?;
    get responseHeadersToRemove(): string[] | undefined;
    set responseHeadersToRemove(value: string[] | undefined);
    resetResponseHeadersToRemove(): void;
    get responseHeadersToRemoveInput(): string[] | undefined;
    private _requestHeadersToAdd?;
    get requestHeadersToAdd(): ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[] | undefined;
    set requestHeadersToAdd(value: ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[] | undefined);
    resetRequestHeadersToAdd(): void;
    get requestHeadersToAddInput(): ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[] | undefined;
    private _responseHeadersToAdd?;
    get responseHeadersToAdd(): ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[] | undefined;
    set responseHeadersToAdd(value: ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[] | undefined);
    resetResponseHeadersToAdd(): void;
    get responseHeadersToAddInput(): ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[] | undefined;
}
export interface ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServices {
    /**
     * The default BackendService resource.
     *
     * Before
     * forwarding the request to backendService, the loadbalancer applies any relevant
     * headerActions specified as part of this backendServiceWeight.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#backend_service ComputeUrlMap#backend_service}
     */
    readonly backendService: string;
    /**
     * Specifies the fraction of traffic sent to backendService, computed as weight / (sum of all weightedBackendService weights in routeAction) .
     *
     * The selection of a
     * backend service is determined only for new traffic. Once a user's request has
     * been directed to a backendService, subsequent requests will be sent to the same
     * backendService as determined by the BackendService's session affinity policy.
     * The value must be between 0 and 1000
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#weight ComputeUrlMap#weight}
     */
    readonly weight: number;
    /**
     * header_action block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_action ComputeUrlMap#header_action}
     */
    readonly headerAction?: ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServicesHeaderAction;
}
export interface ComputeUrlMapPathMatcherPathRuleRouteAction {
    /**
     * cors_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#cors_policy ComputeUrlMap#cors_policy}
     */
    readonly corsPolicy?: ComputeUrlMapPathMatcherPathRuleRouteActionCorsPolicy;
    /**
     * fault_injection_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#fault_injection_policy ComputeUrlMap#fault_injection_policy}
     */
    readonly faultInjectionPolicy?: ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicy;
    /**
     * request_mirror_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#request_mirror_policy ComputeUrlMap#request_mirror_policy}
     */
    readonly requestMirrorPolicy?: ComputeUrlMapPathMatcherPathRuleRouteActionRequestMirrorPolicy;
    /**
     * retry_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#retry_policy ComputeUrlMap#retry_policy}
     */
    readonly retryPolicy?: ComputeUrlMapPathMatcherPathRuleRouteActionRetryPolicy;
    /**
     * timeout block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#timeout ComputeUrlMap#timeout}
     */
    readonly timeout?: ComputeUrlMapPathMatcherPathRuleRouteActionTimeout;
    /**
     * url_rewrite block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#url_rewrite ComputeUrlMap#url_rewrite}
     */
    readonly urlRewrite?: ComputeUrlMapPathMatcherPathRuleRouteActionUrlRewrite;
    /**
     * weighted_backend_services block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#weighted_backend_services ComputeUrlMap#weighted_backend_services}
     */
    readonly weightedBackendServices?: ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServices[];
}
export declare class ComputeUrlMapPathMatcherPathRuleRouteActionOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _corsPolicy?;
    private __corsPolicyOutput;
    get corsPolicy(): ComputeUrlMapPathMatcherPathRuleRouteActionCorsPolicyOutputReference;
    putCorsPolicy(value: ComputeUrlMapPathMatcherPathRuleRouteActionCorsPolicy | undefined): void;
    resetCorsPolicy(): void;
    get corsPolicyInput(): ComputeUrlMapPathMatcherPathRuleRouteActionCorsPolicy | undefined;
    private _faultInjectionPolicy?;
    private __faultInjectionPolicyOutput;
    get faultInjectionPolicy(): ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicyOutputReference;
    putFaultInjectionPolicy(value: ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicy | undefined): void;
    resetFaultInjectionPolicy(): void;
    get faultInjectionPolicyInput(): ComputeUrlMapPathMatcherPathRuleRouteActionFaultInjectionPolicy | undefined;
    private _requestMirrorPolicy?;
    private __requestMirrorPolicyOutput;
    get requestMirrorPolicy(): ComputeUrlMapPathMatcherPathRuleRouteActionRequestMirrorPolicyOutputReference;
    putRequestMirrorPolicy(value: ComputeUrlMapPathMatcherPathRuleRouteActionRequestMirrorPolicy | undefined): void;
    resetRequestMirrorPolicy(): void;
    get requestMirrorPolicyInput(): ComputeUrlMapPathMatcherPathRuleRouteActionRequestMirrorPolicy | undefined;
    private _retryPolicy?;
    private __retryPolicyOutput;
    get retryPolicy(): ComputeUrlMapPathMatcherPathRuleRouteActionRetryPolicyOutputReference;
    putRetryPolicy(value: ComputeUrlMapPathMatcherPathRuleRouteActionRetryPolicy | undefined): void;
    resetRetryPolicy(): void;
    get retryPolicyInput(): ComputeUrlMapPathMatcherPathRuleRouteActionRetryPolicy | undefined;
    private _timeout?;
    private __timeoutOutput;
    get timeout(): ComputeUrlMapPathMatcherPathRuleRouteActionTimeoutOutputReference;
    putTimeout(value: ComputeUrlMapPathMatcherPathRuleRouteActionTimeout | undefined): void;
    resetTimeout(): void;
    get timeoutInput(): ComputeUrlMapPathMatcherPathRuleRouteActionTimeout | undefined;
    private _urlRewrite?;
    private __urlRewriteOutput;
    get urlRewrite(): ComputeUrlMapPathMatcherPathRuleRouteActionUrlRewriteOutputReference;
    putUrlRewrite(value: ComputeUrlMapPathMatcherPathRuleRouteActionUrlRewrite | undefined): void;
    resetUrlRewrite(): void;
    get urlRewriteInput(): ComputeUrlMapPathMatcherPathRuleRouteActionUrlRewrite | undefined;
    private _weightedBackendServices?;
    get weightedBackendServices(): ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServices[] | undefined;
    set weightedBackendServices(value: ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServices[] | undefined);
    resetWeightedBackendServices(): void;
    get weightedBackendServicesInput(): ComputeUrlMapPathMatcherPathRuleRouteActionWeightedBackendServices[] | undefined;
}
export interface ComputeUrlMapPathMatcherPathRuleUrlRedirect {
    /**
     * The host that will be used in the redirect response instead of the one that was supplied in the request.
     *
     * The value must be between 1 and 255
     * characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#host_redirect ComputeUrlMap#host_redirect}
     */
    readonly hostRedirect?: string;
    /**
     * If set to true, the URL scheme in the redirected request is set to https.
     *
     * If set to false, the URL scheme of the redirected request will remain the
     * same as that of the request. This must only be set for UrlMaps used in
     * TargetHttpProxys. Setting this true for TargetHttpsProxy is not
     * permitted. The default is set to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#https_redirect ComputeUrlMap#https_redirect}
     */
    readonly httpsRedirect?: boolean | cdktf.IResolvable;
    /**
     * The path that will be used in the redirect response instead of the one that was supplied in the request.
     *
     * pathRedirect cannot be supplied
     * together with prefixRedirect. Supply one alone or neither. If neither is
     * supplied, the path of the original request will be used for the redirect.
     * The value must be between 1 and 1024 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#path_redirect ComputeUrlMap#path_redirect}
     */
    readonly pathRedirect?: string;
    /**
     * The prefix that replaces the prefixMatch specified in the HttpRouteRuleMatch, retaining the remaining portion of the URL before redirecting the request.
     *
     * prefixRedirect cannot be supplied together with
     * pathRedirect. Supply one alone or neither. If neither is supplied, the
     * path of the original request will be used for the redirect. The value
     * must be between 1 and 1024 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#prefix_redirect ComputeUrlMap#prefix_redirect}
     */
    readonly prefixRedirect?: string;
    /**
     * The HTTP Status code to use for this RedirectAction. Supported values are:.
     *
     * MOVED_PERMANENTLY_DEFAULT, which is the default value and corresponds to 301.
     *
     * FOUND, which corresponds to 302.
     *
     * SEE_OTHER which corresponds to 303.
     *
     * TEMPORARY_REDIRECT, which corresponds to 307. In this case, the request method
     * will be retained.
     *
     * PERMANENT_REDIRECT, which corresponds to 308. In this case,
     * the request method will be retained. Possible values: ["FOUND", "MOVED_PERMANENTLY_DEFAULT", "PERMANENT_REDIRECT", "SEE_OTHER", "TEMPORARY_REDIRECT"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#redirect_response_code ComputeUrlMap#redirect_response_code}
     */
    readonly redirectResponseCode?: string;
    /**
     * If set to true, any accompanying query portion of the original URL is removed prior to redirecting the request.
     *
     * If set to false, the query
     * portion of the original URL is retained.
     * This field is required to ensure an empty block is not set. The normal default value is false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#strip_query ComputeUrlMap#strip_query}
     */
    readonly stripQuery: boolean | cdktf.IResolvable;
}
export declare class ComputeUrlMapPathMatcherPathRuleUrlRedirectOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _hostRedirect?;
    get hostRedirect(): string | undefined;
    set hostRedirect(value: string | undefined);
    resetHostRedirect(): void;
    get hostRedirectInput(): string | undefined;
    private _httpsRedirect?;
    get httpsRedirect(): boolean | cdktf.IResolvable | undefined;
    set httpsRedirect(value: boolean | cdktf.IResolvable | undefined);
    resetHttpsRedirect(): void;
    get httpsRedirectInput(): boolean | cdktf.IResolvable | undefined;
    private _pathRedirect?;
    get pathRedirect(): string | undefined;
    set pathRedirect(value: string | undefined);
    resetPathRedirect(): void;
    get pathRedirectInput(): string | undefined;
    private _prefixRedirect?;
    get prefixRedirect(): string | undefined;
    set prefixRedirect(value: string | undefined);
    resetPrefixRedirect(): void;
    get prefixRedirectInput(): string | undefined;
    private _redirectResponseCode?;
    get redirectResponseCode(): string | undefined;
    set redirectResponseCode(value: string | undefined);
    resetRedirectResponseCode(): void;
    get redirectResponseCodeInput(): string | undefined;
    private _stripQuery?;
    get stripQuery(): boolean | cdktf.IResolvable;
    set stripQuery(value: boolean | cdktf.IResolvable);
    get stripQueryInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ComputeUrlMapPathMatcherPathRule {
    /**
     * The list of path patterns to match.
     *
     * Each must start with / and the only place a
     * \* is allowed is at the end following a /. The string fed to the path matcher
     * does not include any text after the first ? or #, and those chars are not
     * allowed here.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#paths ComputeUrlMap#paths}
     */
    readonly paths: string[];
    /**
     * The backend service or backend bucket to use if any of the given paths match.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#service ComputeUrlMap#service}
     */
    readonly service?: string;
    /**
     * route_action block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#route_action ComputeUrlMap#route_action}
     */
    readonly routeAction?: ComputeUrlMapPathMatcherPathRuleRouteAction;
    /**
     * url_redirect block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#url_redirect ComputeUrlMap#url_redirect}
     */
    readonly urlRedirect?: ComputeUrlMapPathMatcherPathRuleUrlRedirect;
}
export interface ComputeUrlMapPathMatcherRouteRulesHeaderActionRequestHeadersToAdd {
    /**
     * The name of the header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_name ComputeUrlMap#header_name}
     */
    readonly headerName: string;
    /**
     * The value of the header to add.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_value ComputeUrlMap#header_value}
     */
    readonly headerValue: string;
    /**
     * If false, headerValue is appended to any values that already exist for the header.
     *
     * If true, headerValue is set for the header, discarding any values that
     * were set for that header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#replace ComputeUrlMap#replace}
     */
    readonly replace: boolean | cdktf.IResolvable;
}
export interface ComputeUrlMapPathMatcherRouteRulesHeaderActionResponseHeadersToAdd {
    /**
     * The name of the header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_name ComputeUrlMap#header_name}
     */
    readonly headerName: string;
    /**
     * The value of the header to add.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_value ComputeUrlMap#header_value}
     */
    readonly headerValue: string;
    /**
     * If false, headerValue is appended to any values that already exist for the header.
     *
     * If true, headerValue is set for the header, discarding any values that
     * were set for that header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#replace ComputeUrlMap#replace}
     */
    readonly replace: boolean | cdktf.IResolvable;
}
export interface ComputeUrlMapPathMatcherRouteRulesHeaderAction {
    /**
     * A list of header names for headers that need to be removed from the request prior to forwarding the request to the backendService.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#request_headers_to_remove ComputeUrlMap#request_headers_to_remove}
     */
    readonly requestHeadersToRemove?: string[];
    /**
     * A list of header names for headers that need to be removed from the response prior to sending the response back to the client.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#response_headers_to_remove ComputeUrlMap#response_headers_to_remove}
     */
    readonly responseHeadersToRemove?: string[];
    /**
     * request_headers_to_add block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#request_headers_to_add ComputeUrlMap#request_headers_to_add}
     */
    readonly requestHeadersToAdd?: ComputeUrlMapPathMatcherRouteRulesHeaderActionRequestHeadersToAdd[];
    /**
     * response_headers_to_add block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#response_headers_to_add ComputeUrlMap#response_headers_to_add}
     */
    readonly responseHeadersToAdd?: ComputeUrlMapPathMatcherRouteRulesHeaderActionResponseHeadersToAdd[];
}
export declare class ComputeUrlMapPathMatcherRouteRulesHeaderActionOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _requestHeadersToRemove?;
    get requestHeadersToRemove(): string[] | undefined;
    set requestHeadersToRemove(value: string[] | undefined);
    resetRequestHeadersToRemove(): void;
    get requestHeadersToRemoveInput(): string[] | undefined;
    private _responseHeadersToRemove?;
    get responseHeadersToRemove(): string[] | undefined;
    set responseHeadersToRemove(value: string[] | undefined);
    resetResponseHeadersToRemove(): void;
    get responseHeadersToRemoveInput(): string[] | undefined;
    private _requestHeadersToAdd?;
    get requestHeadersToAdd(): ComputeUrlMapPathMatcherRouteRulesHeaderActionRequestHeadersToAdd[] | undefined;
    set requestHeadersToAdd(value: ComputeUrlMapPathMatcherRouteRulesHeaderActionRequestHeadersToAdd[] | undefined);
    resetRequestHeadersToAdd(): void;
    get requestHeadersToAddInput(): ComputeUrlMapPathMatcherRouteRulesHeaderActionRequestHeadersToAdd[] | undefined;
    private _responseHeadersToAdd?;
    get responseHeadersToAdd(): ComputeUrlMapPathMatcherRouteRulesHeaderActionResponseHeadersToAdd[] | undefined;
    set responseHeadersToAdd(value: ComputeUrlMapPathMatcherRouteRulesHeaderActionResponseHeadersToAdd[] | undefined);
    resetResponseHeadersToAdd(): void;
    get responseHeadersToAddInput(): ComputeUrlMapPathMatcherRouteRulesHeaderActionResponseHeadersToAdd[] | undefined;
}
export interface ComputeUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesRangeMatch {
    /**
     * The end of the range (exclusive).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#range_end ComputeUrlMap#range_end}
     */
    readonly rangeEnd: number;
    /**
     * The start of the range (inclusive).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#range_start ComputeUrlMap#range_start}
     */
    readonly rangeStart: number;
}
export declare class ComputeUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesRangeMatchOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _rangeEnd?;
    get rangeEnd(): number;
    set rangeEnd(value: number);
    get rangeEndInput(): number | undefined;
    private _rangeStart?;
    get rangeStart(): number;
    set rangeStart(value: number);
    get rangeStartInput(): number | undefined;
}
export interface ComputeUrlMapPathMatcherRouteRulesMatchRulesHeaderMatches {
    /**
     * The value should exactly match contents of exactMatch.
     *
     * Only one of exactMatch,
     * prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#exact_match ComputeUrlMap#exact_match}
     */
    readonly exactMatch?: string;
    /**
     * The name of the HTTP header to match.
     *
     * For matching against the HTTP request's
     * authority, use a headerMatch with the header name ":authority". For matching a
     * request's method, use the headerName ":method".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_name ComputeUrlMap#header_name}
     */
    readonly headerName: string;
    /**
     * If set to false, the headerMatch is considered a match if the match criteria above are met.
     *
     * If set to true, the headerMatch is considered a match if the
     * match criteria above are NOT met. Defaults to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#invert_match ComputeUrlMap#invert_match}
     */
    readonly invertMatch?: boolean | cdktf.IResolvable;
    /**
     * The value of the header must start with the contents of prefixMatch.
     *
     * Only one of
     * exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch
     * must be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#prefix_match ComputeUrlMap#prefix_match}
     */
    readonly prefixMatch?: string;
    /**
     * A header with the contents of headerName must exist.
     *
     * The match takes place
     * whether or not the request's header has a value or not. Only one of exactMatch,
     * prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch must be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#present_match ComputeUrlMap#present_match}
     */
    readonly presentMatch?: boolean | cdktf.IResolvable;
    /**
     * The value of the header must match the regular expression specified in regexMatch.
     *
     * For regular expression grammar, please see:
     * en.cppreference.com/w/cpp/regex/ecmascript  For matching against a port
     * specified in the HTTP request, use a headerMatch with headerName set to PORT and
     * a regular expression that satisfies the RFC2616 Host header's port specifier.
     * Only one of exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or
     * rangeMatch must be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#regex_match ComputeUrlMap#regex_match}
     */
    readonly regexMatch?: string;
    /**
     * The value of the header must end with the contents of suffixMatch.
     *
     * Only one of
     * exactMatch, prefixMatch, suffixMatch, regexMatch, presentMatch or rangeMatch
     * must be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#suffix_match ComputeUrlMap#suffix_match}
     */
    readonly suffixMatch?: string;
    /**
     * range_match block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#range_match ComputeUrlMap#range_match}
     */
    readonly rangeMatch?: ComputeUrlMapPathMatcherRouteRulesMatchRulesHeaderMatchesRangeMatch;
}
export interface ComputeUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersFilterLabels {
    /**
     * Name of metadata label.
     *
     * The name can have a maximum length of 1024 characters
     * and must be at least 1 character long.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#name ComputeUrlMap#name}
     */
    readonly name: string;
    /**
     * The value of the label must match the specified value. value can have a maximum length of 1024 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#value ComputeUrlMap#value}
     */
    readonly value: string;
}
export interface ComputeUrlMapPathMatcherRouteRulesMatchRulesMetadataFilters {
    /**
     * Specifies how individual filterLabel matches within the list of filterLabels contribute towards the overall metadataFilter match.
     *
     * Supported values are:
     * - MATCH_ANY: At least one of the filterLabels must have a matching label in the
     * provided metadata.
     * - MATCH_ALL: All filterLabels must have matching labels in
     * the provided metadata. Possible values: ["MATCH_ALL", "MATCH_ANY"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#filter_match_criteria ComputeUrlMap#filter_match_criteria}
     */
    readonly filterMatchCriteria: string;
    /**
     * filter_labels block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#filter_labels ComputeUrlMap#filter_labels}
     */
    readonly filterLabels: ComputeUrlMapPathMatcherRouteRulesMatchRulesMetadataFiltersFilterLabels[];
}
export interface ComputeUrlMapPathMatcherRouteRulesMatchRulesQueryParameterMatches {
    /**
     * The queryParameterMatch matches if the value of the parameter exactly matches the contents of exactMatch.
     *
     * Only one of presentMatch, exactMatch and regexMatch
     * must be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#exact_match ComputeUrlMap#exact_match}
     */
    readonly exactMatch?: string;
    /**
     * The name of the query parameter to match.
     *
     * The query parameter must exist in the
     * request, in the absence of which the request match fails.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#name ComputeUrlMap#name}
     */
    readonly name: string;
    /**
     * Specifies that the queryParameterMatch matches if the request contains the query parameter, irrespective of whether the parameter has a value or not.
     *
     * Only one of
     * presentMatch, exactMatch and regexMatch must be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#present_match ComputeUrlMap#present_match}
     */
    readonly presentMatch?: boolean | cdktf.IResolvable;
    /**
     * The queryParameterMatch matches if the value of the parameter matches the regular expression specified by regexMatch.
     *
     * For the regular expression grammar,
     * please see en.cppreference.com/w/cpp/regex/ecmascript  Only one of presentMatch,
     * exactMatch and regexMatch must be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#regex_match ComputeUrlMap#regex_match}
     */
    readonly regexMatch?: string;
}
export interface ComputeUrlMapPathMatcherRouteRulesMatchRules {
    /**
     * For satisfying the matchRule condition, the path of the request must exactly match the value specified in fullPathMatch after removing any query parameters and anchor that may be part of the original URL.
     *
     * FullPathMatch must be between 1
     * and 1024 characters. Only one of prefixMatch, fullPathMatch or regexMatch must
     * be specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#full_path_match ComputeUrlMap#full_path_match}
     */
    readonly fullPathMatch?: string;
    /**
     * Specifies that prefixMatch and fullPathMatch matches are case sensitive. Defaults to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#ignore_case ComputeUrlMap#ignore_case}
     */
    readonly ignoreCase?: boolean | cdktf.IResolvable;
    /**
     * For satisfying the matchRule condition, the request's path must begin with the specified prefixMatch.
     *
     * prefixMatch must begin with a /. The value must be
     * between 1 and 1024 characters. Only one of prefixMatch, fullPathMatch or
     * regexMatch must be specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#prefix_match ComputeUrlMap#prefix_match}
     */
    readonly prefixMatch?: string;
    /**
     * For satisfying the matchRule condition, the path of the request must satisfy the regular expression specified in regexMatch after removing any query parameters and anchor supplied with the original URL.
     *
     * For regular expression grammar please
     * see en.cppreference.com/w/cpp/regex/ecmascript  Only one of prefixMatch,
     * fullPathMatch or regexMatch must be specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#regex_match ComputeUrlMap#regex_match}
     */
    readonly regexMatch?: string;
    /**
     * header_matches block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_matches ComputeUrlMap#header_matches}
     */
    readonly headerMatches?: ComputeUrlMapPathMatcherRouteRulesMatchRulesHeaderMatches[];
    /**
     * metadata_filters block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#metadata_filters ComputeUrlMap#metadata_filters}
     */
    readonly metadataFilters?: ComputeUrlMapPathMatcherRouteRulesMatchRulesMetadataFilters[];
    /**
     * query_parameter_matches block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#query_parameter_matches ComputeUrlMap#query_parameter_matches}
     */
    readonly queryParameterMatches?: ComputeUrlMapPathMatcherRouteRulesMatchRulesQueryParameterMatches[];
}
export interface ComputeUrlMapPathMatcherRouteRulesRouteActionCorsPolicy {
    /**
     * In response to a preflight request, setting this to true indicates that the actual request can include user credentials.
     *
     * This translates to the Access-
     * Control-Allow-Credentials header. Defaults to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#allow_credentials ComputeUrlMap#allow_credentials}
     */
    readonly allowCredentials?: boolean | cdktf.IResolvable;
    /**
     * Specifies the content for the Access-Control-Allow-Headers header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#allow_headers ComputeUrlMap#allow_headers}
     */
    readonly allowHeaders?: string[];
    /**
     * Specifies the content for the Access-Control-Allow-Methods header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#allow_methods ComputeUrlMap#allow_methods}
     */
    readonly allowMethods?: string[];
    /**
     * Specifies the regular expression patterns that match allowed origins.
     *
     * For
     * regular expression grammar please see en.cppreference.com/w/cpp/regex/ecmascript
     * An origin is allowed if it matches either allow_origins or allow_origin_regex.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#allow_origin_regexes ComputeUrlMap#allow_origin_regexes}
     */
    readonly allowOriginRegexes?: string[];
    /**
     * Specifies the list of origins that will be allowed to do CORS requests.
     *
     * An
     * origin is allowed if it matches either allow_origins or allow_origin_regex.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#allow_origins ComputeUrlMap#allow_origins}
     */
    readonly allowOrigins?: string[];
    /**
     * If true, specifies the CORS policy is disabled. which indicates that the CORS policy is in effect. Defaults to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#disabled ComputeUrlMap#disabled}
     */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
     * Specifies the content for the Access-Control-Expose-Headers header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#expose_headers ComputeUrlMap#expose_headers}
     */
    readonly exposeHeaders?: string[];
    /**
     * Specifies how long the results of a preflight request can be cached.
     *
     * This
     * translates to the content for the Access-Control-Max-Age header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#max_age ComputeUrlMap#max_age}
     */
    readonly maxAge?: number;
}
export declare class ComputeUrlMapPathMatcherRouteRulesRouteActionCorsPolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _allowCredentials?;
    get allowCredentials(): boolean | cdktf.IResolvable | undefined;
    set allowCredentials(value: boolean | cdktf.IResolvable | undefined);
    resetAllowCredentials(): void;
    get allowCredentialsInput(): boolean | cdktf.IResolvable | undefined;
    private _allowHeaders?;
    get allowHeaders(): string[] | undefined;
    set allowHeaders(value: string[] | undefined);
    resetAllowHeaders(): void;
    get allowHeadersInput(): string[] | undefined;
    private _allowMethods?;
    get allowMethods(): string[] | undefined;
    set allowMethods(value: string[] | undefined);
    resetAllowMethods(): void;
    get allowMethodsInput(): string[] | undefined;
    private _allowOriginRegexes?;
    get allowOriginRegexes(): string[] | undefined;
    set allowOriginRegexes(value: string[] | undefined);
    resetAllowOriginRegexes(): void;
    get allowOriginRegexesInput(): string[] | undefined;
    private _allowOrigins?;
    get allowOrigins(): string[] | undefined;
    set allowOrigins(value: string[] | undefined);
    resetAllowOrigins(): void;
    get allowOriginsInput(): string[] | undefined;
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable | undefined;
    set disabled(value: boolean | cdktf.IResolvable | undefined);
    resetDisabled(): void;
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _exposeHeaders?;
    get exposeHeaders(): string[] | undefined;
    set exposeHeaders(value: string[] | undefined);
    resetExposeHeaders(): void;
    get exposeHeadersInput(): string[] | undefined;
    private _maxAge?;
    get maxAge(): number | undefined;
    set maxAge(value: number | undefined);
    resetMaxAge(): void;
    get maxAgeInput(): number | undefined;
}
export interface ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyAbort {
    /**
     * The HTTP status code used to abort the request. The value must be between 200 and 599 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#http_status ComputeUrlMap#http_status}
     */
    readonly httpStatus?: number;
    /**
     * The percentage of traffic (connections/operations/requests) which will be aborted as part of fault injection.
     *
     * The value must be between 0.0 and 100.0
     * inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#percentage ComputeUrlMap#percentage}
     */
    readonly percentage?: number;
}
export declare class ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyAbortOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _httpStatus?;
    get httpStatus(): number | undefined;
    set httpStatus(value: number | undefined);
    resetHttpStatus(): void;
    get httpStatusInput(): number | undefined;
    private _percentage?;
    get percentage(): number | undefined;
    set percentage(value: number | undefined);
    resetPercentage(): void;
    get percentageInput(): number | undefined;
}
export interface ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayFixedDelay {
    /**
     * Span of time that's a fraction of a second at nanosecond resolution.
     *
     * Durations
     * less than one second are represented with a 0 'seconds' field and a positive
     * 'nanos' field. Must be from 0 to 999,999,999 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#nanos ComputeUrlMap#nanos}
     */
    readonly nanos?: number;
    /**
     * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#seconds ComputeUrlMap#seconds}
     */
    readonly seconds: string;
}
export declare class ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayFixedDelayOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _nanos?;
    get nanos(): number | undefined;
    set nanos(value: number | undefined);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): string;
    set seconds(value: string);
    get secondsInput(): string | undefined;
}
export interface ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelay {
    /**
     * The percentage of traffic (connections/operations/requests) on which delay will be introduced as part of fault injection.
     *
     * The value must be between 0.0 and
     * 100.0 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#percentage ComputeUrlMap#percentage}
     */
    readonly percentage?: number;
    /**
     * fixed_delay block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#fixed_delay ComputeUrlMap#fixed_delay}
     */
    readonly fixedDelay?: ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayFixedDelay;
}
export declare class ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _percentage?;
    get percentage(): number | undefined;
    set percentage(value: number | undefined);
    resetPercentage(): void;
    get percentageInput(): number | undefined;
    private _fixedDelay?;
    private __fixedDelayOutput;
    get fixedDelay(): ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayFixedDelayOutputReference;
    putFixedDelay(value: ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayFixedDelay | undefined): void;
    resetFixedDelay(): void;
    get fixedDelayInput(): ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayFixedDelay | undefined;
}
export interface ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicy {
    /**
     * abort block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#abort ComputeUrlMap#abort}
     */
    readonly abort?: ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyAbort;
    /**
     * delay block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#delay ComputeUrlMap#delay}
     */
    readonly delay?: ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelay;
}
export declare class ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _abort?;
    private __abortOutput;
    get abort(): ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyAbortOutputReference;
    putAbort(value: ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyAbort | undefined): void;
    resetAbort(): void;
    get abortInput(): ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyAbort | undefined;
    private _delay?;
    private __delayOutput;
    get delay(): ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelayOutputReference;
    putDelay(value: ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelay | undefined): void;
    resetDelay(): void;
    get delayInput(): ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyDelay | undefined;
}
export interface ComputeUrlMapPathMatcherRouteRulesRouteActionRequestMirrorPolicy {
    /**
     * The BackendService resource being mirrored to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#backend_service ComputeUrlMap#backend_service}
     */
    readonly backendService: string;
}
export declare class ComputeUrlMapPathMatcherRouteRulesRouteActionRequestMirrorPolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _backendService?;
    get backendService(): string;
    set backendService(value: string);
    get backendServiceInput(): string | undefined;
}
export interface ComputeUrlMapPathMatcherRouteRulesRouteActionRetryPolicyPerTryTimeout {
    /**
     * Span of time that's a fraction of a second at nanosecond resolution.
     *
     * Durations
     * less than one second are represented with a 0 'seconds' field and a positive
     * 'nanos' field. Must be from 0 to 999,999,999 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#nanos ComputeUrlMap#nanos}
     */
    readonly nanos?: number;
    /**
     * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#seconds ComputeUrlMap#seconds}
     */
    readonly seconds: string;
}
export declare class ComputeUrlMapPathMatcherRouteRulesRouteActionRetryPolicyPerTryTimeoutOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _nanos?;
    get nanos(): number | undefined;
    set nanos(value: number | undefined);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): string;
    set seconds(value: string);
    get secondsInput(): string | undefined;
}
export interface ComputeUrlMapPathMatcherRouteRulesRouteActionRetryPolicy {
    /**
     * Specifies the allowed number retries. This number must be > 0.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#num_retries ComputeUrlMap#num_retries}
     */
    readonly numRetries: number;
    /**
     * Specfies one or more conditions when this retry rule applies. Valid values are:.
     *
     * 5xx: Loadbalancer will attempt a retry if the backend service responds with
     * any 5xx response code, or if the backend service does not respond at all,
     * example: disconnects, reset, read timeout, connection failure, and refused
     * streams.
     * gateway-error: Similar to 5xx, but only applies to response codes
     * 502, 503 or 504.
     * connect-failure: Loadbalancer will retry on failures
     * connecting to backend services, for example due to connection timeouts.
     * retriable-4xx: Loadbalancer will retry for retriable 4xx response codes.
     * Currently the only retriable error supported is 409.
     * refused-stream: Loadbalancer will retry if the backend service resets the stream with a
     * REFUSED_STREAM error code. This reset type indicates that it is safe to retry.
     * cancelled: Loadbalancer will retry if the gRPC status code in the response
     * header is set to cancelled
     * deadline-exceeded: Loadbalancer will retry if the
     * gRPC status code in the response header is set to deadline-exceeded
     * resource-exhausted: Loadbalancer will retry if the gRPC status code in the response
     * header is set to resource-exhausted
     * unavailable: Loadbalancer will retry if the gRPC status code in
     * the response header is set to unavailable
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#retry_conditions ComputeUrlMap#retry_conditions}
     */
    readonly retryConditions?: string[];
    /**
     * per_try_timeout block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#per_try_timeout ComputeUrlMap#per_try_timeout}
     */
    readonly perTryTimeout?: ComputeUrlMapPathMatcherRouteRulesRouteActionRetryPolicyPerTryTimeout;
}
export declare class ComputeUrlMapPathMatcherRouteRulesRouteActionRetryPolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _numRetries?;
    get numRetries(): number;
    set numRetries(value: number);
    get numRetriesInput(): number | undefined;
    private _retryConditions?;
    get retryConditions(): string[] | undefined;
    set retryConditions(value: string[] | undefined);
    resetRetryConditions(): void;
    get retryConditionsInput(): string[] | undefined;
    private _perTryTimeout?;
    private __perTryTimeoutOutput;
    get perTryTimeout(): ComputeUrlMapPathMatcherRouteRulesRouteActionRetryPolicyPerTryTimeoutOutputReference;
    putPerTryTimeout(value: ComputeUrlMapPathMatcherRouteRulesRouteActionRetryPolicyPerTryTimeout | undefined): void;
    resetPerTryTimeout(): void;
    get perTryTimeoutInput(): ComputeUrlMapPathMatcherRouteRulesRouteActionRetryPolicyPerTryTimeout | undefined;
}
export interface ComputeUrlMapPathMatcherRouteRulesRouteActionTimeout {
    /**
     * Span of time that's a fraction of a second at nanosecond resolution.
     *
     * Durations
     * less than one second are represented with a 0 'seconds' field and a positive
     * 'nanos' field. Must be from 0 to 999,999,999 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#nanos ComputeUrlMap#nanos}
     */
    readonly nanos?: number;
    /**
     * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#seconds ComputeUrlMap#seconds}
     */
    readonly seconds: string;
}
export declare class ComputeUrlMapPathMatcherRouteRulesRouteActionTimeoutOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _nanos?;
    get nanos(): number | undefined;
    set nanos(value: number | undefined);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): string;
    set seconds(value: string);
    get secondsInput(): string | undefined;
}
export interface ComputeUrlMapPathMatcherRouteRulesRouteActionUrlRewrite {
    /**
     * Prior to forwarding the request to the selected service, the request's host header is replaced with contents of hostRewrite.
     *
     * The value must be between 1 and
     * 255 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#host_rewrite ComputeUrlMap#host_rewrite}
     */
    readonly hostRewrite?: string;
    /**
     * Prior to forwarding the request to the selected backend service, the matching portion of the request's path is replaced by pathPrefixRewrite.
     *
     * The value must
     * be between 1 and 1024 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#path_prefix_rewrite ComputeUrlMap#path_prefix_rewrite}
     */
    readonly pathPrefixRewrite?: string;
}
export declare class ComputeUrlMapPathMatcherRouteRulesRouteActionUrlRewriteOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _hostRewrite?;
    get hostRewrite(): string | undefined;
    set hostRewrite(value: string | undefined);
    resetHostRewrite(): void;
    get hostRewriteInput(): string | undefined;
    private _pathPrefixRewrite?;
    get pathPrefixRewrite(): string | undefined;
    set pathPrefixRewrite(value: string | undefined);
    resetPathPrefixRewrite(): void;
    get pathPrefixRewriteInput(): string | undefined;
}
export interface ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd {
    /**
     * The name of the header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_name ComputeUrlMap#header_name}
     */
    readonly headerName: string;
    /**
     * The value of the header to add.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_value ComputeUrlMap#header_value}
     */
    readonly headerValue: string;
    /**
     * If false, headerValue is appended to any values that already exist for the header.
     *
     * If true, headerValue is set for the header, discarding any values that
     * were set for that header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#replace ComputeUrlMap#replace}
     */
    readonly replace: boolean | cdktf.IResolvable;
}
export interface ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd {
    /**
     * The name of the header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_name ComputeUrlMap#header_name}
     */
    readonly headerName: string;
    /**
     * The value of the header to add.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_value ComputeUrlMap#header_value}
     */
    readonly headerValue: string;
    /**
     * If false, headerValue is appended to any values that already exist for the header.
     *
     * If true, headerValue is set for the header, discarding any values that
     * were set for that header.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#replace ComputeUrlMap#replace}
     */
    readonly replace: boolean | cdktf.IResolvable;
}
export interface ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderAction {
    /**
     * A list of header names for headers that need to be removed from the request prior to forwarding the request to the backendService.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#request_headers_to_remove ComputeUrlMap#request_headers_to_remove}
     */
    readonly requestHeadersToRemove?: string[];
    /**
     * A list of header names for headers that need to be removed from the response prior to sending the response back to the client.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#response_headers_to_remove ComputeUrlMap#response_headers_to_remove}
     */
    readonly responseHeadersToRemove?: string[];
    /**
     * request_headers_to_add block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#request_headers_to_add ComputeUrlMap#request_headers_to_add}
     */
    readonly requestHeadersToAdd?: ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[];
    /**
     * response_headers_to_add block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#response_headers_to_add ComputeUrlMap#response_headers_to_add}
     */
    readonly responseHeadersToAdd?: ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[];
}
export declare class ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _requestHeadersToRemove?;
    get requestHeadersToRemove(): string[] | undefined;
    set requestHeadersToRemove(value: string[] | undefined);
    resetRequestHeadersToRemove(): void;
    get requestHeadersToRemoveInput(): string[] | undefined;
    private _responseHeadersToRemove?;
    get responseHeadersToRemove(): string[] | undefined;
    set responseHeadersToRemove(value: string[] | undefined);
    resetResponseHeadersToRemove(): void;
    get responseHeadersToRemoveInput(): string[] | undefined;
    private _requestHeadersToAdd?;
    get requestHeadersToAdd(): ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[] | undefined;
    set requestHeadersToAdd(value: ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[] | undefined);
    resetRequestHeadersToAdd(): void;
    get requestHeadersToAddInput(): ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionRequestHeadersToAdd[] | undefined;
    private _responseHeadersToAdd?;
    get responseHeadersToAdd(): ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[] | undefined;
    set responseHeadersToAdd(value: ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[] | undefined);
    resetResponseHeadersToAdd(): void;
    get responseHeadersToAddInput(): ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderActionResponseHeadersToAdd[] | undefined;
}
export interface ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServices {
    /**
     * The default BackendService resource.
     *
     * Before
     * forwarding the request to backendService, the loadbalancer applies any relevant
     * headerActions specified as part of this backendServiceWeight.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#backend_service ComputeUrlMap#backend_service}
     */
    readonly backendService: string;
    /**
     * Specifies the fraction of traffic sent to backendService, computed as weight / (sum of all weightedBackendService weights in routeAction) .
     *
     * The selection of a
     * backend service is determined only for new traffic. Once a user's request has
     * been directed to a backendService, subsequent requests will be sent to the same
     * backendService as determined by the BackendService's session affinity policy.
     * The value must be between 0 and 1000
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#weight ComputeUrlMap#weight}
     */
    readonly weight: number;
    /**
     * header_action block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_action ComputeUrlMap#header_action}
     */
    readonly headerAction?: ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServicesHeaderAction;
}
export interface ComputeUrlMapPathMatcherRouteRulesRouteAction {
    /**
     * cors_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#cors_policy ComputeUrlMap#cors_policy}
     */
    readonly corsPolicy?: ComputeUrlMapPathMatcherRouteRulesRouteActionCorsPolicy;
    /**
     * fault_injection_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#fault_injection_policy ComputeUrlMap#fault_injection_policy}
     */
    readonly faultInjectionPolicy?: ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicy;
    /**
     * request_mirror_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#request_mirror_policy ComputeUrlMap#request_mirror_policy}
     */
    readonly requestMirrorPolicy?: ComputeUrlMapPathMatcherRouteRulesRouteActionRequestMirrorPolicy;
    /**
     * retry_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#retry_policy ComputeUrlMap#retry_policy}
     */
    readonly retryPolicy?: ComputeUrlMapPathMatcherRouteRulesRouteActionRetryPolicy;
    /**
     * timeout block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#timeout ComputeUrlMap#timeout}
     */
    readonly timeout?: ComputeUrlMapPathMatcherRouteRulesRouteActionTimeout;
    /**
     * url_rewrite block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#url_rewrite ComputeUrlMap#url_rewrite}
     */
    readonly urlRewrite?: ComputeUrlMapPathMatcherRouteRulesRouteActionUrlRewrite;
    /**
     * weighted_backend_services block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#weighted_backend_services ComputeUrlMap#weighted_backend_services}
     */
    readonly weightedBackendServices?: ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServices[];
}
export declare class ComputeUrlMapPathMatcherRouteRulesRouteActionOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _corsPolicy?;
    private __corsPolicyOutput;
    get corsPolicy(): ComputeUrlMapPathMatcherRouteRulesRouteActionCorsPolicyOutputReference;
    putCorsPolicy(value: ComputeUrlMapPathMatcherRouteRulesRouteActionCorsPolicy | undefined): void;
    resetCorsPolicy(): void;
    get corsPolicyInput(): ComputeUrlMapPathMatcherRouteRulesRouteActionCorsPolicy | undefined;
    private _faultInjectionPolicy?;
    private __faultInjectionPolicyOutput;
    get faultInjectionPolicy(): ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicyOutputReference;
    putFaultInjectionPolicy(value: ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicy | undefined): void;
    resetFaultInjectionPolicy(): void;
    get faultInjectionPolicyInput(): ComputeUrlMapPathMatcherRouteRulesRouteActionFaultInjectionPolicy | undefined;
    private _requestMirrorPolicy?;
    private __requestMirrorPolicyOutput;
    get requestMirrorPolicy(): ComputeUrlMapPathMatcherRouteRulesRouteActionRequestMirrorPolicyOutputReference;
    putRequestMirrorPolicy(value: ComputeUrlMapPathMatcherRouteRulesRouteActionRequestMirrorPolicy | undefined): void;
    resetRequestMirrorPolicy(): void;
    get requestMirrorPolicyInput(): ComputeUrlMapPathMatcherRouteRulesRouteActionRequestMirrorPolicy | undefined;
    private _retryPolicy?;
    private __retryPolicyOutput;
    get retryPolicy(): ComputeUrlMapPathMatcherRouteRulesRouteActionRetryPolicyOutputReference;
    putRetryPolicy(value: ComputeUrlMapPathMatcherRouteRulesRouteActionRetryPolicy | undefined): void;
    resetRetryPolicy(): void;
    get retryPolicyInput(): ComputeUrlMapPathMatcherRouteRulesRouteActionRetryPolicy | undefined;
    private _timeout?;
    private __timeoutOutput;
    get timeout(): ComputeUrlMapPathMatcherRouteRulesRouteActionTimeoutOutputReference;
    putTimeout(value: ComputeUrlMapPathMatcherRouteRulesRouteActionTimeout | undefined): void;
    resetTimeout(): void;
    get timeoutInput(): ComputeUrlMapPathMatcherRouteRulesRouteActionTimeout | undefined;
    private _urlRewrite?;
    private __urlRewriteOutput;
    get urlRewrite(): ComputeUrlMapPathMatcherRouteRulesRouteActionUrlRewriteOutputReference;
    putUrlRewrite(value: ComputeUrlMapPathMatcherRouteRulesRouteActionUrlRewrite | undefined): void;
    resetUrlRewrite(): void;
    get urlRewriteInput(): ComputeUrlMapPathMatcherRouteRulesRouteActionUrlRewrite | undefined;
    private _weightedBackendServices?;
    get weightedBackendServices(): ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServices[] | undefined;
    set weightedBackendServices(value: ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServices[] | undefined);
    resetWeightedBackendServices(): void;
    get weightedBackendServicesInput(): ComputeUrlMapPathMatcherRouteRulesRouteActionWeightedBackendServices[] | undefined;
}
export interface ComputeUrlMapPathMatcherRouteRulesUrlRedirect {
    /**
     * The host that will be used in the redirect response instead of the one that was supplied in the request.
     *
     * The value must be between 1 and 255 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#host_redirect ComputeUrlMap#host_redirect}
     */
    readonly hostRedirect?: string;
    /**
     * If set to true, the URL scheme in the redirected request is set to https.
     *
     * If set
     * to false, the URL scheme of the redirected request will remain the same as that
     * of the request. This must only be set for UrlMaps used in TargetHttpProxys.
     * Setting this true for TargetHttpsProxy is not permitted. Defaults to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#https_redirect ComputeUrlMap#https_redirect}
     */
    readonly httpsRedirect?: boolean | cdktf.IResolvable;
    /**
     * The path that will be used in the redirect response instead of the one that was supplied in the request.
     *
     * Only one of pathRedirect or prefixRedirect must be
     * specified. The value must be between 1 and 1024 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#path_redirect ComputeUrlMap#path_redirect}
     */
    readonly pathRedirect?: string;
    /**
     * The prefix that replaces the prefixMatch specified in the HttpRouteRuleMatch, retaining the remaining portion of the URL before redirecting the request.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#prefix_redirect ComputeUrlMap#prefix_redirect}
     */
    readonly prefixRedirect?: string;
    /**
     * The HTTP Status code to use for this RedirectAction. Supported values are:.
     *
     * MOVED_PERMANENTLY_DEFAULT, which is the default value and corresponds to 301.
     *
     * FOUND, which corresponds to 302.
     *
     * SEE_OTHER which corresponds to 303.
     *
     * TEMPORARY_REDIRECT, which corresponds to 307. In this case, the request method will be retained.
     *
     * PERMANENT_REDIRECT, which corresponds to 308. In this case, the request method will be retained. Possible values: ["FOUND", "MOVED_PERMANENTLY_DEFAULT", "PERMANENT_REDIRECT", "SEE_OTHER", "TEMPORARY_REDIRECT"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#redirect_response_code ComputeUrlMap#redirect_response_code}
     */
    readonly redirectResponseCode?: string;
    /**
     * If set to true, any accompanying query portion of the original URL is removed prior to redirecting the request.
     *
     * If set to false, the query portion of the
     * original URL is retained. Defaults to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#strip_query ComputeUrlMap#strip_query}
     */
    readonly stripQuery?: boolean | cdktf.IResolvable;
}
export declare class ComputeUrlMapPathMatcherRouteRulesUrlRedirectOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _hostRedirect?;
    get hostRedirect(): string | undefined;
    set hostRedirect(value: string | undefined);
    resetHostRedirect(): void;
    get hostRedirectInput(): string | undefined;
    private _httpsRedirect?;
    get httpsRedirect(): boolean | cdktf.IResolvable | undefined;
    set httpsRedirect(value: boolean | cdktf.IResolvable | undefined);
    resetHttpsRedirect(): void;
    get httpsRedirectInput(): boolean | cdktf.IResolvable | undefined;
    private _pathRedirect?;
    get pathRedirect(): string | undefined;
    set pathRedirect(value: string | undefined);
    resetPathRedirect(): void;
    get pathRedirectInput(): string | undefined;
    private _prefixRedirect?;
    get prefixRedirect(): string | undefined;
    set prefixRedirect(value: string | undefined);
    resetPrefixRedirect(): void;
    get prefixRedirectInput(): string | undefined;
    private _redirectResponseCode?;
    get redirectResponseCode(): string | undefined;
    set redirectResponseCode(value: string | undefined);
    resetRedirectResponseCode(): void;
    get redirectResponseCodeInput(): string | undefined;
    private _stripQuery?;
    get stripQuery(): boolean | cdktf.IResolvable | undefined;
    set stripQuery(value: boolean | cdktf.IResolvable | undefined);
    resetStripQuery(): void;
    get stripQueryInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ComputeUrlMapPathMatcherRouteRules {
    /**
     * For routeRules within a given pathMatcher, priority determines the order in which load balancer will interpret routeRules.
     *
     * RouteRules are evaluated
     * in order of priority, from the lowest to highest number. The priority of
     * a rule decreases as its number increases (1, 2, 3, N+1). The first rule
     * that matches the request is applied.
     *
     * You cannot configure two or more routeRules with the same priority.
     * Priority for each rule must be set to a number between 0 and
     * 2147483647 inclusive.
     *
     * Priority numbers can have gaps, which enable you to add or remove rules
     * in the future without affecting the rest of the rules. For example,
     * 1, 2, 3, 4, 5, 9, 12, 16 is a valid series of priority numbers to which
     * you could add rules numbered from 6 to 8, 10 to 11, and 13 to 15 in the
     * future without any impact on existing rules.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#priority ComputeUrlMap#priority}
     */
    readonly priority: number;
    /**
     * The backend service resource to which traffic is directed if this rule is matched.
     *
     * If routeAction is additionally specified,
     * advanced routing actions like URL Rewrites, etc. take effect prior to sending
     * the request to the backend. However, if service is specified, routeAction cannot
     * contain any weightedBackendService s. Conversely, if routeAction specifies any
     * weightedBackendServices, service must not be specified. Only one of urlRedirect,
     * service or routeAction.weightedBackendService must be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#service ComputeUrlMap#service}
     */
    readonly service?: string;
    /**
     * header_action block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_action ComputeUrlMap#header_action}
     */
    readonly headerAction?: ComputeUrlMapPathMatcherRouteRulesHeaderAction;
    /**
     * match_rules block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#match_rules ComputeUrlMap#match_rules}
     */
    readonly matchRules?: ComputeUrlMapPathMatcherRouteRulesMatchRules[];
    /**
     * route_action block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#route_action ComputeUrlMap#route_action}
     */
    readonly routeAction?: ComputeUrlMapPathMatcherRouteRulesRouteAction;
    /**
     * url_redirect block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#url_redirect ComputeUrlMap#url_redirect}
     */
    readonly urlRedirect?: ComputeUrlMapPathMatcherRouteRulesUrlRedirect;
}
export interface ComputeUrlMapPathMatcher {
    /**
     * The backend service or backend bucket to use when none of the given paths match.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#default_service ComputeUrlMap#default_service}
     */
    readonly defaultService?: string;
    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#description ComputeUrlMap#description}
     */
    readonly description?: string;
    /**
     * The name to which this PathMatcher is referred by the HostRule.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#name ComputeUrlMap#name}
     */
    readonly name: string;
    /**
     * default_route_action block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#default_route_action ComputeUrlMap#default_route_action}
     */
    readonly defaultRouteAction?: ComputeUrlMapPathMatcherDefaultRouteAction;
    /**
     * default_url_redirect block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#default_url_redirect ComputeUrlMap#default_url_redirect}
     */
    readonly defaultUrlRedirect?: ComputeUrlMapPathMatcherDefaultUrlRedirect;
    /**
     * header_action block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#header_action ComputeUrlMap#header_action}
     */
    readonly headerAction?: ComputeUrlMapPathMatcherHeaderAction;
    /**
     * path_rule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#path_rule ComputeUrlMap#path_rule}
     */
    readonly pathRule?: ComputeUrlMapPathMatcherPathRule[];
    /**
     * route_rules block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#route_rules ComputeUrlMap#route_rules}
     */
    readonly routeRules?: ComputeUrlMapPathMatcherRouteRules[];
}
export interface ComputeUrlMapTest {
    /**
     * Description of this test case.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#description ComputeUrlMap#description}
     */
    readonly description?: string;
    /**
     * Host portion of the URL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#host ComputeUrlMap#host}
     */
    readonly host: string;
    /**
     * Path portion of the URL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#path ComputeUrlMap#path}
     */
    readonly path: string;
    /**
     * The backend service or backend bucket link that should be matched by this test.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#service ComputeUrlMap#service}
     */
    readonly service: string;
}
export interface ComputeUrlMapTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#create ComputeUrlMap#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#delete ComputeUrlMap#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html#update ComputeUrlMap#update}.
     */
    readonly update?: string;
}
export declare class ComputeUrlMapTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html google_compute_url_map}.
 */
export declare class ComputeUrlMap extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_url_map.html google_compute_url_map} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: ComputeUrlMapConfig);
    get creationTimestamp(): string;
    private _defaultService?;
    get defaultService(): string | undefined;
    set defaultService(value: string | undefined);
    resetDefaultService(): void;
    get defaultServiceInput(): string | undefined;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get fingerprint(): string;
    get id(): string;
    get mapId(): number;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    private _defaultRouteAction?;
    private __defaultRouteActionOutput;
    get defaultRouteAction(): ComputeUrlMapDefaultRouteActionOutputReference;
    putDefaultRouteAction(value: ComputeUrlMapDefaultRouteAction | undefined): void;
    resetDefaultRouteAction(): void;
    get defaultRouteActionInput(): ComputeUrlMapDefaultRouteAction | undefined;
    private _defaultUrlRedirect?;
    private __defaultUrlRedirectOutput;
    get defaultUrlRedirect(): ComputeUrlMapDefaultUrlRedirectOutputReference;
    putDefaultUrlRedirect(value: ComputeUrlMapDefaultUrlRedirect | undefined): void;
    resetDefaultUrlRedirect(): void;
    get defaultUrlRedirectInput(): ComputeUrlMapDefaultUrlRedirect | undefined;
    private _headerAction?;
    private __headerActionOutput;
    get headerAction(): ComputeUrlMapHeaderActionOutputReference;
    putHeaderAction(value: ComputeUrlMapHeaderAction | undefined): void;
    resetHeaderAction(): void;
    get headerActionInput(): ComputeUrlMapHeaderAction | undefined;
    private _hostRule?;
    get hostRule(): ComputeUrlMapHostRule[] | undefined;
    set hostRule(value: ComputeUrlMapHostRule[] | undefined);
    resetHostRule(): void;
    get hostRuleInput(): ComputeUrlMapHostRule[] | undefined;
    private _pathMatcher?;
    get pathMatcher(): ComputeUrlMapPathMatcher[] | undefined;
    set pathMatcher(value: ComputeUrlMapPathMatcher[] | undefined);
    resetPathMatcher(): void;
    get pathMatcherInput(): ComputeUrlMapPathMatcher[] | undefined;
    private _test?;
    get test(): ComputeUrlMapTest[] | undefined;
    set test(value: ComputeUrlMapTest[] | undefined);
    resetTest(): void;
    get testInput(): ComputeUrlMapTest[] | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): ComputeUrlMapTimeoutsOutputReference;
    putTimeouts(value: ComputeUrlMapTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeUrlMapTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
