import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeTargetTcpProxyConfig extends cdktf.TerraformMetaArguments {
    /**
     * A reference to the BackendService resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_tcp_proxy.html#backend_service ComputeTargetTcpProxy#backend_service}
     */
    readonly backendService: string;
    /**
     * An optional description of this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_tcp_proxy.html#description ComputeTargetTcpProxy#description}
     */
    readonly description?: string;
    /**
     * Name of the resource.
     *
     * Provided by the client when the resource is
     * created. The name must be 1-63 characters long, and comply with
     * RFC1035. Specifically, the name must be 1-63 characters long and match
     * the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
     * first character must be a lowercase letter, and all following
     * characters must be a dash, lowercase letter, or digit, except the last
     * character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_tcp_proxy.html#name ComputeTargetTcpProxy#name}
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_tcp_proxy.html#project ComputeTargetTcpProxy#project}.
     */
    readonly project?: string;
    /**
     * This field only applies when the forwarding rule that references this target proxy has a loadBalancingScheme set to INTERNAL_SELF_MANAGED.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_tcp_proxy.html#proxy_bind ComputeTargetTcpProxy#proxy_bind}
     */
    readonly proxyBind?: boolean | cdktf.IResolvable;
    /**
     * Specifies the type of proxy header to append before sending data to the backend.
     *
     * Default value: "NONE" Possible values: ["NONE", "PROXY_V1"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_tcp_proxy.html#proxy_header ComputeTargetTcpProxy#proxy_header}
     */
    readonly proxyHeader?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_tcp_proxy.html#timeouts ComputeTargetTcpProxy#timeouts}
     */
    readonly timeouts?: ComputeTargetTcpProxyTimeouts;
}
export interface ComputeTargetTcpProxyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_tcp_proxy.html#create ComputeTargetTcpProxy#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_tcp_proxy.html#delete ComputeTargetTcpProxy#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_tcp_proxy.html#update ComputeTargetTcpProxy#update}.
     */
    readonly update?: string;
}
export declare class ComputeTargetTcpProxyTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_target_tcp_proxy.html google_compute_target_tcp_proxy}.
 */
export declare class ComputeTargetTcpProxy extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_target_tcp_proxy.html google_compute_target_tcp_proxy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: ComputeTargetTcpProxyConfig);
    private _backendService?;
    get backendService(): string;
    set backendService(value: string);
    get backendServiceInput(): string | undefined;
    get creationTimestamp(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _proxyBind?;
    get proxyBind(): boolean | cdktf.IResolvable | undefined;
    set proxyBind(value: boolean | cdktf.IResolvable | undefined);
    resetProxyBind(): void;
    get proxyBindInput(): boolean | cdktf.IResolvable | undefined;
    private _proxyHeader?;
    get proxyHeader(): string | undefined;
    set proxyHeader(value: string | undefined);
    resetProxyHeader(): void;
    get proxyHeaderInput(): string | undefined;
    get proxyId(): number;
    get selfLink(): string;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): ComputeTargetTcpProxyTimeoutsOutputReference;
    putTimeouts(value: ComputeTargetTcpProxyTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeTargetTcpProxyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
