import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeTargetSslProxyConfig extends cdktf.TerraformMetaArguments {
    /**
     * A reference to the BackendService resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_ssl_proxy.html#backend_service ComputeTargetSslProxy#backend_service}
     */
    readonly backendService: string;
    /**
     * An optional description of this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_ssl_proxy.html#description ComputeTargetSslProxy#description}
     */
    readonly description?: string;
    /**
     * Name of the resource.
     *
     * Provided by the client when the resource is
     * created. The name must be 1-63 characters long, and comply with
     * RFC1035. Specifically, the name must be 1-63 characters long and match
     * the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
     * first character must be a lowercase letter, and all following
     * characters must be a dash, lowercase letter, or digit, except the last
     * character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_ssl_proxy.html#name ComputeTargetSslProxy#name}
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_ssl_proxy.html#project ComputeTargetSslProxy#project}.
     */
    readonly project?: string;
    /**
     * Specifies the type of proxy header to append before sending data to the backend.
     *
     * Default value: "NONE" Possible values: ["NONE", "PROXY_V1"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_ssl_proxy.html#proxy_header ComputeTargetSslProxy#proxy_header}
     */
    readonly proxyHeader?: string;
    /**
     * A list of SslCertificate resources that are used to authenticate connections between users and the load balancer.
     *
     * At least one
     * SSL certificate must be specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_ssl_proxy.html#ssl_certificates ComputeTargetSslProxy#ssl_certificates}
     */
    readonly sslCertificates: string[];
    /**
     * A reference to the SslPolicy resource that will be associated with the TargetSslProxy resource.
     *
     * If not set, the TargetSslProxy
     * resource will not have any SSL policy configured.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_ssl_proxy.html#ssl_policy ComputeTargetSslProxy#ssl_policy}
     */
    readonly sslPolicy?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_ssl_proxy.html#timeouts ComputeTargetSslProxy#timeouts}
     */
    readonly timeouts?: ComputeTargetSslProxyTimeouts;
}
export interface ComputeTargetSslProxyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_ssl_proxy.html#create ComputeTargetSslProxy#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_ssl_proxy.html#delete ComputeTargetSslProxy#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_ssl_proxy.html#update ComputeTargetSslProxy#update}.
     */
    readonly update?: string;
}
export declare class ComputeTargetSslProxyTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_target_ssl_proxy.html google_compute_target_ssl_proxy}.
 */
export declare class ComputeTargetSslProxy extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_target_ssl_proxy.html google_compute_target_ssl_proxy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: ComputeTargetSslProxyConfig);
    private _backendService?;
    get backendService(): string;
    set backendService(value: string);
    get backendServiceInput(): string | undefined;
    get creationTimestamp(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _proxyHeader?;
    get proxyHeader(): string | undefined;
    set proxyHeader(value: string | undefined);
    resetProxyHeader(): void;
    get proxyHeaderInput(): string | undefined;
    get proxyId(): number;
    get selfLink(): string;
    private _sslCertificates?;
    get sslCertificates(): string[];
    set sslCertificates(value: string[]);
    get sslCertificatesInput(): string[] | undefined;
    private _sslPolicy?;
    get sslPolicy(): string | undefined;
    set sslPolicy(value: string | undefined);
    resetSslPolicy(): void;
    get sslPolicyInput(): string | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): ComputeTargetSslProxyTimeoutsOutputReference;
    putTimeouts(value: ComputeTargetSslProxyTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeTargetSslProxyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
