import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeSubnetworkConfig extends cdktf.TerraformMetaArguments {
    /**
     * An optional description of this resource.
     *
     * Provide this property when
     * you create the resource. This field can be set only at resource
     * creation time.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork.html#description ComputeSubnetwork#description}
     */
    readonly description?: string;
    /**
     * The range of internal addresses that are owned by this subnetwork.
     *
     * Provide this property when you create the subnetwork. For example,
     * 10.0.0.0/8 or 192.168.0.0/16. Ranges must be unique and
     * non-overlapping within a network. Only IPv4 is supported.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork.html#ip_cidr_range ComputeSubnetwork#ip_cidr_range}
     */
    readonly ipCidrRange: string;
    /**
     * The access type of IPv6 address this subnet holds.
     *
     * It's immutable and can only be specified during creation
     * or the first time the subnet is updated into IPV4_IPV6 dual stack. If the ipv6_type is EXTERNAL then this subnet
     * cannot enable direct path. Possible values: ["EXTERNAL"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork.html#ipv6_access_type ComputeSubnetwork#ipv6_access_type}
     */
    readonly ipv6AccessType?: string;
    /**
     * The name of the resource, provided by the client when initially creating the resource.
     *
     * The name must be 1-63 characters long, and
     * comply with RFC1035. Specifically, the name must be 1-63 characters
     * long and match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which
     * means the first character must be a lowercase letter, and all
     * following characters must be a dash, lowercase letter, or digit,
     * except the last character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork.html#name ComputeSubnetwork#name}
     */
    readonly name: string;
    /**
     * The network this subnet belongs to. Only networks that are in the distributed mode can have subnetworks.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork.html#network ComputeSubnetwork#network}
     */
    readonly network: string;
    /**
     * When enabled, VMs in this subnetwork without external IP addresses can access Google APIs and services by using Private Google Access.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork.html#private_ip_google_access ComputeSubnetwork#private_ip_google_access}
     */
    readonly privateIpGoogleAccess?: boolean | cdktf.IResolvable;
    /**
     * The private IPv6 google access type for the VMs in this subnet.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork.html#private_ipv6_google_access ComputeSubnetwork#private_ipv6_google_access}
     */
    readonly privateIpv6GoogleAccess?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork.html#project ComputeSubnetwork#project}.
     */
    readonly project?: string;
    /**
     * The purpose of the resource.
     *
     * This field can be either PRIVATE
     * or INTERNAL_HTTPS_LOAD_BALANCER. A subnetwork with purpose set to
     * INTERNAL_HTTPS_LOAD_BALANCER is a user-created subnetwork that is
     * reserved for Internal HTTP(S) Load Balancing. If unspecified, the
     * purpose defaults to PRIVATE.
     *
     * If set to INTERNAL_HTTPS_LOAD_BALANCER you must also set 'role'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork.html#purpose ComputeSubnetwork#purpose}
     */
    readonly purpose?: string;
    /**
     * The GCP region for this subnetwork.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork.html#region ComputeSubnetwork#region}
     */
    readonly region?: string;
    /**
     * The role of subnetwork.
     *
     * Currently, this field is only used when
     * purpose = INTERNAL_HTTPS_LOAD_BALANCER. The value can be set to ACTIVE
     * or BACKUP. An ACTIVE subnetwork is one that is currently being used
     * for Internal HTTP(S) Load Balancing. A BACKUP subnetwork is one that
     * is ready to be promoted to ACTIVE or is currently draining. Possible values: ["ACTIVE", "BACKUP"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork.html#role ComputeSubnetwork#role}
     */
    readonly role?: string;
    /**
     * An array of configurations for secondary IP ranges for VM instances contained in this subnetwork.
     *
     * The primary IP of such VM must belong
     * to the primary ipCidrRange of the subnetwork. The alias IPs may belong
     * to either primary or secondary ranges.
     *
     * *Note**: This field uses [attr-as-block mode](https://www.terraform.io/docs/configuration/attr-as-blocks.html) to avoid
     * breaking users during the 0.12 upgrade. To explicitly send a list
     * of zero objects you must use the following syntax:
     * 'example=[]'
     * For more details about this behavior, see [this section](https://www.terraform.io/docs/configuration/attr-as-blocks.html#defining-a-fixed-object-collection-value).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork.html#secondary_ip_range ComputeSubnetwork#secondary_ip_range}
     */
    readonly secondaryIpRange?: ComputeSubnetworkSecondaryIpRange[];
    /**
     * The stack type for this subnet to identify whether the IPv6 feature is enabled or not.
     *
     * If not specified IPV4_ONLY will be used. Possible values: ["IPV4_ONLY", "IPV4_IPV6"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork.html#stack_type ComputeSubnetwork#stack_type}
     */
    readonly stackType?: string;
    /**
     * log_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork.html#log_config ComputeSubnetwork#log_config}
     */
    readonly logConfig?: ComputeSubnetworkLogConfig;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork.html#timeouts ComputeSubnetwork#timeouts}
     */
    readonly timeouts?: ComputeSubnetworkTimeouts;
}
export interface ComputeSubnetworkSecondaryIpRange {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork.html#ip_cidr_range ComputeSubnetwork#ip_cidr_range}.
     */
    readonly ipCidrRange?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork.html#range_name ComputeSubnetwork#range_name}.
     */
    readonly rangeName?: string;
}
export interface ComputeSubnetworkLogConfig {
    /**
     * Can only be specified if VPC flow logging for this subnetwork is enabled.
     *
     * Toggles the aggregation interval for collecting flow logs. Increasing the
     * interval time will reduce the amount of generated flow logs for long
     * lasting connections. Default is an interval of 5 seconds per connection. Default value: "INTERVAL_5_SEC" Possible values: ["INTERVAL_5_SEC", "INTERVAL_30_SEC", "INTERVAL_1_MIN", "INTERVAL_5_MIN", "INTERVAL_10_MIN", "INTERVAL_15_MIN"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork.html#aggregation_interval ComputeSubnetwork#aggregation_interval}
     */
    readonly aggregationInterval?: string;
    /**
     * Export filter used to define which VPC flow logs should be logged, as as CEL expression.
     *
     * See
     * https://cloud.google.com/vpc/docs/flow-logs#filtering for details on how to format this field.
     * The default value is 'true', which evaluates to include everything.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork.html#filter_expr ComputeSubnetwork#filter_expr}
     */
    readonly filterExpr?: string;
    /**
     * Can only be specified if VPC flow logging for this subnetwork is enabled.
     *
     * The value of the field must be in [0, 1]. Set the sampling rate of VPC
     * flow logs within the subnetwork where 1.0 means all collected logs are
     * reported and 0.0 means no logs are reported. Default is 0.5 which means
     * half of all collected logs are reported.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork.html#flow_sampling ComputeSubnetwork#flow_sampling}
     */
    readonly flowSampling?: number;
    /**
     * Can only be specified if VPC flow logging for this subnetwork is enabled.
     *
     * Configures whether metadata fields should be added to the reported VPC
     * flow logs. Default value: "INCLUDE_ALL_METADATA" Possible values: ["EXCLUDE_ALL_METADATA", "INCLUDE_ALL_METADATA", "CUSTOM_METADATA"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork.html#metadata ComputeSubnetwork#metadata}
     */
    readonly metadata?: string;
    /**
     * List of metadata fields that should be added to reported logs.
     *
     * Can only be specified if VPC flow logs for this subnetwork is enabled and "metadata" is set to CUSTOM_METADATA.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork.html#metadata_fields ComputeSubnetwork#metadata_fields}
     */
    readonly metadataFields?: string[];
}
export declare class ComputeSubnetworkLogConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aggregationInterval?;
    get aggregationInterval(): string | undefined;
    set aggregationInterval(value: string | undefined);
    resetAggregationInterval(): void;
    get aggregationIntervalInput(): string | undefined;
    private _filterExpr?;
    get filterExpr(): string | undefined;
    set filterExpr(value: string | undefined);
    resetFilterExpr(): void;
    get filterExprInput(): string | undefined;
    private _flowSampling?;
    get flowSampling(): number | undefined;
    set flowSampling(value: number | undefined);
    resetFlowSampling(): void;
    get flowSamplingInput(): number | undefined;
    private _metadata?;
    get metadata(): string | undefined;
    set metadata(value: string | undefined);
    resetMetadata(): void;
    get metadataInput(): string | undefined;
    private _metadataFields?;
    get metadataFields(): string[] | undefined;
    set metadataFields(value: string[] | undefined);
    resetMetadataFields(): void;
    get metadataFieldsInput(): string[] | undefined;
}
export interface ComputeSubnetworkTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork.html#create ComputeSubnetwork#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork.html#delete ComputeSubnetwork#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork.html#update ComputeSubnetwork#update}.
     */
    readonly update?: string;
}
export declare class ComputeSubnetworkTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork.html google_compute_subnetwork}.
 */
export declare class ComputeSubnetwork extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork.html google_compute_subnetwork} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: ComputeSubnetworkConfig);
    get creationTimestamp(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get externalIpv6Prefix(): string;
    get fingerprint(): string;
    get gatewayAddress(): string;
    get id(): string;
    private _ipCidrRange?;
    get ipCidrRange(): string;
    set ipCidrRange(value: string);
    get ipCidrRangeInput(): string | undefined;
    private _ipv6AccessType?;
    get ipv6AccessType(): string | undefined;
    set ipv6AccessType(value: string | undefined);
    resetIpv6AccessType(): void;
    get ipv6AccessTypeInput(): string | undefined;
    get ipv6CidrRange(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    get networkInput(): string | undefined;
    private _privateIpGoogleAccess?;
    get privateIpGoogleAccess(): boolean | cdktf.IResolvable | undefined;
    set privateIpGoogleAccess(value: boolean | cdktf.IResolvable | undefined);
    resetPrivateIpGoogleAccess(): void;
    get privateIpGoogleAccessInput(): boolean | cdktf.IResolvable | undefined;
    private _privateIpv6GoogleAccess?;
    get privateIpv6GoogleAccess(): string | undefined;
    set privateIpv6GoogleAccess(value: string | undefined);
    resetPrivateIpv6GoogleAccess(): void;
    get privateIpv6GoogleAccessInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _purpose?;
    get purpose(): string | undefined;
    set purpose(value: string | undefined);
    resetPurpose(): void;
    get purposeInput(): string | undefined;
    private _region?;
    get region(): string | undefined;
    set region(value: string | undefined);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _role?;
    get role(): string | undefined;
    set role(value: string | undefined);
    resetRole(): void;
    get roleInput(): string | undefined;
    private _secondaryIpRange?;
    get secondaryIpRange(): ComputeSubnetworkSecondaryIpRange[] | undefined;
    set secondaryIpRange(value: ComputeSubnetworkSecondaryIpRange[] | undefined);
    resetSecondaryIpRange(): void;
    get secondaryIpRangeInput(): ComputeSubnetworkSecondaryIpRange[] | undefined;
    get selfLink(): string;
    private _stackType?;
    get stackType(): string | undefined;
    set stackType(value: string | undefined);
    resetStackType(): void;
    get stackTypeInput(): string | undefined;
    private _logConfig?;
    private __logConfigOutput;
    get logConfig(): ComputeSubnetworkLogConfigOutputReference;
    putLogConfig(value: ComputeSubnetworkLogConfig | undefined): void;
    resetLogConfig(): void;
    get logConfigInput(): ComputeSubnetworkLogConfig | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): ComputeSubnetworkTimeoutsOutputReference;
    putTimeouts(value: ComputeSubnetworkTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeSubnetworkTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
