import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeSubnetworkIamPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork_iam_policy.html#policy_data ComputeSubnetworkIamPolicy#policy_data}.
     */
    readonly policyData: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork_iam_policy.html#project ComputeSubnetworkIamPolicy#project}.
     */
    readonly project?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork_iam_policy.html#region ComputeSubnetworkIamPolicy#region}.
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork_iam_policy.html#subnetwork ComputeSubnetworkIamPolicy#subnetwork}.
     */
    readonly subnetwork: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork_iam_policy.html google_compute_subnetwork_iam_policy}.
 */
export declare class ComputeSubnetworkIamPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_subnetwork_iam_policy.html google_compute_subnetwork_iam_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: ComputeSubnetworkIamPolicyConfig);
    get etag(): string;
    get id(): string;
    private _policyData?;
    get policyData(): string;
    set policyData(value: string);
    get policyDataInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string | undefined;
    set region(value: string | undefined);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _subnetwork?;
    get subnetwork(): string;
    set subnetwork(value: string);
    get subnetworkInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
