import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeSslPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Profile specifies the set of SSL features that can be used by the load balancer when negotiating SSL with clients.
     *
     * This can be one of
     * 'COMPATIBLE', 'MODERN', 'RESTRICTED', or 'CUSTOM'. If using 'CUSTOM',
     * the set of SSL features to enable must be specified in the
     * 'customFeatures' field.
     *
     * See the [official documentation](https://cloud.google.com/compute/docs/load-balancing/ssl-policies#profilefeaturesupport)
     * for which ciphers are available to use. **Note**: this argument
     * must* be present when using the 'CUSTOM' profile. This argument
     * must not* be present when using any other profile.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_ssl_policy.html#custom_features ComputeSslPolicy#custom_features}
     */
    readonly customFeatures?: string[];
    /**
     * An optional description of this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_ssl_policy.html#description ComputeSslPolicy#description}
     */
    readonly description?: string;
    /**
     * The minimum version of SSL protocol that can be used by the clients to establish a connection with the load balancer.
     *
     * Default value: "TLS_1_0" Possible values: ["TLS_1_0", "TLS_1_1", "TLS_1_2"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_ssl_policy.html#min_tls_version ComputeSslPolicy#min_tls_version}
     */
    readonly minTlsVersion?: string;
    /**
     * Name of the resource.
     *
     * Provided by the client when the resource is
     * created. The name must be 1-63 characters long, and comply with
     * RFC1035. Specifically, the name must be 1-63 characters long and match
     * the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
     * first character must be a lowercase letter, and all following
     * characters must be a dash, lowercase letter, or digit, except the last
     * character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_ssl_policy.html#name ComputeSslPolicy#name}
     */
    readonly name: string;
    /**
     * Profile specifies the set of SSL features that can be used by the load balancer when negotiating SSL with clients.
     *
     * If using 'CUSTOM',
     * the set of SSL features to enable must be specified in the
     * 'customFeatures' field.
     *
     * See the [official documentation](https://cloud.google.com/compute/docs/load-balancing/ssl-policies#profilefeaturesupport)
     * for information on what cipher suites each profile provides. If
     * 'CUSTOM' is used, the 'custom_features' attribute **must be set**. Default value: "COMPATIBLE" Possible values: ["COMPATIBLE", "MODERN", "RESTRICTED", "CUSTOM"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_ssl_policy.html#profile ComputeSslPolicy#profile}
     */
    readonly profile?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_ssl_policy.html#project ComputeSslPolicy#project}.
     */
    readonly project?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_ssl_policy.html#timeouts ComputeSslPolicy#timeouts}
     */
    readonly timeouts?: ComputeSslPolicyTimeouts;
}
export interface ComputeSslPolicyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_ssl_policy.html#create ComputeSslPolicy#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_ssl_policy.html#delete ComputeSslPolicy#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_ssl_policy.html#update ComputeSslPolicy#update}.
     */
    readonly update?: string;
}
export declare class ComputeSslPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_ssl_policy.html google_compute_ssl_policy}.
 */
export declare class ComputeSslPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_ssl_policy.html google_compute_ssl_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: ComputeSslPolicyConfig);
    get creationTimestamp(): string;
    private _customFeatures?;
    get customFeatures(): string[] | undefined;
    set customFeatures(value: string[] | undefined);
    resetCustomFeatures(): void;
    get customFeaturesInput(): string[] | undefined;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get enabledFeatures(): string[];
    get fingerprint(): string;
    get id(): string;
    private _minTlsVersion?;
    get minTlsVersion(): string | undefined;
    set minTlsVersion(value: string | undefined);
    resetMinTlsVersion(): void;
    get minTlsVersionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _profile?;
    get profile(): string | undefined;
    set profile(value: string | undefined);
    resetProfile(): void;
    get profileInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): ComputeSslPolicyTimeoutsOutputReference;
    putTimeouts(value: ComputeSslPolicyTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeSslPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
