import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeSnapshotConfig extends cdktf.TerraformMetaArguments {
    /**
     * An optional description of this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_snapshot.html#description ComputeSnapshot#description}
     */
    readonly description?: string;
    /**
     * Labels to apply to this Snapshot.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_snapshot.html#labels ComputeSnapshot#labels}
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Name of the resource;
     *
     * provided by the client when the resource is
     * created. The name must be 1-63 characters long, and comply with
     * RFC1035. Specifically, the name must be 1-63 characters long and match
     * the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
     * first character must be a lowercase letter, and all following
     * characters must be a dash, lowercase letter, or digit, except the last
     * character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_snapshot.html#name ComputeSnapshot#name}
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_snapshot.html#project ComputeSnapshot#project}.
     */
    readonly project?: string;
    /**
     * A reference to the disk used to create this snapshot.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_snapshot.html#source_disk ComputeSnapshot#source_disk}
     */
    readonly sourceDisk: string;
    /**
     * Cloud Storage bucket storage location of the snapshot (regional or multi-regional).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_snapshot.html#storage_locations ComputeSnapshot#storage_locations}
     */
    readonly storageLocations?: string[];
    /**
     * A reference to the zone where the disk is hosted.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_snapshot.html#zone ComputeSnapshot#zone}
     */
    readonly zone?: string;
    /**
     * snapshot_encryption_key block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_snapshot.html#snapshot_encryption_key ComputeSnapshot#snapshot_encryption_key}
     */
    readonly snapshotEncryptionKey?: ComputeSnapshotSnapshotEncryptionKey;
    /**
     * source_disk_encryption_key block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_snapshot.html#source_disk_encryption_key ComputeSnapshot#source_disk_encryption_key}
     */
    readonly sourceDiskEncryptionKey?: ComputeSnapshotSourceDiskEncryptionKey;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_snapshot.html#timeouts ComputeSnapshot#timeouts}
     */
    readonly timeouts?: ComputeSnapshotTimeouts;
}
export interface ComputeSnapshotSnapshotEncryptionKey {
    /**
     * The name of the encryption key that is stored in Google Cloud KMS.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_snapshot.html#kms_key_self_link ComputeSnapshot#kms_key_self_link}
     */
    readonly kmsKeySelfLink?: string;
    /**
     * The service account used for the encryption request for the given KMS key.
     *
     * If absent, the Compute Engine Service Agent service account is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_snapshot.html#kms_key_service_account ComputeSnapshot#kms_key_service_account}
     */
    readonly kmsKeyServiceAccount?: string;
    /**
     * Specifies a 256-bit customer-supplied encryption key, encoded in RFC 4648 base64 to either encrypt or decrypt this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_snapshot.html#raw_key ComputeSnapshot#raw_key}
     */
    readonly rawKey?: string;
}
export declare class ComputeSnapshotSnapshotEncryptionKeyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _kmsKeySelfLink?;
    get kmsKeySelfLink(): string | undefined;
    set kmsKeySelfLink(value: string | undefined);
    resetKmsKeySelfLink(): void;
    get kmsKeySelfLinkInput(): string | undefined;
    private _kmsKeyServiceAccount?;
    get kmsKeyServiceAccount(): string | undefined;
    set kmsKeyServiceAccount(value: string | undefined);
    resetKmsKeyServiceAccount(): void;
    get kmsKeyServiceAccountInput(): string | undefined;
    private _rawKey?;
    get rawKey(): string | undefined;
    set rawKey(value: string | undefined);
    resetRawKey(): void;
    get rawKeyInput(): string | undefined;
}
export interface ComputeSnapshotSourceDiskEncryptionKey {
    /**
     * The service account used for the encryption request for the given KMS key.
     *
     * If absent, the Compute Engine Service Agent service account is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_snapshot.html#kms_key_service_account ComputeSnapshot#kms_key_service_account}
     */
    readonly kmsKeyServiceAccount?: string;
    /**
     * Specifies a 256-bit customer-supplied encryption key, encoded in RFC 4648 base64 to either encrypt or decrypt this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_snapshot.html#raw_key ComputeSnapshot#raw_key}
     */
    readonly rawKey?: string;
}
export declare class ComputeSnapshotSourceDiskEncryptionKeyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _kmsKeyServiceAccount?;
    get kmsKeyServiceAccount(): string | undefined;
    set kmsKeyServiceAccount(value: string | undefined);
    resetKmsKeyServiceAccount(): void;
    get kmsKeyServiceAccountInput(): string | undefined;
    private _rawKey?;
    get rawKey(): string | undefined;
    set rawKey(value: string | undefined);
    resetRawKey(): void;
    get rawKeyInput(): string | undefined;
}
export interface ComputeSnapshotTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_snapshot.html#create ComputeSnapshot#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_snapshot.html#delete ComputeSnapshot#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_snapshot.html#update ComputeSnapshot#update}.
     */
    readonly update?: string;
}
export declare class ComputeSnapshotTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_snapshot.html google_compute_snapshot}.
 */
export declare class ComputeSnapshot extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_snapshot.html google_compute_snapshot} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: ComputeSnapshotConfig);
    get creationTimestamp(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get diskSizeGb(): number;
    get id(): string;
    get labelFingerprint(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    get licenses(): string[];
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    get snapshotId(): number;
    private _sourceDisk?;
    get sourceDisk(): string;
    set sourceDisk(value: string);
    get sourceDiskInput(): string | undefined;
    get sourceDiskLink(): string;
    get storageBytes(): number;
    private _storageLocations?;
    get storageLocations(): string[] | undefined;
    set storageLocations(value: string[] | undefined);
    resetStorageLocations(): void;
    get storageLocationsInput(): string[] | undefined;
    private _zone?;
    get zone(): string | undefined;
    set zone(value: string | undefined);
    resetZone(): void;
    get zoneInput(): string | undefined;
    private _snapshotEncryptionKey?;
    private __snapshotEncryptionKeyOutput;
    get snapshotEncryptionKey(): ComputeSnapshotSnapshotEncryptionKeyOutputReference;
    putSnapshotEncryptionKey(value: ComputeSnapshotSnapshotEncryptionKey | undefined): void;
    resetSnapshotEncryptionKey(): void;
    get snapshotEncryptionKeyInput(): ComputeSnapshotSnapshotEncryptionKey | undefined;
    private _sourceDiskEncryptionKey?;
    private __sourceDiskEncryptionKeyOutput;
    get sourceDiskEncryptionKey(): ComputeSnapshotSourceDiskEncryptionKeyOutputReference;
    putSourceDiskEncryptionKey(value: ComputeSnapshotSourceDiskEncryptionKey | undefined): void;
    resetSourceDiskEncryptionKey(): void;
    get sourceDiskEncryptionKeyInput(): ComputeSnapshotSourceDiskEncryptionKey | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): ComputeSnapshotTimeoutsOutputReference;
    putTimeouts(value: ComputeSnapshotTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeSnapshotTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
