import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeSharedVpcServiceProjectConfig extends cdktf.TerraformMetaArguments {
    /**
     * The ID of a host project to associate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_shared_vpc_service_project.html#host_project ComputeSharedVpcServiceProject#host_project}
     */
    readonly hostProject: string;
    /**
     * The ID of the project that will serve as a Shared VPC service project.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_shared_vpc_service_project.html#service_project ComputeSharedVpcServiceProject#service_project}
     */
    readonly serviceProject: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_shared_vpc_service_project.html#timeouts ComputeSharedVpcServiceProject#timeouts}
     */
    readonly timeouts?: ComputeSharedVpcServiceProjectTimeouts;
}
export interface ComputeSharedVpcServiceProjectTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_shared_vpc_service_project.html#create ComputeSharedVpcServiceProject#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_shared_vpc_service_project.html#delete ComputeSharedVpcServiceProject#delete}.
     */
    readonly delete?: string;
}
export declare class ComputeSharedVpcServiceProjectTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_shared_vpc_service_project.html google_compute_shared_vpc_service_project}.
 */
export declare class ComputeSharedVpcServiceProject extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_shared_vpc_service_project.html google_compute_shared_vpc_service_project} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: ComputeSharedVpcServiceProjectConfig);
    private _hostProject?;
    get hostProject(): string;
    set hostProject(value: string);
    get hostProjectInput(): string | undefined;
    get id(): string;
    private _serviceProject?;
    get serviceProject(): string;
    set serviceProject(value: string);
    get serviceProjectInput(): string | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): ComputeSharedVpcServiceProjectTimeoutsOutputReference;
    putTimeouts(value: ComputeSharedVpcServiceProjectTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeSharedVpcServiceProjectTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
