import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeSharedVpcHostProjectConfig extends cdktf.TerraformMetaArguments {
    /**
     * The ID of the project that will serve as a Shared VPC host project.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_shared_vpc_host_project.html#project ComputeSharedVpcHostProject#project}
     */
    readonly project: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_shared_vpc_host_project.html#timeouts ComputeSharedVpcHostProject#timeouts}
     */
    readonly timeouts?: ComputeSharedVpcHostProjectTimeouts;
}
export interface ComputeSharedVpcHostProjectTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_shared_vpc_host_project.html#create ComputeSharedVpcHostProject#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_shared_vpc_host_project.html#delete ComputeSharedVpcHostProject#delete}.
     */
    readonly delete?: string;
}
export declare class ComputeSharedVpcHostProjectTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_shared_vpc_host_project.html google_compute_shared_vpc_host_project}.
 */
export declare class ComputeSharedVpcHostProject extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_shared_vpc_host_project.html google_compute_shared_vpc_host_project} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: ComputeSharedVpcHostProjectConfig);
    get id(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): ComputeSharedVpcHostProjectTimeoutsOutputReference;
    putTimeouts(value: ComputeSharedVpcHostProjectTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeSharedVpcHostProjectTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
