import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeServiceAttachmentConfig extends cdktf.TerraformMetaArguments {
    /**
     * The connection preference to use for this service attachment. Valid values include "ACCEPT_AUTOMATIC", "ACCEPT_MANUAL".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_service_attachment.html#connection_preference ComputeServiceAttachment#connection_preference}
     */
    readonly connectionPreference: string;
    /**
     * An array of projects that are not allowed to connect to this service attachment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_service_attachment.html#consumer_reject_lists ComputeServiceAttachment#consumer_reject_lists}
     */
    readonly consumerRejectLists?: string[];
    /**
     * An optional description of this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_service_attachment.html#description ComputeServiceAttachment#description}
     */
    readonly description?: string;
    /**
     * If true, enable the proxy protocol which is for supplying client TCP/IP address data in TCP connections that traverse proxies on their way to destination servers.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_service_attachment.html#enable_proxy_protocol ComputeServiceAttachment#enable_proxy_protocol}
     */
    readonly enableProxyProtocol: boolean | cdktf.IResolvable;
    /**
     * Name of the resource.
     *
     * The name must be 1-63 characters long, and
     * comply with RFC1035. Specifically, the name must be 1-63 characters
     * long and match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?'
     * which means the first character must be a lowercase letter, and all
     * following characters must be a dash, lowercase letter, or digit,
     * except the last character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_service_attachment.html#name ComputeServiceAttachment#name}
     */
    readonly name: string;
    /**
     * An array of subnets that is provided for NAT in this service attachment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_service_attachment.html#nat_subnets ComputeServiceAttachment#nat_subnets}
     */
    readonly natSubnets: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_service_attachment.html#project ComputeServiceAttachment#project}.
     */
    readonly project?: string;
    /**
     * URL of the region where the resource resides.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_service_attachment.html#region ComputeServiceAttachment#region}
     */
    readonly region?: string;
    /**
     * The URL of a forwarding rule that represents the service identified by this service attachment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_service_attachment.html#target_service ComputeServiceAttachment#target_service}
     */
    readonly targetService: string;
    /**
     * consumer_accept_lists block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_service_attachment.html#consumer_accept_lists ComputeServiceAttachment#consumer_accept_lists}
     */
    readonly consumerAcceptLists?: ComputeServiceAttachmentConsumerAcceptLists[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_service_attachment.html#timeouts ComputeServiceAttachment#timeouts}
     */
    readonly timeouts?: ComputeServiceAttachmentTimeouts;
}
export declare class ComputeServiceAttachmentConnectedEndpoints extends cdktf.ComplexComputedList {
    get endpoint(): string;
    get status(): string;
}
export interface ComputeServiceAttachmentConsumerAcceptLists {
    /**
     * The number of consumer forwarding rules the consumer project can create.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_service_attachment.html#connection_limit ComputeServiceAttachment#connection_limit}
     */
    readonly connectionLimit: number;
    /**
     * A project that is allowed to connect to this service attachment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_service_attachment.html#project_id_or_num ComputeServiceAttachment#project_id_or_num}
     */
    readonly projectIdOrNum: string;
}
export interface ComputeServiceAttachmentTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_service_attachment.html#create ComputeServiceAttachment#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_service_attachment.html#delete ComputeServiceAttachment#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_service_attachment.html#update ComputeServiceAttachment#update}.
     */
    readonly update?: string;
}
export declare class ComputeServiceAttachmentTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_service_attachment.html google_compute_service_attachment}.
 */
export declare class ComputeServiceAttachment extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_service_attachment.html google_compute_service_attachment} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: ComputeServiceAttachmentConfig);
    connectedEndpoints(index: string): ComputeServiceAttachmentConnectedEndpoints;
    private _connectionPreference?;
    get connectionPreference(): string;
    set connectionPreference(value: string);
    get connectionPreferenceInput(): string | undefined;
    private _consumerRejectLists?;
    get consumerRejectLists(): string[] | undefined;
    set consumerRejectLists(value: string[] | undefined);
    resetConsumerRejectLists(): void;
    get consumerRejectListsInput(): string[] | undefined;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _enableProxyProtocol?;
    get enableProxyProtocol(): boolean | cdktf.IResolvable;
    set enableProxyProtocol(value: boolean | cdktf.IResolvable);
    get enableProxyProtocolInput(): boolean | cdktf.IResolvable | undefined;
    get fingerprint(): string;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _natSubnets?;
    get natSubnets(): string[];
    set natSubnets(value: string[]);
    get natSubnetsInput(): string[] | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string | undefined;
    set region(value: string | undefined);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get selfLink(): string;
    private _targetService?;
    get targetService(): string;
    set targetService(value: string);
    get targetServiceInput(): string | undefined;
    private _consumerAcceptLists?;
    get consumerAcceptLists(): ComputeServiceAttachmentConsumerAcceptLists[] | undefined;
    set consumerAcceptLists(value: ComputeServiceAttachmentConsumerAcceptLists[] | undefined);
    resetConsumerAcceptLists(): void;
    get consumerAcceptListsInput(): ComputeServiceAttachmentConsumerAcceptLists[] | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): ComputeServiceAttachmentTimeoutsOutputReference;
    putTimeouts(value: ComputeServiceAttachmentTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeServiceAttachmentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
