import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeSecurityPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * An optional description of this security policy. Max size is 2048.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy.html#description ComputeSecurityPolicy#description}
     */
    readonly description?: string;
    /**
     * The name of the security policy.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy.html#name ComputeSecurityPolicy#name}
     */
    readonly name: string;
    /**
     * The project in which the resource belongs. If it is not provided, the provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy.html#project ComputeSecurityPolicy#project}
     */
    readonly project?: string;
    /**
     * rule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy.html#rule ComputeSecurityPolicy#rule}
     */
    readonly rule?: ComputeSecurityPolicyRule[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy.html#timeouts ComputeSecurityPolicy#timeouts}
     */
    readonly timeouts?: ComputeSecurityPolicyTimeouts;
}
export interface ComputeSecurityPolicyRuleMatchConfig {
    /**
     * Set of IP addresses or ranges (IPV4 or IPV6) in CIDR notation to match against inbound traffic.
     *
     * There is a limit of 10 IP ranges per rule. A value of '*' matches all IPs (can be used to override the default behavior).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy.html#src_ip_ranges ComputeSecurityPolicy#src_ip_ranges}
     */
    readonly srcIpRanges: string[];
}
export declare class ComputeSecurityPolicyRuleMatchConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _srcIpRanges?;
    get srcIpRanges(): string[];
    set srcIpRanges(value: string[]);
    get srcIpRangesInput(): string[] | undefined;
}
export interface ComputeSecurityPolicyRuleMatchExpr {
    /**
     * Textual representation of an expression in Common Expression Language syntax.
     *
     * The application context of the containing message determines which well-known feature set of CEL is supported.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy.html#expression ComputeSecurityPolicy#expression}
     */
    readonly expression: string;
}
export declare class ComputeSecurityPolicyRuleMatchExprOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
}
export interface ComputeSecurityPolicyRuleMatch {
    /**
     * Predefined rule expression.
     *
     * If this field is specified, config must also be specified. Available options:   SRC_IPS_V1: Must specify the corresponding src_ip_ranges field in config.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy.html#versioned_expr ComputeSecurityPolicy#versioned_expr}
     */
    readonly versionedExpr?: string;
    /**
     * config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy.html#config ComputeSecurityPolicy#config}
     */
    readonly config?: ComputeSecurityPolicyRuleMatchConfig;
    /**
     * expr block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy.html#expr ComputeSecurityPolicy#expr}
     */
    readonly expr?: ComputeSecurityPolicyRuleMatchExpr;
}
export declare class ComputeSecurityPolicyRuleMatchOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _versionedExpr?;
    get versionedExpr(): string | undefined;
    set versionedExpr(value: string | undefined);
    resetVersionedExpr(): void;
    get versionedExprInput(): string | undefined;
    private _config?;
    private __configOutput;
    get config(): ComputeSecurityPolicyRuleMatchConfigOutputReference;
    putConfig(value: ComputeSecurityPolicyRuleMatchConfig | undefined): void;
    resetConfig(): void;
    get configInput(): ComputeSecurityPolicyRuleMatchConfig | undefined;
    private _expr?;
    private __exprOutput;
    get expr(): ComputeSecurityPolicyRuleMatchExprOutputReference;
    putExpr(value: ComputeSecurityPolicyRuleMatchExpr | undefined): void;
    resetExpr(): void;
    get exprInput(): ComputeSecurityPolicyRuleMatchExpr | undefined;
}
export interface ComputeSecurityPolicyRule {
    /**
     * Action to take when match matches the request.
     *
     * Valid values:   "allow" : allow access to target, "deny(status)" : deny access to target, returns the HTTP response code specified (valid values are 403, 404 and 502)
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy.html#action ComputeSecurityPolicy#action}
     */
    readonly action: string;
    /**
     * An optional description of this rule. Max size is 64.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy.html#description ComputeSecurityPolicy#description}
     */
    readonly description?: string;
    /**
     * When set to true, the action specified above is not enforced.
     *
     * Stackdriver logs for requests that trigger a preview action are annotated as such.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy.html#preview ComputeSecurityPolicy#preview}
     */
    readonly preview?: boolean | cdktf.IResolvable;
    /**
     * An unique positive integer indicating the priority of evaluation for a rule.
     *
     * Rules are evaluated from highest priority (lowest numerically) to lowest priority (highest numerically) in order.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy.html#priority ComputeSecurityPolicy#priority}
     */
    readonly priority: number;
    /**
     * match block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy.html#match ComputeSecurityPolicy#match}
     */
    readonly match: ComputeSecurityPolicyRuleMatch;
}
export interface ComputeSecurityPolicyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy.html#create ComputeSecurityPolicy#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy.html#delete ComputeSecurityPolicy#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy.html#update ComputeSecurityPolicy#update}.
     */
    readonly update?: string;
}
export declare class ComputeSecurityPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy.html google_compute_security_policy}.
 */
export declare class ComputeSecurityPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_security_policy.html google_compute_security_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: ComputeSecurityPolicyConfig);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get fingerprint(): string;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    private _rule?;
    get rule(): ComputeSecurityPolicyRule[] | undefined;
    set rule(value: ComputeSecurityPolicyRule[] | undefined);
    resetRule(): void;
    get ruleInput(): ComputeSecurityPolicyRule[] | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): ComputeSecurityPolicyTimeoutsOutputReference;
    putTimeouts(value: ComputeSecurityPolicyTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeSecurityPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
