import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeRouterConfig extends cdktf.TerraformMetaArguments {
    /**
     * An optional description of this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router.html#description ComputeRouter#description}
     */
    readonly description?: string;
    /**
     * Name of the resource.
     *
     * The name must be 1-63 characters long, and
     * comply with RFC1035. Specifically, the name must be 1-63 characters
     * long and match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?'
     * which means the first character must be a lowercase letter, and all
     * following characters must be a dash, lowercase letter, or digit,
     * except the last character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router.html#name ComputeRouter#name}
     */
    readonly name: string;
    /**
     * A reference to the network to which this router belongs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router.html#network ComputeRouter#network}
     */
    readonly network: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router.html#project ComputeRouter#project}.
     */
    readonly project?: string;
    /**
     * Region where the router resides.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router.html#region ComputeRouter#region}
     */
    readonly region?: string;
    /**
     * bgp block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router.html#bgp ComputeRouter#bgp}
     */
    readonly bgp?: ComputeRouterBgp;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router.html#timeouts ComputeRouter#timeouts}
     */
    readonly timeouts?: ComputeRouterTimeouts;
}
export interface ComputeRouterBgpAdvertisedIpRanges {
    /**
     * User-specified description for the IP range.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router.html#description ComputeRouter#description}
     */
    readonly description?: string;
    /**
     * The IP range to advertise. The value must be a CIDR-formatted string.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router.html#range ComputeRouter#range}
     */
    readonly range: string;
}
export interface ComputeRouterBgp {
    /**
     * User-specified flag to indicate which mode to use for advertisement. Default value: "DEFAULT" Possible values: ["DEFAULT", "CUSTOM"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router.html#advertise_mode ComputeRouter#advertise_mode}
     */
    readonly advertiseMode?: string;
    /**
     * User-specified list of prefix groups to advertise in custom mode.
     *
     * This field can only be populated if advertiseMode is CUSTOM and
     * is advertised to all peers of the router. These groups will be
     * advertised in addition to any specified prefixes. Leave this field
     * blank to advertise no custom groups.
     *
     * This enum field has the one valid value: ALL_SUBNETS
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router.html#advertised_groups ComputeRouter#advertised_groups}
     */
    readonly advertisedGroups?: string[];
    /**
     * Local BGP Autonomous System Number (ASN).
     *
     * Must be an RFC6996
     * private ASN, either 16-bit or 32-bit. The value will be fixed for
     * this router resource. All VPN tunnels that link to this router
     * will have the same local ASN.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router.html#asn ComputeRouter#asn}
     */
    readonly asn: number;
    /**
     * advertised_ip_ranges block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router.html#advertised_ip_ranges ComputeRouter#advertised_ip_ranges}
     */
    readonly advertisedIpRanges?: ComputeRouterBgpAdvertisedIpRanges[];
}
export declare class ComputeRouterBgpOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _advertiseMode?;
    get advertiseMode(): string | undefined;
    set advertiseMode(value: string | undefined);
    resetAdvertiseMode(): void;
    get advertiseModeInput(): string | undefined;
    private _advertisedGroups?;
    get advertisedGroups(): string[] | undefined;
    set advertisedGroups(value: string[] | undefined);
    resetAdvertisedGroups(): void;
    get advertisedGroupsInput(): string[] | undefined;
    private _asn?;
    get asn(): number;
    set asn(value: number);
    get asnInput(): number | undefined;
    private _advertisedIpRanges?;
    get advertisedIpRanges(): ComputeRouterBgpAdvertisedIpRanges[] | undefined;
    set advertisedIpRanges(value: ComputeRouterBgpAdvertisedIpRanges[] | undefined);
    resetAdvertisedIpRanges(): void;
    get advertisedIpRangesInput(): ComputeRouterBgpAdvertisedIpRanges[] | undefined;
}
export interface ComputeRouterTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router.html#create ComputeRouter#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router.html#delete ComputeRouter#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router.html#update ComputeRouter#update}.
     */
    readonly update?: string;
}
export declare class ComputeRouterTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_router.html google_compute_router}.
 */
export declare class ComputeRouter extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_router.html google_compute_router} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: ComputeRouterConfig);
    get creationTimestamp(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    get networkInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string | undefined;
    set region(value: string | undefined);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get selfLink(): string;
    private _bgp?;
    private __bgpOutput;
    get bgp(): ComputeRouterBgpOutputReference;
    putBgp(value: ComputeRouterBgp | undefined): void;
    resetBgp(): void;
    get bgpInput(): ComputeRouterBgp | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): ComputeRouterTimeoutsOutputReference;
    putTimeouts(value: ComputeRouterTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeRouterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
