import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeRouterNatConfig extends cdktf.TerraformMetaArguments {
    /**
     * A list of URLs of the IP resources to be drained.
     *
     * These IPs must be
     * valid static external IPs that have been assigned to the NAT.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_nat.html#drain_nat_ips ComputeRouterNat#drain_nat_ips}
     */
    readonly drainNatIps?: string[];
    /**
     * Specifies if endpoint independent mapping is enabled. This is enabled by default. For more information see the [official documentation](https://cloud.google.com/nat/docs/overview#specs-rfcs).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_nat.html#enable_endpoint_independent_mapping ComputeRouterNat#enable_endpoint_independent_mapping}
     */
    readonly enableEndpointIndependentMapping?: boolean | cdktf.IResolvable;
    /**
     * Timeout (in seconds) for ICMP connections. Defaults to 30s if not set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_nat.html#icmp_idle_timeout_sec ComputeRouterNat#icmp_idle_timeout_sec}
     */
    readonly icmpIdleTimeoutSec?: number;
    /**
     * Minimum number of ports allocated to a VM from this NAT.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_nat.html#min_ports_per_vm ComputeRouterNat#min_ports_per_vm}
     */
    readonly minPortsPerVm?: number;
    /**
     * Name of the NAT service. The name must be 1-63 characters long and comply with RFC1035.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_nat.html#name ComputeRouterNat#name}
     */
    readonly name: string;
    /**
     * How external IPs should be allocated for this NAT.
     *
     * Valid values are
     * 'AUTO_ONLY' for only allowing NAT IPs allocated by Google Cloud
     * Platform, or 'MANUAL_ONLY' for only user-allocated NAT IP addresses. Possible values: ["MANUAL_ONLY", "AUTO_ONLY"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_nat.html#nat_ip_allocate_option ComputeRouterNat#nat_ip_allocate_option}
     */
    readonly natIpAllocateOption: string;
    /**
     * Self-links of NAT IPs. Only valid if natIpAllocateOption is set to MANUAL_ONLY.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_nat.html#nat_ips ComputeRouterNat#nat_ips}
     */
    readonly natIps?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_nat.html#project ComputeRouterNat#project}.
     */
    readonly project?: string;
    /**
     * Region where the router and NAT reside.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_nat.html#region ComputeRouterNat#region}
     */
    readonly region?: string;
    /**
     * The name of the Cloud Router in which this NAT will be configured.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_nat.html#router ComputeRouterNat#router}
     */
    readonly router: string;
    /**
     * How NAT should be configured per Subnetwork.
     *
     * If 'ALL_SUBNETWORKS_ALL_IP_RANGES', all of the
     * IP ranges in every Subnetwork are allowed to Nat.
     * If 'ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES', all of the primary IP
     * ranges in every Subnetwork are allowed to Nat.
     * 'LIST_OF_SUBNETWORKS': A list of Subnetworks are allowed to Nat
     * (specified in the field subnetwork below). Note that if this field
     * contains ALL_SUBNETWORKS_ALL_IP_RANGES or
     * ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES, then there should not be any
     * other RouterNat section in any Router for this network in this region. Possible values: ["ALL_SUBNETWORKS_ALL_IP_RANGES", "ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES", "LIST_OF_SUBNETWORKS"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_nat.html#source_subnetwork_ip_ranges_to_nat ComputeRouterNat#source_subnetwork_ip_ranges_to_nat}
     */
    readonly sourceSubnetworkIpRangesToNat: string;
    /**
     * Timeout (in seconds) for TCP established connections. Defaults to 1200s if not set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_nat.html#tcp_established_idle_timeout_sec ComputeRouterNat#tcp_established_idle_timeout_sec}
     */
    readonly tcpEstablishedIdleTimeoutSec?: number;
    /**
     * Timeout (in seconds) for TCP transitory connections. Defaults to 30s if not set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_nat.html#tcp_transitory_idle_timeout_sec ComputeRouterNat#tcp_transitory_idle_timeout_sec}
     */
    readonly tcpTransitoryIdleTimeoutSec?: number;
    /**
     * Timeout (in seconds) for UDP connections. Defaults to 30s if not set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_nat.html#udp_idle_timeout_sec ComputeRouterNat#udp_idle_timeout_sec}
     */
    readonly udpIdleTimeoutSec?: number;
    /**
     * log_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_nat.html#log_config ComputeRouterNat#log_config}
     */
    readonly logConfig?: ComputeRouterNatLogConfig;
    /**
     * subnetwork block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_nat.html#subnetwork ComputeRouterNat#subnetwork}
     */
    readonly subnetwork?: ComputeRouterNatSubnetwork[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_nat.html#timeouts ComputeRouterNat#timeouts}
     */
    readonly timeouts?: ComputeRouterNatTimeouts;
}
export interface ComputeRouterNatLogConfig {
    /**
     * Indicates whether or not to export logs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_nat.html#enable ComputeRouterNat#enable}
     */
    readonly enable: boolean | cdktf.IResolvable;
    /**
     * Specifies the desired filtering of logs on this NAT. Possible values: ["ERRORS_ONLY", "TRANSLATIONS_ONLY", "ALL"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_nat.html#filter ComputeRouterNat#filter}
     */
    readonly filter: string;
}
export declare class ComputeRouterNatLogConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _enable?;
    get enable(): boolean | cdktf.IResolvable;
    set enable(value: boolean | cdktf.IResolvable);
    get enableInput(): boolean | cdktf.IResolvable | undefined;
    private _filter?;
    get filter(): string;
    set filter(value: string);
    get filterInput(): string | undefined;
}
export interface ComputeRouterNatSubnetwork {
    /**
     * Self-link of subnetwork to NAT.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_nat.html#name ComputeRouterNat#name}
     */
    readonly name: string;
    /**
     * List of the secondary ranges of the subnetwork that are allowed to use NAT.
     *
     * This can be populated only if
     * 'LIST_OF_SECONDARY_IP_RANGES' is one of the values in
     * sourceIpRangesToNat
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_nat.html#secondary_ip_range_names ComputeRouterNat#secondary_ip_range_names}
     */
    readonly secondaryIpRangeNames?: string[];
    /**
     * List of options for which source IPs in the subnetwork should have NAT enabled. Supported values include: 'ALL_IP_RANGES', 'LIST_OF_SECONDARY_IP_RANGES', 'PRIMARY_IP_RANGE'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_nat.html#source_ip_ranges_to_nat ComputeRouterNat#source_ip_ranges_to_nat}
     */
    readonly sourceIpRangesToNat: string[];
}
export interface ComputeRouterNatTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_nat.html#create ComputeRouterNat#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_nat.html#delete ComputeRouterNat#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_nat.html#update ComputeRouterNat#update}.
     */
    readonly update?: string;
}
export declare class ComputeRouterNatTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_router_nat.html google_compute_router_nat}.
 */
export declare class ComputeRouterNat extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_router_nat.html google_compute_router_nat} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: ComputeRouterNatConfig);
    private _drainNatIps?;
    get drainNatIps(): string[] | undefined;
    set drainNatIps(value: string[] | undefined);
    resetDrainNatIps(): void;
    get drainNatIpsInput(): string[] | undefined;
    private _enableEndpointIndependentMapping?;
    get enableEndpointIndependentMapping(): boolean | cdktf.IResolvable | undefined;
    set enableEndpointIndependentMapping(value: boolean | cdktf.IResolvable | undefined);
    resetEnableEndpointIndependentMapping(): void;
    get enableEndpointIndependentMappingInput(): boolean | cdktf.IResolvable | undefined;
    private _icmpIdleTimeoutSec?;
    get icmpIdleTimeoutSec(): number | undefined;
    set icmpIdleTimeoutSec(value: number | undefined);
    resetIcmpIdleTimeoutSec(): void;
    get icmpIdleTimeoutSecInput(): number | undefined;
    get id(): string;
    private _minPortsPerVm?;
    get minPortsPerVm(): number | undefined;
    set minPortsPerVm(value: number | undefined);
    resetMinPortsPerVm(): void;
    get minPortsPerVmInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _natIpAllocateOption?;
    get natIpAllocateOption(): string;
    set natIpAllocateOption(value: string);
    get natIpAllocateOptionInput(): string | undefined;
    private _natIps?;
    get natIps(): string[] | undefined;
    set natIps(value: string[] | undefined);
    resetNatIps(): void;
    get natIpsInput(): string[] | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string | undefined;
    set region(value: string | undefined);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _router?;
    get router(): string;
    set router(value: string);
    get routerInput(): string | undefined;
    private _sourceSubnetworkIpRangesToNat?;
    get sourceSubnetworkIpRangesToNat(): string;
    set sourceSubnetworkIpRangesToNat(value: string);
    get sourceSubnetworkIpRangesToNatInput(): string | undefined;
    private _tcpEstablishedIdleTimeoutSec?;
    get tcpEstablishedIdleTimeoutSec(): number | undefined;
    set tcpEstablishedIdleTimeoutSec(value: number | undefined);
    resetTcpEstablishedIdleTimeoutSec(): void;
    get tcpEstablishedIdleTimeoutSecInput(): number | undefined;
    private _tcpTransitoryIdleTimeoutSec?;
    get tcpTransitoryIdleTimeoutSec(): number | undefined;
    set tcpTransitoryIdleTimeoutSec(value: number | undefined);
    resetTcpTransitoryIdleTimeoutSec(): void;
    get tcpTransitoryIdleTimeoutSecInput(): number | undefined;
    private _udpIdleTimeoutSec?;
    get udpIdleTimeoutSec(): number | undefined;
    set udpIdleTimeoutSec(value: number | undefined);
    resetUdpIdleTimeoutSec(): void;
    get udpIdleTimeoutSecInput(): number | undefined;
    private _logConfig?;
    private __logConfigOutput;
    get logConfig(): ComputeRouterNatLogConfigOutputReference;
    putLogConfig(value: ComputeRouterNatLogConfig | undefined): void;
    resetLogConfig(): void;
    get logConfigInput(): ComputeRouterNatLogConfig | undefined;
    private _subnetwork?;
    get subnetwork(): ComputeRouterNatSubnetwork[] | undefined;
    set subnetwork(value: ComputeRouterNatSubnetwork[] | undefined);
    resetSubnetwork(): void;
    get subnetworkInput(): ComputeRouterNatSubnetwork[] | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): ComputeRouterNatTimeoutsOutputReference;
    putTimeouts(value: ComputeRouterNatTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeRouterNatTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
