import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeRouterInterfaceConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name or resource link to the VLAN interconnect for this interface.
     *
     * Changing this forces a new interface to be created. Only one of vpn_tunnel and interconnect_attachment can be specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_interface.html#interconnect_attachment ComputeRouterInterface#interconnect_attachment}
     */
    readonly interconnectAttachment?: string;
    /**
     * IP address and range of the interface.
     *
     * The IP range must be in the RFC3927 link-local IP space. Changing this forces a new interface to be created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_interface.html#ip_range ComputeRouterInterface#ip_range}
     */
    readonly ipRange?: string;
    /**
     * A unique name for the interface, required by GCE. Changing this forces a new interface to be created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_interface.html#name ComputeRouterInterface#name}
     */
    readonly name: string;
    /**
     * The ID of the project in which this interface's router belongs.
     *
     * If it is not provided, the provider project is used. Changing this forces a new interface to be created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_interface.html#project ComputeRouterInterface#project}
     */
    readonly project?: string;
    /**
     * The region this interface's router sits in.
     *
     * If not specified, the project region will be used. Changing this forces a new interface to be created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_interface.html#region ComputeRouterInterface#region}
     */
    readonly region?: string;
    /**
     * The name of the router this interface will be attached to.
     *
     * Changing this forces a new interface to be created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_interface.html#router ComputeRouterInterface#router}
     */
    readonly router: string;
    /**
     * The name or resource link to the VPN tunnel this interface will be linked to.
     *
     * Changing this forces a new interface to be created. Only one of vpn_tunnel and interconnect_attachment can be specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_interface.html#vpn_tunnel ComputeRouterInterface#vpn_tunnel}
     */
    readonly vpnTunnel?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_interface.html#timeouts ComputeRouterInterface#timeouts}
     */
    readonly timeouts?: ComputeRouterInterfaceTimeouts;
}
export interface ComputeRouterInterfaceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_interface.html#create ComputeRouterInterface#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_interface.html#delete ComputeRouterInterface#delete}.
     */
    readonly delete?: string;
}
export declare class ComputeRouterInterfaceTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_router_interface.html google_compute_router_interface}.
 */
export declare class ComputeRouterInterface extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_router_interface.html google_compute_router_interface} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: ComputeRouterInterfaceConfig);
    get id(): string;
    private _interconnectAttachment?;
    get interconnectAttachment(): string | undefined;
    set interconnectAttachment(value: string | undefined);
    resetInterconnectAttachment(): void;
    get interconnectAttachmentInput(): string | undefined;
    private _ipRange?;
    get ipRange(): string | undefined;
    set ipRange(value: string | undefined);
    resetIpRange(): void;
    get ipRangeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string | undefined;
    set region(value: string | undefined);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _router?;
    get router(): string;
    set router(value: string);
    get routerInput(): string | undefined;
    private _vpnTunnel?;
    get vpnTunnel(): string | undefined;
    set vpnTunnel(value: string | undefined);
    resetVpnTunnel(): void;
    get vpnTunnelInput(): string | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): ComputeRouterInterfaceTimeoutsOutputReference;
    putTimeouts(value: ComputeRouterInterfaceTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeRouterInterfaceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
