import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeRouteConfig extends cdktf.TerraformMetaArguments {
    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_route.html#description ComputeRoute#description}
     */
    readonly description?: string;
    /**
     * The destination range of outgoing packets that this route applies to. Only IPv4 is supported.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_route.html#dest_range ComputeRoute#dest_range}
     */
    readonly destRange: string;
    /**
     * Name of the resource.
     *
     * Provided by the client when the resource is
     * created. The name must be 1-63 characters long, and comply with
     * RFC1035.  Specifically, the name must be 1-63 characters long and
     * match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means
     * the first character must be a lowercase letter, and all following
     * characters must be a dash, lowercase letter, or digit, except the
     * last character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_route.html#name ComputeRoute#name}
     */
    readonly name: string;
    /**
     * The network that this route applies to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_route.html#network ComputeRoute#network}
     */
    readonly network: string;
    /**
     * URL to a gateway that should handle matching packets.
     *
     * Currently, you can only specify the internet gateway, using a full or
     * partial valid URL:
     * 'https://www.googleapis.com/compute/v1/projects/project/global/gateways/default-internet-gateway'
     * 'projects/project/global/gateways/default-internet-gateway'
     * 'global/gateways/default-internet-gateway'
     * The string 'default-internet-gateway'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_route.html#next_hop_gateway ComputeRoute#next_hop_gateway}
     */
    readonly nextHopGateway?: string;
    /**
     * The IP address or URL to a forwarding rule of type loadBalancingScheme=INTERNAL that should handle matching packets.
     *
     * With the GA provider you can only specify the forwarding
     * rule as a partial or full URL. For example, the following
     * are all valid values:
     * 10.128.0.56
     * https://www.googleapis.com/compute/v1/projects/project/regions/region/forwardingRules/forwardingRule
     * regions/region/forwardingRules/forwardingRule
     *
     * When the beta provider, you can also specify the IP address
     * of a forwarding rule from the same VPC or any peered VPC.
     *
     * Note that this can only be used when the destinationRange is
     * a public (non-RFC 1918) IP CIDR range.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_route.html#next_hop_ilb ComputeRoute#next_hop_ilb}
     */
    readonly nextHopIlb?: string;
    /**
     * URL to an instance that should handle matching packets.
     *
     * You can specify this as a full or partial URL. For example:
     * 'https://www.googleapis.com/compute/v1/projects/project/zones/zone/instances/instance'
     * 'projects/project/zones/zone/instances/instance'
     * 'zones/zone/instances/instance'
     * Just the instance name, with the zone in 'next_hop_instance_zone'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_route.html#next_hop_instance ComputeRoute#next_hop_instance}
     */
    readonly nextHopInstance?: string;
    /**
     * The zone of the instance specified in next_hop_instance. Omit if next_hop_instance is specified as a URL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_route.html#next_hop_instance_zone ComputeRoute#next_hop_instance_zone}
     */
    readonly nextHopInstanceZone?: string;
    /**
     * Network IP address of an instance that should handle matching packets.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_route.html#next_hop_ip ComputeRoute#next_hop_ip}
     */
    readonly nextHopIp?: string;
    /**
     * URL to a VpnTunnel that should handle matching packets.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_route.html#next_hop_vpn_tunnel ComputeRoute#next_hop_vpn_tunnel}
     */
    readonly nextHopVpnTunnel?: string;
    /**
     * The priority of this route.
     *
     * Priority is used to break ties in cases
     * where there is more than one matching route of equal prefix length.
     *
     * In the case of two routes with equal prefix length, the one with the
     * lowest-numbered priority value wins.
     *
     * Default value is 1000. Valid range is 0 through 65535.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_route.html#priority ComputeRoute#priority}
     */
    readonly priority?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_route.html#project ComputeRoute#project}.
     */
    readonly project?: string;
    /**
     * A list of instance tags to which this route applies.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_route.html#tags ComputeRoute#tags}
     */
    readonly tags?: string[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_route.html#timeouts ComputeRoute#timeouts}
     */
    readonly timeouts?: ComputeRouteTimeouts;
}
export interface ComputeRouteTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_route.html#create ComputeRoute#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_route.html#delete ComputeRoute#delete}.
     */
    readonly delete?: string;
}
export declare class ComputeRouteTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_route.html google_compute_route}.
 */
export declare class ComputeRoute extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_route.html google_compute_route} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: ComputeRouteConfig);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _destRange?;
    get destRange(): string;
    set destRange(value: string);
    get destRangeInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    get networkInput(): string | undefined;
    private _nextHopGateway?;
    get nextHopGateway(): string | undefined;
    set nextHopGateway(value: string | undefined);
    resetNextHopGateway(): void;
    get nextHopGatewayInput(): string | undefined;
    private _nextHopIlb?;
    get nextHopIlb(): string | undefined;
    set nextHopIlb(value: string | undefined);
    resetNextHopIlb(): void;
    get nextHopIlbInput(): string | undefined;
    private _nextHopInstance?;
    get nextHopInstance(): string | undefined;
    set nextHopInstance(value: string | undefined);
    resetNextHopInstance(): void;
    get nextHopInstanceInput(): string | undefined;
    private _nextHopInstanceZone?;
    get nextHopInstanceZone(): string | undefined;
    set nextHopInstanceZone(value: string | undefined);
    resetNextHopInstanceZone(): void;
    get nextHopInstanceZoneInput(): string | undefined;
    private _nextHopIp?;
    get nextHopIp(): string | undefined;
    set nextHopIp(value: string | undefined);
    resetNextHopIp(): void;
    get nextHopIpInput(): string | undefined;
    get nextHopNetwork(): string;
    private _nextHopVpnTunnel?;
    get nextHopVpnTunnel(): string | undefined;
    set nextHopVpnTunnel(value: string | undefined);
    resetNextHopVpnTunnel(): void;
    get nextHopVpnTunnelInput(): string | undefined;
    private _priority?;
    get priority(): number | undefined;
    set priority(value: number | undefined);
    resetPriority(): void;
    get priorityInput(): number | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    private _tags?;
    get tags(): string[] | undefined;
    set tags(value: string[] | undefined);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): ComputeRouteTimeoutsOutputReference;
    putTimeouts(value: ComputeRouteTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeRouteTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
