import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeReservationConfig extends cdktf.TerraformMetaArguments {
    /**
     * An optional description of this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_reservation.html#description ComputeReservation#description}
     */
    readonly description?: string;
    /**
     * Name of the resource.
     *
     * Provided by the client when the resource is
     * created. The name must be 1-63 characters long, and comply with
     * RFC1035. Specifically, the name must be 1-63 characters long and match
     * the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
     * first character must be a lowercase letter, and all following
     * characters must be a dash, lowercase letter, or digit, except the last
     * character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_reservation.html#name ComputeReservation#name}
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_reservation.html#project ComputeReservation#project}.
     */
    readonly project?: string;
    /**
     * When set to true, only VMs that target this reservation by name can consume this reservation.
     *
     * Otherwise, it can be consumed by VMs with
     * affinity for any reservation. Defaults to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_reservation.html#specific_reservation_required ComputeReservation#specific_reservation_required}
     */
    readonly specificReservationRequired?: boolean | cdktf.IResolvable;
    /**
     * The zone where the reservation is made.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_reservation.html#zone ComputeReservation#zone}
     */
    readonly zone: string;
    /**
     * specific_reservation block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_reservation.html#specific_reservation ComputeReservation#specific_reservation}
     */
    readonly specificReservation: ComputeReservationSpecificReservation;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_reservation.html#timeouts ComputeReservation#timeouts}
     */
    readonly timeouts?: ComputeReservationTimeouts;
}
export interface ComputeReservationSpecificReservationInstancePropertiesGuestAccelerators {
    /**
     * The number of the guest accelerator cards exposed to this instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_reservation.html#accelerator_count ComputeReservation#accelerator_count}
     */
    readonly acceleratorCount: number;
    /**
     * The full or partial URL of the accelerator type to attach to this instance. For example: 'projects/my-project/zones/us-central1-c/acceleratorTypes/nvidia-tesla-p100'.
     *
     * If you are creating an instance template, specify only the accelerator name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_reservation.html#accelerator_type ComputeReservation#accelerator_type}
     */
    readonly acceleratorType: string;
}
export interface ComputeReservationSpecificReservationInstancePropertiesLocalSsds {
    /**
     * The size of the disk in base-2 GB.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_reservation.html#disk_size_gb ComputeReservation#disk_size_gb}
     */
    readonly diskSizeGb: number;
    /**
     * The disk interface to use for attaching this disk. Default value: "SCSI" Possible values: ["SCSI", "NVME"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_reservation.html#interface ComputeReservation#interface}
     */
    readonly interface?: string;
}
export interface ComputeReservationSpecificReservationInstanceProperties {
    /**
     * The name of the machine type to reserve.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_reservation.html#machine_type ComputeReservation#machine_type}
     */
    readonly machineType: string;
    /**
     * The minimum CPU platform for the reservation.
     *
     * For example,
     * '"Intel Skylake"'. See
     * the CPU platform availability reference](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform#availablezones)
     * for information on available CPU platforms.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_reservation.html#min_cpu_platform ComputeReservation#min_cpu_platform}
     */
    readonly minCpuPlatform?: string;
    /**
     * guest_accelerators block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_reservation.html#guest_accelerators ComputeReservation#guest_accelerators}
     */
    readonly guestAccelerators?: ComputeReservationSpecificReservationInstancePropertiesGuestAccelerators[];
    /**
     * local_ssds block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_reservation.html#local_ssds ComputeReservation#local_ssds}
     */
    readonly localSsds?: ComputeReservationSpecificReservationInstancePropertiesLocalSsds[];
}
export declare class ComputeReservationSpecificReservationInstancePropertiesOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _machineType?;
    get machineType(): string;
    set machineType(value: string);
    get machineTypeInput(): string | undefined;
    private _minCpuPlatform?;
    get minCpuPlatform(): string | undefined;
    set minCpuPlatform(value: string | undefined);
    resetMinCpuPlatform(): void;
    get minCpuPlatformInput(): string | undefined;
    private _guestAccelerators?;
    get guestAccelerators(): ComputeReservationSpecificReservationInstancePropertiesGuestAccelerators[] | undefined;
    set guestAccelerators(value: ComputeReservationSpecificReservationInstancePropertiesGuestAccelerators[] | undefined);
    resetGuestAccelerators(): void;
    get guestAcceleratorsInput(): ComputeReservationSpecificReservationInstancePropertiesGuestAccelerators[] | undefined;
    private _localSsds?;
    get localSsds(): ComputeReservationSpecificReservationInstancePropertiesLocalSsds[] | undefined;
    set localSsds(value: ComputeReservationSpecificReservationInstancePropertiesLocalSsds[] | undefined);
    resetLocalSsds(): void;
    get localSsdsInput(): ComputeReservationSpecificReservationInstancePropertiesLocalSsds[] | undefined;
}
export interface ComputeReservationSpecificReservation {
    /**
     * The number of resources that are allocated.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_reservation.html#count ComputeReservation#count}
     */
    readonly count: number;
    /**
     * instance_properties block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_reservation.html#instance_properties ComputeReservation#instance_properties}
     */
    readonly instanceProperties: ComputeReservationSpecificReservationInstanceProperties;
}
export declare class ComputeReservationSpecificReservationOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _count?;
    get count(): number;
    set count(value: number);
    get countInput(): number | undefined;
    private _instanceProperties?;
    private __instancePropertiesOutput;
    get instanceProperties(): ComputeReservationSpecificReservationInstancePropertiesOutputReference;
    putInstanceProperties(value: ComputeReservationSpecificReservationInstanceProperties): void;
    get instancePropertiesInput(): ComputeReservationSpecificReservationInstanceProperties | undefined;
}
export interface ComputeReservationTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_reservation.html#create ComputeReservation#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_reservation.html#delete ComputeReservation#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_reservation.html#update ComputeReservation#update}.
     */
    readonly update?: string;
}
export declare class ComputeReservationTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_reservation.html google_compute_reservation}.
 */
export declare class ComputeReservation extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_reservation.html google_compute_reservation} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: ComputeReservationConfig);
    get commitment(): string;
    get creationTimestamp(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    private _specificReservationRequired?;
    get specificReservationRequired(): boolean | cdktf.IResolvable | undefined;
    set specificReservationRequired(value: boolean | cdktf.IResolvable | undefined);
    resetSpecificReservationRequired(): void;
    get specificReservationRequiredInput(): boolean | cdktf.IResolvable | undefined;
    get status(): string;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    get zoneInput(): string | undefined;
    private _specificReservation?;
    private __specificReservationOutput;
    get specificReservation(): ComputeReservationSpecificReservationOutputReference;
    putSpecificReservation(value: ComputeReservationSpecificReservation): void;
    get specificReservationInput(): ComputeReservationSpecificReservation | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): ComputeReservationTimeoutsOutputReference;
    putTimeouts(value: ComputeReservationTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeReservationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
