import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeRegionSslCertificateConfig extends cdktf.TerraformMetaArguments {
    /**
     * The certificate in PEM format.
     *
     * The certificate chain must be no greater than 5 certs long.
     * The chain must include at least one intermediate cert.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_ssl_certificate.html#certificate ComputeRegionSslCertificate#certificate}
     */
    readonly certificate: string;
    /**
     * An optional description of this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_ssl_certificate.html#description ComputeRegionSslCertificate#description}
     */
    readonly description?: string;
    /**
     * Name of the resource.
     *
     * Provided by the client when the resource is
     * created. The name must be 1-63 characters long, and comply with
     * RFC1035. Specifically, the name must be 1-63 characters long and match
     * the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
     * first character must be a lowercase letter, and all following
     * characters must be a dash, lowercase letter, or digit, except the last
     * character, which cannot be a dash.
     *
     *
     * These are in the same namespace as the managed SSL certificates.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_ssl_certificate.html#name ComputeRegionSslCertificate#name}
     */
    readonly name?: string;
    /**
     * Creates a unique name beginning with the specified prefix. Conflicts with name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_ssl_certificate.html#name_prefix ComputeRegionSslCertificate#name_prefix}
     */
    readonly namePrefix?: string;
    /**
     * The write-only private key in PEM format.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_ssl_certificate.html#private_key ComputeRegionSslCertificate#private_key}
     */
    readonly privateKey: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_ssl_certificate.html#project ComputeRegionSslCertificate#project}.
     */
    readonly project?: string;
    /**
     * The Region in which the created regional ssl certificate should reside.
     *
     * If it is not provided, the provider region is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_ssl_certificate.html#region ComputeRegionSslCertificate#region}
     */
    readonly region?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_ssl_certificate.html#timeouts ComputeRegionSslCertificate#timeouts}
     */
    readonly timeouts?: ComputeRegionSslCertificateTimeouts;
}
export interface ComputeRegionSslCertificateTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_ssl_certificate.html#create ComputeRegionSslCertificate#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_ssl_certificate.html#delete ComputeRegionSslCertificate#delete}.
     */
    readonly delete?: string;
}
export declare class ComputeRegionSslCertificateTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_region_ssl_certificate.html google_compute_region_ssl_certificate}.
 */
export declare class ComputeRegionSslCertificate extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_region_ssl_certificate.html google_compute_region_ssl_certificate} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: ComputeRegionSslCertificateConfig);
    private _certificate?;
    get certificate(): string;
    set certificate(value: string);
    get certificateInput(): string | undefined;
    get certificateId(): number;
    get creationTimestamp(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    resetName(): void;
    get nameInput(): string | undefined;
    private _namePrefix?;
    get namePrefix(): string | undefined;
    set namePrefix(value: string | undefined);
    resetNamePrefix(): void;
    get namePrefixInput(): string | undefined;
    private _privateKey?;
    get privateKey(): string;
    set privateKey(value: string);
    get privateKeyInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string | undefined;
    set region(value: string | undefined);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get selfLink(): string;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): ComputeRegionSslCertificateTimeoutsOutputReference;
    putTimeouts(value: ComputeRegionSslCertificateTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeRegionSslCertificateTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
