import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeRegionPerInstanceConfigConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config.html#minimal_action ComputeRegionPerInstanceConfig#minimal_action}.
     */
    readonly minimalAction?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config.html#most_disruptive_allowed_action ComputeRegionPerInstanceConfig#most_disruptive_allowed_action}.
     */
    readonly mostDisruptiveAllowedAction?: string;
    /**
     * The name for this per-instance config and its corresponding instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config.html#name ComputeRegionPerInstanceConfig#name}
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config.html#project ComputeRegionPerInstanceConfig#project}.
     */
    readonly project?: string;
    /**
     * Region where the containing instance group manager is located.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config.html#region ComputeRegionPerInstanceConfig#region}
     */
    readonly region?: string;
    /**
     * The region instance group manager this instance config is part of.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config.html#region_instance_group_manager ComputeRegionPerInstanceConfig#region_instance_group_manager}
     */
    readonly regionInstanceGroupManager: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config.html#remove_instance_state_on_destroy ComputeRegionPerInstanceConfig#remove_instance_state_on_destroy}.
     */
    readonly removeInstanceStateOnDestroy?: boolean | cdktf.IResolvable;
    /**
     * preserved_state block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config.html#preserved_state ComputeRegionPerInstanceConfig#preserved_state}
     */
    readonly preservedState?: ComputeRegionPerInstanceConfigPreservedState;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config.html#timeouts ComputeRegionPerInstanceConfig#timeouts}
     */
    readonly timeouts?: ComputeRegionPerInstanceConfigTimeouts;
}
export interface ComputeRegionPerInstanceConfigPreservedStateDisk {
    /**
     * A value that prescribes what should happen to the stateful disk when the VM instance is deleted.
     *
     * The available options are 'NEVER' and 'ON_PERMANENT_INSTANCE_DELETION'.
     * 'NEVER' - detach the disk when the VM is deleted, but do not delete the disk.
     * 'ON_PERMANENT_INSTANCE_DELETION' will delete the stateful disk when the VM is permanently
     * deleted from the instance group. Default value: "NEVER" Possible values: ["NEVER", "ON_PERMANENT_INSTANCE_DELETION"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config.html#delete_rule ComputeRegionPerInstanceConfig#delete_rule}
     */
    readonly deleteRule?: string;
    /**
     * A unique device name that is reflected into the /dev/ tree of a Linux operating system running within the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config.html#device_name ComputeRegionPerInstanceConfig#device_name}
     */
    readonly deviceName: string;
    /**
     * The mode of the disk. Default value: "READ_WRITE" Possible values: ["READ_ONLY", "READ_WRITE"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config.html#mode ComputeRegionPerInstanceConfig#mode}
     */
    readonly mode?: string;
    /**
     * The URI of an existing persistent disk to attach under the specified device-name in the format 'projects/project-id/zones/zone/disks/disk-name'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config.html#source ComputeRegionPerInstanceConfig#source}
     */
    readonly source: string;
}
export interface ComputeRegionPerInstanceConfigPreservedState {
    /**
     * Preserved metadata defined for this instance. This is a list of key->value pairs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config.html#metadata ComputeRegionPerInstanceConfig#metadata}
     */
    readonly metadata?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * disk block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config.html#disk ComputeRegionPerInstanceConfig#disk}
     */
    readonly disk?: ComputeRegionPerInstanceConfigPreservedStateDisk[];
}
export declare class ComputeRegionPerInstanceConfigPreservedStateOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set metadata(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetMetadata(): void;
    get metadataInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _disk?;
    get disk(): ComputeRegionPerInstanceConfigPreservedStateDisk[] | undefined;
    set disk(value: ComputeRegionPerInstanceConfigPreservedStateDisk[] | undefined);
    resetDisk(): void;
    get diskInput(): ComputeRegionPerInstanceConfigPreservedStateDisk[] | undefined;
}
export interface ComputeRegionPerInstanceConfigTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config.html#create ComputeRegionPerInstanceConfig#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config.html#delete ComputeRegionPerInstanceConfig#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config.html#update ComputeRegionPerInstanceConfig#update}.
     */
    readonly update?: string;
}
export declare class ComputeRegionPerInstanceConfigTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config.html google_compute_region_per_instance_config}.
 */
export declare class ComputeRegionPerInstanceConfig extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_region_per_instance_config.html google_compute_region_per_instance_config} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: ComputeRegionPerInstanceConfigConfig);
    get id(): string;
    private _minimalAction?;
    get minimalAction(): string | undefined;
    set minimalAction(value: string | undefined);
    resetMinimalAction(): void;
    get minimalActionInput(): string | undefined;
    private _mostDisruptiveAllowedAction?;
    get mostDisruptiveAllowedAction(): string | undefined;
    set mostDisruptiveAllowedAction(value: string | undefined);
    resetMostDisruptiveAllowedAction(): void;
    get mostDisruptiveAllowedActionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string | undefined;
    set region(value: string | undefined);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _regionInstanceGroupManager?;
    get regionInstanceGroupManager(): string;
    set regionInstanceGroupManager(value: string);
    get regionInstanceGroupManagerInput(): string | undefined;
    private _removeInstanceStateOnDestroy?;
    get removeInstanceStateOnDestroy(): boolean | cdktf.IResolvable | undefined;
    set removeInstanceStateOnDestroy(value: boolean | cdktf.IResolvable | undefined);
    resetRemoveInstanceStateOnDestroy(): void;
    get removeInstanceStateOnDestroyInput(): boolean | cdktf.IResolvable | undefined;
    private _preservedState?;
    private __preservedStateOutput;
    get preservedState(): ComputeRegionPerInstanceConfigPreservedStateOutputReference;
    putPreservedState(value: ComputeRegionPerInstanceConfigPreservedState | undefined): void;
    resetPreservedState(): void;
    get preservedStateInput(): ComputeRegionPerInstanceConfigPreservedState | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): ComputeRegionPerInstanceConfigTimeoutsOutputReference;
    putTimeouts(value: ComputeRegionPerInstanceConfigTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeRegionPerInstanceConfigTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
