import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeRegionNetworkEndpointGroupConfig extends cdktf.TerraformMetaArguments {
    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_network_endpoint_group.html#description ComputeRegionNetworkEndpointGroup#description}
     */
    readonly description?: string;
    /**
     * Name of the resource;
     *
     * provided by the client when the resource is
     * created. The name must be 1-63 characters long, and comply with
     * RFC1035. Specifically, the name must be 1-63 characters long and match
     * the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
     * first character must be a lowercase letter, and all following
     * characters must be a dash, lowercase letter, or digit, except the last
     * character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_network_endpoint_group.html#name ComputeRegionNetworkEndpointGroup#name}
     */
    readonly name: string;
    /**
     * Type of network endpoints in this network endpoint group. Defaults to SERVERLESS Default value: "SERVERLESS" Possible values: ["SERVERLESS"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_network_endpoint_group.html#network_endpoint_type ComputeRegionNetworkEndpointGroup#network_endpoint_type}
     */
    readonly networkEndpointType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_network_endpoint_group.html#project ComputeRegionNetworkEndpointGroup#project}.
     */
    readonly project?: string;
    /**
     * A reference to the region where the Serverless NEGs Reside.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_network_endpoint_group.html#region ComputeRegionNetworkEndpointGroup#region}
     */
    readonly region: string;
    /**
     * app_engine block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_network_endpoint_group.html#app_engine ComputeRegionNetworkEndpointGroup#app_engine}
     */
    readonly appEngine?: ComputeRegionNetworkEndpointGroupAppEngine;
    /**
     * cloud_function block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_network_endpoint_group.html#cloud_function ComputeRegionNetworkEndpointGroup#cloud_function}
     */
    readonly cloudFunction?: ComputeRegionNetworkEndpointGroupCloudFunction;
    /**
     * cloud_run block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_network_endpoint_group.html#cloud_run ComputeRegionNetworkEndpointGroup#cloud_run}
     */
    readonly cloudRun?: ComputeRegionNetworkEndpointGroupCloudRun;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_network_endpoint_group.html#timeouts ComputeRegionNetworkEndpointGroup#timeouts}
     */
    readonly timeouts?: ComputeRegionNetworkEndpointGroupTimeouts;
}
export interface ComputeRegionNetworkEndpointGroupAppEngine {
    /**
     * Optional serving service. The service name must be 1-63 characters long, and comply with RFC1035. Example value: "default", "my-service".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_network_endpoint_group.html#service ComputeRegionNetworkEndpointGroup#service}
     */
    readonly service?: string;
    /**
     * A template to parse service and version fields from a request URL.
     *
     * URL mask allows for routing to multiple App Engine services without
     * having to create multiple Network Endpoint Groups and backend services.
     *
     * For example, the request URLs "foo1-dot-appname.appspot.com/v1" and
     * "foo1-dot-appname.appspot.com/v2" can be backed by the same Serverless NEG with
     * URL mask "-dot-appname.appspot.com/". The URL mask will parse
     * them to { service = "foo1", version = "v1" } and { service = "foo1", version = "v2" } respectively.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_network_endpoint_group.html#url_mask ComputeRegionNetworkEndpointGroup#url_mask}
     */
    readonly urlMask?: string;
    /**
     * Optional serving version. The version must be 1-63 characters long, and comply with RFC1035. Example value: "v1", "v2".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_network_endpoint_group.html#version ComputeRegionNetworkEndpointGroup#version}
     */
    readonly version?: string;
}
export declare class ComputeRegionNetworkEndpointGroupAppEngineOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _service?;
    get service(): string | undefined;
    set service(value: string | undefined);
    resetService(): void;
    get serviceInput(): string | undefined;
    private _urlMask?;
    get urlMask(): string | undefined;
    set urlMask(value: string | undefined);
    resetUrlMask(): void;
    get urlMaskInput(): string | undefined;
    private _version?;
    get version(): string | undefined;
    set version(value: string | undefined);
    resetVersion(): void;
    get versionInput(): string | undefined;
}
export interface ComputeRegionNetworkEndpointGroupCloudFunction {
    /**
     * A user-defined name of the Cloud Function. The function name is case-sensitive and must be 1-63 characters long. Example value: "func1".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_network_endpoint_group.html#function ComputeRegionNetworkEndpointGroup#function}
     */
    readonly function?: string;
    /**
     * A template to parse function field from a request URL.
     *
     * URL mask allows
     * for routing to multiple Cloud Functions without having to create
     * multiple Network Endpoint Groups and backend services.
     *
     * For example, request URLs "mydomain.com/function1" and "mydomain.com/function2"
     * can be backed by the same Serverless NEG with URL mask "/". The URL mask
     * will parse them to { function = "function1" } and { function = "function2" } respectively.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_network_endpoint_group.html#url_mask ComputeRegionNetworkEndpointGroup#url_mask}
     */
    readonly urlMask?: string;
}
export declare class ComputeRegionNetworkEndpointGroupCloudFunctionOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _function?;
    get function(): string | undefined;
    set function(value: string | undefined);
    resetFunction(): void;
    get functionInput(): string | undefined;
    private _urlMask?;
    get urlMask(): string | undefined;
    set urlMask(value: string | undefined);
    resetUrlMask(): void;
    get urlMaskInput(): string | undefined;
}
export interface ComputeRegionNetworkEndpointGroupCloudRun {
    /**
     * Cloud Run service is the main resource of Cloud Run.
     *
     * The service must be 1-63 characters long, and comply with RFC1035.
     * Example value: "run-service".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_network_endpoint_group.html#service ComputeRegionNetworkEndpointGroup#service}
     */
    readonly service?: string;
    /**
     * Cloud Run tag represents the "named-revision" to provide additional fine-grained traffic routing information.
     *
     * The tag must be 1-63 characters long, and comply with RFC1035.
     * Example value: "revision-0010".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_network_endpoint_group.html#tag ComputeRegionNetworkEndpointGroup#tag}
     */
    readonly tag?: string;
    /**
     * A template to parse service and tag fields from a request URL.
     *
     * URL mask allows for routing to multiple Run services without having
     * to create multiple network endpoint groups and backend services.
     *
     * For example, request URLs "foo1.domain.com/bar1" and "foo1.domain.com/bar2"
     * an be backed by the same Serverless Network Endpoint Group (NEG) with
     * URL mask ".domain.com/". The URL mask will parse them to { service="bar1", tag="foo1" }
     * and { service="bar2", tag="foo2" } respectively.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_network_endpoint_group.html#url_mask ComputeRegionNetworkEndpointGroup#url_mask}
     */
    readonly urlMask?: string;
}
export declare class ComputeRegionNetworkEndpointGroupCloudRunOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _service?;
    get service(): string | undefined;
    set service(value: string | undefined);
    resetService(): void;
    get serviceInput(): string | undefined;
    private _tag?;
    get tag(): string | undefined;
    set tag(value: string | undefined);
    resetTag(): void;
    get tagInput(): string | undefined;
    private _urlMask?;
    get urlMask(): string | undefined;
    set urlMask(value: string | undefined);
    resetUrlMask(): void;
    get urlMaskInput(): string | undefined;
}
export interface ComputeRegionNetworkEndpointGroupTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_network_endpoint_group.html#create ComputeRegionNetworkEndpointGroup#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_network_endpoint_group.html#delete ComputeRegionNetworkEndpointGroup#delete}.
     */
    readonly delete?: string;
}
export declare class ComputeRegionNetworkEndpointGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_region_network_endpoint_group.html google_compute_region_network_endpoint_group}.
 */
export declare class ComputeRegionNetworkEndpointGroup extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_region_network_endpoint_group.html google_compute_region_network_endpoint_group} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: ComputeRegionNetworkEndpointGroupConfig);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkEndpointType?;
    get networkEndpointType(): string | undefined;
    set networkEndpointType(value: string | undefined);
    resetNetworkEndpointType(): void;
    get networkEndpointTypeInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    get regionInput(): string | undefined;
    get selfLink(): string;
    private _appEngine?;
    private __appEngineOutput;
    get appEngine(): ComputeRegionNetworkEndpointGroupAppEngineOutputReference;
    putAppEngine(value: ComputeRegionNetworkEndpointGroupAppEngine | undefined): void;
    resetAppEngine(): void;
    get appEngineInput(): ComputeRegionNetworkEndpointGroupAppEngine | undefined;
    private _cloudFunction?;
    private __cloudFunctionOutput;
    get cloudFunction(): ComputeRegionNetworkEndpointGroupCloudFunctionOutputReference;
    putCloudFunction(value: ComputeRegionNetworkEndpointGroupCloudFunction | undefined): void;
    resetCloudFunction(): void;
    get cloudFunctionInput(): ComputeRegionNetworkEndpointGroupCloudFunction | undefined;
    private _cloudRun?;
    private __cloudRunOutput;
    get cloudRun(): ComputeRegionNetworkEndpointGroupCloudRunOutputReference;
    putCloudRun(value: ComputeRegionNetworkEndpointGroupCloudRun | undefined): void;
    resetCloudRun(): void;
    get cloudRunInput(): ComputeRegionNetworkEndpointGroupCloudRun | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): ComputeRegionNetworkEndpointGroupTimeoutsOutputReference;
    putTimeouts(value: ComputeRegionNetworkEndpointGroupTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeRegionNetworkEndpointGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
