import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeRegionHealthCheckConfig extends cdktf.TerraformMetaArguments {
    /**
     * How often (in seconds) to send a health check. The default value is 5 seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#check_interval_sec ComputeRegionHealthCheck#check_interval_sec}
     */
    readonly checkIntervalSec?: number;
    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#description ComputeRegionHealthCheck#description}
     */
    readonly description?: string;
    /**
     * A so-far unhealthy instance will be marked healthy after this many consecutive successes. The default value is 2.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#healthy_threshold ComputeRegionHealthCheck#healthy_threshold}
     */
    readonly healthyThreshold?: number;
    /**
     * Name of the resource.
     *
     * Provided by the client when the resource is
     * created. The name must be 1-63 characters long, and comply with
     * RFC1035.  Specifically, the name must be 1-63 characters long and
     * match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means
     * the first character must be a lowercase letter, and all following
     * characters must be a dash, lowercase letter, or digit, except the
     * last character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#name ComputeRegionHealthCheck#name}
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#project ComputeRegionHealthCheck#project}.
     */
    readonly project?: string;
    /**
     * The Region in which the created health check should reside. If it is not provided, the provider region is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#region ComputeRegionHealthCheck#region}
     */
    readonly region?: string;
    /**
     * How long (in seconds) to wait before claiming failure.
     *
     * The default value is 5 seconds.  It is invalid for timeoutSec to have
     * greater value than checkIntervalSec.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#timeout_sec ComputeRegionHealthCheck#timeout_sec}
     */
    readonly timeoutSec?: number;
    /**
     * A so-far healthy instance will be marked unhealthy after this many consecutive failures. The default value is 2.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#unhealthy_threshold ComputeRegionHealthCheck#unhealthy_threshold}
     */
    readonly unhealthyThreshold?: number;
    /**
     * grpc_health_check block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#grpc_health_check ComputeRegionHealthCheck#grpc_health_check}
     */
    readonly grpcHealthCheck?: ComputeRegionHealthCheckGrpcHealthCheck;
    /**
     * http2_health_check block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#http2_health_check ComputeRegionHealthCheck#http2_health_check}
     */
    readonly http2HealthCheck?: ComputeRegionHealthCheckHttp2HealthCheck;
    /**
     * http_health_check block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#http_health_check ComputeRegionHealthCheck#http_health_check}
     */
    readonly httpHealthCheck?: ComputeRegionHealthCheckHttpHealthCheck;
    /**
     * https_health_check block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#https_health_check ComputeRegionHealthCheck#https_health_check}
     */
    readonly httpsHealthCheck?: ComputeRegionHealthCheckHttpsHealthCheck;
    /**
     * log_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#log_config ComputeRegionHealthCheck#log_config}
     */
    readonly logConfig?: ComputeRegionHealthCheckLogConfig;
    /**
     * ssl_health_check block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#ssl_health_check ComputeRegionHealthCheck#ssl_health_check}
     */
    readonly sslHealthCheck?: ComputeRegionHealthCheckSslHealthCheck;
    /**
     * tcp_health_check block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#tcp_health_check ComputeRegionHealthCheck#tcp_health_check}
     */
    readonly tcpHealthCheck?: ComputeRegionHealthCheckTcpHealthCheck;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#timeouts ComputeRegionHealthCheck#timeouts}
     */
    readonly timeouts?: ComputeRegionHealthCheckTimeouts;
}
export interface ComputeRegionHealthCheckGrpcHealthCheck {
    /**
     * The gRPC service name for the health check. The value of grpcServiceName has the following meanings by convention:.
     *
     * Empty serviceName means the overall status of all services at the backend.
     * Non-empty serviceName means the health of that gRPC service, as defined by the owner of the service.
     *
     * The grpcServiceName can only be ASCII.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#grpc_service_name ComputeRegionHealthCheck#grpc_service_name}
     */
    readonly grpcServiceName?: string;
    /**
     * The port number for the health check request.
     *
     * Must be specified if portName and portSpecification are not set
     * or if port_specification is USE_FIXED_PORT. Valid values are 1 through 65535.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#port ComputeRegionHealthCheck#port}
     */
    readonly port?: number;
    /**
     * Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#port_name ComputeRegionHealthCheck#port_name}
     */
    readonly portName?: string;
    /**
     * Specifies how port is selected for health checking, can be one of the following values:.
     *
     * 'USE_FIXED_PORT': The port number in 'port' is used for health checking.
     *
     * 'USE_NAMED_PORT': The 'portName' is used for health checking.
     *
     * 'USE_SERVING_PORT': For NetworkEndpointGroup, the port specified for each
     * network endpoint is used for health checking. For other backends, the
     * port or named port specified in the Backend Service is used for health
     * checking.
     *
     * If not specified, gRPC health check follows behavior specified in 'port' and
     * 'portName' fields. Possible values: ["USE_FIXED_PORT", "USE_NAMED_PORT", "USE_SERVING_PORT"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#port_specification ComputeRegionHealthCheck#port_specification}
     */
    readonly portSpecification?: string;
}
export declare class ComputeRegionHealthCheckGrpcHealthCheckOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _grpcServiceName?;
    get grpcServiceName(): string | undefined;
    set grpcServiceName(value: string | undefined);
    resetGrpcServiceName(): void;
    get grpcServiceNameInput(): string | undefined;
    private _port?;
    get port(): number | undefined;
    set port(value: number | undefined);
    resetPort(): void;
    get portInput(): number | undefined;
    private _portName?;
    get portName(): string | undefined;
    set portName(value: string | undefined);
    resetPortName(): void;
    get portNameInput(): string | undefined;
    private _portSpecification?;
    get portSpecification(): string | undefined;
    set portSpecification(value: string | undefined);
    resetPortSpecification(): void;
    get portSpecificationInput(): string | undefined;
}
export interface ComputeRegionHealthCheckHttp2HealthCheck {
    /**
     * The value of the host header in the HTTP2 health check request.
     *
     * If left empty (default value), the public IP on behalf of which this health
     * check is performed will be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#host ComputeRegionHealthCheck#host}
     */
    readonly host?: string;
    /**
     * The TCP port number for the HTTP2 health check request. The default value is 443.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#port ComputeRegionHealthCheck#port}
     */
    readonly port?: number;
    /**
     * Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#port_name ComputeRegionHealthCheck#port_name}
     */
    readonly portName?: string;
    /**
     * Specifies how port is selected for health checking, can be one of the following values:.
     *
     * 'USE_FIXED_PORT': The port number in 'port' is used for health checking.
     *
     * 'USE_NAMED_PORT': The 'portName' is used for health checking.
     *
     * 'USE_SERVING_PORT': For NetworkEndpointGroup, the port specified for each
     * network endpoint is used for health checking. For other backends, the
     * port or named port specified in the Backend Service is used for health
     * checking.
     *
     * If not specified, HTTP2 health check follows behavior specified in 'port' and
     * 'portName' fields. Possible values: ["USE_FIXED_PORT", "USE_NAMED_PORT", "USE_SERVING_PORT"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#port_specification ComputeRegionHealthCheck#port_specification}
     */
    readonly portSpecification?: string;
    /**
     * Specifies the type of proxy header to append before sending data to the backend.
     *
     * Default value: "NONE" Possible values: ["NONE", "PROXY_V1"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#proxy_header ComputeRegionHealthCheck#proxy_header}
     */
    readonly proxyHeader?: string;
    /**
     * The request path of the HTTP2 health check request. The default value is /.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#request_path ComputeRegionHealthCheck#request_path}
     */
    readonly requestPath?: string;
    /**
     * The bytes to match against the beginning of the response data.
     *
     * If left empty
     * (the default value), any response will indicate health. The response data
     * can only be ASCII.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#response ComputeRegionHealthCheck#response}
     */
    readonly response?: string;
}
export declare class ComputeRegionHealthCheckHttp2HealthCheckOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _host?;
    get host(): string | undefined;
    set host(value: string | undefined);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _port?;
    get port(): number | undefined;
    set port(value: number | undefined);
    resetPort(): void;
    get portInput(): number | undefined;
    private _portName?;
    get portName(): string | undefined;
    set portName(value: string | undefined);
    resetPortName(): void;
    get portNameInput(): string | undefined;
    private _portSpecification?;
    get portSpecification(): string | undefined;
    set portSpecification(value: string | undefined);
    resetPortSpecification(): void;
    get portSpecificationInput(): string | undefined;
    private _proxyHeader?;
    get proxyHeader(): string | undefined;
    set proxyHeader(value: string | undefined);
    resetProxyHeader(): void;
    get proxyHeaderInput(): string | undefined;
    private _requestPath?;
    get requestPath(): string | undefined;
    set requestPath(value: string | undefined);
    resetRequestPath(): void;
    get requestPathInput(): string | undefined;
    private _response?;
    get response(): string | undefined;
    set response(value: string | undefined);
    resetResponse(): void;
    get responseInput(): string | undefined;
}
export interface ComputeRegionHealthCheckHttpHealthCheck {
    /**
     * The value of the host header in the HTTP health check request.
     *
     * If left empty (default value), the public IP on behalf of which this health
     * check is performed will be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#host ComputeRegionHealthCheck#host}
     */
    readonly host?: string;
    /**
     * The TCP port number for the HTTP health check request. The default value is 80.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#port ComputeRegionHealthCheck#port}
     */
    readonly port?: number;
    /**
     * Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#port_name ComputeRegionHealthCheck#port_name}
     */
    readonly portName?: string;
    /**
     * Specifies how port is selected for health checking, can be one of the following values:.
     *
     * 'USE_FIXED_PORT': The port number in 'port' is used for health checking.
     *
     * 'USE_NAMED_PORT': The 'portName' is used for health checking.
     *
     * 'USE_SERVING_PORT': For NetworkEndpointGroup, the port specified for each
     * network endpoint is used for health checking. For other backends, the
     * port or named port specified in the Backend Service is used for health
     * checking.
     *
     * If not specified, HTTP health check follows behavior specified in 'port' and
     * 'portName' fields. Possible values: ["USE_FIXED_PORT", "USE_NAMED_PORT", "USE_SERVING_PORT"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#port_specification ComputeRegionHealthCheck#port_specification}
     */
    readonly portSpecification?: string;
    /**
     * Specifies the type of proxy header to append before sending data to the backend.
     *
     * Default value: "NONE" Possible values: ["NONE", "PROXY_V1"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#proxy_header ComputeRegionHealthCheck#proxy_header}
     */
    readonly proxyHeader?: string;
    /**
     * The request path of the HTTP health check request. The default value is /.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#request_path ComputeRegionHealthCheck#request_path}
     */
    readonly requestPath?: string;
    /**
     * The bytes to match against the beginning of the response data.
     *
     * If left empty
     * (the default value), any response will indicate health. The response data
     * can only be ASCII.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#response ComputeRegionHealthCheck#response}
     */
    readonly response?: string;
}
export declare class ComputeRegionHealthCheckHttpHealthCheckOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _host?;
    get host(): string | undefined;
    set host(value: string | undefined);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _port?;
    get port(): number | undefined;
    set port(value: number | undefined);
    resetPort(): void;
    get portInput(): number | undefined;
    private _portName?;
    get portName(): string | undefined;
    set portName(value: string | undefined);
    resetPortName(): void;
    get portNameInput(): string | undefined;
    private _portSpecification?;
    get portSpecification(): string | undefined;
    set portSpecification(value: string | undefined);
    resetPortSpecification(): void;
    get portSpecificationInput(): string | undefined;
    private _proxyHeader?;
    get proxyHeader(): string | undefined;
    set proxyHeader(value: string | undefined);
    resetProxyHeader(): void;
    get proxyHeaderInput(): string | undefined;
    private _requestPath?;
    get requestPath(): string | undefined;
    set requestPath(value: string | undefined);
    resetRequestPath(): void;
    get requestPathInput(): string | undefined;
    private _response?;
    get response(): string | undefined;
    set response(value: string | undefined);
    resetResponse(): void;
    get responseInput(): string | undefined;
}
export interface ComputeRegionHealthCheckHttpsHealthCheck {
    /**
     * The value of the host header in the HTTPS health check request.
     *
     * If left empty (default value), the public IP on behalf of which this health
     * check is performed will be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#host ComputeRegionHealthCheck#host}
     */
    readonly host?: string;
    /**
     * The TCP port number for the HTTPS health check request. The default value is 443.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#port ComputeRegionHealthCheck#port}
     */
    readonly port?: number;
    /**
     * Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#port_name ComputeRegionHealthCheck#port_name}
     */
    readonly portName?: string;
    /**
     * Specifies how port is selected for health checking, can be one of the following values:.
     *
     * 'USE_FIXED_PORT': The port number in 'port' is used for health checking.
     *
     * 'USE_NAMED_PORT': The 'portName' is used for health checking.
     *
     * 'USE_SERVING_PORT': For NetworkEndpointGroup, the port specified for each
     * network endpoint is used for health checking. For other backends, the
     * port or named port specified in the Backend Service is used for health
     * checking.
     *
     * If not specified, HTTPS health check follows behavior specified in 'port' and
     * 'portName' fields. Possible values: ["USE_FIXED_PORT", "USE_NAMED_PORT", "USE_SERVING_PORT"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#port_specification ComputeRegionHealthCheck#port_specification}
     */
    readonly portSpecification?: string;
    /**
     * Specifies the type of proxy header to append before sending data to the backend.
     *
     * Default value: "NONE" Possible values: ["NONE", "PROXY_V1"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#proxy_header ComputeRegionHealthCheck#proxy_header}
     */
    readonly proxyHeader?: string;
    /**
     * The request path of the HTTPS health check request. The default value is /.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#request_path ComputeRegionHealthCheck#request_path}
     */
    readonly requestPath?: string;
    /**
     * The bytes to match against the beginning of the response data.
     *
     * If left empty
     * (the default value), any response will indicate health. The response data
     * can only be ASCII.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#response ComputeRegionHealthCheck#response}
     */
    readonly response?: string;
}
export declare class ComputeRegionHealthCheckHttpsHealthCheckOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _host?;
    get host(): string | undefined;
    set host(value: string | undefined);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _port?;
    get port(): number | undefined;
    set port(value: number | undefined);
    resetPort(): void;
    get portInput(): number | undefined;
    private _portName?;
    get portName(): string | undefined;
    set portName(value: string | undefined);
    resetPortName(): void;
    get portNameInput(): string | undefined;
    private _portSpecification?;
    get portSpecification(): string | undefined;
    set portSpecification(value: string | undefined);
    resetPortSpecification(): void;
    get portSpecificationInput(): string | undefined;
    private _proxyHeader?;
    get proxyHeader(): string | undefined;
    set proxyHeader(value: string | undefined);
    resetProxyHeader(): void;
    get proxyHeaderInput(): string | undefined;
    private _requestPath?;
    get requestPath(): string | undefined;
    set requestPath(value: string | undefined);
    resetRequestPath(): void;
    get requestPathInput(): string | undefined;
    private _response?;
    get response(): string | undefined;
    set response(value: string | undefined);
    resetResponse(): void;
    get responseInput(): string | undefined;
}
export interface ComputeRegionHealthCheckLogConfig {
    /**
     * Indicates whether or not to export logs.
     *
     * This is false by default,
     * which means no health check logging will be done.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#enable ComputeRegionHealthCheck#enable}
     */
    readonly enable?: boolean | cdktf.IResolvable;
}
export declare class ComputeRegionHealthCheckLogConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _enable?;
    get enable(): boolean | cdktf.IResolvable | undefined;
    set enable(value: boolean | cdktf.IResolvable | undefined);
    resetEnable(): void;
    get enableInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ComputeRegionHealthCheckSslHealthCheck {
    /**
     * The TCP port number for the SSL health check request. The default value is 443.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#port ComputeRegionHealthCheck#port}
     */
    readonly port?: number;
    /**
     * Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#port_name ComputeRegionHealthCheck#port_name}
     */
    readonly portName?: string;
    /**
     * Specifies how port is selected for health checking, can be one of the following values:.
     *
     * 'USE_FIXED_PORT': The port number in 'port' is used for health checking.
     *
     * 'USE_NAMED_PORT': The 'portName' is used for health checking.
     *
     * 'USE_SERVING_PORT': For NetworkEndpointGroup, the port specified for each
     * network endpoint is used for health checking. For other backends, the
     * port or named port specified in the Backend Service is used for health
     * checking.
     *
     * If not specified, SSL health check follows behavior specified in 'port' and
     * 'portName' fields. Possible values: ["USE_FIXED_PORT", "USE_NAMED_PORT", "USE_SERVING_PORT"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#port_specification ComputeRegionHealthCheck#port_specification}
     */
    readonly portSpecification?: string;
    /**
     * Specifies the type of proxy header to append before sending data to the backend.
     *
     * Default value: "NONE" Possible values: ["NONE", "PROXY_V1"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#proxy_header ComputeRegionHealthCheck#proxy_header}
     */
    readonly proxyHeader?: string;
    /**
     * The application data to send once the SSL connection has been established (default value is empty).
     *
     * If both request and response are
     * empty, the connection establishment alone will indicate health. The request
     * data can only be ASCII.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#request ComputeRegionHealthCheck#request}
     */
    readonly request?: string;
    /**
     * The bytes to match against the beginning of the response data.
     *
     * If left empty
     * (the default value), any response will indicate health. The response data
     * can only be ASCII.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#response ComputeRegionHealthCheck#response}
     */
    readonly response?: string;
}
export declare class ComputeRegionHealthCheckSslHealthCheckOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _port?;
    get port(): number | undefined;
    set port(value: number | undefined);
    resetPort(): void;
    get portInput(): number | undefined;
    private _portName?;
    get portName(): string | undefined;
    set portName(value: string | undefined);
    resetPortName(): void;
    get portNameInput(): string | undefined;
    private _portSpecification?;
    get portSpecification(): string | undefined;
    set portSpecification(value: string | undefined);
    resetPortSpecification(): void;
    get portSpecificationInput(): string | undefined;
    private _proxyHeader?;
    get proxyHeader(): string | undefined;
    set proxyHeader(value: string | undefined);
    resetProxyHeader(): void;
    get proxyHeaderInput(): string | undefined;
    private _request?;
    get request(): string | undefined;
    set request(value: string | undefined);
    resetRequest(): void;
    get requestInput(): string | undefined;
    private _response?;
    get response(): string | undefined;
    set response(value: string | undefined);
    resetResponse(): void;
    get responseInput(): string | undefined;
}
export interface ComputeRegionHealthCheckTcpHealthCheck {
    /**
     * The TCP port number for the TCP health check request. The default value is 80.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#port ComputeRegionHealthCheck#port}
     */
    readonly port?: number;
    /**
     * Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#port_name ComputeRegionHealthCheck#port_name}
     */
    readonly portName?: string;
    /**
     * Specifies how port is selected for health checking, can be one of the following values:.
     *
     * 'USE_FIXED_PORT': The port number in 'port' is used for health checking.
     *
     * 'USE_NAMED_PORT': The 'portName' is used for health checking.
     *
     * 'USE_SERVING_PORT': For NetworkEndpointGroup, the port specified for each
     * network endpoint is used for health checking. For other backends, the
     * port or named port specified in the Backend Service is used for health
     * checking.
     *
     * If not specified, TCP health check follows behavior specified in 'port' and
     * 'portName' fields. Possible values: ["USE_FIXED_PORT", "USE_NAMED_PORT", "USE_SERVING_PORT"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#port_specification ComputeRegionHealthCheck#port_specification}
     */
    readonly portSpecification?: string;
    /**
     * Specifies the type of proxy header to append before sending data to the backend.
     *
     * Default value: "NONE" Possible values: ["NONE", "PROXY_V1"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#proxy_header ComputeRegionHealthCheck#proxy_header}
     */
    readonly proxyHeader?: string;
    /**
     * The application data to send once the TCP connection has been established (default value is empty).
     *
     * If both request and response are
     * empty, the connection establishment alone will indicate health. The request
     * data can only be ASCII.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#request ComputeRegionHealthCheck#request}
     */
    readonly request?: string;
    /**
     * The bytes to match against the beginning of the response data.
     *
     * If left empty
     * (the default value), any response will indicate health. The response data
     * can only be ASCII.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#response ComputeRegionHealthCheck#response}
     */
    readonly response?: string;
}
export declare class ComputeRegionHealthCheckTcpHealthCheckOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _port?;
    get port(): number | undefined;
    set port(value: number | undefined);
    resetPort(): void;
    get portInput(): number | undefined;
    private _portName?;
    get portName(): string | undefined;
    set portName(value: string | undefined);
    resetPortName(): void;
    get portNameInput(): string | undefined;
    private _portSpecification?;
    get portSpecification(): string | undefined;
    set portSpecification(value: string | undefined);
    resetPortSpecification(): void;
    get portSpecificationInput(): string | undefined;
    private _proxyHeader?;
    get proxyHeader(): string | undefined;
    set proxyHeader(value: string | undefined);
    resetProxyHeader(): void;
    get proxyHeaderInput(): string | undefined;
    private _request?;
    get request(): string | undefined;
    set request(value: string | undefined);
    resetRequest(): void;
    get requestInput(): string | undefined;
    private _response?;
    get response(): string | undefined;
    set response(value: string | undefined);
    resetResponse(): void;
    get responseInput(): string | undefined;
}
export interface ComputeRegionHealthCheckTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#create ComputeRegionHealthCheck#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#delete ComputeRegionHealthCheck#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#update ComputeRegionHealthCheck#update}.
     */
    readonly update?: string;
}
export declare class ComputeRegionHealthCheckTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html google_compute_region_health_check}.
 */
export declare class ComputeRegionHealthCheck extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html google_compute_region_health_check} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: ComputeRegionHealthCheckConfig);
    private _checkIntervalSec?;
    get checkIntervalSec(): number | undefined;
    set checkIntervalSec(value: number | undefined);
    resetCheckIntervalSec(): void;
    get checkIntervalSecInput(): number | undefined;
    get creationTimestamp(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _healthyThreshold?;
    get healthyThreshold(): number | undefined;
    set healthyThreshold(value: number | undefined);
    resetHealthyThreshold(): void;
    get healthyThresholdInput(): number | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string | undefined;
    set region(value: string | undefined);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get selfLink(): string;
    private _timeoutSec?;
    get timeoutSec(): number | undefined;
    set timeoutSec(value: number | undefined);
    resetTimeoutSec(): void;
    get timeoutSecInput(): number | undefined;
    get type(): string;
    private _unhealthyThreshold?;
    get unhealthyThreshold(): number | undefined;
    set unhealthyThreshold(value: number | undefined);
    resetUnhealthyThreshold(): void;
    get unhealthyThresholdInput(): number | undefined;
    private _grpcHealthCheck?;
    private __grpcHealthCheckOutput;
    get grpcHealthCheck(): ComputeRegionHealthCheckGrpcHealthCheckOutputReference;
    putGrpcHealthCheck(value: ComputeRegionHealthCheckGrpcHealthCheck | undefined): void;
    resetGrpcHealthCheck(): void;
    get grpcHealthCheckInput(): ComputeRegionHealthCheckGrpcHealthCheck | undefined;
    private _http2HealthCheck?;
    private __http2HealthCheckOutput;
    get http2HealthCheck(): ComputeRegionHealthCheckHttp2HealthCheckOutputReference;
    putHttp2HealthCheck(value: ComputeRegionHealthCheckHttp2HealthCheck | undefined): void;
    resetHttp2HealthCheck(): void;
    get http2HealthCheckInput(): ComputeRegionHealthCheckHttp2HealthCheck | undefined;
    private _httpHealthCheck?;
    private __httpHealthCheckOutput;
    get httpHealthCheck(): ComputeRegionHealthCheckHttpHealthCheckOutputReference;
    putHttpHealthCheck(value: ComputeRegionHealthCheckHttpHealthCheck | undefined): void;
    resetHttpHealthCheck(): void;
    get httpHealthCheckInput(): ComputeRegionHealthCheckHttpHealthCheck | undefined;
    private _httpsHealthCheck?;
    private __httpsHealthCheckOutput;
    get httpsHealthCheck(): ComputeRegionHealthCheckHttpsHealthCheckOutputReference;
    putHttpsHealthCheck(value: ComputeRegionHealthCheckHttpsHealthCheck | undefined): void;
    resetHttpsHealthCheck(): void;
    get httpsHealthCheckInput(): ComputeRegionHealthCheckHttpsHealthCheck | undefined;
    private _logConfig?;
    private __logConfigOutput;
    get logConfig(): ComputeRegionHealthCheckLogConfigOutputReference;
    putLogConfig(value: ComputeRegionHealthCheckLogConfig | undefined): void;
    resetLogConfig(): void;
    get logConfigInput(): ComputeRegionHealthCheckLogConfig | undefined;
    private _sslHealthCheck?;
    private __sslHealthCheckOutput;
    get sslHealthCheck(): ComputeRegionHealthCheckSslHealthCheckOutputReference;
    putSslHealthCheck(value: ComputeRegionHealthCheckSslHealthCheck | undefined): void;
    resetSslHealthCheck(): void;
    get sslHealthCheckInput(): ComputeRegionHealthCheckSslHealthCheck | undefined;
    private _tcpHealthCheck?;
    private __tcpHealthCheckOutput;
    get tcpHealthCheck(): ComputeRegionHealthCheckTcpHealthCheckOutputReference;
    putTcpHealthCheck(value: ComputeRegionHealthCheckTcpHealthCheck | undefined): void;
    resetTcpHealthCheck(): void;
    get tcpHealthCheckInput(): ComputeRegionHealthCheckTcpHealthCheck | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): ComputeRegionHealthCheckTimeoutsOutputReference;
    putTimeouts(value: ComputeRegionHealthCheckTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeRegionHealthCheckTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
