import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeRegionDiskConfig extends cdktf.TerraformMetaArguments {
    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_disk.html#description ComputeRegionDisk#description}
     */
    readonly description?: string;
    /**
     * Labels to apply to this disk.  A list of key->value pairs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_disk.html#labels ComputeRegionDisk#labels}
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Name of the resource.
     *
     * Provided by the client when the resource is
     * created. The name must be 1-63 characters long, and comply with
     * RFC1035. Specifically, the name must be 1-63 characters long and match
     * the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
     * first character must be a lowercase letter, and all following
     * characters must be a dash, lowercase letter, or digit, except the last
     * character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_disk.html#name ComputeRegionDisk#name}
     */
    readonly name: string;
    /**
     * Physical block size of the persistent disk, in bytes.
     *
     * If not present
     * in a request, a default value is used. Currently supported sizes
     * are 4096 and 16384, other sizes may be added in the future.
     * If an unsupported value is requested, the error message will list
     * the supported values for the caller's project.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_disk.html#physical_block_size_bytes ComputeRegionDisk#physical_block_size_bytes}
     */
    readonly physicalBlockSizeBytes?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_disk.html#project ComputeRegionDisk#project}.
     */
    readonly project?: string;
    /**
     * A reference to the region where the disk resides.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_disk.html#region ComputeRegionDisk#region}
     */
    readonly region?: string;
    /**
     * URLs of the zones where the disk should be replicated to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_disk.html#replica_zones ComputeRegionDisk#replica_zones}
     */
    readonly replicaZones: string[];
    /**
     * Size of the persistent disk, specified in GB.
     *
     * You can specify this
     * field when creating a persistent disk using the sourceImage or
     * sourceSnapshot parameter, or specify it alone to create an empty
     * persistent disk.
     *
     * If you specify this field along with sourceImage or sourceSnapshot,
     * the value of sizeGb must not be less than the size of the sourceImage
     * or the size of the snapshot.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_disk.html#size ComputeRegionDisk#size}
     */
    readonly size?: number;
    /**
     * The source snapshot used to create this disk.
     *
     * You can provide this as
     * a partial or full URL to the resource. For example, the following are
     * valid values:
     *
     * 'https://www.googleapis.com/compute/v1/projects/project/global/snapshots/snapshot'
     * 'projects/project/global/snapshots/snapshot'
     * 'global/snapshots/snapshot'
     * 'snapshot'
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_disk.html#snapshot ComputeRegionDisk#snapshot}
     */
    readonly snapshot?: string;
    /**
     * URL of the disk type resource describing which disk type to use to create the disk.
     *
     * Provide this when creating the disk.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_disk.html#type ComputeRegionDisk#type}
     */
    readonly type?: string;
    /**
     * disk_encryption_key block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_disk.html#disk_encryption_key ComputeRegionDisk#disk_encryption_key}
     */
    readonly diskEncryptionKey?: ComputeRegionDiskDiskEncryptionKey;
    /**
     * source_snapshot_encryption_key block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_disk.html#source_snapshot_encryption_key ComputeRegionDisk#source_snapshot_encryption_key}
     */
    readonly sourceSnapshotEncryptionKey?: ComputeRegionDiskSourceSnapshotEncryptionKey;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_disk.html#timeouts ComputeRegionDisk#timeouts}
     */
    readonly timeouts?: ComputeRegionDiskTimeouts;
}
export interface ComputeRegionDiskDiskEncryptionKey {
    /**
     * Specifies a 256-bit customer-supplied encryption key, encoded in RFC 4648 base64 to either encrypt or decrypt this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_disk.html#raw_key ComputeRegionDisk#raw_key}
     */
    readonly rawKey?: string;
}
export declare class ComputeRegionDiskDiskEncryptionKeyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _rawKey?;
    get rawKey(): string | undefined;
    set rawKey(value: string | undefined);
    resetRawKey(): void;
    get rawKeyInput(): string | undefined;
}
export interface ComputeRegionDiskSourceSnapshotEncryptionKey {
    /**
     * Specifies a 256-bit customer-supplied encryption key, encoded in RFC 4648 base64 to either encrypt or decrypt this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_disk.html#raw_key ComputeRegionDisk#raw_key}
     */
    readonly rawKey?: string;
}
export declare class ComputeRegionDiskSourceSnapshotEncryptionKeyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _rawKey?;
    get rawKey(): string | undefined;
    set rawKey(value: string | undefined);
    resetRawKey(): void;
    get rawKeyInput(): string | undefined;
}
export interface ComputeRegionDiskTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_disk.html#create ComputeRegionDisk#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_disk.html#delete ComputeRegionDisk#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_disk.html#update ComputeRegionDisk#update}.
     */
    readonly update?: string;
}
export declare class ComputeRegionDiskTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_region_disk.html google_compute_region_disk}.
 */
export declare class ComputeRegionDisk extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_region_disk.html google_compute_region_disk} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: ComputeRegionDiskConfig);
    get creationTimestamp(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    get labelFingerprint(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    get lastAttachTimestamp(): string;
    get lastDetachTimestamp(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _physicalBlockSizeBytes?;
    get physicalBlockSizeBytes(): number | undefined;
    set physicalBlockSizeBytes(value: number | undefined);
    resetPhysicalBlockSizeBytes(): void;
    get physicalBlockSizeBytesInput(): number | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string | undefined;
    set region(value: string | undefined);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _replicaZones?;
    get replicaZones(): string[];
    set replicaZones(value: string[]);
    get replicaZonesInput(): string[] | undefined;
    get selfLink(): string;
    private _size?;
    get size(): number | undefined;
    set size(value: number | undefined);
    resetSize(): void;
    get sizeInput(): number | undefined;
    private _snapshot?;
    get snapshot(): string | undefined;
    set snapshot(value: string | undefined);
    resetSnapshot(): void;
    get snapshotInput(): string | undefined;
    get sourceSnapshotId(): string;
    private _type?;
    get type(): string | undefined;
    set type(value: string | undefined);
    resetType(): void;
    get typeInput(): string | undefined;
    get users(): string[];
    private _diskEncryptionKey?;
    private __diskEncryptionKeyOutput;
    get diskEncryptionKey(): ComputeRegionDiskDiskEncryptionKeyOutputReference;
    putDiskEncryptionKey(value: ComputeRegionDiskDiskEncryptionKey | undefined): void;
    resetDiskEncryptionKey(): void;
    get diskEncryptionKeyInput(): ComputeRegionDiskDiskEncryptionKey | undefined;
    private _sourceSnapshotEncryptionKey?;
    private __sourceSnapshotEncryptionKeyOutput;
    get sourceSnapshotEncryptionKey(): ComputeRegionDiskSourceSnapshotEncryptionKeyOutputReference;
    putSourceSnapshotEncryptionKey(value: ComputeRegionDiskSourceSnapshotEncryptionKey | undefined): void;
    resetSourceSnapshotEncryptionKey(): void;
    get sourceSnapshotEncryptionKeyInput(): ComputeRegionDiskSourceSnapshotEncryptionKey | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): ComputeRegionDiskTimeoutsOutputReference;
    putTimeouts(value: ComputeRegionDiskTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeRegionDiskTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
