import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeProjectMetadataConfig extends cdktf.TerraformMetaArguments {
    /**
     * A series of key value pairs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_project_metadata.html#metadata ComputeProjectMetadata#metadata}
     */
    readonly metadata: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The ID of the project in which the resource belongs.
     *
     * If it is not provided, the provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_project_metadata.html#project ComputeProjectMetadata#project}
     */
    readonly project?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_project_metadata.html#timeouts ComputeProjectMetadata#timeouts}
     */
    readonly timeouts?: ComputeProjectMetadataTimeouts;
}
export interface ComputeProjectMetadataTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_project_metadata.html#create ComputeProjectMetadata#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_project_metadata.html#delete ComputeProjectMetadata#delete}.
     */
    readonly delete?: string;
}
export declare class ComputeProjectMetadataTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_project_metadata.html google_compute_project_metadata}.
 */
export declare class ComputeProjectMetadata extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_project_metadata.html google_compute_project_metadata} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: ComputeProjectMetadataConfig);
    get id(): string;
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    set metadata(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    get metadataInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): ComputeProjectMetadataTimeoutsOutputReference;
    putTimeouts(value: ComputeProjectMetadataTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeProjectMetadataTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
