import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeProjectDefaultNetworkTierConfig extends cdktf.TerraformMetaArguments {
    /**
     * The default network tier to be configured for the project.
     *
     * This field can take the following values: PREMIUM or STANDARD.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_project_default_network_tier.html#network_tier ComputeProjectDefaultNetworkTier#network_tier}
     */
    readonly networkTier: string;
    /**
     * The ID of the project in which the resource belongs.
     *
     * If it is not provided, the provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_project_default_network_tier.html#project ComputeProjectDefaultNetworkTier#project}
     */
    readonly project?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_project_default_network_tier.html#timeouts ComputeProjectDefaultNetworkTier#timeouts}
     */
    readonly timeouts?: ComputeProjectDefaultNetworkTierTimeouts;
}
export interface ComputeProjectDefaultNetworkTierTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_project_default_network_tier.html#create ComputeProjectDefaultNetworkTier#create}.
     */
    readonly create?: string;
}
export declare class ComputeProjectDefaultNetworkTierTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_project_default_network_tier.html google_compute_project_default_network_tier}.
 */
export declare class ComputeProjectDefaultNetworkTier extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_project_default_network_tier.html google_compute_project_default_network_tier} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: ComputeProjectDefaultNetworkTierConfig);
    get id(): string;
    private _networkTier?;
    get networkTier(): string;
    set networkTier(value: string);
    get networkTierInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): ComputeProjectDefaultNetworkTierTimeoutsOutputReference;
    putTimeouts(value: ComputeProjectDefaultNetworkTierTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeProjectDefaultNetworkTierTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
