import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputePacketMirroringConfig extends cdktf.TerraformMetaArguments {
    /**
     * A human-readable description of the rule.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#description ComputePacketMirroring#description}
     */
    readonly description?: string;
    /**
     * The name of the packet mirroring rule.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#name ComputePacketMirroring#name}
     */
    readonly name: string;
    /**
     * Since only one rule can be active at a time, priority is used to break ties in the case of two rules that apply to the same instances.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#priority ComputePacketMirroring#priority}
     */
    readonly priority?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#project ComputePacketMirroring#project}.
     */
    readonly project?: string;
    /**
     * The Region in which the created address should reside. If it is not provided, the provider region is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#region ComputePacketMirroring#region}
     */
    readonly region?: string;
    /**
     * collector_ilb block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#collector_ilb ComputePacketMirroring#collector_ilb}
     */
    readonly collectorIlb: ComputePacketMirroringCollectorIlb;
    /**
     * filter block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#filter ComputePacketMirroring#filter}
     */
    readonly filter?: ComputePacketMirroringFilter;
    /**
     * mirrored_resources block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#mirrored_resources ComputePacketMirroring#mirrored_resources}
     */
    readonly mirroredResources: ComputePacketMirroringMirroredResources;
    /**
     * network block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#network ComputePacketMirroring#network}
     */
    readonly network: ComputePacketMirroringNetwork;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#timeouts ComputePacketMirroring#timeouts}
     */
    readonly timeouts?: ComputePacketMirroringTimeouts;
}
export interface ComputePacketMirroringCollectorIlb {
    /**
     * The URL of the forwarding rule.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#url ComputePacketMirroring#url}
     */
    readonly url: string;
}
export declare class ComputePacketMirroringCollectorIlbOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
}
export interface ComputePacketMirroringFilter {
    /**
     * IP CIDR ranges that apply as a filter on the source (ingress) or destination (egress) IP in the IP header.
     *
     * Only IPv4 is supported.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#cidr_ranges ComputePacketMirroring#cidr_ranges}
     */
    readonly cidrRanges?: string[];
    /**
     * Direction of traffic to mirror. Default value: "BOTH" Possible values: ["INGRESS", "EGRESS", "BOTH"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#direction ComputePacketMirroring#direction}
     */
    readonly direction?: string;
    /**
     * Protocols that apply as a filter on mirrored traffic. Possible values: ["tcp", "udp", "icmp"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#ip_protocols ComputePacketMirroring#ip_protocols}
     */
    readonly ipProtocols?: string[];
}
export declare class ComputePacketMirroringFilterOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _cidrRanges?;
    get cidrRanges(): string[] | undefined;
    set cidrRanges(value: string[] | undefined);
    resetCidrRanges(): void;
    get cidrRangesInput(): string[] | undefined;
    private _direction?;
    get direction(): string | undefined;
    set direction(value: string | undefined);
    resetDirection(): void;
    get directionInput(): string | undefined;
    private _ipProtocols?;
    get ipProtocols(): string[] | undefined;
    set ipProtocols(value: string[] | undefined);
    resetIpProtocols(): void;
    get ipProtocolsInput(): string[] | undefined;
}
export interface ComputePacketMirroringMirroredResourcesInstances {
    /**
     * The URL of the instances where this rule should be active.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#url ComputePacketMirroring#url}
     */
    readonly url: string;
}
export interface ComputePacketMirroringMirroredResourcesSubnetworks {
    /**
     * The URL of the subnetwork where this rule should be active.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#url ComputePacketMirroring#url}
     */
    readonly url: string;
}
export interface ComputePacketMirroringMirroredResources {
    /**
     * All instances with these tags will be mirrored.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#tags ComputePacketMirroring#tags}
     */
    readonly tags?: string[];
    /**
     * instances block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#instances ComputePacketMirroring#instances}
     */
    readonly instances?: ComputePacketMirroringMirroredResourcesInstances[];
    /**
     * subnetworks block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#subnetworks ComputePacketMirroring#subnetworks}
     */
    readonly subnetworks?: ComputePacketMirroringMirroredResourcesSubnetworks[];
}
export declare class ComputePacketMirroringMirroredResourcesOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _tags?;
    get tags(): string[] | undefined;
    set tags(value: string[] | undefined);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _instances?;
    get instances(): ComputePacketMirroringMirroredResourcesInstances[] | undefined;
    set instances(value: ComputePacketMirroringMirroredResourcesInstances[] | undefined);
    resetInstances(): void;
    get instancesInput(): ComputePacketMirroringMirroredResourcesInstances[] | undefined;
    private _subnetworks?;
    get subnetworks(): ComputePacketMirroringMirroredResourcesSubnetworks[] | undefined;
    set subnetworks(value: ComputePacketMirroringMirroredResourcesSubnetworks[] | undefined);
    resetSubnetworks(): void;
    get subnetworksInput(): ComputePacketMirroringMirroredResourcesSubnetworks[] | undefined;
}
export interface ComputePacketMirroringNetwork {
    /**
     * The full self_link URL of the network where this rule is active.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#url ComputePacketMirroring#url}
     */
    readonly url: string;
}
export declare class ComputePacketMirroringNetworkOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
}
export interface ComputePacketMirroringTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#create ComputePacketMirroring#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#delete ComputePacketMirroring#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html#update ComputePacketMirroring#update}.
     */
    readonly update?: string;
}
export declare class ComputePacketMirroringTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html google_compute_packet_mirroring}.
 */
export declare class ComputePacketMirroring extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_packet_mirroring.html google_compute_packet_mirroring} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: ComputePacketMirroringConfig);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _priority?;
    get priority(): number | undefined;
    set priority(value: number | undefined);
    resetPriority(): void;
    get priorityInput(): number | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string | undefined;
    set region(value: string | undefined);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _collectorIlb?;
    private __collectorIlbOutput;
    get collectorIlb(): ComputePacketMirroringCollectorIlbOutputReference;
    putCollectorIlb(value: ComputePacketMirroringCollectorIlb): void;
    get collectorIlbInput(): ComputePacketMirroringCollectorIlb | undefined;
    private _filter?;
    private __filterOutput;
    get filter(): ComputePacketMirroringFilterOutputReference;
    putFilter(value: ComputePacketMirroringFilter | undefined): void;
    resetFilter(): void;
    get filterInput(): ComputePacketMirroringFilter | undefined;
    private _mirroredResources?;
    private __mirroredResourcesOutput;
    get mirroredResources(): ComputePacketMirroringMirroredResourcesOutputReference;
    putMirroredResources(value: ComputePacketMirroringMirroredResources): void;
    get mirroredResourcesInput(): ComputePacketMirroringMirroredResources | undefined;
    private _network?;
    private __networkOutput;
    get network(): ComputePacketMirroringNetworkOutputReference;
    putNetwork(value: ComputePacketMirroringNetwork): void;
    get networkInput(): ComputePacketMirroringNetwork | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): ComputePacketMirroringTimeoutsOutputReference;
    putTimeouts(value: ComputePacketMirroringTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputePacketMirroringTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
