import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeNodeTemplateConfig extends cdktf.TerraformMetaArguments {
    /**
     * CPU overcommit. Default value: "NONE" Possible values: ["ENABLED", "NONE"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_template.html#cpu_overcommit_type ComputeNodeTemplate#cpu_overcommit_type}
     */
    readonly cpuOvercommitType?: string;
    /**
     * An optional textual description of the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_template.html#description ComputeNodeTemplate#description}
     */
    readonly description?: string;
    /**
     * Name of the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_template.html#name ComputeNodeTemplate#name}
     */
    readonly name?: string;
    /**
     * Labels to use for node affinity, which will be used in instance scheduling.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_template.html#node_affinity_labels ComputeNodeTemplate#node_affinity_labels}
     */
    readonly nodeAffinityLabels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Node type to use for nodes group that are created from this template.
     *
     * Only one of nodeTypeFlexibility and nodeType can be specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_template.html#node_type ComputeNodeTemplate#node_type}
     */
    readonly nodeType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_template.html#project ComputeNodeTemplate#project}.
     */
    readonly project?: string;
    /**
     * Region where nodes using the node template will be created. If it is not provided, the provider region is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_template.html#region ComputeNodeTemplate#region}
     */
    readonly region?: string;
    /**
     * node_type_flexibility block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_template.html#node_type_flexibility ComputeNodeTemplate#node_type_flexibility}
     */
    readonly nodeTypeFlexibility?: ComputeNodeTemplateNodeTypeFlexibility;
    /**
     * server_binding block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_template.html#server_binding ComputeNodeTemplate#server_binding}
     */
    readonly serverBinding?: ComputeNodeTemplateServerBinding;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_template.html#timeouts ComputeNodeTemplate#timeouts}
     */
    readonly timeouts?: ComputeNodeTemplateTimeouts;
}
export interface ComputeNodeTemplateNodeTypeFlexibility {
    /**
     * Number of virtual CPUs to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_template.html#cpus ComputeNodeTemplate#cpus}
     */
    readonly cpus?: string;
    /**
     * Physical memory available to the node, defined in MB.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_template.html#memory ComputeNodeTemplate#memory}
     */
    readonly memory?: string;
}
export declare class ComputeNodeTemplateNodeTypeFlexibilityOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _cpus?;
    get cpus(): string | undefined;
    set cpus(value: string | undefined);
    resetCpus(): void;
    get cpusInput(): string | undefined;
    private _memory?;
    get memory(): string | undefined;
    set memory(value: string | undefined);
    resetMemory(): void;
    get memoryInput(): string | undefined;
}
export interface ComputeNodeTemplateServerBinding {
    /**
     * Type of server binding policy. If 'RESTART_NODE_ON_ANY_SERVER', nodes using this template will restart on any physical server following a maintenance event.
     *
     * If 'RESTART_NODE_ON_MINIMAL_SERVER', nodes using this template
     * will restart on the same physical server following a maintenance
     * event, instead of being live migrated to or restarted on a new
     * physical server. This option may be useful if you are using
     * software licenses tied to the underlying server characteristics
     * such as physical sockets or cores, to avoid the need for
     * additional licenses when maintenance occurs. However, VMs on such
     * nodes will experience outages while maintenance is applied. Possible values: ["RESTART_NODE_ON_ANY_SERVER", "RESTART_NODE_ON_MINIMAL_SERVERS"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_template.html#type ComputeNodeTemplate#type}
     */
    readonly type: string;
}
export declare class ComputeNodeTemplateServerBindingOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface ComputeNodeTemplateTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_template.html#create ComputeNodeTemplate#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_template.html#delete ComputeNodeTemplate#delete}.
     */
    readonly delete?: string;
}
export declare class ComputeNodeTemplateTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_node_template.html google_compute_node_template}.
 */
export declare class ComputeNodeTemplate extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_node_template.html google_compute_node_template} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config?: ComputeNodeTemplateConfig);
    private _cpuOvercommitType?;
    get cpuOvercommitType(): string | undefined;
    set cpuOvercommitType(value: string | undefined);
    resetCpuOvercommitType(): void;
    get cpuOvercommitTypeInput(): string | undefined;
    get creationTimestamp(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    resetName(): void;
    get nameInput(): string | undefined;
    private _nodeAffinityLabels?;
    get nodeAffinityLabels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set nodeAffinityLabels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetNodeAffinityLabels(): void;
    get nodeAffinityLabelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _nodeType?;
    get nodeType(): string | undefined;
    set nodeType(value: string | undefined);
    resetNodeType(): void;
    get nodeTypeInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string | undefined;
    set region(value: string | undefined);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get selfLink(): string;
    private _nodeTypeFlexibility?;
    private __nodeTypeFlexibilityOutput;
    get nodeTypeFlexibility(): ComputeNodeTemplateNodeTypeFlexibilityOutputReference;
    putNodeTypeFlexibility(value: ComputeNodeTemplateNodeTypeFlexibility | undefined): void;
    resetNodeTypeFlexibility(): void;
    get nodeTypeFlexibilityInput(): ComputeNodeTemplateNodeTypeFlexibility | undefined;
    private _serverBinding?;
    private __serverBindingOutput;
    get serverBinding(): ComputeNodeTemplateServerBindingOutputReference;
    putServerBinding(value: ComputeNodeTemplateServerBinding | undefined): void;
    resetServerBinding(): void;
    get serverBindingInput(): ComputeNodeTemplateServerBinding | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): ComputeNodeTemplateTimeoutsOutputReference;
    putTimeouts(value: ComputeNodeTemplateTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeNodeTemplateTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
