import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeNodeGroupConfig extends cdktf.TerraformMetaArguments {
    /**
     * An optional textual description of the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group.html#description ComputeNodeGroup#description}
     */
    readonly description?: string;
    /**
     * The initial number of nodes in the node group. One of 'initial_size' or 'size' must be specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group.html#initial_size ComputeNodeGroup#initial_size}
     */
    readonly initialSize?: number;
    /**
     * Specifies how to handle instances when a node in the group undergoes maintenance.
     *
     * Set to one of: DEFAULT, RESTART_IN_PLACE, or MIGRATE_WITHIN_NODE_GROUP. The default value is DEFAULT.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group.html#maintenance_policy ComputeNodeGroup#maintenance_policy}
     */
    readonly maintenancePolicy?: string;
    /**
     * Name of the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group.html#name ComputeNodeGroup#name}
     */
    readonly name?: string;
    /**
     * The URL of the node template to which this node group belongs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group.html#node_template ComputeNodeGroup#node_template}
     */
    readonly nodeTemplate: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group.html#project ComputeNodeGroup#project}.
     */
    readonly project?: string;
    /**
     * The total number of nodes in the node group. One of 'initial_size' or 'size' must be specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group.html#size ComputeNodeGroup#size}
     */
    readonly size?: number;
    /**
     * Zone where this node group is located.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group.html#zone ComputeNodeGroup#zone}
     */
    readonly zone?: string;
    /**
     * autoscaling_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group.html#autoscaling_policy ComputeNodeGroup#autoscaling_policy}
     */
    readonly autoscalingPolicy?: ComputeNodeGroupAutoscalingPolicy;
    /**
     * maintenance_window block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group.html#maintenance_window ComputeNodeGroup#maintenance_window}
     */
    readonly maintenanceWindow?: ComputeNodeGroupMaintenanceWindow;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group.html#timeouts ComputeNodeGroup#timeouts}
     */
    readonly timeouts?: ComputeNodeGroupTimeouts;
}
export interface ComputeNodeGroupAutoscalingPolicy {
    /**
     * Maximum size of the node group.
     *
     * Set to a value less than or equal
     * to 100 and greater than or equal to min-nodes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group.html#max_nodes ComputeNodeGroup#max_nodes}
     */
    readonly maxNodes?: number;
    /**
     * Minimum size of the node group. Must be less than or equal to max-nodes. The default value is 0.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group.html#min_nodes ComputeNodeGroup#min_nodes}
     */
    readonly minNodes?: number;
    /**
     * The autoscaling mode.
     *
     * Set to one of the following:
     * - OFF: Disables the autoscaler.
     * - ON: Enables scaling in and scaling out.
     * - ONLY_SCALE_OUT: Enables only scaling out.
     * You must use this mode if your node groups are configured to
     * restart their hosted VMs on minimal servers. Possible values: ["OFF", "ON", "ONLY_SCALE_OUT"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group.html#mode ComputeNodeGroup#mode}
     */
    readonly mode?: string;
}
export declare class ComputeNodeGroupAutoscalingPolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _maxNodes?;
    get maxNodes(): number | undefined;
    set maxNodes(value: number | undefined);
    resetMaxNodes(): void;
    get maxNodesInput(): number | undefined;
    private _minNodes?;
    get minNodes(): number | undefined;
    set minNodes(value: number | undefined);
    resetMinNodes(): void;
    get minNodesInput(): number | undefined;
    private _mode?;
    get mode(): string | undefined;
    set mode(value: string | undefined);
    resetMode(): void;
    get modeInput(): string | undefined;
}
export interface ComputeNodeGroupMaintenanceWindow {
    /**
     * instances.start time of the window. This must be in UTC format that resolves to one of 00:00, 04:00, 08:00, 12:00, 16:00, or 20:00. For example, both 13:00-5 and 08:00 are valid.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group.html#start_time ComputeNodeGroup#start_time}
     */
    readonly startTime: string;
}
export declare class ComputeNodeGroupMaintenanceWindowOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _startTime?;
    get startTime(): string;
    set startTime(value: string);
    get startTimeInput(): string | undefined;
}
export interface ComputeNodeGroupTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group.html#create ComputeNodeGroup#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group.html#delete ComputeNodeGroup#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group.html#update ComputeNodeGroup#update}.
     */
    readonly update?: string;
}
export declare class ComputeNodeGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_node_group.html google_compute_node_group}.
 */
export declare class ComputeNodeGroup extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_node_group.html google_compute_node_group} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: ComputeNodeGroupConfig);
    get creationTimestamp(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _initialSize?;
    get initialSize(): number | undefined;
    set initialSize(value: number | undefined);
    resetInitialSize(): void;
    get initialSizeInput(): number | undefined;
    private _maintenancePolicy?;
    get maintenancePolicy(): string | undefined;
    set maintenancePolicy(value: string | undefined);
    resetMaintenancePolicy(): void;
    get maintenancePolicyInput(): string | undefined;
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    resetName(): void;
    get nameInput(): string | undefined;
    private _nodeTemplate?;
    get nodeTemplate(): string;
    set nodeTemplate(value: string);
    get nodeTemplateInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    private _size?;
    get size(): number | undefined;
    set size(value: number | undefined);
    resetSize(): void;
    get sizeInput(): number | undefined;
    private _zone?;
    get zone(): string | undefined;
    set zone(value: string | undefined);
    resetZone(): void;
    get zoneInput(): string | undefined;
    private _autoscalingPolicy?;
    private __autoscalingPolicyOutput;
    get autoscalingPolicy(): ComputeNodeGroupAutoscalingPolicyOutputReference;
    putAutoscalingPolicy(value: ComputeNodeGroupAutoscalingPolicy | undefined): void;
    resetAutoscalingPolicy(): void;
    get autoscalingPolicyInput(): ComputeNodeGroupAutoscalingPolicy | undefined;
    private _maintenanceWindow?;
    private __maintenanceWindowOutput;
    get maintenanceWindow(): ComputeNodeGroupMaintenanceWindowOutputReference;
    putMaintenanceWindow(value: ComputeNodeGroupMaintenanceWindow | undefined): void;
    resetMaintenanceWindow(): void;
    get maintenanceWindowInput(): ComputeNodeGroupMaintenanceWindow | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): ComputeNodeGroupTimeoutsOutputReference;
    putTimeouts(value: ComputeNodeGroupTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeNodeGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
