import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeNetworkConfig extends cdktf.TerraformMetaArguments {
    /**
     * When set to 'true', the network is created in "auto subnet mode" and it will create a subnet for each region automatically across the '10.128.0.0/9' address range.
     *
     * When set to 'false', the network is created in "custom subnet mode" so
     * the user can explicitly connect subnetwork resources.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network.html#auto_create_subnetworks ComputeNetwork#auto_create_subnetworks}
     */
    readonly autoCreateSubnetworks?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network.html#delete_default_routes_on_create ComputeNetwork#delete_default_routes_on_create}.
     */
    readonly deleteDefaultRoutesOnCreate?: boolean | cdktf.IResolvable;
    /**
     * An optional description of this resource. The resource must be recreated to modify this field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network.html#description ComputeNetwork#description}
     */
    readonly description?: string;
    /**
     * Maximum Transmission Unit in bytes. The minimum value for this field is 1460 and the maximum value is 1500 bytes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network.html#mtu ComputeNetwork#mtu}
     */
    readonly mtu?: number;
    /**
     * Name of the resource.
     *
     * Provided by the client when the resource is
     * created. The name must be 1-63 characters long, and comply with
     * RFC1035. Specifically, the name must be 1-63 characters long and match
     * the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
     * first character must be a lowercase letter, and all following
     * characters must be a dash, lowercase letter, or digit, except the last
     * character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network.html#name ComputeNetwork#name}
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network.html#project ComputeNetwork#project}.
     */
    readonly project?: string;
    /**
     * The network-wide routing mode to use.
     *
     * If set to 'REGIONAL', this
     * network's cloud routers will only advertise routes with subnetworks
     * of this network in the same region as the router. If set to 'GLOBAL',
     * this network's cloud routers will advertise routes with all
     * subnetworks of this network, across regions. Possible values: ["REGIONAL", "GLOBAL"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network.html#routing_mode ComputeNetwork#routing_mode}
     */
    readonly routingMode?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network.html#timeouts ComputeNetwork#timeouts}
     */
    readonly timeouts?: ComputeNetworkTimeouts;
}
export interface ComputeNetworkTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network.html#create ComputeNetwork#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network.html#delete ComputeNetwork#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network.html#update ComputeNetwork#update}.
     */
    readonly update?: string;
}
export declare class ComputeNetworkTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_network.html google_compute_network}.
 */
export declare class ComputeNetwork extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_network.html google_compute_network} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: ComputeNetworkConfig);
    private _autoCreateSubnetworks?;
    get autoCreateSubnetworks(): boolean | cdktf.IResolvable | undefined;
    set autoCreateSubnetworks(value: boolean | cdktf.IResolvable | undefined);
    resetAutoCreateSubnetworks(): void;
    get autoCreateSubnetworksInput(): boolean | cdktf.IResolvable | undefined;
    private _deleteDefaultRoutesOnCreate?;
    get deleteDefaultRoutesOnCreate(): boolean | cdktf.IResolvable | undefined;
    set deleteDefaultRoutesOnCreate(value: boolean | cdktf.IResolvable | undefined);
    resetDeleteDefaultRoutesOnCreate(): void;
    get deleteDefaultRoutesOnCreateInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get gatewayIpv4(): string;
    get id(): string;
    private _mtu?;
    get mtu(): number | undefined;
    set mtu(value: number | undefined);
    resetMtu(): void;
    get mtuInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _routingMode?;
    get routingMode(): string | undefined;
    set routingMode(value: string | undefined);
    resetRoutingMode(): void;
    get routingModeInput(): string | undefined;
    get selfLink(): string;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): ComputeNetworkTimeoutsOutputReference;
    putTimeouts(value: ComputeNetworkTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeNetworkTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
