import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeNetworkPeeringConfig extends cdktf.TerraformMetaArguments {
    /**
     * Whether to export the custom routes to the peer network. Defaults to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering.html#export_custom_routes ComputeNetworkPeering#export_custom_routes}
     */
    readonly exportCustomRoutes?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering.html#export_subnet_routes_with_public_ip ComputeNetworkPeering#export_subnet_routes_with_public_ip}.
     */
    readonly exportSubnetRoutesWithPublicIp?: boolean | cdktf.IResolvable;
    /**
     * Whether to export the custom routes from the peer network. Defaults to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering.html#import_custom_routes ComputeNetworkPeering#import_custom_routes}
     */
    readonly importCustomRoutes?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering.html#import_subnet_routes_with_public_ip ComputeNetworkPeering#import_subnet_routes_with_public_ip}.
     */
    readonly importSubnetRoutesWithPublicIp?: boolean | cdktf.IResolvable;
    /**
     * Name of the peering.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering.html#name ComputeNetworkPeering#name}
     */
    readonly name: string;
    /**
     * The primary network of the peering.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering.html#network ComputeNetworkPeering#network}
     */
    readonly network: string;
    /**
     * The peer network in the peering. The peer network may belong to a different project.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering.html#peer_network ComputeNetworkPeering#peer_network}
     */
    readonly peerNetwork: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering.html#timeouts ComputeNetworkPeering#timeouts}
     */
    readonly timeouts?: ComputeNetworkPeeringTimeouts;
}
export interface ComputeNetworkPeeringTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering.html#create ComputeNetworkPeering#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering.html#delete ComputeNetworkPeering#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering.html#update ComputeNetworkPeering#update}.
     */
    readonly update?: string;
}
export declare class ComputeNetworkPeeringTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering.html google_compute_network_peering}.
 */
export declare class ComputeNetworkPeering extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering.html google_compute_network_peering} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: ComputeNetworkPeeringConfig);
    private _exportCustomRoutes?;
    get exportCustomRoutes(): boolean | cdktf.IResolvable | undefined;
    set exportCustomRoutes(value: boolean | cdktf.IResolvable | undefined);
    resetExportCustomRoutes(): void;
    get exportCustomRoutesInput(): boolean | cdktf.IResolvable | undefined;
    private _exportSubnetRoutesWithPublicIp?;
    get exportSubnetRoutesWithPublicIp(): boolean | cdktf.IResolvable | undefined;
    set exportSubnetRoutesWithPublicIp(value: boolean | cdktf.IResolvable | undefined);
    resetExportSubnetRoutesWithPublicIp(): void;
    get exportSubnetRoutesWithPublicIpInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _importCustomRoutes?;
    get importCustomRoutes(): boolean | cdktf.IResolvable | undefined;
    set importCustomRoutes(value: boolean | cdktf.IResolvable | undefined);
    resetImportCustomRoutes(): void;
    get importCustomRoutesInput(): boolean | cdktf.IResolvable | undefined;
    private _importSubnetRoutesWithPublicIp?;
    get importSubnetRoutesWithPublicIp(): boolean | cdktf.IResolvable | undefined;
    set importSubnetRoutesWithPublicIp(value: boolean | cdktf.IResolvable | undefined);
    resetImportSubnetRoutesWithPublicIp(): void;
    get importSubnetRoutesWithPublicIpInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    get networkInput(): string | undefined;
    private _peerNetwork?;
    get peerNetwork(): string;
    set peerNetwork(value: string);
    get peerNetworkInput(): string | undefined;
    get state(): string;
    get stateDetails(): string;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): ComputeNetworkPeeringTimeoutsOutputReference;
    putTimeouts(value: ComputeNetworkPeeringTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeNetworkPeeringTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
