import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeNetworkPeeringRoutesConfigConfig extends cdktf.TerraformMetaArguments {
    /**
     * Whether to export the custom routes to the peer network.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering_routes_config.html#export_custom_routes ComputeNetworkPeeringRoutesConfig#export_custom_routes}
     */
    readonly exportCustomRoutes: boolean | cdktf.IResolvable;
    /**
     * Whether to import the custom routes to the peer network.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering_routes_config.html#import_custom_routes ComputeNetworkPeeringRoutesConfig#import_custom_routes}
     */
    readonly importCustomRoutes: boolean | cdktf.IResolvable;
    /**
     * The name of the primary network for the peering.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering_routes_config.html#network ComputeNetworkPeeringRoutesConfig#network}
     */
    readonly network: string;
    /**
     * Name of the peering.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering_routes_config.html#peering ComputeNetworkPeeringRoutesConfig#peering}
     */
    readonly peering: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering_routes_config.html#project ComputeNetworkPeeringRoutesConfig#project}.
     */
    readonly project?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering_routes_config.html#timeouts ComputeNetworkPeeringRoutesConfig#timeouts}
     */
    readonly timeouts?: ComputeNetworkPeeringRoutesConfigTimeouts;
}
export interface ComputeNetworkPeeringRoutesConfigTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering_routes_config.html#create ComputeNetworkPeeringRoutesConfig#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering_routes_config.html#delete ComputeNetworkPeeringRoutesConfig#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering_routes_config.html#update ComputeNetworkPeeringRoutesConfig#update}.
     */
    readonly update?: string;
}
export declare class ComputeNetworkPeeringRoutesConfigTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering_routes_config.html google_compute_network_peering_routes_config}.
 */
export declare class ComputeNetworkPeeringRoutesConfig extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering_routes_config.html google_compute_network_peering_routes_config} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: ComputeNetworkPeeringRoutesConfigConfig);
    private _exportCustomRoutes?;
    get exportCustomRoutes(): boolean | cdktf.IResolvable;
    set exportCustomRoutes(value: boolean | cdktf.IResolvable);
    get exportCustomRoutesInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _importCustomRoutes?;
    get importCustomRoutes(): boolean | cdktf.IResolvable;
    set importCustomRoutes(value: boolean | cdktf.IResolvable);
    get importCustomRoutesInput(): boolean | cdktf.IResolvable | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    get networkInput(): string | undefined;
    private _peering?;
    get peering(): string;
    set peering(value: string);
    get peeringInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): ComputeNetworkPeeringRoutesConfigTimeoutsOutputReference;
    putTimeouts(value: ComputeNetworkPeeringRoutesConfigTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeNetworkPeeringRoutesConfigTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
