import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeNetworkEndpointGroupConfig extends cdktf.TerraformMetaArguments {
    /**
     * The default port used if the port number is not specified in the network endpoint.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_endpoint_group.html#default_port ComputeNetworkEndpointGroup#default_port}
     */
    readonly defaultPort?: number;
    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_endpoint_group.html#description ComputeNetworkEndpointGroup#description}
     */
    readonly description?: string;
    /**
     * Name of the resource;
     *
     * provided by the client when the resource is
     * created. The name must be 1-63 characters long, and comply with
     * RFC1035. Specifically, the name must be 1-63 characters long and match
     * the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
     * first character must be a lowercase letter, and all following
     * characters must be a dash, lowercase letter, or digit, except the last
     * character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_endpoint_group.html#name ComputeNetworkEndpointGroup#name}
     */
    readonly name: string;
    /**
     * The network to which all network endpoints in the NEG belong. Uses "default" project network if unspecified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_endpoint_group.html#network ComputeNetworkEndpointGroup#network}
     */
    readonly network: string;
    /**
     * Type of network endpoints in this network endpoint group. Default value: "GCE_VM_IP_PORT" Possible values: ["GCE_VM_IP_PORT"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_endpoint_group.html#network_endpoint_type ComputeNetworkEndpointGroup#network_endpoint_type}
     */
    readonly networkEndpointType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_endpoint_group.html#project ComputeNetworkEndpointGroup#project}.
     */
    readonly project?: string;
    /**
     * Optional subnetwork to which all network endpoints in the NEG belong.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_endpoint_group.html#subnetwork ComputeNetworkEndpointGroup#subnetwork}
     */
    readonly subnetwork?: string;
    /**
     * Zone where the network endpoint group is located.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_endpoint_group.html#zone ComputeNetworkEndpointGroup#zone}
     */
    readonly zone?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_endpoint_group.html#timeouts ComputeNetworkEndpointGroup#timeouts}
     */
    readonly timeouts?: ComputeNetworkEndpointGroupTimeouts;
}
export interface ComputeNetworkEndpointGroupTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_endpoint_group.html#create ComputeNetworkEndpointGroup#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_endpoint_group.html#delete ComputeNetworkEndpointGroup#delete}.
     */
    readonly delete?: string;
}
export declare class ComputeNetworkEndpointGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_network_endpoint_group.html google_compute_network_endpoint_group}.
 */
export declare class ComputeNetworkEndpointGroup extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_network_endpoint_group.html google_compute_network_endpoint_group} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: ComputeNetworkEndpointGroupConfig);
    private _defaultPort?;
    get defaultPort(): number | undefined;
    set defaultPort(value: number | undefined);
    resetDefaultPort(): void;
    get defaultPortInput(): number | undefined;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    get networkInput(): string | undefined;
    private _networkEndpointType?;
    get networkEndpointType(): string | undefined;
    set networkEndpointType(value: string | undefined);
    resetNetworkEndpointType(): void;
    get networkEndpointTypeInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    get size(): number;
    private _subnetwork?;
    get subnetwork(): string | undefined;
    set subnetwork(value: string | undefined);
    resetSubnetwork(): void;
    get subnetworkInput(): string | undefined;
    private _zone?;
    get zone(): string | undefined;
    set zone(value: string | undefined);
    resetZone(): void;
    get zoneInput(): string | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): ComputeNetworkEndpointGroupTimeoutsOutputReference;
    putTimeouts(value: ComputeNetworkEndpointGroupTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeNetworkEndpointGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
