import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeManagedSslCertificateConfig extends cdktf.TerraformMetaArguments {
    /**
     * The unique identifier for the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_managed_ssl_certificate.html#certificate_id ComputeManagedSslCertificate#certificate_id}
     */
    readonly certificateId?: number;
    /**
     * An optional description of this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_managed_ssl_certificate.html#description ComputeManagedSslCertificate#description}
     */
    readonly description?: string;
    /**
     * Name of the resource.
     *
     * Provided by the client when the resource is
     * created. The name must be 1-63 characters long, and comply with
     * RFC1035. Specifically, the name must be 1-63 characters long and match
     * the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
     * first character must be a lowercase letter, and all following
     * characters must be a dash, lowercase letter, or digit, except the last
     * character, which cannot be a dash.
     *
     *
     * These are in the same namespace as the managed SSL certificates.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_managed_ssl_certificate.html#name ComputeManagedSslCertificate#name}
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_managed_ssl_certificate.html#project ComputeManagedSslCertificate#project}.
     */
    readonly project?: string;
    /**
     * Enum field whose value is always 'MANAGED' - used to signal to the API which type this is.
     *
     * Default value: "MANAGED" Possible values: ["MANAGED"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_managed_ssl_certificate.html#type ComputeManagedSslCertificate#type}
     */
    readonly type?: string;
    /**
     * managed block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_managed_ssl_certificate.html#managed ComputeManagedSslCertificate#managed}
     */
    readonly managed?: ComputeManagedSslCertificateManaged;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_managed_ssl_certificate.html#timeouts ComputeManagedSslCertificate#timeouts}
     */
    readonly timeouts?: ComputeManagedSslCertificateTimeouts;
}
export interface ComputeManagedSslCertificateManaged {
    /**
     * Domains for which a managed SSL certificate will be valid.
     *
     * Currently,
     * there can be up to 100 domains in this list.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_managed_ssl_certificate.html#domains ComputeManagedSslCertificate#domains}
     */
    readonly domains: string[];
}
export declare class ComputeManagedSslCertificateManagedOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _domains?;
    get domains(): string[];
    set domains(value: string[]);
    get domainsInput(): string[] | undefined;
}
export interface ComputeManagedSslCertificateTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_managed_ssl_certificate.html#create ComputeManagedSslCertificate#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_managed_ssl_certificate.html#delete ComputeManagedSslCertificate#delete}.
     */
    readonly delete?: string;
}
export declare class ComputeManagedSslCertificateTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_managed_ssl_certificate.html google_compute_managed_ssl_certificate}.
 */
export declare class ComputeManagedSslCertificate extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_managed_ssl_certificate.html google_compute_managed_ssl_certificate} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config?: ComputeManagedSslCertificateConfig);
    private _certificateId?;
    get certificateId(): number | undefined;
    set certificateId(value: number | undefined);
    resetCertificateId(): void;
    get certificateIdInput(): number | undefined;
    get creationTimestamp(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get expireTime(): string;
    get id(): string;
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    resetName(): void;
    get nameInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    get subjectAlternativeNames(): string[];
    private _type?;
    get type(): string | undefined;
    set type(value: string | undefined);
    resetType(): void;
    get typeInput(): string | undefined;
    private _managed?;
    private __managedOutput;
    get managed(): ComputeManagedSslCertificateManagedOutputReference;
    putManaged(value: ComputeManagedSslCertificateManaged | undefined): void;
    resetManaged(): void;
    get managedInput(): ComputeManagedSslCertificateManaged | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): ComputeManagedSslCertificateTimeoutsOutputReference;
    putTimeouts(value: ComputeManagedSslCertificateTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeManagedSslCertificateTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
