import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeInterconnectAttachmentConfig extends cdktf.TerraformMetaArguments {
    /**
     * Whether the VLAN attachment is enabled or disabled.  When using PARTNER type this will Pre-Activate the interconnect attachment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment.html#admin_enabled ComputeInterconnectAttachment#admin_enabled}
     */
    readonly adminEnabled?: boolean | cdktf.IResolvable;
    /**
     * Provisioned bandwidth capacity for the interconnect attachment.
     *
     * For attachments of type DEDICATED, the user can set the bandwidth.
     * For attachments of type PARTNER, the Google Partner that is operating the interconnect must set the bandwidth.
     * Output only for PARTNER type, mutable for PARTNER_PROVIDER and DEDICATED,
     * Defaults to BPS_10G Possible values: ["BPS_50M", "BPS_100M", "BPS_200M", "BPS_300M", "BPS_400M", "BPS_500M", "BPS_1G", "BPS_2G", "BPS_5G", "BPS_10G", "BPS_20G", "BPS_50G"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment.html#bandwidth ComputeInterconnectAttachment#bandwidth}
     */
    readonly bandwidth?: string;
    /**
     * Up to 16 candidate prefixes that can be used to restrict the allocation of cloudRouterIpAddress and customerRouterIpAddress for this attachment.
     *
     * All prefixes must be within link-local address space (169.254.0.0/16)
     * and must be /29 or shorter (/28, /27, etc). Google will attempt to select
     * an unused /29 from the supplied candidate prefix(es). The request will
     * fail if all possible /29s are in use on Google's edge. If not supplied,
     * Google will randomly select an unused /29 from all of link-local space.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment.html#candidate_subnets ComputeInterconnectAttachment#candidate_subnets}
     */
    readonly candidateSubnets?: string[];
    /**
     * An optional description of this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment.html#description ComputeInterconnectAttachment#description}
     */
    readonly description?: string;
    /**
     * Desired availability domain for the attachment.
     *
     * Only available for type
     * PARTNER, at creation time. For improved reliability, customers should
     * configure a pair of attachments with one per availability domain. The
     * selected availability domain will be provided to the Partner via the
     * pairing key so that the provisioned circuit will lie in the specified
     * domain. If not specified, the value will default to AVAILABILITY_DOMAIN_ANY.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment.html#edge_availability_domain ComputeInterconnectAttachment#edge_availability_domain}
     */
    readonly edgeAvailabilityDomain?: string;
    /**
     * Indicates the user-supplied encryption option of this interconnect attachment:.
     *
     * NONE is the default value, which means that the attachment carries
     * unencrypted traffic. VMs can send traffic to, or receive traffic
     * from, this type of attachment.
     *
     * IPSEC indicates that the attachment carries only traffic encrypted by
     * an IPsec device such as an HA VPN gateway. VMs cannot directly send
     * traffic to, or receive traffic from, such an attachment. To use
     * IPsec-encrypted Cloud Interconnect create the attachment using this
     * option.
     *
     * Not currently available publicly. Default value: "NONE" Possible values: ["NONE", "IPSEC"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment.html#encryption ComputeInterconnectAttachment#encryption}
     */
    readonly encryption?: string;
    /**
     * URL of the underlying Interconnect object that this attachment's traffic will traverse through.
     *
     * Required if type is DEDICATED, must not
     * be set if type is PARTNER.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment.html#interconnect ComputeInterconnectAttachment#interconnect}
     */
    readonly interconnect?: string;
    /**
     * URL of addresses that have been reserved for the interconnect attachment, Used only for interconnect attachment that has the encryption option as IPSEC.
     *
     * The addresses must be RFC 1918 IP address ranges. When creating HA
     * VPN gateway over the interconnect attachment, if the attachment is
     * configured to use an RFC 1918 IP address, then the VPN gateway's IP
     * address will be allocated from the IP address range specified
     * here.
     *
     * For example, if the HA VPN gateway's interface 0 is paired to this
     * interconnect attachment, then an RFC 1918 IP address for the VPN
     * gateway interface 0 will be allocated from the IP address specified
     * for this interconnect attachment.
     *
     * If this field is not specified for interconnect attachment that has
     * encryption option as IPSEC, later on when creating HA VPN gateway on
     * this interconnect attachment, the HA VPN gateway's IP address will be
     * allocated from regional external IP address pool.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment.html#ipsec_internal_addresses ComputeInterconnectAttachment#ipsec_internal_addresses}
     */
    readonly ipsecInternalAddresses?: string[];
    /**
     * Maximum Transmission Unit (MTU), in bytes, of packets passing through this interconnect attachment.
     *
     * Currently, only 1440 and 1500 are allowed. If not specified, the value will default to 1440.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment.html#mtu ComputeInterconnectAttachment#mtu}
     */
    readonly mtu?: string;
    /**
     * Name of the resource.
     *
     * Provided by the client when the resource is created. The
     * name must be 1-63 characters long, and comply with RFC1035. Specifically, the
     * name must be 1-63 characters long and match the regular expression
     * '[a-z]([-a-z0-9]*[a-z0-9])?' which means the first character must be a
     * lowercase letter, and all following characters must be a dash, lowercase
     * letter, or digit, except the last character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment.html#name ComputeInterconnectAttachment#name}
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment.html#project ComputeInterconnectAttachment#project}.
     */
    readonly project?: string;
    /**
     * Region where the regional interconnect attachment resides.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment.html#region ComputeInterconnectAttachment#region}
     */
    readonly region?: string;
    /**
     * URL of the cloud router to be used for dynamic routing.
     *
     * This router must be in
     * the same region as this InterconnectAttachment. The InterconnectAttachment will
     * automatically connect the Interconnect to the network & region within which the
     * Cloud Router is configured.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment.html#router ComputeInterconnectAttachment#router}
     */
    readonly router: string;
    /**
     * The type of InterconnectAttachment you wish to create. Defaults to DEDICATED. Possible values: ["DEDICATED", "PARTNER", "PARTNER_PROVIDER"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment.html#type ComputeInterconnectAttachment#type}
     */
    readonly type?: string;
    /**
     * The IEEE 802.1Q VLAN tag for this attachment, in the range 2-4094. When using PARTNER type this will be managed upstream.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment.html#vlan_tag8021q ComputeInterconnectAttachment#vlan_tag8021q}
     */
    readonly vlanTag8021Q?: number;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment.html#timeouts ComputeInterconnectAttachment#timeouts}
     */
    readonly timeouts?: ComputeInterconnectAttachmentTimeouts;
}
export declare class ComputeInterconnectAttachmentPrivateInterconnectInfo extends cdktf.ComplexComputedList {
    get tag8021Q(): number;
}
export interface ComputeInterconnectAttachmentTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment.html#create ComputeInterconnectAttachment#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment.html#delete ComputeInterconnectAttachment#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment.html#update ComputeInterconnectAttachment#update}.
     */
    readonly update?: string;
}
export declare class ComputeInterconnectAttachmentTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment.html google_compute_interconnect_attachment}.
 */
export declare class ComputeInterconnectAttachment extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_interconnect_attachment.html google_compute_interconnect_attachment} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: ComputeInterconnectAttachmentConfig);
    private _adminEnabled?;
    get adminEnabled(): boolean | cdktf.IResolvable | undefined;
    set adminEnabled(value: boolean | cdktf.IResolvable | undefined);
    resetAdminEnabled(): void;
    get adminEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _bandwidth?;
    get bandwidth(): string | undefined;
    set bandwidth(value: string | undefined);
    resetBandwidth(): void;
    get bandwidthInput(): string | undefined;
    private _candidateSubnets?;
    get candidateSubnets(): string[] | undefined;
    set candidateSubnets(value: string[] | undefined);
    resetCandidateSubnets(): void;
    get candidateSubnetsInput(): string[] | undefined;
    get cloudRouterIpAddress(): string;
    get creationTimestamp(): string;
    get customerRouterIpAddress(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _edgeAvailabilityDomain?;
    get edgeAvailabilityDomain(): string | undefined;
    set edgeAvailabilityDomain(value: string | undefined);
    resetEdgeAvailabilityDomain(): void;
    get edgeAvailabilityDomainInput(): string | undefined;
    private _encryption?;
    get encryption(): string | undefined;
    set encryption(value: string | undefined);
    resetEncryption(): void;
    get encryptionInput(): string | undefined;
    get googleReferenceId(): string;
    get id(): string;
    private _interconnect?;
    get interconnect(): string | undefined;
    set interconnect(value: string | undefined);
    resetInterconnect(): void;
    get interconnectInput(): string | undefined;
    private _ipsecInternalAddresses?;
    get ipsecInternalAddresses(): string[] | undefined;
    set ipsecInternalAddresses(value: string[] | undefined);
    resetIpsecInternalAddresses(): void;
    get ipsecInternalAddressesInput(): string[] | undefined;
    private _mtu?;
    get mtu(): string | undefined;
    set mtu(value: string | undefined);
    resetMtu(): void;
    get mtuInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get pairingKey(): string;
    get partnerAsn(): string;
    privateInterconnectInfo(index: string): ComputeInterconnectAttachmentPrivateInterconnectInfo;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string | undefined;
    set region(value: string | undefined);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _router?;
    get router(): string;
    set router(value: string);
    get routerInput(): string | undefined;
    get selfLink(): string;
    get state(): string;
    private _type?;
    get type(): string | undefined;
    set type(value: string | undefined);
    resetType(): void;
    get typeInput(): string | undefined;
    private _vlanTag8021Q?;
    get vlanTag8021Q(): number | undefined;
    set vlanTag8021Q(value: number | undefined);
    resetVlanTag8021Q(): void;
    get vlanTag8021QInput(): number | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): ComputeInterconnectAttachmentTimeoutsOutputReference;
    putTimeouts(value: ComputeInterconnectAttachmentTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeInterconnectAttachmentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
