import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
     * If true, allows Terraform to stop the instance to update its properties.
     *
     * If you try to update a property that requires stopping the instance without setting this field, the update will fail.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#allow_stopping_for_update ComputeInstance#allow_stopping_for_update}
     */
    readonly allowStoppingForUpdate?: boolean | cdktf.IResolvable;
    /**
     * Whether sending and receiving of packets with non-matching source or destination IPs is allowed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#can_ip_forward ComputeInstance#can_ip_forward}
     */
    readonly canIpForward?: boolean | cdktf.IResolvable;
    /**
     * Whether deletion protection is enabled on this instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#deletion_protection ComputeInstance#deletion_protection}
     */
    readonly deletionProtection?: boolean | cdktf.IResolvable;
    /**
     * A brief description of the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#description ComputeInstance#description}
     */
    readonly description?: string;
    /**
     * Desired status of the instance. Either "RUNNING" or "TERMINATED".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#desired_status ComputeInstance#desired_status}
     */
    readonly desiredStatus?: string;
    /**
     * Whether the instance has virtual displays enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#enable_display ComputeInstance#enable_display}
     */
    readonly enableDisplay?: boolean | cdktf.IResolvable;
    /**
     * List of the type and count of accelerator cards attached to the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#guest_accelerator ComputeInstance#guest_accelerator}
     */
    readonly guestAccelerator?: ComputeInstanceGuestAccelerator[];
    /**
     * A custom hostname for the instance.
     *
     * Must be a fully qualified DNS name and RFC-1035-valid. Valid format is a series of labels 1-63 characters long matching the regular expression [a-z]([-a-z0-9]*[a-z0-9]), concatenated with periods. The entire hostname must not exceed 253 characters. Changing this forces a new resource to be created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#hostname ComputeInstance#hostname}
     */
    readonly hostname?: string;
    /**
     * A set of key/value label pairs assigned to the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#labels ComputeInstance#labels}
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The machine type to create.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#machine_type ComputeInstance#machine_type}
     */
    readonly machineType: string;
    /**
     * Metadata key/value pairs made available within the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#metadata ComputeInstance#metadata}
     */
    readonly metadata?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Metadata startup scripts made available within the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#metadata_startup_script ComputeInstance#metadata_startup_script}
     */
    readonly metadataStartupScript?: string;
    /**
     * The minimum CPU platform specified for the VM instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#min_cpu_platform ComputeInstance#min_cpu_platform}
     */
    readonly minCpuPlatform?: string;
    /**
     * The name of the instance. One of name or self_link must be provided.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#name ComputeInstance#name}
     */
    readonly name: string;
    /**
     * The ID of the project in which the resource belongs.
     *
     * If self_link is provided, this value is ignored. If neither self_link nor project are provided, the provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#project ComputeInstance#project}
     */
    readonly project?: string;
    /**
     * A list of short names or self_links of resource policies to attach to the instance.
     *
     * Currently a max of 1 resource policy is supported.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#resource_policies ComputeInstance#resource_policies}
     */
    readonly resourcePolicies?: string[];
    /**
     * The list of tags attached to the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#tags ComputeInstance#tags}
     */
    readonly tags?: string[];
    /**
     * The zone of the instance.
     *
     * If self_link is provided, this value is ignored. If neither self_link nor zone are provided, the provider zone is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#zone ComputeInstance#zone}
     */
    readonly zone?: string;
    /**
     * advanced_machine_features block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#advanced_machine_features ComputeInstance#advanced_machine_features}
     */
    readonly advancedMachineFeatures?: ComputeInstanceAdvancedMachineFeatures;
    /**
     * attached_disk block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#attached_disk ComputeInstance#attached_disk}
     */
    readonly attachedDisk?: ComputeInstanceAttachedDisk[];
    /**
     * boot_disk block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#boot_disk ComputeInstance#boot_disk}
     */
    readonly bootDisk: ComputeInstanceBootDisk;
    /**
     * confidential_instance_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#confidential_instance_config ComputeInstance#confidential_instance_config}
     */
    readonly confidentialInstanceConfig?: ComputeInstanceConfidentialInstanceConfig;
    /**
     * network_interface block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#network_interface ComputeInstance#network_interface}
     */
    readonly networkInterface: ComputeInstanceNetworkInterface[];
    /**
     * reservation_affinity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#reservation_affinity ComputeInstance#reservation_affinity}
     */
    readonly reservationAffinity?: ComputeInstanceReservationAffinity;
    /**
     * scheduling block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#scheduling ComputeInstance#scheduling}
     */
    readonly scheduling?: ComputeInstanceScheduling;
    /**
     * scratch_disk block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#scratch_disk ComputeInstance#scratch_disk}
     */
    readonly scratchDisk?: ComputeInstanceScratchDisk[];
    /**
     * service_account block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#service_account ComputeInstance#service_account}
     */
    readonly serviceAccount?: ComputeInstanceServiceAccount;
    /**
     * shielded_instance_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#shielded_instance_config ComputeInstance#shielded_instance_config}
     */
    readonly shieldedInstanceConfig?: ComputeInstanceShieldedInstanceConfig;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#timeouts ComputeInstance#timeouts}
     */
    readonly timeouts?: ComputeInstanceTimeouts;
}
export interface ComputeInstanceGuestAccelerator {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#count ComputeInstance#count}.
     */
    readonly count?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#type ComputeInstance#type}.
     */
    readonly type?: string;
}
export interface ComputeInstanceAdvancedMachineFeatures {
    /**
     * Whether to enable nested virtualization or not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#enable_nested_virtualization ComputeInstance#enable_nested_virtualization}
     */
    readonly enableNestedVirtualization?: boolean | cdktf.IResolvable;
    /**
     * The number of threads per physical core.
     *
     * To disable simultaneous multithreading (SMT) set this to 1. If unset, the maximum number of threads supported per core by the underlying processor is assumed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#threads_per_core ComputeInstance#threads_per_core}
     */
    readonly threadsPerCore?: number;
}
export declare class ComputeInstanceAdvancedMachineFeaturesOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _enableNestedVirtualization?;
    get enableNestedVirtualization(): boolean | cdktf.IResolvable | undefined;
    set enableNestedVirtualization(value: boolean | cdktf.IResolvable | undefined);
    resetEnableNestedVirtualization(): void;
    get enableNestedVirtualizationInput(): boolean | cdktf.IResolvable | undefined;
    private _threadsPerCore?;
    get threadsPerCore(): number | undefined;
    set threadsPerCore(value: number | undefined);
    resetThreadsPerCore(): void;
    get threadsPerCoreInput(): number | undefined;
}
export interface ComputeInstanceAttachedDisk {
    /**
     * Name with which the attached disk is accessible under /dev/disk/by-id/.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#device_name ComputeInstance#device_name}
     */
    readonly deviceName?: string;
    /**
     * A 256-bit customer-supplied encryption key, encoded in RFC 4648 base64 to encrypt this disk.
     *
     * Only one of kms_key_self_link and disk_encryption_key_raw may be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#disk_encryption_key_raw ComputeInstance#disk_encryption_key_raw}
     */
    readonly diskEncryptionKeyRaw?: string;
    /**
     * The self_link of the encryption key that is stored in Google Cloud KMS to encrypt this disk.
     *
     * Only one of kms_key_self_link and disk_encryption_key_raw may be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#kms_key_self_link ComputeInstance#kms_key_self_link}
     */
    readonly kmsKeySelfLink?: string;
    /**
     * Read/write mode for the disk. One of "READ_ONLY" or "READ_WRITE".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#mode ComputeInstance#mode}
     */
    readonly mode?: string;
    /**
     * The name or self_link of the disk attached to this instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#source ComputeInstance#source}
     */
    readonly source: string;
}
export interface ComputeInstanceBootDiskInitializeParams {
    /**
     * The image from which this disk was initialised.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#image ComputeInstance#image}
     */
    readonly image?: string;
    /**
     * A set of key/value label pairs assigned to the disk.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#labels ComputeInstance#labels}
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The size of the image in gigabytes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#size ComputeInstance#size}
     */
    readonly size?: number;
    /**
     * The Google Compute Engine disk type. One of pd-standard, pd-ssd or pd-balanced.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#type ComputeInstance#type}
     */
    readonly type?: string;
}
export declare class ComputeInstanceBootDiskInitializeParamsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _image?;
    get image(): string | undefined;
    set image(value: string | undefined);
    resetImage(): void;
    get imageInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _size?;
    get size(): number | undefined;
    set size(value: number | undefined);
    resetSize(): void;
    get sizeInput(): number | undefined;
    private _type?;
    get type(): string | undefined;
    set type(value: string | undefined);
    resetType(): void;
    get typeInput(): string | undefined;
}
export interface ComputeInstanceBootDisk {
    /**
     * Whether the disk will be auto-deleted when the instance is deleted.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#auto_delete ComputeInstance#auto_delete}
     */
    readonly autoDelete?: boolean | cdktf.IResolvable;
    /**
     * Name with which attached disk will be accessible under /dev/disk/by-id/.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#device_name ComputeInstance#device_name}
     */
    readonly deviceName?: string;
    /**
     * A 256-bit customer-supplied encryption key, encoded in RFC 4648 base64 to encrypt this disk.
     *
     * Only one of kms_key_self_link and disk_encryption_key_raw may be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#disk_encryption_key_raw ComputeInstance#disk_encryption_key_raw}
     */
    readonly diskEncryptionKeyRaw?: string;
    /**
     * The self_link of the encryption key that is stored in Google Cloud KMS to encrypt this disk.
     *
     * Only one of kms_key_self_link and disk_encryption_key_raw may be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#kms_key_self_link ComputeInstance#kms_key_self_link}
     */
    readonly kmsKeySelfLink?: string;
    /**
     * Read/write mode for the disk. One of "READ_ONLY" or "READ_WRITE".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#mode ComputeInstance#mode}
     */
    readonly mode?: string;
    /**
     * The name or self_link of the disk attached to this instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#source ComputeInstance#source}
     */
    readonly source?: string;
    /**
     * initialize_params block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#initialize_params ComputeInstance#initialize_params}
     */
    readonly initializeParams?: ComputeInstanceBootDiskInitializeParams;
}
export declare class ComputeInstanceBootDiskOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _autoDelete?;
    get autoDelete(): boolean | cdktf.IResolvable | undefined;
    set autoDelete(value: boolean | cdktf.IResolvable | undefined);
    resetAutoDelete(): void;
    get autoDeleteInput(): boolean | cdktf.IResolvable | undefined;
    private _deviceName?;
    get deviceName(): string | undefined;
    set deviceName(value: string | undefined);
    resetDeviceName(): void;
    get deviceNameInput(): string | undefined;
    private _diskEncryptionKeyRaw?;
    get diskEncryptionKeyRaw(): string | undefined;
    set diskEncryptionKeyRaw(value: string | undefined);
    resetDiskEncryptionKeyRaw(): void;
    get diskEncryptionKeyRawInput(): string | undefined;
    private _kmsKeySelfLink?;
    get kmsKeySelfLink(): string | undefined;
    set kmsKeySelfLink(value: string | undefined);
    resetKmsKeySelfLink(): void;
    get kmsKeySelfLinkInput(): string | undefined;
    private _mode?;
    get mode(): string | undefined;
    set mode(value: string | undefined);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _source?;
    get source(): string | undefined;
    set source(value: string | undefined);
    resetSource(): void;
    get sourceInput(): string | undefined;
    private _initializeParams?;
    private __initializeParamsOutput;
    get initializeParams(): ComputeInstanceBootDiskInitializeParamsOutputReference;
    putInitializeParams(value: ComputeInstanceBootDiskInitializeParams | undefined): void;
    resetInitializeParams(): void;
    get initializeParamsInput(): ComputeInstanceBootDiskInitializeParams | undefined;
}
export interface ComputeInstanceConfidentialInstanceConfig {
    /**
     * Defines whether the instance should have confidential compute enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#enable_confidential_compute ComputeInstance#enable_confidential_compute}
     */
    readonly enableConfidentialCompute: boolean | cdktf.IResolvable;
}
export declare class ComputeInstanceConfidentialInstanceConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _enableConfidentialCompute?;
    get enableConfidentialCompute(): boolean | cdktf.IResolvable;
    set enableConfidentialCompute(value: boolean | cdktf.IResolvable);
    get enableConfidentialComputeInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ComputeInstanceNetworkInterfaceAccessConfig {
    /**
     * The IP address that is be 1:1 mapped to the instance's network ip.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#nat_ip ComputeInstance#nat_ip}
     */
    readonly natIp?: string;
    /**
     * The networking tier used for configuring this instance. One of PREMIUM or STANDARD.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#network_tier ComputeInstance#network_tier}
     */
    readonly networkTier?: string;
    /**
     * The DNS domain name for the public PTR record.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#public_ptr_domain_name ComputeInstance#public_ptr_domain_name}
     */
    readonly publicPtrDomainName?: string;
}
export interface ComputeInstanceNetworkInterfaceAliasIpRange {
    /**
     * The IP CIDR range represented by this alias IP range.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#ip_cidr_range ComputeInstance#ip_cidr_range}
     */
    readonly ipCidrRange: string;
    /**
     * The subnetwork secondary range name specifying the secondary range from which to allocate the IP CIDR range for this alias IP range.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#subnetwork_range_name ComputeInstance#subnetwork_range_name}
     */
    readonly subnetworkRangeName?: string;
}
export interface ComputeInstanceNetworkInterfaceIpv6AccessConfig {
    /**
     * The service-level to be provided for IPv6 traffic when the subnet has an external subnet.
     *
     * Only PREMIUM tier is valid for IPv6
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#network_tier ComputeInstance#network_tier}
     */
    readonly networkTier: string;
    /**
     * The domain name to be used when creating DNSv6 records for the external IPv6 ranges.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#public_ptr_domain_name ComputeInstance#public_ptr_domain_name}
     */
    readonly publicPtrDomainName?: string;
}
export interface ComputeInstanceNetworkInterface {
    /**
     * The name or self_link of the network attached to this interface.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#network ComputeInstance#network}
     */
    readonly network?: string;
    /**
     * The private IP address assigned to the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#network_ip ComputeInstance#network_ip}
     */
    readonly networkIp?: string;
    /**
     * The type of vNIC to be used on this interface. Possible values:GVNIC, VIRTIO_NET.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#nic_type ComputeInstance#nic_type}
     */
    readonly nicType?: string;
    /**
     * The stack type for this network interface to identify whether the IPv6 feature is enabled or not.
     *
     * If not specified, IPV4_ONLY will be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#stack_type ComputeInstance#stack_type}
     */
    readonly stackType?: string;
    /**
     * The name or self_link of the subnetwork attached to this interface.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#subnetwork ComputeInstance#subnetwork}
     */
    readonly subnetwork?: string;
    /**
     * The project in which the subnetwork belongs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#subnetwork_project ComputeInstance#subnetwork_project}
     */
    readonly subnetworkProject?: string;
    /**
     * access_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#access_config ComputeInstance#access_config}
     */
    readonly accessConfig?: ComputeInstanceNetworkInterfaceAccessConfig[];
    /**
     * alias_ip_range block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#alias_ip_range ComputeInstance#alias_ip_range}
     */
    readonly aliasIpRange?: ComputeInstanceNetworkInterfaceAliasIpRange[];
    /**
     * ipv6_access_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#ipv6_access_config ComputeInstance#ipv6_access_config}
     */
    readonly ipv6AccessConfig?: ComputeInstanceNetworkInterfaceIpv6AccessConfig[];
}
export interface ComputeInstanceReservationAffinitySpecificReservation {
    /**
     * Corresponds to the label key of a reservation resource.
     *
     * To target a SPECIFIC_RESERVATION by name, specify compute.googleapis.com/reservation-name as the key and specify the name of your reservation as the only value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#key ComputeInstance#key}
     */
    readonly key: string;
    /**
     * Corresponds to the label values of a reservation resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#values ComputeInstance#values}
     */
    readonly values: string[];
}
export declare class ComputeInstanceReservationAffinitySpecificReservationOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export interface ComputeInstanceReservationAffinity {
    /**
     * The type of reservation from which this instance can consume resources.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#type ComputeInstance#type}
     */
    readonly type: string;
    /**
     * specific_reservation block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#specific_reservation ComputeInstance#specific_reservation}
     */
    readonly specificReservation?: ComputeInstanceReservationAffinitySpecificReservation;
}
export declare class ComputeInstanceReservationAffinityOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _specificReservation?;
    private __specificReservationOutput;
    get specificReservation(): ComputeInstanceReservationAffinitySpecificReservationOutputReference;
    putSpecificReservation(value: ComputeInstanceReservationAffinitySpecificReservation | undefined): void;
    resetSpecificReservation(): void;
    get specificReservationInput(): ComputeInstanceReservationAffinitySpecificReservation | undefined;
}
export interface ComputeInstanceSchedulingNodeAffinities {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#key ComputeInstance#key}.
     */
    readonly key: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#operator ComputeInstance#operator}.
     */
    readonly operator: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#values ComputeInstance#values}.
     */
    readonly values: string[];
}
export interface ComputeInstanceScheduling {
    /**
     * Specifies if the instance should be restarted if it was terminated by Compute Engine (not a user).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#automatic_restart ComputeInstance#automatic_restart}
     */
    readonly automaticRestart?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#min_node_cpus ComputeInstance#min_node_cpus}.
     */
    readonly minNodeCpus?: number;
    /**
     * Describes maintenance behavior for the instance. One of MIGRATE or TERMINATE,.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#on_host_maintenance ComputeInstance#on_host_maintenance}
     */
    readonly onHostMaintenance?: string;
    /**
     * Whether the instance is preemptible.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#preemptible ComputeInstance#preemptible}
     */
    readonly preemptible?: boolean | cdktf.IResolvable;
    /**
     * node_affinities block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#node_affinities ComputeInstance#node_affinities}
     */
    readonly nodeAffinities?: ComputeInstanceSchedulingNodeAffinities[];
}
export declare class ComputeInstanceSchedulingOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _automaticRestart?;
    get automaticRestart(): boolean | cdktf.IResolvable | undefined;
    set automaticRestart(value: boolean | cdktf.IResolvable | undefined);
    resetAutomaticRestart(): void;
    get automaticRestartInput(): boolean | cdktf.IResolvable | undefined;
    private _minNodeCpus?;
    get minNodeCpus(): number | undefined;
    set minNodeCpus(value: number | undefined);
    resetMinNodeCpus(): void;
    get minNodeCpusInput(): number | undefined;
    private _onHostMaintenance?;
    get onHostMaintenance(): string | undefined;
    set onHostMaintenance(value: string | undefined);
    resetOnHostMaintenance(): void;
    get onHostMaintenanceInput(): string | undefined;
    private _preemptible?;
    get preemptible(): boolean | cdktf.IResolvable | undefined;
    set preemptible(value: boolean | cdktf.IResolvable | undefined);
    resetPreemptible(): void;
    get preemptibleInput(): boolean | cdktf.IResolvable | undefined;
    private _nodeAffinities?;
    get nodeAffinities(): ComputeInstanceSchedulingNodeAffinities[] | undefined;
    set nodeAffinities(value: ComputeInstanceSchedulingNodeAffinities[] | undefined);
    resetNodeAffinities(): void;
    get nodeAffinitiesInput(): ComputeInstanceSchedulingNodeAffinities[] | undefined;
}
export interface ComputeInstanceScratchDisk {
    /**
     * The disk interface used for attaching this disk. One of SCSI or NVME.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#interface ComputeInstance#interface}
     */
    readonly interface: string;
}
export interface ComputeInstanceServiceAccount {
    /**
     * The service account e-mail address.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#email ComputeInstance#email}
     */
    readonly email?: string;
    /**
     * A list of service scopes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#scopes ComputeInstance#scopes}
     */
    readonly scopes: string[];
}
export declare class ComputeInstanceServiceAccountOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _email?;
    get email(): string | undefined;
    set email(value: string | undefined);
    resetEmail(): void;
    get emailInput(): string | undefined;
    private _scopes?;
    get scopes(): string[];
    set scopes(value: string[]);
    get scopesInput(): string[] | undefined;
}
export interface ComputeInstanceShieldedInstanceConfig {
    /**
     * Whether integrity monitoring is enabled for the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#enable_integrity_monitoring ComputeInstance#enable_integrity_monitoring}
     */
    readonly enableIntegrityMonitoring?: boolean | cdktf.IResolvable;
    /**
     * Whether secure boot is enabled for the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#enable_secure_boot ComputeInstance#enable_secure_boot}
     */
    readonly enableSecureBoot?: boolean | cdktf.IResolvable;
    /**
     * Whether the instance uses vTPM.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#enable_vtpm ComputeInstance#enable_vtpm}
     */
    readonly enableVtpm?: boolean | cdktf.IResolvable;
}
export declare class ComputeInstanceShieldedInstanceConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _enableIntegrityMonitoring?;
    get enableIntegrityMonitoring(): boolean | cdktf.IResolvable | undefined;
    set enableIntegrityMonitoring(value: boolean | cdktf.IResolvable | undefined);
    resetEnableIntegrityMonitoring(): void;
    get enableIntegrityMonitoringInput(): boolean | cdktf.IResolvable | undefined;
    private _enableSecureBoot?;
    get enableSecureBoot(): boolean | cdktf.IResolvable | undefined;
    set enableSecureBoot(value: boolean | cdktf.IResolvable | undefined);
    resetEnableSecureBoot(): void;
    get enableSecureBootInput(): boolean | cdktf.IResolvable | undefined;
    private _enableVtpm?;
    get enableVtpm(): boolean | cdktf.IResolvable | undefined;
    set enableVtpm(value: boolean | cdktf.IResolvable | undefined);
    resetEnableVtpm(): void;
    get enableVtpmInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ComputeInstanceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#create ComputeInstance#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#delete ComputeInstance#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html#update ComputeInstance#update}.
     */
    readonly update?: string;
}
export declare class ComputeInstanceTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html google_compute_instance}.
 */
export declare class ComputeInstance extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_instance.html google_compute_instance} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: ComputeInstanceConfig);
    private _allowStoppingForUpdate?;
    get allowStoppingForUpdate(): boolean | cdktf.IResolvable | undefined;
    set allowStoppingForUpdate(value: boolean | cdktf.IResolvable | undefined);
    resetAllowStoppingForUpdate(): void;
    get allowStoppingForUpdateInput(): boolean | cdktf.IResolvable | undefined;
    private _canIpForward?;
    get canIpForward(): boolean | cdktf.IResolvable | undefined;
    set canIpForward(value: boolean | cdktf.IResolvable | undefined);
    resetCanIpForward(): void;
    get canIpForwardInput(): boolean | cdktf.IResolvable | undefined;
    get cpuPlatform(): string;
    get currentStatus(): string;
    private _deletionProtection?;
    get deletionProtection(): boolean | cdktf.IResolvable | undefined;
    set deletionProtection(value: boolean | cdktf.IResolvable | undefined);
    resetDeletionProtection(): void;
    get deletionProtectionInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _desiredStatus?;
    get desiredStatus(): string | undefined;
    set desiredStatus(value: string | undefined);
    resetDesiredStatus(): void;
    get desiredStatusInput(): string | undefined;
    private _enableDisplay?;
    get enableDisplay(): boolean | cdktf.IResolvable | undefined;
    set enableDisplay(value: boolean | cdktf.IResolvable | undefined);
    resetEnableDisplay(): void;
    get enableDisplayInput(): boolean | cdktf.IResolvable | undefined;
    private _guestAccelerator?;
    get guestAccelerator(): ComputeInstanceGuestAccelerator[] | undefined;
    set guestAccelerator(value: ComputeInstanceGuestAccelerator[] | undefined);
    resetGuestAccelerator(): void;
    get guestAcceleratorInput(): ComputeInstanceGuestAccelerator[] | undefined;
    private _hostname?;
    get hostname(): string | undefined;
    set hostname(value: string | undefined);
    resetHostname(): void;
    get hostnameInput(): string | undefined;
    get id(): string;
    get instanceId(): string;
    get labelFingerprint(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _machineType?;
    get machineType(): string;
    set machineType(value: string);
    get machineTypeInput(): string | undefined;
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set metadata(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetMetadata(): void;
    get metadataInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    get metadataFingerprint(): string;
    private _metadataStartupScript?;
    get metadataStartupScript(): string | undefined;
    set metadataStartupScript(value: string | undefined);
    resetMetadataStartupScript(): void;
    get metadataStartupScriptInput(): string | undefined;
    private _minCpuPlatform?;
    get minCpuPlatform(): string | undefined;
    set minCpuPlatform(value: string | undefined);
    resetMinCpuPlatform(): void;
    get minCpuPlatformInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _resourcePolicies?;
    get resourcePolicies(): string[] | undefined;
    set resourcePolicies(value: string[] | undefined);
    resetResourcePolicies(): void;
    get resourcePoliciesInput(): string[] | undefined;
    get selfLink(): string;
    private _tags?;
    get tags(): string[] | undefined;
    set tags(value: string[] | undefined);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    get tagsFingerprint(): string;
    private _zone?;
    get zone(): string | undefined;
    set zone(value: string | undefined);
    resetZone(): void;
    get zoneInput(): string | undefined;
    private _advancedMachineFeatures?;
    private __advancedMachineFeaturesOutput;
    get advancedMachineFeatures(): ComputeInstanceAdvancedMachineFeaturesOutputReference;
    putAdvancedMachineFeatures(value: ComputeInstanceAdvancedMachineFeatures | undefined): void;
    resetAdvancedMachineFeatures(): void;
    get advancedMachineFeaturesInput(): ComputeInstanceAdvancedMachineFeatures | undefined;
    private _attachedDisk?;
    get attachedDisk(): ComputeInstanceAttachedDisk[] | undefined;
    set attachedDisk(value: ComputeInstanceAttachedDisk[] | undefined);
    resetAttachedDisk(): void;
    get attachedDiskInput(): ComputeInstanceAttachedDisk[] | undefined;
    private _bootDisk?;
    private __bootDiskOutput;
    get bootDisk(): ComputeInstanceBootDiskOutputReference;
    putBootDisk(value: ComputeInstanceBootDisk): void;
    get bootDiskInput(): ComputeInstanceBootDisk | undefined;
    private _confidentialInstanceConfig?;
    private __confidentialInstanceConfigOutput;
    get confidentialInstanceConfig(): ComputeInstanceConfidentialInstanceConfigOutputReference;
    putConfidentialInstanceConfig(value: ComputeInstanceConfidentialInstanceConfig | undefined): void;
    resetConfidentialInstanceConfig(): void;
    get confidentialInstanceConfigInput(): ComputeInstanceConfidentialInstanceConfig | undefined;
    private _networkInterface?;
    get networkInterface(): ComputeInstanceNetworkInterface[];
    set networkInterface(value: ComputeInstanceNetworkInterface[]);
    get networkInterfaceInput(): ComputeInstanceNetworkInterface[] | undefined;
    private _reservationAffinity?;
    private __reservationAffinityOutput;
    get reservationAffinity(): ComputeInstanceReservationAffinityOutputReference;
    putReservationAffinity(value: ComputeInstanceReservationAffinity | undefined): void;
    resetReservationAffinity(): void;
    get reservationAffinityInput(): ComputeInstanceReservationAffinity | undefined;
    private _scheduling?;
    private __schedulingOutput;
    get scheduling(): ComputeInstanceSchedulingOutputReference;
    putScheduling(value: ComputeInstanceScheduling | undefined): void;
    resetScheduling(): void;
    get schedulingInput(): ComputeInstanceScheduling | undefined;
    private _scratchDisk?;
    get scratchDisk(): ComputeInstanceScratchDisk[] | undefined;
    set scratchDisk(value: ComputeInstanceScratchDisk[] | undefined);
    resetScratchDisk(): void;
    get scratchDiskInput(): ComputeInstanceScratchDisk[] | undefined;
    private _serviceAccount?;
    private __serviceAccountOutput;
    get serviceAccount(): ComputeInstanceServiceAccountOutputReference;
    putServiceAccount(value: ComputeInstanceServiceAccount | undefined): void;
    resetServiceAccount(): void;
    get serviceAccountInput(): ComputeInstanceServiceAccount | undefined;
    private _shieldedInstanceConfig?;
    private __shieldedInstanceConfigOutput;
    get shieldedInstanceConfig(): ComputeInstanceShieldedInstanceConfigOutputReference;
    putShieldedInstanceConfig(value: ComputeInstanceShieldedInstanceConfig | undefined): void;
    resetShieldedInstanceConfig(): void;
    get shieldedInstanceConfigInput(): ComputeInstanceShieldedInstanceConfig | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): ComputeInstanceTimeoutsOutputReference;
    putTimeouts(value: ComputeInstanceTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeInstanceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
