import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeInstanceGroupConfig extends cdktf.TerraformMetaArguments {
    /**
     * An optional textual description of the instance group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group.html#description ComputeInstanceGroup#description}
     */
    readonly description?: string;
    /**
     * List of instances in the group.
     *
     * They should be given as self_link URLs. When adding instances they must all be in the same network and zone as the instance group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group.html#instances ComputeInstanceGroup#instances}
     */
    readonly instances?: string[];
    /**
     * The name of the instance group.
     *
     * Must be 1-63 characters long and comply with RFC1035. Supported characters include lowercase letters, numbers, and hyphens.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group.html#name ComputeInstanceGroup#name}
     */
    readonly name: string;
    /**
     * The URL of the network the instance group is in.
     *
     * If this is different from the network where the instances are in, the creation fails. Defaults to the network where the instances are in (if neither network nor instances is specified, this field will be blank).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group.html#network ComputeInstanceGroup#network}
     */
    readonly network?: string;
    /**
     * The ID of the project in which the resource belongs.
     *
     * If it is not provided, the provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group.html#project ComputeInstanceGroup#project}
     */
    readonly project?: string;
    /**
     * The zone that this instance group should be created in.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group.html#zone ComputeInstanceGroup#zone}
     */
    readonly zone?: string;
    /**
     * named_port block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group.html#named_port ComputeInstanceGroup#named_port}
     */
    readonly namedPort?: ComputeInstanceGroupNamedPort[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group.html#timeouts ComputeInstanceGroup#timeouts}
     */
    readonly timeouts?: ComputeInstanceGroupTimeouts;
}
export interface ComputeInstanceGroupNamedPort {
    /**
     * The name which the port will be mapped to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group.html#name ComputeInstanceGroup#name}
     */
    readonly name: string;
    /**
     * The port number to map the name to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group.html#port ComputeInstanceGroup#port}
     */
    readonly port: number;
}
export interface ComputeInstanceGroupTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group.html#create ComputeInstanceGroup#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group.html#delete ComputeInstanceGroup#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group.html#update ComputeInstanceGroup#update}.
     */
    readonly update?: string;
}
export declare class ComputeInstanceGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group.html google_compute_instance_group}.
 */
export declare class ComputeInstanceGroup extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group.html google_compute_instance_group} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: ComputeInstanceGroupConfig);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _instances?;
    get instances(): string[] | undefined;
    set instances(value: string[] | undefined);
    resetInstances(): void;
    get instancesInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _network?;
    get network(): string | undefined;
    set network(value: string | undefined);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    get size(): number;
    private _zone?;
    get zone(): string | undefined;
    set zone(value: string | undefined);
    resetZone(): void;
    get zoneInput(): string | undefined;
    private _namedPort?;
    get namedPort(): ComputeInstanceGroupNamedPort[] | undefined;
    set namedPort(value: ComputeInstanceGroupNamedPort[] | undefined);
    resetNamedPort(): void;
    get namedPortInput(): ComputeInstanceGroupNamedPort[] | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): ComputeInstanceGroupTimeoutsOutputReference;
    putTimeouts(value: ComputeInstanceGroupTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeInstanceGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
