import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeInstanceGroupNamedPortAConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the instance group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_named_port.html#group ComputeInstanceGroupNamedPortA#group}
     */
    readonly group: string;
    /**
     * The name for this named port. The name must be 1-63 characters long, and comply with RFC1035.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_named_port.html#name ComputeInstanceGroupNamedPortA#name}
     */
    readonly name: string;
    /**
     * The port number, which can be a value between 1 and 65535.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_named_port.html#port ComputeInstanceGroupNamedPortA#port}
     */
    readonly port: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_named_port.html#project ComputeInstanceGroupNamedPortA#project}.
     */
    readonly project?: string;
    /**
     * The zone of the instance group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_named_port.html#zone ComputeInstanceGroupNamedPortA#zone}
     */
    readonly zone?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_named_port.html#timeouts ComputeInstanceGroupNamedPortA#timeouts}
     */
    readonly timeouts?: ComputeInstanceGroupNamedPortTimeouts;
}
export interface ComputeInstanceGroupNamedPortTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_named_port.html#create ComputeInstanceGroupNamedPortA#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_named_port.html#delete ComputeInstanceGroupNamedPortA#delete}.
     */
    readonly delete?: string;
}
export declare class ComputeInstanceGroupNamedPortTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_named_port.html google_compute_instance_group_named_port}.
 */
export declare class ComputeInstanceGroupNamedPortA extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_instance_group_named_port.html google_compute_instance_group_named_port} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: ComputeInstanceGroupNamedPortAConfig);
    private _group?;
    get group(): string;
    set group(value: string);
    get groupInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    get portInput(): number | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _zone?;
    get zone(): string | undefined;
    set zone(value: string | undefined);
    resetZone(): void;
    get zoneInput(): string | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): ComputeInstanceGroupNamedPortTimeoutsOutputReference;
    putTimeouts(value: ComputeInstanceGroupNamedPortTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeInstanceGroupNamedPortTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
