import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeInstanceFromTemplateConfig extends cdktf.TerraformMetaArguments {
    /**
     * If true, allows Terraform to stop the instance to update its properties.
     *
     * If you try to update a property that requires stopping the instance without setting this field, the update will fail.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#allow_stopping_for_update ComputeInstanceFromTemplate#allow_stopping_for_update}
     */
    readonly allowStoppingForUpdate?: boolean | cdktf.IResolvable;
    /**
     * List of disks attached to the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#attached_disk ComputeInstanceFromTemplate#attached_disk}
     */
    readonly attachedDisk?: ComputeInstanceFromTemplateAttachedDisk[];
    /**
     * Whether sending and receiving of packets with non-matching source or destination IPs is allowed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#can_ip_forward ComputeInstanceFromTemplate#can_ip_forward}
     */
    readonly canIpForward?: boolean | cdktf.IResolvable;
    /**
     * Whether deletion protection is enabled on this instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#deletion_protection ComputeInstanceFromTemplate#deletion_protection}
     */
    readonly deletionProtection?: boolean | cdktf.IResolvable;
    /**
     * A brief description of the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#description ComputeInstanceFromTemplate#description}
     */
    readonly description?: string;
    /**
     * Desired status of the instance. Either "RUNNING" or "TERMINATED".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#desired_status ComputeInstanceFromTemplate#desired_status}
     */
    readonly desiredStatus?: string;
    /**
     * Whether the instance has virtual displays enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#enable_display ComputeInstanceFromTemplate#enable_display}
     */
    readonly enableDisplay?: boolean | cdktf.IResolvable;
    /**
     * List of the type and count of accelerator cards attached to the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#guest_accelerator ComputeInstanceFromTemplate#guest_accelerator}
     */
    readonly guestAccelerator?: ComputeInstanceFromTemplateGuestAccelerator[];
    /**
     * A custom hostname for the instance.
     *
     * Must be a fully qualified DNS name and RFC-1035-valid. Valid format is a series of labels 1-63 characters long matching the regular expression [a-z]([-a-z0-9]*[a-z0-9]), concatenated with periods. The entire hostname must not exceed 253 characters. Changing this forces a new resource to be created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#hostname ComputeInstanceFromTemplate#hostname}
     */
    readonly hostname?: string;
    /**
     * A set of key/value label pairs assigned to the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#labels ComputeInstanceFromTemplate#labels}
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The machine type to create.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#machine_type ComputeInstanceFromTemplate#machine_type}
     */
    readonly machineType?: string;
    /**
     * Metadata key/value pairs made available within the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#metadata ComputeInstanceFromTemplate#metadata}
     */
    readonly metadata?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Metadata startup scripts made available within the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#metadata_startup_script ComputeInstanceFromTemplate#metadata_startup_script}
     */
    readonly metadataStartupScript?: string;
    /**
     * The minimum CPU platform specified for the VM instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#min_cpu_platform ComputeInstanceFromTemplate#min_cpu_platform}
     */
    readonly minCpuPlatform?: string;
    /**
     * The name of the instance. One of name or self_link must be provided.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#name ComputeInstanceFromTemplate#name}
     */
    readonly name: string;
    /**
     * The ID of the project in which the resource belongs.
     *
     * If self_link is provided, this value is ignored. If neither self_link nor project are provided, the provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#project ComputeInstanceFromTemplate#project}
     */
    readonly project?: string;
    /**
     * A list of short names or self_links of resource policies to attach to the instance.
     *
     * Currently a max of 1 resource policy is supported.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#resource_policies ComputeInstanceFromTemplate#resource_policies}
     */
    readonly resourcePolicies?: string[];
    /**
     * The scratch disks attached to the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#scratch_disk ComputeInstanceFromTemplate#scratch_disk}
     */
    readonly scratchDisk?: ComputeInstanceFromTemplateScratchDisk[];
    /**
     * The service account to attach to the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#service_account ComputeInstanceFromTemplate#service_account}
     */
    readonly serviceAccount?: ComputeInstanceFromTemplateServiceAccount[];
    /**
     * Name or self link of an instance template to create the instance based on.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#source_instance_template ComputeInstanceFromTemplate#source_instance_template}
     */
    readonly sourceInstanceTemplate: string;
    /**
     * The list of tags attached to the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#tags ComputeInstanceFromTemplate#tags}
     */
    readonly tags?: string[];
    /**
     * The zone of the instance.
     *
     * If self_link is provided, this value is ignored. If neither self_link nor zone are provided, the provider zone is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#zone ComputeInstanceFromTemplate#zone}
     */
    readonly zone?: string;
    /**
     * advanced_machine_features block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#advanced_machine_features ComputeInstanceFromTemplate#advanced_machine_features}
     */
    readonly advancedMachineFeatures?: ComputeInstanceFromTemplateAdvancedMachineFeatures;
    /**
     * boot_disk block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#boot_disk ComputeInstanceFromTemplate#boot_disk}
     */
    readonly bootDisk?: ComputeInstanceFromTemplateBootDisk;
    /**
     * confidential_instance_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#confidential_instance_config ComputeInstanceFromTemplate#confidential_instance_config}
     */
    readonly confidentialInstanceConfig?: ComputeInstanceFromTemplateConfidentialInstanceConfig;
    /**
     * network_interface block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#network_interface ComputeInstanceFromTemplate#network_interface}
     */
    readonly networkInterface?: ComputeInstanceFromTemplateNetworkInterface[];
    /**
     * reservation_affinity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#reservation_affinity ComputeInstanceFromTemplate#reservation_affinity}
     */
    readonly reservationAffinity?: ComputeInstanceFromTemplateReservationAffinity;
    /**
     * scheduling block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#scheduling ComputeInstanceFromTemplate#scheduling}
     */
    readonly scheduling?: ComputeInstanceFromTemplateScheduling;
    /**
     * shielded_instance_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#shielded_instance_config ComputeInstanceFromTemplate#shielded_instance_config}
     */
    readonly shieldedInstanceConfig?: ComputeInstanceFromTemplateShieldedInstanceConfig;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#timeouts ComputeInstanceFromTemplate#timeouts}
     */
    readonly timeouts?: ComputeInstanceFromTemplateTimeouts;
}
export interface ComputeInstanceFromTemplateAttachedDisk {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#device_name ComputeInstanceFromTemplate#device_name}.
     */
    readonly deviceName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#disk_encryption_key_raw ComputeInstanceFromTemplate#disk_encryption_key_raw}.
     */
    readonly diskEncryptionKeyRaw?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#disk_encryption_key_sha256 ComputeInstanceFromTemplate#disk_encryption_key_sha256}.
     */
    readonly diskEncryptionKeySha256?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#kms_key_self_link ComputeInstanceFromTemplate#kms_key_self_link}.
     */
    readonly kmsKeySelfLink?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#mode ComputeInstanceFromTemplate#mode}.
     */
    readonly mode?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#source ComputeInstanceFromTemplate#source}.
     */
    readonly source?: string;
}
export interface ComputeInstanceFromTemplateGuestAccelerator {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#count ComputeInstanceFromTemplate#count}.
     */
    readonly count?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#type ComputeInstanceFromTemplate#type}.
     */
    readonly type?: string;
}
export interface ComputeInstanceFromTemplateScratchDisk {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#interface ComputeInstanceFromTemplate#interface}.
     */
    readonly interface?: string;
}
export interface ComputeInstanceFromTemplateServiceAccount {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#email ComputeInstanceFromTemplate#email}.
     */
    readonly email?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#scopes ComputeInstanceFromTemplate#scopes}.
     */
    readonly scopes?: string[];
}
export interface ComputeInstanceFromTemplateAdvancedMachineFeatures {
    /**
     * Whether to enable nested virtualization or not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#enable_nested_virtualization ComputeInstanceFromTemplate#enable_nested_virtualization}
     */
    readonly enableNestedVirtualization?: boolean | cdktf.IResolvable;
    /**
     * The number of threads per physical core.
     *
     * To disable simultaneous multithreading (SMT) set this to 1. If unset, the maximum number of threads supported per core by the underlying processor is assumed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#threads_per_core ComputeInstanceFromTemplate#threads_per_core}
     */
    readonly threadsPerCore?: number;
}
export declare class ComputeInstanceFromTemplateAdvancedMachineFeaturesOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _enableNestedVirtualization?;
    get enableNestedVirtualization(): boolean | cdktf.IResolvable | undefined;
    set enableNestedVirtualization(value: boolean | cdktf.IResolvable | undefined);
    resetEnableNestedVirtualization(): void;
    get enableNestedVirtualizationInput(): boolean | cdktf.IResolvable | undefined;
    private _threadsPerCore?;
    get threadsPerCore(): number | undefined;
    set threadsPerCore(value: number | undefined);
    resetThreadsPerCore(): void;
    get threadsPerCoreInput(): number | undefined;
}
export interface ComputeInstanceFromTemplateBootDiskInitializeParams {
    /**
     * The image from which this disk was initialised.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#image ComputeInstanceFromTemplate#image}
     */
    readonly image?: string;
    /**
     * A set of key/value label pairs assigned to the disk.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#labels ComputeInstanceFromTemplate#labels}
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The size of the image in gigabytes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#size ComputeInstanceFromTemplate#size}
     */
    readonly size?: number;
    /**
     * The Google Compute Engine disk type. One of pd-standard, pd-ssd or pd-balanced.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#type ComputeInstanceFromTemplate#type}
     */
    readonly type?: string;
}
export declare class ComputeInstanceFromTemplateBootDiskInitializeParamsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _image?;
    get image(): string | undefined;
    set image(value: string | undefined);
    resetImage(): void;
    get imageInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _size?;
    get size(): number | undefined;
    set size(value: number | undefined);
    resetSize(): void;
    get sizeInput(): number | undefined;
    private _type?;
    get type(): string | undefined;
    set type(value: string | undefined);
    resetType(): void;
    get typeInput(): string | undefined;
}
export interface ComputeInstanceFromTemplateBootDisk {
    /**
     * Whether the disk will be auto-deleted when the instance is deleted.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#auto_delete ComputeInstanceFromTemplate#auto_delete}
     */
    readonly autoDelete?: boolean | cdktf.IResolvable;
    /**
     * Name with which attached disk will be accessible under /dev/disk/by-id/.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#device_name ComputeInstanceFromTemplate#device_name}
     */
    readonly deviceName?: string;
    /**
     * A 256-bit customer-supplied encryption key, encoded in RFC 4648 base64 to encrypt this disk.
     *
     * Only one of kms_key_self_link and disk_encryption_key_raw may be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#disk_encryption_key_raw ComputeInstanceFromTemplate#disk_encryption_key_raw}
     */
    readonly diskEncryptionKeyRaw?: string;
    /**
     * The self_link of the encryption key that is stored in Google Cloud KMS to encrypt this disk.
     *
     * Only one of kms_key_self_link and disk_encryption_key_raw may be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#kms_key_self_link ComputeInstanceFromTemplate#kms_key_self_link}
     */
    readonly kmsKeySelfLink?: string;
    /**
     * Read/write mode for the disk. One of "READ_ONLY" or "READ_WRITE".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#mode ComputeInstanceFromTemplate#mode}
     */
    readonly mode?: string;
    /**
     * The name or self_link of the disk attached to this instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#source ComputeInstanceFromTemplate#source}
     */
    readonly source?: string;
    /**
     * initialize_params block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#initialize_params ComputeInstanceFromTemplate#initialize_params}
     */
    readonly initializeParams?: ComputeInstanceFromTemplateBootDiskInitializeParams;
}
export declare class ComputeInstanceFromTemplateBootDiskOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _autoDelete?;
    get autoDelete(): boolean | cdktf.IResolvable | undefined;
    set autoDelete(value: boolean | cdktf.IResolvable | undefined);
    resetAutoDelete(): void;
    get autoDeleteInput(): boolean | cdktf.IResolvable | undefined;
    private _deviceName?;
    get deviceName(): string | undefined;
    set deviceName(value: string | undefined);
    resetDeviceName(): void;
    get deviceNameInput(): string | undefined;
    private _diskEncryptionKeyRaw?;
    get diskEncryptionKeyRaw(): string | undefined;
    set diskEncryptionKeyRaw(value: string | undefined);
    resetDiskEncryptionKeyRaw(): void;
    get diskEncryptionKeyRawInput(): string | undefined;
    private _kmsKeySelfLink?;
    get kmsKeySelfLink(): string | undefined;
    set kmsKeySelfLink(value: string | undefined);
    resetKmsKeySelfLink(): void;
    get kmsKeySelfLinkInput(): string | undefined;
    private _mode?;
    get mode(): string | undefined;
    set mode(value: string | undefined);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _source?;
    get source(): string | undefined;
    set source(value: string | undefined);
    resetSource(): void;
    get sourceInput(): string | undefined;
    private _initializeParams?;
    private __initializeParamsOutput;
    get initializeParams(): ComputeInstanceFromTemplateBootDiskInitializeParamsOutputReference;
    putInitializeParams(value: ComputeInstanceFromTemplateBootDiskInitializeParams | undefined): void;
    resetInitializeParams(): void;
    get initializeParamsInput(): ComputeInstanceFromTemplateBootDiskInitializeParams | undefined;
}
export interface ComputeInstanceFromTemplateConfidentialInstanceConfig {
    /**
     * Defines whether the instance should have confidential compute enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#enable_confidential_compute ComputeInstanceFromTemplate#enable_confidential_compute}
     */
    readonly enableConfidentialCompute: boolean | cdktf.IResolvable;
}
export declare class ComputeInstanceFromTemplateConfidentialInstanceConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _enableConfidentialCompute?;
    get enableConfidentialCompute(): boolean | cdktf.IResolvable;
    set enableConfidentialCompute(value: boolean | cdktf.IResolvable);
    get enableConfidentialComputeInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ComputeInstanceFromTemplateNetworkInterfaceAccessConfig {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#nat_ip ComputeInstanceFromTemplate#nat_ip}.
     */
    readonly natIp?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#network_tier ComputeInstanceFromTemplate#network_tier}.
     */
    readonly networkTier?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#public_ptr_domain_name ComputeInstanceFromTemplate#public_ptr_domain_name}.
     */
    readonly publicPtrDomainName?: string;
}
export interface ComputeInstanceFromTemplateNetworkInterfaceAliasIpRange {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#ip_cidr_range ComputeInstanceFromTemplate#ip_cidr_range}.
     */
    readonly ipCidrRange?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#subnetwork_range_name ComputeInstanceFromTemplate#subnetwork_range_name}.
     */
    readonly subnetworkRangeName?: string;
}
export interface ComputeInstanceFromTemplateNetworkInterfaceIpv6AccessConfig {
    /**
     * The service-level to be provided for IPv6 traffic when the subnet has an external subnet.
     *
     * Only PREMIUM tier is valid for IPv6
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#network_tier ComputeInstanceFromTemplate#network_tier}
     */
    readonly networkTier: string;
    /**
     * The domain name to be used when creating DNSv6 records for the external IPv6 ranges.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#public_ptr_domain_name ComputeInstanceFromTemplate#public_ptr_domain_name}
     */
    readonly publicPtrDomainName?: string;
}
export interface ComputeInstanceFromTemplateNetworkInterface {
    /**
     * Access configurations, i.e. IPs via which this instance can be accessed via the Internet.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#access_config ComputeInstanceFromTemplate#access_config}
     */
    readonly accessConfig?: ComputeInstanceFromTemplateNetworkInterfaceAccessConfig[];
    /**
     * An array of alias IP ranges for this network interface.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#alias_ip_range ComputeInstanceFromTemplate#alias_ip_range}
     */
    readonly aliasIpRange?: ComputeInstanceFromTemplateNetworkInterfaceAliasIpRange[];
    /**
     * The name or self_link of the network attached to this interface.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#network ComputeInstanceFromTemplate#network}
     */
    readonly network?: string;
    /**
     * The private IP address assigned to the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#network_ip ComputeInstanceFromTemplate#network_ip}
     */
    readonly networkIp?: string;
    /**
     * The type of vNIC to be used on this interface. Possible values:GVNIC, VIRTIO_NET.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#nic_type ComputeInstanceFromTemplate#nic_type}
     */
    readonly nicType?: string;
    /**
     * The stack type for this network interface to identify whether the IPv6 feature is enabled or not.
     *
     * If not specified, IPV4_ONLY will be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#stack_type ComputeInstanceFromTemplate#stack_type}
     */
    readonly stackType?: string;
    /**
     * The name or self_link of the subnetwork attached to this interface.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#subnetwork ComputeInstanceFromTemplate#subnetwork}
     */
    readonly subnetwork?: string;
    /**
     * The project in which the subnetwork belongs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#subnetwork_project ComputeInstanceFromTemplate#subnetwork_project}
     */
    readonly subnetworkProject?: string;
    /**
     * ipv6_access_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#ipv6_access_config ComputeInstanceFromTemplate#ipv6_access_config}
     */
    readonly ipv6AccessConfig?: ComputeInstanceFromTemplateNetworkInterfaceIpv6AccessConfig[];
}
export interface ComputeInstanceFromTemplateReservationAffinitySpecificReservation {
    /**
     * Corresponds to the label key of a reservation resource.
     *
     * To target a SPECIFIC_RESERVATION by name, specify compute.googleapis.com/reservation-name as the key and specify the name of your reservation as the only value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#key ComputeInstanceFromTemplate#key}
     */
    readonly key: string;
    /**
     * Corresponds to the label values of a reservation resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#values ComputeInstanceFromTemplate#values}
     */
    readonly values: string[];
}
export declare class ComputeInstanceFromTemplateReservationAffinitySpecificReservationOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export interface ComputeInstanceFromTemplateReservationAffinity {
    /**
     * The type of reservation from which this instance can consume resources.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#type ComputeInstanceFromTemplate#type}
     */
    readonly type: string;
    /**
     * specific_reservation block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#specific_reservation ComputeInstanceFromTemplate#specific_reservation}
     */
    readonly specificReservation?: ComputeInstanceFromTemplateReservationAffinitySpecificReservation;
}
export declare class ComputeInstanceFromTemplateReservationAffinityOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _specificReservation?;
    private __specificReservationOutput;
    get specificReservation(): ComputeInstanceFromTemplateReservationAffinitySpecificReservationOutputReference;
    putSpecificReservation(value: ComputeInstanceFromTemplateReservationAffinitySpecificReservation | undefined): void;
    resetSpecificReservation(): void;
    get specificReservationInput(): ComputeInstanceFromTemplateReservationAffinitySpecificReservation | undefined;
}
export interface ComputeInstanceFromTemplateSchedulingNodeAffinities {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#key ComputeInstanceFromTemplate#key}.
     */
    readonly key: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#operator ComputeInstanceFromTemplate#operator}.
     */
    readonly operator: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#values ComputeInstanceFromTemplate#values}.
     */
    readonly values: string[];
}
export interface ComputeInstanceFromTemplateScheduling {
    /**
     * Specifies if the instance should be restarted if it was terminated by Compute Engine (not a user).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#automatic_restart ComputeInstanceFromTemplate#automatic_restart}
     */
    readonly automaticRestart?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#min_node_cpus ComputeInstanceFromTemplate#min_node_cpus}.
     */
    readonly minNodeCpus?: number;
    /**
     * Describes maintenance behavior for the instance. One of MIGRATE or TERMINATE,.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#on_host_maintenance ComputeInstanceFromTemplate#on_host_maintenance}
     */
    readonly onHostMaintenance?: string;
    /**
     * Whether the instance is preemptible.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#preemptible ComputeInstanceFromTemplate#preemptible}
     */
    readonly preemptible?: boolean | cdktf.IResolvable;
    /**
     * node_affinities block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#node_affinities ComputeInstanceFromTemplate#node_affinities}
     */
    readonly nodeAffinities?: ComputeInstanceFromTemplateSchedulingNodeAffinities[];
}
export declare class ComputeInstanceFromTemplateSchedulingOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _automaticRestart?;
    get automaticRestart(): boolean | cdktf.IResolvable | undefined;
    set automaticRestart(value: boolean | cdktf.IResolvable | undefined);
    resetAutomaticRestart(): void;
    get automaticRestartInput(): boolean | cdktf.IResolvable | undefined;
    private _minNodeCpus?;
    get minNodeCpus(): number | undefined;
    set minNodeCpus(value: number | undefined);
    resetMinNodeCpus(): void;
    get minNodeCpusInput(): number | undefined;
    private _onHostMaintenance?;
    get onHostMaintenance(): string | undefined;
    set onHostMaintenance(value: string | undefined);
    resetOnHostMaintenance(): void;
    get onHostMaintenanceInput(): string | undefined;
    private _preemptible?;
    get preemptible(): boolean | cdktf.IResolvable | undefined;
    set preemptible(value: boolean | cdktf.IResolvable | undefined);
    resetPreemptible(): void;
    get preemptibleInput(): boolean | cdktf.IResolvable | undefined;
    private _nodeAffinities?;
    get nodeAffinities(): ComputeInstanceFromTemplateSchedulingNodeAffinities[] | undefined;
    set nodeAffinities(value: ComputeInstanceFromTemplateSchedulingNodeAffinities[] | undefined);
    resetNodeAffinities(): void;
    get nodeAffinitiesInput(): ComputeInstanceFromTemplateSchedulingNodeAffinities[] | undefined;
}
export interface ComputeInstanceFromTemplateShieldedInstanceConfig {
    /**
     * Whether integrity monitoring is enabled for the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#enable_integrity_monitoring ComputeInstanceFromTemplate#enable_integrity_monitoring}
     */
    readonly enableIntegrityMonitoring?: boolean | cdktf.IResolvable;
    /**
     * Whether secure boot is enabled for the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#enable_secure_boot ComputeInstanceFromTemplate#enable_secure_boot}
     */
    readonly enableSecureBoot?: boolean | cdktf.IResolvable;
    /**
     * Whether the instance uses vTPM.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#enable_vtpm ComputeInstanceFromTemplate#enable_vtpm}
     */
    readonly enableVtpm?: boolean | cdktf.IResolvable;
}
export declare class ComputeInstanceFromTemplateShieldedInstanceConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _enableIntegrityMonitoring?;
    get enableIntegrityMonitoring(): boolean | cdktf.IResolvable | undefined;
    set enableIntegrityMonitoring(value: boolean | cdktf.IResolvable | undefined);
    resetEnableIntegrityMonitoring(): void;
    get enableIntegrityMonitoringInput(): boolean | cdktf.IResolvable | undefined;
    private _enableSecureBoot?;
    get enableSecureBoot(): boolean | cdktf.IResolvable | undefined;
    set enableSecureBoot(value: boolean | cdktf.IResolvable | undefined);
    resetEnableSecureBoot(): void;
    get enableSecureBootInput(): boolean | cdktf.IResolvable | undefined;
    private _enableVtpm?;
    get enableVtpm(): boolean | cdktf.IResolvable | undefined;
    set enableVtpm(value: boolean | cdktf.IResolvable | undefined);
    resetEnableVtpm(): void;
    get enableVtpmInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ComputeInstanceFromTemplateTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#create ComputeInstanceFromTemplate#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#delete ComputeInstanceFromTemplate#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html#update ComputeInstanceFromTemplate#update}.
     */
    readonly update?: string;
}
export declare class ComputeInstanceFromTemplateTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html google_compute_instance_from_template}.
 */
export declare class ComputeInstanceFromTemplate extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_instance_from_template.html google_compute_instance_from_template} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: ComputeInstanceFromTemplateConfig);
    private _allowStoppingForUpdate?;
    get allowStoppingForUpdate(): boolean | cdktf.IResolvable | undefined;
    set allowStoppingForUpdate(value: boolean | cdktf.IResolvable | undefined);
    resetAllowStoppingForUpdate(): void;
    get allowStoppingForUpdateInput(): boolean | cdktf.IResolvable | undefined;
    private _attachedDisk?;
    get attachedDisk(): ComputeInstanceFromTemplateAttachedDisk[] | undefined;
    set attachedDisk(value: ComputeInstanceFromTemplateAttachedDisk[] | undefined);
    resetAttachedDisk(): void;
    get attachedDiskInput(): ComputeInstanceFromTemplateAttachedDisk[] | undefined;
    private _canIpForward?;
    get canIpForward(): boolean | cdktf.IResolvable | undefined;
    set canIpForward(value: boolean | cdktf.IResolvable | undefined);
    resetCanIpForward(): void;
    get canIpForwardInput(): boolean | cdktf.IResolvable | undefined;
    get cpuPlatform(): string;
    get currentStatus(): string;
    private _deletionProtection?;
    get deletionProtection(): boolean | cdktf.IResolvable | undefined;
    set deletionProtection(value: boolean | cdktf.IResolvable | undefined);
    resetDeletionProtection(): void;
    get deletionProtectionInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _desiredStatus?;
    get desiredStatus(): string | undefined;
    set desiredStatus(value: string | undefined);
    resetDesiredStatus(): void;
    get desiredStatusInput(): string | undefined;
    private _enableDisplay?;
    get enableDisplay(): boolean | cdktf.IResolvable | undefined;
    set enableDisplay(value: boolean | cdktf.IResolvable | undefined);
    resetEnableDisplay(): void;
    get enableDisplayInput(): boolean | cdktf.IResolvable | undefined;
    private _guestAccelerator?;
    get guestAccelerator(): ComputeInstanceFromTemplateGuestAccelerator[] | undefined;
    set guestAccelerator(value: ComputeInstanceFromTemplateGuestAccelerator[] | undefined);
    resetGuestAccelerator(): void;
    get guestAcceleratorInput(): ComputeInstanceFromTemplateGuestAccelerator[] | undefined;
    private _hostname?;
    get hostname(): string | undefined;
    set hostname(value: string | undefined);
    resetHostname(): void;
    get hostnameInput(): string | undefined;
    get id(): string;
    get instanceId(): string;
    get labelFingerprint(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _machineType?;
    get machineType(): string | undefined;
    set machineType(value: string | undefined);
    resetMachineType(): void;
    get machineTypeInput(): string | undefined;
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set metadata(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetMetadata(): void;
    get metadataInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    get metadataFingerprint(): string;
    private _metadataStartupScript?;
    get metadataStartupScript(): string | undefined;
    set metadataStartupScript(value: string | undefined);
    resetMetadataStartupScript(): void;
    get metadataStartupScriptInput(): string | undefined;
    private _minCpuPlatform?;
    get minCpuPlatform(): string | undefined;
    set minCpuPlatform(value: string | undefined);
    resetMinCpuPlatform(): void;
    get minCpuPlatformInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _resourcePolicies?;
    get resourcePolicies(): string[] | undefined;
    set resourcePolicies(value: string[] | undefined);
    resetResourcePolicies(): void;
    get resourcePoliciesInput(): string[] | undefined;
    private _scratchDisk?;
    get scratchDisk(): ComputeInstanceFromTemplateScratchDisk[] | undefined;
    set scratchDisk(value: ComputeInstanceFromTemplateScratchDisk[] | undefined);
    resetScratchDisk(): void;
    get scratchDiskInput(): ComputeInstanceFromTemplateScratchDisk[] | undefined;
    get selfLink(): string;
    private _serviceAccount?;
    get serviceAccount(): ComputeInstanceFromTemplateServiceAccount[] | undefined;
    set serviceAccount(value: ComputeInstanceFromTemplateServiceAccount[] | undefined);
    resetServiceAccount(): void;
    get serviceAccountInput(): ComputeInstanceFromTemplateServiceAccount[] | undefined;
    private _sourceInstanceTemplate?;
    get sourceInstanceTemplate(): string;
    set sourceInstanceTemplate(value: string);
    get sourceInstanceTemplateInput(): string | undefined;
    private _tags?;
    get tags(): string[] | undefined;
    set tags(value: string[] | undefined);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    get tagsFingerprint(): string;
    private _zone?;
    get zone(): string | undefined;
    set zone(value: string | undefined);
    resetZone(): void;
    get zoneInput(): string | undefined;
    private _advancedMachineFeatures?;
    private __advancedMachineFeaturesOutput;
    get advancedMachineFeatures(): ComputeInstanceFromTemplateAdvancedMachineFeaturesOutputReference;
    putAdvancedMachineFeatures(value: ComputeInstanceFromTemplateAdvancedMachineFeatures | undefined): void;
    resetAdvancedMachineFeatures(): void;
    get advancedMachineFeaturesInput(): ComputeInstanceFromTemplateAdvancedMachineFeatures | undefined;
    private _bootDisk?;
    private __bootDiskOutput;
    get bootDisk(): ComputeInstanceFromTemplateBootDiskOutputReference;
    putBootDisk(value: ComputeInstanceFromTemplateBootDisk | undefined): void;
    resetBootDisk(): void;
    get bootDiskInput(): ComputeInstanceFromTemplateBootDisk | undefined;
    private _confidentialInstanceConfig?;
    private __confidentialInstanceConfigOutput;
    get confidentialInstanceConfig(): ComputeInstanceFromTemplateConfidentialInstanceConfigOutputReference;
    putConfidentialInstanceConfig(value: ComputeInstanceFromTemplateConfidentialInstanceConfig | undefined): void;
    resetConfidentialInstanceConfig(): void;
    get confidentialInstanceConfigInput(): ComputeInstanceFromTemplateConfidentialInstanceConfig | undefined;
    private _networkInterface?;
    get networkInterface(): ComputeInstanceFromTemplateNetworkInterface[] | undefined;
    set networkInterface(value: ComputeInstanceFromTemplateNetworkInterface[] | undefined);
    resetNetworkInterface(): void;
    get networkInterfaceInput(): ComputeInstanceFromTemplateNetworkInterface[] | undefined;
    private _reservationAffinity?;
    private __reservationAffinityOutput;
    get reservationAffinity(): ComputeInstanceFromTemplateReservationAffinityOutputReference;
    putReservationAffinity(value: ComputeInstanceFromTemplateReservationAffinity | undefined): void;
    resetReservationAffinity(): void;
    get reservationAffinityInput(): ComputeInstanceFromTemplateReservationAffinity | undefined;
    private _scheduling?;
    private __schedulingOutput;
    get scheduling(): ComputeInstanceFromTemplateSchedulingOutputReference;
    putScheduling(value: ComputeInstanceFromTemplateScheduling | undefined): void;
    resetScheduling(): void;
    get schedulingInput(): ComputeInstanceFromTemplateScheduling | undefined;
    private _shieldedInstanceConfig?;
    private __shieldedInstanceConfigOutput;
    get shieldedInstanceConfig(): ComputeInstanceFromTemplateShieldedInstanceConfigOutputReference;
    putShieldedInstanceConfig(value: ComputeInstanceFromTemplateShieldedInstanceConfig | undefined): void;
    resetShieldedInstanceConfig(): void;
    get shieldedInstanceConfigInput(): ComputeInstanceFromTemplateShieldedInstanceConfig | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): ComputeInstanceFromTemplateTimeoutsOutputReference;
    putTimeouts(value: ComputeInstanceFromTemplateTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeInstanceFromTemplateTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
