import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeHttpsHealthCheckConfig extends cdktf.TerraformMetaArguments {
    /**
     * How often (in seconds) to send a health check. The default value is 5 seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_https_health_check.html#check_interval_sec ComputeHttpsHealthCheck#check_interval_sec}
     */
    readonly checkIntervalSec?: number;
    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_https_health_check.html#description ComputeHttpsHealthCheck#description}
     */
    readonly description?: string;
    /**
     * A so-far unhealthy instance will be marked healthy after this many consecutive successes. The default value is 2.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_https_health_check.html#healthy_threshold ComputeHttpsHealthCheck#healthy_threshold}
     */
    readonly healthyThreshold?: number;
    /**
     * The value of the host header in the HTTPS health check request.
     *
     * If
     * left empty (default value), the public IP on behalf of which this
     * health check is performed will be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_https_health_check.html#host ComputeHttpsHealthCheck#host}
     */
    readonly host?: string;
    /**
     * Name of the resource.
     *
     * Provided by the client when the resource is
     * created. The name must be 1-63 characters long, and comply with
     * RFC1035.  Specifically, the name must be 1-63 characters long and
     * match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means
     * the first character must be a lowercase letter, and all following
     * characters must be a dash, lowercase letter, or digit, except the
     * last character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_https_health_check.html#name ComputeHttpsHealthCheck#name}
     */
    readonly name: string;
    /**
     * The TCP port number for the HTTPS health check request. The default value is 443.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_https_health_check.html#port ComputeHttpsHealthCheck#port}
     */
    readonly port?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_https_health_check.html#project ComputeHttpsHealthCheck#project}.
     */
    readonly project?: string;
    /**
     * The request path of the HTTPS health check request. The default value is /.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_https_health_check.html#request_path ComputeHttpsHealthCheck#request_path}
     */
    readonly requestPath?: string;
    /**
     * How long (in seconds) to wait before claiming failure.
     *
     * The default value is 5 seconds.  It is invalid for timeoutSec to have
     * greater value than checkIntervalSec.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_https_health_check.html#timeout_sec ComputeHttpsHealthCheck#timeout_sec}
     */
    readonly timeoutSec?: number;
    /**
     * A so-far healthy instance will be marked unhealthy after this many consecutive failures. The default value is 2.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_https_health_check.html#unhealthy_threshold ComputeHttpsHealthCheck#unhealthy_threshold}
     */
    readonly unhealthyThreshold?: number;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_https_health_check.html#timeouts ComputeHttpsHealthCheck#timeouts}
     */
    readonly timeouts?: ComputeHttpsHealthCheckTimeouts;
}
export interface ComputeHttpsHealthCheckTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_https_health_check.html#create ComputeHttpsHealthCheck#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_https_health_check.html#delete ComputeHttpsHealthCheck#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_https_health_check.html#update ComputeHttpsHealthCheck#update}.
     */
    readonly update?: string;
}
export declare class ComputeHttpsHealthCheckTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_https_health_check.html google_compute_https_health_check}.
 */
export declare class ComputeHttpsHealthCheck extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_https_health_check.html google_compute_https_health_check} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: ComputeHttpsHealthCheckConfig);
    private _checkIntervalSec?;
    get checkIntervalSec(): number | undefined;
    set checkIntervalSec(value: number | undefined);
    resetCheckIntervalSec(): void;
    get checkIntervalSecInput(): number | undefined;
    get creationTimestamp(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _healthyThreshold?;
    get healthyThreshold(): number | undefined;
    set healthyThreshold(value: number | undefined);
    resetHealthyThreshold(): void;
    get healthyThresholdInput(): number | undefined;
    private _host?;
    get host(): string | undefined;
    set host(value: string | undefined);
    resetHost(): void;
    get hostInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _port?;
    get port(): number | undefined;
    set port(value: number | undefined);
    resetPort(): void;
    get portInput(): number | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _requestPath?;
    get requestPath(): string | undefined;
    set requestPath(value: string | undefined);
    resetRequestPath(): void;
    get requestPathInput(): string | undefined;
    get selfLink(): string;
    private _timeoutSec?;
    get timeoutSec(): number | undefined;
    set timeoutSec(value: number | undefined);
    resetTimeoutSec(): void;
    get timeoutSecInput(): number | undefined;
    private _unhealthyThreshold?;
    get unhealthyThreshold(): number | undefined;
    set unhealthyThreshold(value: number | undefined);
    resetUnhealthyThreshold(): void;
    get unhealthyThresholdInput(): number | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): ComputeHttpsHealthCheckTimeoutsOutputReference;
    putTimeouts(value: ComputeHttpsHealthCheckTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeHttpsHealthCheckTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
