import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeHaVpnGatewayConfig extends cdktf.TerraformMetaArguments {
    /**
     * An optional description of this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_ha_vpn_gateway.html#description ComputeHaVpnGateway#description}
     */
    readonly description?: string;
    /**
     * Name of the resource.
     *
     * Provided by the client when the resource is
     * created. The name must be 1-63 characters long, and comply with
     * RFC1035.  Specifically, the name must be 1-63 characters long and
     * match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means
     * the first character must be a lowercase letter, and all following
     * characters must be a dash, lowercase letter, or digit, except the last
     * character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_ha_vpn_gateway.html#name ComputeHaVpnGateway#name}
     */
    readonly name: string;
    /**
     * The network this VPN gateway is accepting traffic for.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_ha_vpn_gateway.html#network ComputeHaVpnGateway#network}
     */
    readonly network: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_ha_vpn_gateway.html#project ComputeHaVpnGateway#project}.
     */
    readonly project?: string;
    /**
     * The region this gateway should sit in.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_ha_vpn_gateway.html#region ComputeHaVpnGateway#region}
     */
    readonly region?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_ha_vpn_gateway.html#timeouts ComputeHaVpnGateway#timeouts}
     */
    readonly timeouts?: ComputeHaVpnGatewayTimeouts;
    /**
     * vpn_interfaces block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_ha_vpn_gateway.html#vpn_interfaces ComputeHaVpnGateway#vpn_interfaces}
     */
    readonly vpnInterfaces?: ComputeHaVpnGatewayVpnInterfaces[];
}
export interface ComputeHaVpnGatewayTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_ha_vpn_gateway.html#create ComputeHaVpnGateway#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_ha_vpn_gateway.html#delete ComputeHaVpnGateway#delete}.
     */
    readonly delete?: string;
}
export declare class ComputeHaVpnGatewayTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
export interface ComputeHaVpnGatewayVpnInterfaces {
    /**
     * The numeric ID of this VPN gateway interface.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_ha_vpn_gateway.html#id ComputeHaVpnGateway#id}
     */
    readonly id?: number;
    /**
     * URL of the interconnect attachment resource.
     *
     * When the value
     * of this field is present, the VPN Gateway will be used for
     * IPsec-encrypted Cloud Interconnect; all Egress or Ingress
     * traffic for this VPN Gateway interface will go through the
     * specified interconnect attachment resource.
     *
     * Not currently available publicly.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_ha_vpn_gateway.html#interconnect_attachment ComputeHaVpnGateway#interconnect_attachment}
     */
    readonly interconnectAttachment?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_ha_vpn_gateway.html google_compute_ha_vpn_gateway}.
 */
export declare class ComputeHaVpnGateway extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_ha_vpn_gateway.html google_compute_ha_vpn_gateway} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: ComputeHaVpnGatewayConfig);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    get networkInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string | undefined;
    set region(value: string | undefined);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get selfLink(): string;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): ComputeHaVpnGatewayTimeoutsOutputReference;
    putTimeouts(value: ComputeHaVpnGatewayTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeHaVpnGatewayTimeouts | undefined;
    private _vpnInterfaces?;
    get vpnInterfaces(): ComputeHaVpnGatewayVpnInterfaces[] | undefined;
    set vpnInterfaces(value: ComputeHaVpnGatewayVpnInterfaces[] | undefined);
    resetVpnInterfaces(): void;
    get vpnInterfacesInput(): ComputeHaVpnGatewayVpnInterfaces[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
