import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeGlobalAddressConfig extends cdktf.TerraformMetaArguments {
    /**
     * The IP address or beginning of the address range represented by this resource.
     *
     * This can be supplied as an input to reserve a specific
     * address or omitted to allow GCP to choose a valid one for you.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_address.html#address ComputeGlobalAddress#address}
     */
    readonly address?: string;
    /**
     * The type of the address to reserve.
     *
     * EXTERNAL indicates public/external single IP address.
     * INTERNAL indicates internal IP ranges belonging to some network. Default value: "EXTERNAL" Possible values: ["EXTERNAL", "INTERNAL"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_address.html#address_type ComputeGlobalAddress#address_type}
     */
    readonly addressType?: string;
    /**
     * An optional description of this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_address.html#description ComputeGlobalAddress#description}
     */
    readonly description?: string;
    /**
     * The IP Version that will be used by this address. The default value is 'IPV4'. Possible values: ["IPV4", "IPV6"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_address.html#ip_version ComputeGlobalAddress#ip_version}
     */
    readonly ipVersion?: string;
    /**
     * Name of the resource.
     *
     * Provided by the client when the resource is
     * created. The name must be 1-63 characters long, and comply with
     * RFC1035.  Specifically, the name must be 1-63 characters long and
     * match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means
     * the first character must be a lowercase letter, and all following
     * characters must be a dash, lowercase letter, or digit, except the last
     * character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_address.html#name ComputeGlobalAddress#name}
     */
    readonly name: string;
    /**
     * The URL of the network in which to reserve the IP range.
     *
     * The IP range
     * must be in RFC1918 space. The network cannot be deleted if there are
     * any reserved IP ranges referring to it.
     *
     * This should only be set when using an Internal address.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_address.html#network ComputeGlobalAddress#network}
     */
    readonly network?: string;
    /**
     * The prefix length of the IP range. If not present, it means the address field is a single IP address.
     *
     * This field is not applicable to addresses with addressType=EXTERNAL,
     * or addressType=INTERNAL when purpose=PRIVATE_SERVICE_CONNECT
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_address.html#prefix_length ComputeGlobalAddress#prefix_length}
     */
    readonly prefixLength?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_address.html#project ComputeGlobalAddress#project}.
     */
    readonly project?: string;
    /**
     * The purpose of the resource. Possible values include:.
     *
     * VPC_PEERING - for peer networks
     *
     * PRIVATE_SERVICE_CONNECT - for ([Beta](https://terraform.io/docs/providers/google/guides/provider_versions.html) only) Private Service Connect networks
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_address.html#purpose ComputeGlobalAddress#purpose}
     */
    readonly purpose?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_address.html#timeouts ComputeGlobalAddress#timeouts}
     */
    readonly timeouts?: ComputeGlobalAddressTimeouts;
}
export interface ComputeGlobalAddressTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_address.html#create ComputeGlobalAddress#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_address.html#delete ComputeGlobalAddress#delete}.
     */
    readonly delete?: string;
}
export declare class ComputeGlobalAddressTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_global_address.html google_compute_global_address}.
 */
export declare class ComputeGlobalAddress extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_global_address.html google_compute_global_address} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: ComputeGlobalAddressConfig);
    private _address?;
    get address(): string | undefined;
    set address(value: string | undefined);
    resetAddress(): void;
    get addressInput(): string | undefined;
    private _addressType?;
    get addressType(): string | undefined;
    set addressType(value: string | undefined);
    resetAddressType(): void;
    get addressTypeInput(): string | undefined;
    get creationTimestamp(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _ipVersion?;
    get ipVersion(): string | undefined;
    set ipVersion(value: string | undefined);
    resetIpVersion(): void;
    get ipVersionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _network?;
    get network(): string | undefined;
    set network(value: string | undefined);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _prefixLength?;
    get prefixLength(): number | undefined;
    set prefixLength(value: number | undefined);
    resetPrefixLength(): void;
    get prefixLengthInput(): number | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _purpose?;
    get purpose(): string | undefined;
    set purpose(value: string | undefined);
    resetPurpose(): void;
    get purposeInput(): string | undefined;
    get selfLink(): string;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): ComputeGlobalAddressTimeoutsOutputReference;
    putTimeouts(value: ComputeGlobalAddressTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeGlobalAddressTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
