import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeFirewallPolicyRuleConfig extends cdktf.TerraformMetaArguments {
    /**
     * The Action to perform when the client connection triggers the rule.
     *
     * Can currently be either "allow" or "deny()" where valid values for status are 403, 404, and 502.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy_rule.html#action ComputeFirewallPolicyRule#action}
     */
    readonly action: string;
    /**
     * An optional description for this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy_rule.html#description ComputeFirewallPolicyRule#description}
     */
    readonly description?: string;
    /**
     * The direction in which this rule applies. Possible values: INGRESS, EGRESS.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy_rule.html#direction ComputeFirewallPolicyRule#direction}
     */
    readonly direction: string;
    /**
     * Denotes whether the firewall policy rule is disabled.
     *
     * When set to true, the firewall policy rule is not enforced and traffic behaves as if it did not exist. If this is unspecified, the firewall policy rule will be enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy_rule.html#disabled ComputeFirewallPolicyRule#disabled}
     */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
     * Denotes whether to enable logging for a particular rule.
     *
     * If logging is enabled, logs will be exported to the configured export destination in Stackdriver. Logs may be exported to BigQuery or Pub/Sub. Note: you cannot enable logging on "goto_next" rules.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy_rule.html#enable_logging ComputeFirewallPolicyRule#enable_logging}
     */
    readonly enableLogging?: boolean | cdktf.IResolvable;
    /**
     * The firewall policy of the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy_rule.html#firewall_policy ComputeFirewallPolicyRule#firewall_policy}
     */
    readonly firewallPolicy: string;
    /**
     * An integer indicating the priority of a rule in the list.
     *
     * The priority must be a positive value between 0 and 2147483647. Rules are evaluated from highest to lowest priority where 0 is the highest priority and 2147483647 is the lowest prority.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy_rule.html#priority ComputeFirewallPolicyRule#priority}
     */
    readonly priority: number;
    /**
     * A list of network resource URLs to which this rule applies.
     *
     * This field allows you to control which network's VMs get this rule. If this field is left blank, all VMs within the organization will receive the rule.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy_rule.html#target_resources ComputeFirewallPolicyRule#target_resources}
     */
    readonly targetResources?: string[];
    /**
     * A list of service accounts indicating the sets of instances that are applied with this rule.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy_rule.html#target_service_accounts ComputeFirewallPolicyRule#target_service_accounts}
     */
    readonly targetServiceAccounts?: string[];
    /**
     * match block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy_rule.html#match ComputeFirewallPolicyRule#match}
     */
    readonly match: ComputeFirewallPolicyRuleMatch;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy_rule.html#timeouts ComputeFirewallPolicyRule#timeouts}
     */
    readonly timeouts?: ComputeFirewallPolicyRuleTimeouts;
}
export interface ComputeFirewallPolicyRuleMatchLayer4Configs {
    /**
     * The IP protocol to which this rule applies.
     *
     * The protocol type is required when creating a firewall rule. This value can either be one of the following well known protocol strings (`tcp`, `udp`, `icmp`, `esp`, `ah`, `ipip`, `sctp`), or the IP protocol number.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy_rule.html#ip_protocol ComputeFirewallPolicyRule#ip_protocol}
     */
    readonly ipProtocol: string;
    /**
     * An optional list of ports to which this rule applies.
     *
     * This field is only applicable for UDP or TCP protocol. Each entry must be either an integer or a range. If not specified, this rule applies to connections through any port. Example inputs include: ``.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy_rule.html#ports ComputeFirewallPolicyRule#ports}
     */
    readonly ports?: string[];
}
export interface ComputeFirewallPolicyRuleMatch {
    /**
     * CIDR IP address range. Maximum number of destination CIDR IP ranges allowed is 256.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy_rule.html#dest_ip_ranges ComputeFirewallPolicyRule#dest_ip_ranges}
     */
    readonly destIpRanges?: string[];
    /**
     * CIDR IP address range. Maximum number of source CIDR IP ranges allowed is 256.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy_rule.html#src_ip_ranges ComputeFirewallPolicyRule#src_ip_ranges}
     */
    readonly srcIpRanges?: string[];
    /**
     * layer4_configs block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy_rule.html#layer4_configs ComputeFirewallPolicyRule#layer4_configs}
     */
    readonly layer4Configs: ComputeFirewallPolicyRuleMatchLayer4Configs[];
}
export declare class ComputeFirewallPolicyRuleMatchOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _destIpRanges?;
    get destIpRanges(): string[] | undefined;
    set destIpRanges(value: string[] | undefined);
    resetDestIpRanges(): void;
    get destIpRangesInput(): string[] | undefined;
    private _srcIpRanges?;
    get srcIpRanges(): string[] | undefined;
    set srcIpRanges(value: string[] | undefined);
    resetSrcIpRanges(): void;
    get srcIpRangesInput(): string[] | undefined;
    private _layer4Configs?;
    get layer4Configs(): ComputeFirewallPolicyRuleMatchLayer4Configs[];
    set layer4Configs(value: ComputeFirewallPolicyRuleMatchLayer4Configs[]);
    get layer4ConfigsInput(): ComputeFirewallPolicyRuleMatchLayer4Configs[] | undefined;
}
export interface ComputeFirewallPolicyRuleTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy_rule.html#create ComputeFirewallPolicyRule#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy_rule.html#delete ComputeFirewallPolicyRule#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy_rule.html#update ComputeFirewallPolicyRule#update}.
     */
    readonly update?: string;
}
export declare class ComputeFirewallPolicyRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy_rule.html google_compute_firewall_policy_rule}.
 */
export declare class ComputeFirewallPolicyRule extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy_rule.html google_compute_firewall_policy_rule} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: ComputeFirewallPolicyRuleConfig);
    private _action?;
    get action(): string;
    set action(value: string);
    get actionInput(): string | undefined;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _direction?;
    get direction(): string;
    set direction(value: string);
    get directionInput(): string | undefined;
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable | undefined;
    set disabled(value: boolean | cdktf.IResolvable | undefined);
    resetDisabled(): void;
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _enableLogging?;
    get enableLogging(): boolean | cdktf.IResolvable | undefined;
    set enableLogging(value: boolean | cdktf.IResolvable | undefined);
    resetEnableLogging(): void;
    get enableLoggingInput(): boolean | cdktf.IResolvable | undefined;
    private _firewallPolicy?;
    get firewallPolicy(): string;
    set firewallPolicy(value: string);
    get firewallPolicyInput(): string | undefined;
    get id(): string;
    get kind(): string;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    get priorityInput(): number | undefined;
    get ruleTupleCount(): number;
    private _targetResources?;
    get targetResources(): string[] | undefined;
    set targetResources(value: string[] | undefined);
    resetTargetResources(): void;
    get targetResourcesInput(): string[] | undefined;
    private _targetServiceAccounts?;
    get targetServiceAccounts(): string[] | undefined;
    set targetServiceAccounts(value: string[] | undefined);
    resetTargetServiceAccounts(): void;
    get targetServiceAccountsInput(): string[] | undefined;
    private _match?;
    private __matchOutput;
    get match(): ComputeFirewallPolicyRuleMatchOutputReference;
    putMatch(value: ComputeFirewallPolicyRuleMatch): void;
    get matchInput(): ComputeFirewallPolicyRuleMatch | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): ComputeFirewallPolicyRuleTimeoutsOutputReference;
    putTimeouts(value: ComputeFirewallPolicyRuleTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeFirewallPolicyRuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
