import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeFirewallPolicyAssociationConfig extends cdktf.TerraformMetaArguments {
    /**
     * The target that the firewall policy is attached to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy_association.html#attachment_target ComputeFirewallPolicyAssociation#attachment_target}
     */
    readonly attachmentTarget: string;
    /**
     * The firewall policy ID of the association.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy_association.html#firewall_policy ComputeFirewallPolicyAssociation#firewall_policy}
     */
    readonly firewallPolicy: string;
    /**
     * The name for an association.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy_association.html#name ComputeFirewallPolicyAssociation#name}
     */
    readonly name: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy_association.html#timeouts ComputeFirewallPolicyAssociation#timeouts}
     */
    readonly timeouts?: ComputeFirewallPolicyAssociationTimeouts;
}
export interface ComputeFirewallPolicyAssociationTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy_association.html#create ComputeFirewallPolicyAssociation#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy_association.html#delete ComputeFirewallPolicyAssociation#delete}.
     */
    readonly delete?: string;
}
export declare class ComputeFirewallPolicyAssociationTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy_association.html google_compute_firewall_policy_association}.
 */
export declare class ComputeFirewallPolicyAssociation extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy_association.html google_compute_firewall_policy_association} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: ComputeFirewallPolicyAssociationConfig);
    private _attachmentTarget?;
    get attachmentTarget(): string;
    set attachmentTarget(value: string);
    get attachmentTargetInput(): string | undefined;
    private _firewallPolicy?;
    get firewallPolicy(): string;
    set firewallPolicy(value: string);
    get firewallPolicyInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get shortName(): string;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): ComputeFirewallPolicyAssociationTimeoutsOutputReference;
    putTimeouts(value: ComputeFirewallPolicyAssociationTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeFirewallPolicyAssociationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
