import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeExternalVpnGatewayConfig extends cdktf.TerraformMetaArguments {
    /**
     * An optional description of this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_external_vpn_gateway.html#description ComputeExternalVpnGateway#description}
     */
    readonly description?: string;
    /**
     * Name of the resource.
     *
     * Provided by the client when the resource is
     * created. The name must be 1-63 characters long, and comply with
     * RFC1035.  Specifically, the name must be 1-63 characters long and
     * match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means
     * the first character must be a lowercase letter, and all following
     * characters must be a dash, lowercase letter, or digit, except the last
     * character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_external_vpn_gateway.html#name ComputeExternalVpnGateway#name}
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_external_vpn_gateway.html#project ComputeExternalVpnGateway#project}.
     */
    readonly project?: string;
    /**
     * Indicates the redundancy type of this external VPN gateway Possible values: ["FOUR_IPS_REDUNDANCY", "SINGLE_IP_INTERNALLY_REDUNDANT", "TWO_IPS_REDUNDANCY"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_external_vpn_gateway.html#redundancy_type ComputeExternalVpnGateway#redundancy_type}
     */
    readonly redundancyType?: string;
    /**
     * interface block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_external_vpn_gateway.html#interface ComputeExternalVpnGateway#interface}
     */
    readonly interface?: ComputeExternalVpnGatewayInterface[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_external_vpn_gateway.html#timeouts ComputeExternalVpnGateway#timeouts}
     */
    readonly timeouts?: ComputeExternalVpnGatewayTimeouts;
}
export interface ComputeExternalVpnGatewayInterface {
    /**
     * The numeric ID for this interface.
     *
     * Allowed values are based on the redundancy type
     * of this external VPN gateway
     * '0 - SINGLE_IP_INTERNALLY_REDUNDANT'
     * '0, 1 - TWO_IPS_REDUNDANCY'
     * '0, 1, 2, 3 - FOUR_IPS_REDUNDANCY'
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_external_vpn_gateway.html#id ComputeExternalVpnGateway#id}
     */
    readonly id?: number;
    /**
     * IP address of the interface in the external VPN gateway.
     *
     * Only IPv4 is supported. This IP address can be either from
     * your on-premise gateway or another Cloud provider's VPN gateway,
     * it cannot be an IP address from Google Compute Engine.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_external_vpn_gateway.html#ip_address ComputeExternalVpnGateway#ip_address}
     */
    readonly ipAddress?: string;
}
export interface ComputeExternalVpnGatewayTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_external_vpn_gateway.html#create ComputeExternalVpnGateway#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_external_vpn_gateway.html#delete ComputeExternalVpnGateway#delete}.
     */
    readonly delete?: string;
}
export declare class ComputeExternalVpnGatewayTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_external_vpn_gateway.html google_compute_external_vpn_gateway}.
 */
export declare class ComputeExternalVpnGateway extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_external_vpn_gateway.html google_compute_external_vpn_gateway} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: ComputeExternalVpnGatewayConfig);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _redundancyType?;
    get redundancyType(): string | undefined;
    set redundancyType(value: string | undefined);
    resetRedundancyType(): void;
    get redundancyTypeInput(): string | undefined;
    get selfLink(): string;
    private _interface?;
    get interface(): ComputeExternalVpnGatewayInterface[] | undefined;
    set interface(value: ComputeExternalVpnGatewayInterface[] | undefined);
    resetInterface(): void;
    get interfaceInput(): ComputeExternalVpnGatewayInterface[] | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): ComputeExternalVpnGatewayTimeoutsOutputReference;
    putTimeouts(value: ComputeExternalVpnGatewayTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeExternalVpnGatewayTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
