import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeBackendServiceSignedUrlKeyConfig extends cdktf.TerraformMetaArguments {
    /**
     * The backend service this signed URL key belongs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service_signed_url_key.html#backend_service ComputeBackendServiceSignedUrlKey#backend_service}
     */
    readonly backendService: string;
    /**
     * 128-bit key value used for signing the URL.
     *
     * The key value must be a
     * valid RFC 4648 Section 5 base64url encoded string.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service_signed_url_key.html#key_value ComputeBackendServiceSignedUrlKey#key_value}
     */
    readonly keyValue: string;
    /**
     * Name of the signed URL key.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service_signed_url_key.html#name ComputeBackendServiceSignedUrlKey#name}
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service_signed_url_key.html#project ComputeBackendServiceSignedUrlKey#project}.
     */
    readonly project?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service_signed_url_key.html#timeouts ComputeBackendServiceSignedUrlKey#timeouts}
     */
    readonly timeouts?: ComputeBackendServiceSignedUrlKeyTimeouts;
}
export interface ComputeBackendServiceSignedUrlKeyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service_signed_url_key.html#create ComputeBackendServiceSignedUrlKey#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service_signed_url_key.html#delete ComputeBackendServiceSignedUrlKey#delete}.
     */
    readonly delete?: string;
}
export declare class ComputeBackendServiceSignedUrlKeyTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service_signed_url_key.html google_compute_backend_service_signed_url_key}.
 */
export declare class ComputeBackendServiceSignedUrlKey extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_backend_service_signed_url_key.html google_compute_backend_service_signed_url_key} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: ComputeBackendServiceSignedUrlKeyConfig);
    private _backendService?;
    get backendService(): string;
    set backendService(value: string);
    get backendServiceInput(): string | undefined;
    get id(): string;
    private _keyValue?;
    get keyValue(): string;
    set keyValue(value: string);
    get keyValueInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): ComputeBackendServiceSignedUrlKeyTimeoutsOutputReference;
    putTimeouts(value: ComputeBackendServiceSignedUrlKeyTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeBackendServiceSignedUrlKeyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
