import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeAutoscalerConfig extends cdktf.TerraformMetaArguments {
    /**
     * An optional description of this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler.html#description ComputeAutoscaler#description}
     */
    readonly description?: string;
    /**
     * Name of the resource.
     *
     * The name must be 1-63 characters long and match
     * the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
     * first character must be a lowercase letter, and all following
     * characters must be a dash, lowercase letter, or digit, except the last
     * character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler.html#name ComputeAutoscaler#name}
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler.html#project ComputeAutoscaler#project}.
     */
    readonly project?: string;
    /**
     * URL of the managed instance group that this autoscaler will scale.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler.html#target ComputeAutoscaler#target}
     */
    readonly target: string;
    /**
     * URL of the zone where the instance group resides.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler.html#zone ComputeAutoscaler#zone}
     */
    readonly zone?: string;
    /**
     * autoscaling_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler.html#autoscaling_policy ComputeAutoscaler#autoscaling_policy}
     */
    readonly autoscalingPolicy: ComputeAutoscalerAutoscalingPolicy;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler.html#timeouts ComputeAutoscaler#timeouts}
     */
    readonly timeouts?: ComputeAutoscalerTimeouts;
}
export interface ComputeAutoscalerAutoscalingPolicyCpuUtilization {
    /**
     * Indicates whether predictive autoscaling based on CPU metric is enabled. Valid values are:.
     *
     * - NONE (default). No predictive method is used. The autoscaler scales the group to meet current demand based on real-time metrics.
     *
     * - OPTIMIZE_AVAILABILITY. Predictive autoscaling improves availability by monitoring daily and weekly load patterns and scaling out ahead of anticipated demand.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler.html#predictive_method ComputeAutoscaler#predictive_method}
     */
    readonly predictiveMethod?: string;
    /**
     * The target CPU utilization that the autoscaler should maintain.
     *
     * Must be a float value in the range (0, 1]. If not specified, the
     * default is 0.6.
     *
     * If the CPU level is below the target utilization, the autoscaler
     * scales down the number of instances until it reaches the minimum
     * number of instances you specified or until the average CPU of
     * your instances reaches the target utilization.
     *
     * If the average CPU is above the target utilization, the autoscaler
     * scales up until it reaches the maximum number of instances you
     * specified or until the average utilization reaches the target
     * utilization.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler.html#target ComputeAutoscaler#target}
     */
    readonly target: number;
}
export declare class ComputeAutoscalerAutoscalingPolicyCpuUtilizationOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _predictiveMethod?;
    get predictiveMethod(): string | undefined;
    set predictiveMethod(value: string | undefined);
    resetPredictiveMethod(): void;
    get predictiveMethodInput(): string | undefined;
    private _target?;
    get target(): number;
    set target(value: number);
    get targetInput(): number | undefined;
}
export interface ComputeAutoscalerAutoscalingPolicyLoadBalancingUtilization {
    /**
     * Fraction of backend capacity utilization (set in HTTP(s) load balancing configuration) that autoscaler should maintain.
     *
     * Must
     * be a positive float value. If not defined, the default is 0.8.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler.html#target ComputeAutoscaler#target}
     */
    readonly target: number;
}
export declare class ComputeAutoscalerAutoscalingPolicyLoadBalancingUtilizationOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _target?;
    get target(): number;
    set target(value: number);
    get targetInput(): number | undefined;
}
export interface ComputeAutoscalerAutoscalingPolicyMetric {
    /**
     * The identifier (type) of the Stackdriver Monitoring metric. The metric cannot have negative values.
     *
     * The metric must have a value type of INT64 or DOUBLE.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler.html#name ComputeAutoscaler#name}
     */
    readonly name: string;
    /**
     * The target value of the metric that autoscaler should maintain.
     *
     * This must be a positive value. A utilization
     * metric scales number of virtual machines handling requests
     * to increase or decrease proportionally to the metric.
     *
     * For example, a good metric to use as a utilizationTarget is
     * www.googleapis.com/compute/instance/network/received_bytes_count.
     * The autoscaler will work to keep this value constant for each
     * of the instances.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler.html#target ComputeAutoscaler#target}
     */
    readonly target?: number;
    /**
     * Defines how target utilization value is expressed for a Stackdriver Monitoring metric. Possible values: ["GAUGE", "DELTA_PER_SECOND", "DELTA_PER_MINUTE"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler.html#type ComputeAutoscaler#type}
     */
    readonly type?: string;
}
export interface ComputeAutoscalerAutoscalingPolicyScaleInControlMaxScaledInReplicas {
    /**
     * Specifies a fixed number of VM instances. This must be a positive integer.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler.html#fixed ComputeAutoscaler#fixed}
     */
    readonly fixed?: number;
    /**
     * Specifies a percentage of instances between 0 to 100%, inclusive. For example, specify 80 for 80%.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler.html#percent ComputeAutoscaler#percent}
     */
    readonly percent?: number;
}
export declare class ComputeAutoscalerAutoscalingPolicyScaleInControlMaxScaledInReplicasOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _fixed?;
    get fixed(): number | undefined;
    set fixed(value: number | undefined);
    resetFixed(): void;
    get fixedInput(): number | undefined;
    private _percent?;
    get percent(): number | undefined;
    set percent(value: number | undefined);
    resetPercent(): void;
    get percentInput(): number | undefined;
}
export interface ComputeAutoscalerAutoscalingPolicyScaleInControl {
    /**
     * How long back autoscaling should look when computing recommendations to include directives regarding slower scale down, as described above.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler.html#time_window_sec ComputeAutoscaler#time_window_sec}
     */
    readonly timeWindowSec?: number;
    /**
     * max_scaled_in_replicas block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler.html#max_scaled_in_replicas ComputeAutoscaler#max_scaled_in_replicas}
     */
    readonly maxScaledInReplicas?: ComputeAutoscalerAutoscalingPolicyScaleInControlMaxScaledInReplicas;
}
export declare class ComputeAutoscalerAutoscalingPolicyScaleInControlOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _timeWindowSec?;
    get timeWindowSec(): number | undefined;
    set timeWindowSec(value: number | undefined);
    resetTimeWindowSec(): void;
    get timeWindowSecInput(): number | undefined;
    private _maxScaledInReplicas?;
    private __maxScaledInReplicasOutput;
    get maxScaledInReplicas(): ComputeAutoscalerAutoscalingPolicyScaleInControlMaxScaledInReplicasOutputReference;
    putMaxScaledInReplicas(value: ComputeAutoscalerAutoscalingPolicyScaleInControlMaxScaledInReplicas | undefined): void;
    resetMaxScaledInReplicas(): void;
    get maxScaledInReplicasInput(): ComputeAutoscalerAutoscalingPolicyScaleInControlMaxScaledInReplicas | undefined;
}
export interface ComputeAutoscalerAutoscalingPolicyScalingSchedules {
    /**
     * A description of a scaling schedule.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler.html#description ComputeAutoscaler#description}
     */
    readonly description?: string;
    /**
     * A boolean value that specifies if a scaling schedule can influence autoscaler recommendations.
     *
     * If set to true, then a scaling schedule has no effect.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler.html#disabled ComputeAutoscaler#disabled}
     */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
     * The duration of time intervals (in seconds) for which this scaling schedule will be running.
     *
     * The minimum allowed value is 300.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler.html#duration_sec ComputeAutoscaler#duration_sec}
     */
    readonly durationSec: number;
    /**
     * Minimum number of VM instances that autoscaler will recommend in time intervals starting according to schedule.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler.html#min_required_replicas ComputeAutoscaler#min_required_replicas}
     */
    readonly minRequiredReplicas: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler.html#name ComputeAutoscaler#name}.
     */
    readonly name: string;
    /**
     * The start timestamps of time intervals when this scaling schedule should provide a scaling signal.
     *
     * This field uses the extended cron format (with an optional year field).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler.html#schedule ComputeAutoscaler#schedule}
     */
    readonly schedule: string;
    /**
     * The time zone to be used when interpreting the schedule.
     *
     * The value of this field must be a time zone name from the tz database: http://en.wikipedia.org/wiki/Tz_database.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler.html#time_zone ComputeAutoscaler#time_zone}
     */
    readonly timeZone?: string;
}
export interface ComputeAutoscalerAutoscalingPolicy {
    /**
     * The number of seconds that the autoscaler should wait before it starts collecting information from a new instance.
     *
     * This prevents
     * the autoscaler from collecting information when the instance is
     * initializing, during which the collected usage would not be
     * reliable. The default time autoscaler waits is 60 seconds.
     *
     * Virtual machine initialization times might vary because of
     * numerous factors. We recommend that you test how long an
     * instance may take to initialize. To do this, create an instance
     * and time the startup process.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler.html#cooldown_period ComputeAutoscaler#cooldown_period}
     */
    readonly cooldownPeriod?: number;
    /**
     * The maximum number of instances that the autoscaler can scale up to.
     *
     * This is required when creating or updating an autoscaler. The
     * maximum number of replicas should not be lower than minimal number
     * of replicas.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler.html#max_replicas ComputeAutoscaler#max_replicas}
     */
    readonly maxReplicas: number;
    /**
     * The minimum number of replicas that the autoscaler can scale down to.
     *
     * This cannot be less than 0. If not provided, autoscaler will
     * choose a default value depending on maximum number of instances
     * allowed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler.html#min_replicas ComputeAutoscaler#min_replicas}
     */
    readonly minReplicas: number;
    /**
     * Defines operating mode for this policy. Default value: "ON" Possible values: ["OFF", "ONLY_UP", "ON"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler.html#mode ComputeAutoscaler#mode}
     */
    readonly mode?: string;
    /**
     * cpu_utilization block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler.html#cpu_utilization ComputeAutoscaler#cpu_utilization}
     */
    readonly cpuUtilization?: ComputeAutoscalerAutoscalingPolicyCpuUtilization;
    /**
     * load_balancing_utilization block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler.html#load_balancing_utilization ComputeAutoscaler#load_balancing_utilization}
     */
    readonly loadBalancingUtilization?: ComputeAutoscalerAutoscalingPolicyLoadBalancingUtilization;
    /**
     * metric block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler.html#metric ComputeAutoscaler#metric}
     */
    readonly metric?: ComputeAutoscalerAutoscalingPolicyMetric[];
    /**
     * scale_in_control block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler.html#scale_in_control ComputeAutoscaler#scale_in_control}
     */
    readonly scaleInControl?: ComputeAutoscalerAutoscalingPolicyScaleInControl;
    /**
     * scaling_schedules block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler.html#scaling_schedules ComputeAutoscaler#scaling_schedules}
     */
    readonly scalingSchedules?: ComputeAutoscalerAutoscalingPolicyScalingSchedules[];
}
export declare class ComputeAutoscalerAutoscalingPolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _cooldownPeriod?;
    get cooldownPeriod(): number | undefined;
    set cooldownPeriod(value: number | undefined);
    resetCooldownPeriod(): void;
    get cooldownPeriodInput(): number | undefined;
    private _maxReplicas?;
    get maxReplicas(): number;
    set maxReplicas(value: number);
    get maxReplicasInput(): number | undefined;
    private _minReplicas?;
    get minReplicas(): number;
    set minReplicas(value: number);
    get minReplicasInput(): number | undefined;
    private _mode?;
    get mode(): string | undefined;
    set mode(value: string | undefined);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _cpuUtilization?;
    private __cpuUtilizationOutput;
    get cpuUtilization(): ComputeAutoscalerAutoscalingPolicyCpuUtilizationOutputReference;
    putCpuUtilization(value: ComputeAutoscalerAutoscalingPolicyCpuUtilization | undefined): void;
    resetCpuUtilization(): void;
    get cpuUtilizationInput(): ComputeAutoscalerAutoscalingPolicyCpuUtilization | undefined;
    private _loadBalancingUtilization?;
    private __loadBalancingUtilizationOutput;
    get loadBalancingUtilization(): ComputeAutoscalerAutoscalingPolicyLoadBalancingUtilizationOutputReference;
    putLoadBalancingUtilization(value: ComputeAutoscalerAutoscalingPolicyLoadBalancingUtilization | undefined): void;
    resetLoadBalancingUtilization(): void;
    get loadBalancingUtilizationInput(): ComputeAutoscalerAutoscalingPolicyLoadBalancingUtilization | undefined;
    private _metric?;
    get metric(): ComputeAutoscalerAutoscalingPolicyMetric[] | undefined;
    set metric(value: ComputeAutoscalerAutoscalingPolicyMetric[] | undefined);
    resetMetric(): void;
    get metricInput(): ComputeAutoscalerAutoscalingPolicyMetric[] | undefined;
    private _scaleInControl?;
    private __scaleInControlOutput;
    get scaleInControl(): ComputeAutoscalerAutoscalingPolicyScaleInControlOutputReference;
    putScaleInControl(value: ComputeAutoscalerAutoscalingPolicyScaleInControl | undefined): void;
    resetScaleInControl(): void;
    get scaleInControlInput(): ComputeAutoscalerAutoscalingPolicyScaleInControl | undefined;
    private _scalingSchedules?;
    get scalingSchedules(): ComputeAutoscalerAutoscalingPolicyScalingSchedules[] | undefined;
    set scalingSchedules(value: ComputeAutoscalerAutoscalingPolicyScalingSchedules[] | undefined);
    resetScalingSchedules(): void;
    get scalingSchedulesInput(): ComputeAutoscalerAutoscalingPolicyScalingSchedules[] | undefined;
}
export interface ComputeAutoscalerTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler.html#create ComputeAutoscaler#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler.html#delete ComputeAutoscaler#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler.html#update ComputeAutoscaler#update}.
     */
    readonly update?: string;
}
export declare class ComputeAutoscalerTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler.html google_compute_autoscaler}.
 */
export declare class ComputeAutoscaler extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_autoscaler.html google_compute_autoscaler} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: ComputeAutoscalerConfig);
    get creationTimestamp(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    private _target?;
    get target(): string;
    set target(value: string);
    get targetInput(): string | undefined;
    private _zone?;
    get zone(): string | undefined;
    set zone(value: string | undefined);
    resetZone(): void;
    get zoneInput(): string | undefined;
    private _autoscalingPolicy?;
    private __autoscalingPolicyOutput;
    get autoscalingPolicy(): ComputeAutoscalerAutoscalingPolicyOutputReference;
    putAutoscalingPolicy(value: ComputeAutoscalerAutoscalingPolicy): void;
    get autoscalingPolicyInput(): ComputeAutoscalerAutoscalingPolicy | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): ComputeAutoscalerTimeoutsOutputReference;
    putTimeouts(value: ComputeAutoscalerTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeAutoscalerTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
