import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeAddressConfig extends cdktf.TerraformMetaArguments {
    /**
     * The static external IP address represented by this resource.
     *
     * Only
     * IPv4 is supported. An address may only be specified for INTERNAL
     * address types. The IP address must be inside the specified subnetwork,
     * if any.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_address.html#address ComputeAddress#address}
     */
    readonly address?: string;
    /**
     * The type of address to reserve. Default value: "EXTERNAL" Possible values: ["INTERNAL", "EXTERNAL"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_address.html#address_type ComputeAddress#address_type}
     */
    readonly addressType?: string;
    /**
     * An optional description of this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_address.html#description ComputeAddress#description}
     */
    readonly description?: string;
    /**
     * Name of the resource.
     *
     * The name must be 1-63 characters long, and
     * comply with RFC1035. Specifically, the name must be 1-63 characters
     * long and match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?'
     * which means the first character must be a lowercase letter, and all
     * following characters must be a dash, lowercase letter, or digit,
     * except the last character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_address.html#name ComputeAddress#name}
     */
    readonly name: string;
    /**
     * The URL of the network in which to reserve the address.
     *
     * This field
     * can only be used with INTERNAL type with the VPC_PEERING and
     * IPSEC_INTERCONNECT purposes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_address.html#network ComputeAddress#network}
     */
    readonly network?: string;
    /**
     * The networking tier used for configuring this address.
     *
     * If this field is not
     * specified, it is assumed to be PREMIUM. Possible values: ["PREMIUM", "STANDARD"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_address.html#network_tier ComputeAddress#network_tier}
     */
    readonly networkTier?: string;
    /**
     * The prefix length if the resource represents an IP range.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_address.html#prefix_length ComputeAddress#prefix_length}
     */
    readonly prefixLength?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_address.html#project ComputeAddress#project}.
     */
    readonly project?: string;
    /**
     * The purpose of this resource, which can be one of the following values:.
     *
     * GCE_ENDPOINT for addresses that are used by VM instances, alias IP
     * ranges, internal load balancers, and similar resources.
     *
     * SHARED_LOADBALANCER_VIP for an address that can be used by multiple
     * internal load balancers.
     *
     * VPC_PEERING for addresses that are reserved for VPC peer networks.
     *
     * IPSEC_INTERCONNECT for addresses created from a private IP range
     * that are reserved for a VLAN attachment in an IPsec-encrypted Cloud
     * Interconnect configuration. These addresses are regional resources.
     *
     * PRIVATE_SERVICE_CONNECT for a private network address that is used
     * to configure Private Service Connect. Only global internal addresses
     * can use this purpose.
     *
     * This should only be set when using an Internal address.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_address.html#purpose ComputeAddress#purpose}
     */
    readonly purpose?: string;
    /**
     * The Region in which the created address should reside. If it is not provided, the provider region is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_address.html#region ComputeAddress#region}
     */
    readonly region?: string;
    /**
     * The URL of the subnetwork in which to reserve the address.
     *
     * If an IP
     * address is specified, it must be within the subnetwork's IP range.
     * This field can only be used with INTERNAL type with
     * GCE_ENDPOINT/DNS_RESOLVER purposes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_address.html#subnetwork ComputeAddress#subnetwork}
     */
    readonly subnetwork?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_address.html#timeouts ComputeAddress#timeouts}
     */
    readonly timeouts?: ComputeAddressTimeouts;
}
export interface ComputeAddressTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_address.html#create ComputeAddress#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_address.html#delete ComputeAddress#delete}.
     */
    readonly delete?: string;
}
export declare class ComputeAddressTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_address.html google_compute_address}.
 */
export declare class ComputeAddress extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_address.html google_compute_address} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: ComputeAddressConfig);
    private _address?;
    get address(): string | undefined;
    set address(value: string | undefined);
    resetAddress(): void;
    get addressInput(): string | undefined;
    private _addressType?;
    get addressType(): string | undefined;
    set addressType(value: string | undefined);
    resetAddressType(): void;
    get addressTypeInput(): string | undefined;
    get creationTimestamp(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _network?;
    get network(): string | undefined;
    set network(value: string | undefined);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _networkTier?;
    get networkTier(): string | undefined;
    set networkTier(value: string | undefined);
    resetNetworkTier(): void;
    get networkTierInput(): string | undefined;
    private _prefixLength?;
    get prefixLength(): number | undefined;
    set prefixLength(value: number | undefined);
    resetPrefixLength(): void;
    get prefixLengthInput(): number | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _purpose?;
    get purpose(): string | undefined;
    set purpose(value: string | undefined);
    resetPurpose(): void;
    get purposeInput(): string | undefined;
    private _region?;
    get region(): string | undefined;
    set region(value: string | undefined);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get selfLink(): string;
    private _subnetwork?;
    get subnetwork(): string | undefined;
    set subnetwork(value: string | undefined);
    resetSubnetwork(): void;
    get subnetworkInput(): string | undefined;
    get users(): string[];
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): ComputeAddressTimeoutsOutputReference;
    putTimeouts(value: ComputeAddressTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeAddressTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
